/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.components;

import edu.uthscsa.ric.mango.components.MangoColorSelectedListener;
import edu.uthscsa.ric.roi.ColorManager;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.utilities.ColorUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class MangoColorIconPanel
extends JPanel
implements MouseListener {
    private String colorName;
    private boolean useButtonBorder;
    private final ColorManager manager;
    private final MangoColorSelectedListener listener;
    private final ROIColor color;
    private final boolean showUsedMarker;
    private static final long serialVersionUID = 1L;
    public static final int SIZE = 25;

    public MangoColorIconPanel(ColorManager manager, MangoColorSelectedListener listener, ROIColor color, String colorName, boolean showUsedMarker) {
        this.manager = manager;
        this.listener = listener;
        this.color = color;
        this.colorName = colorName;
        this.showUsedMarker = showUsedMarker;
        this.createUI();
    }

    public MangoColorIconPanel(ColorManager manager, ROIColor color, String colorName, boolean showUsedMarker) {
        this.manager = manager;
        this.listener = null;
        this.color = color;
        this.colorName = colorName;
        this.showUsedMarker = showUsedMarker;
        this.createUI();
    }

    public boolean isUseButtonBorder() {
        return this.useButtonBorder;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.isEnabled() && this.listener != null) {
            this.listener.colorSelected(this.color.getIndex());
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent me) {
        if (this.isEnabled() && !this.useButtonBorder) {
            this.setBorder(null);
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isEnabled() && this.useButtonBorder) {
            this.setBorder(null);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.updateBorder();
    }

    public void setColorName(String colorName) {
        this.colorName = colorName;
        if (colorName != null) {
            this.setToolTipText(colorName);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!this.isEnabled()) {
            this.setToolTipText(null);
        }
        this.updateBorder();
        this.updateColor();
    }

    public void setUseButtonBorder(boolean useButtonBorder) {
        this.useButtonBorder = useButtonBorder;
        this.updateBorder();
    }

    private void createUI() {
        this.setPreferredSize(new Dimension(25, 25));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        if (this.colorName != null) {
            this.setToolTipText(this.colorName);
        }
        this.addMouseListener(this);
        this.updateBorder();
        this.updateColor();
    }

    private void updateBorder() {
        if (this.isEnabled()) {
            if (this.useButtonBorder) {
                if (this.showUsedMarker) {
                    if (this.manager.isUsed(this.color.getIndex())) {
                        this.setBorder(BorderFactory.createBevelBorder(1, ColorUtilities.createNiceHighlightColor((Color)this.color.getColor()), ColorUtilities.createNiceShadowColor((Color)this.color.getColor())));
                    } else {
                        this.setBorder(BorderFactory.createBevelBorder(0, ColorUtilities.createNiceHighlightColor((Color)this.color.getColor()), ColorUtilities.createNiceShadowColor((Color)this.color.getColor())));
                    }
                } else {
                    this.setBorder(BorderFactory.createBevelBorder(0, ColorUtilities.createNiceHighlightColor((Color)this.color.getColor()), ColorUtilities.createNiceShadowColor((Color)this.color.getColor())));
                }
            }
        } else {
            this.setBorder(null);
        }
    }

    private void updateColor() {
        if (this.isEnabled()) {
            this.setBackground(this.color.getColor());
        } else {
            this.setBackground(Color.GRAY);
        }
    }
}

