/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango;

import edu.uthscsa.ric.cli.CLIUtils;
import edu.uthscsa.ric.cli.Utility;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.utilities.AppLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class MangoClient
implements Utility {
    private static boolean launcher;
    public static final String COMMAND_LINE_NAME = "mango";
    public static final String NO_ARGS = "[]";
    public static final String PORT_FILENAME = "port_number";
    public static final String QUIT_COMMAND = "-q";

    public static boolean isLauncher() {
        return launcher;
    }

    public static void setLauncher(boolean launcher) {
        MangoClient.launcher = launcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        AppLogger.createFileLogger((File)Platform.getLogDir());
        if (!launcher) {
            CLIUtils.prepUtilityProgram();
        }
        BufferedReader reader = null;
        PrintStream output = null;
        Socket socket = null;
        boolean hasQuit = MangoClient.hasQuitCommand(args);
        try {
            File portFile = new File(Platform.getTempDir(), PORT_FILENAME);
            if (portFile.exists()) {
                reader = new BufferedReader(new FileReader(portFile));
                String string = reader.readLine();
                if (string != null) {
                    int portNumber = Integer.parseInt(string);
                    socket = new Socket(InetAddress.getByName(null), portNumber);
                    String command = MangoClient.makeCommand(args);
                    output = new PrintStream(socket.getOutputStream());
                    output.println(command);
                    if (command.equals(NO_ARGS)) {
                        MangoClient.printUsage();
                    }
                }
            } else if (!hasQuit) {
                MangoClient.openMango(args);
            }
        }
        catch (ConnectException cex) {
            if (!hasQuit) {
                MangoClient.openMango(args);
            }
        }
        catch (IOException ex) {
            AppLogger.warn((Throwable)ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
            if (output != null) {
                output.close();
            }
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
    }

    private static String fixPath(String argVal) {
        String arg = argVal;
        if (arg.charAt(0) != '-') {
            File file = new File(arg = arg.trim());
            if (file.exists()) {
                try {
                    String name = file.getCanonicalPath();
                    return "\"" + name + "\"";
                }
                catch (IOException ex) {
                    AppLogger.error((Throwable)ex);
                }
            } else {
                file = new File(System.getProperty("user.dir"), arg);
                if (file.exists()) {
                    try {
                        String name = file.getCanonicalPath();
                        return "\"" + name + "\"";
                    }
                    catch (IOException ex) {
                        AppLogger.error((Throwable)ex);
                    }
                }
            }
            return "\"" + arg + "\"";
        }
        return arg;
    }

    private static Vector<String> getCommands(String[] args) {
        Vector<String> commands = new Vector<String>();
        for (String arg : args) {
            if (StringUtils.isBlank((CharSequence)arg)) continue;
            String current = arg;
            current = current.replace("\"", "");
            if ((current = current.replace("'", "")).trim().endsWith("\\")) continue;
            if (current.charAt(0) != '-' && !Mango.isCustomURL(current) && !current.startsWith("http://")) {
                try {
                    current = new File(current).getCanonicalPath().trim();
                }
                catch (IOException ex) {
                    AppLogger.error((Throwable)ex);
                }
                if (Platform.MAC) {
                    current = MangoClient.removeBackSlashes(current);
                }
                if (!new File(current).exists()) {
                    AppLogger.warn((String)("Warning: " + current + " does not exist!"));
                }
            }
            commands.add(current.trim());
            current = "";
        }
        return commands;
    }

    private static boolean hasQuitCommand(String[] args) {
        if (args != null) {
            for (String arg : args) {
                if (!arg.equals(QUIT_COMMAND)) continue;
                return true;
            }
        }
        return false;
    }

    private static String makeCommand(String[] args) {
        return MangoClient.getCommands(args).toString();
    }

    private static void openMango(String[] args) {
        try {
            if (launcher) {
                Mango.main(new String[]{MangoClient.makeCommand(args)});
            } else {
                Vector<String> allArgs = new Vector<String>();
                if (Platform.MAC) {
                    allArgs.add("/Applications/Mango.app/Contents/MacOS/Mango");
                } else if (Platform.WINDOWS) {
                    allArgs.add(Platform.APP_WINDOWS);
                } else if (Platform.UNIX) {
                    File appFile = new File(Platform.APP_UNIX);
                    if (!appFile.canExecute()) {
                        appFile.setExecutable(true);
                    }
                    allArgs.add(Platform.APP_UNIX);
                }
                for (String arg : args) {
                    if (!StringUtils.isNotBlank((CharSequence)arg)) continue;
                    allArgs.add(MangoClient.fixPath(arg));
                }
                Runtime.getRuntime().exec(allArgs.toArray(new String[allArgs.size()]));
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    private static void printUsage() {
        AppLogger.error((String)new MangoClient().getUsage());
    }

    private static String removeBackSlashes(String string) {
        byte[] chars = string.getBytes();
        byte[] returnChars = new byte[chars.length];
        int index = 0;
        for (byte c : chars) {
            if (c == 92) continue;
            returnChars[index++] = c;
        }
        return new String(returnChars).trim();
    }

    @Override
    public String getUsage() {
        String usage = "";
        usage = usage + "Mango image loader (v" + Mango.getVersionString() + " b-" + Mango.getBuildNumberString() + ")\n";
        usage = usage + "Usage: mango [-q] [-r] <file> [-o] [overlay file]\n";
        usage = usage + "Options:\n";
        usage = usage + "-r  reload this image\n";
        usage = usage + "-o  overlay this image on previous image\n";
        usage = usage + "-q  quit application\n";
        usage = usage + "-k  quit application immediately\n";
        usage = usage + "Note: To use the currently open instance, open Mango preferences, enable the 'Command Line' option, save changes, and restart Mango.";
        return usage;
    }

    @Override
    public String getCommandLineName() {
        return COMMAND_LINE_NAME;
    }
}

