/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.cli.makeroi;

import edu.uthscsa.ric.cli.CLIUtils;
import edu.uthscsa.ric.cli.Context;
import edu.uthscsa.ric.cli.Manager;
import edu.uthscsa.ric.cli.Utility;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.VolumeIOException;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class CreateROI
implements Utility {
    private static String outputLabel;
    private static boolean do3d;
    private static boolean doAxial;
    private static boolean doConvexHull;
    private static boolean doCoronal;
    private static boolean doExcludeZero;
    private static boolean doRange;
    private static boolean doSagittal;
    private static boolean doShrinkWrap;
    private static double maxThresh;
    private static double minThresh;
    private static int outputColor;
    public static final String ARG_3D = "-3d";
    public static final String ARG_AXIAL = "-axi";
    public static final String ARG_COLOR = "-color";
    public static final String ARG_CONVEX_HULL = "-c";
    public static final String ARG_CORONAL = "-cor";
    public static final String ARG_EXCLUDE_ZERO = "-0";
    public static final String ARG_LABEL = "-label";
    public static final String ARG_MAX = "-max";
    public static final String ARG_MIN = "-min";
    public static final String ARG_SAGITTAL = "-sag";
    public static final String ARG_SHRINK_WRAP = "-s";
    public static final String COMMAND_LINE_NAME = "makeroi";
    public static final String NII_EXT = "_roi.nii.gz";
    public static final List<String> DIR_LABELS;
    public static final String TEXT_ETCETERA = " ...";
    public static final String TEXT_IN_RANGE = " in range ";
    public static final String TEXT_TO = " to ";

    public static void reset() {
        outputLabel = null;
        do3d = false;
        doAxial = false;
        doConvexHull = false;
        doCoronal = false;
        doExcludeZero = false;
        doRange = false;
        doSagittal = false;
        doShrinkWrap = false;
        maxThresh = Double.MIN_VALUE;
        minThresh = Double.MAX_VALUE;
        outputColor = 0;
    }

    public static void main(String[] args) {
        int startArg;
        CLIUtils.prepUtilityProgram();
        CLIUtils.addAllPlugins();
        if (args.length == 0) {
            AppLogger.error((String)new CreateROI().getUsage());
            System.exit(1);
        }
        for (int ctr = startArg = CreateROI.readArgs(args); ctr < args.length; ++ctr) {
            CreateROI createROI = new CreateROI();
            File imageFile = new File(args[ctr]);
            try {
                createROI.doOperation(imageFile);
                continue;
            }
            catch (InvalidHeaderException ex) {
                AppLogger.error((String)ex.getMessage());
                continue;
            }
            catch (VolumeIOException ex) {
                AppLogger.error((String)ex.getMessage());
                continue;
            }
            catch (IOException ex) {
                AppLogger.error((String)ex.getMessage());
            }
        }
    }

    private static int readArgs(String[] args) {
        int ctr;
        for (ctr = 0; ctr < args.length && args[ctr].charAt(0) == '-'; ++ctr) {
            String arg = args[ctr];
            if (arg.equals(ARG_EXCLUDE_ZERO)) {
                doExcludeZero = true;
                continue;
            }
            if (arg.startsWith(ARG_AXIAL)) {
                doAxial = true;
                continue;
            }
            if (arg.startsWith(ARG_CORONAL)) {
                doCoronal = true;
                continue;
            }
            if (arg.startsWith(ARG_SAGITTAL)) {
                doSagittal = true;
                continue;
            }
            if (arg.equals(ARG_3D)) {
                do3d = true;
                continue;
            }
            if (arg.equals(ARG_MIN)) {
                try {
                    minThresh = Double.parseDouble(args[ctr + 1]);
                }
                catch (NumberFormatException nfe) {
                    AppLogger.info((Throwable)nfe);
                }
                ++ctr;
                continue;
            }
            if (arg.equals(ARG_MAX)) {
                try {
                    maxThresh = Double.parseDouble(args[ctr + 1]);
                }
                catch (NumberFormatException nfe) {
                    AppLogger.info((Throwable)nfe);
                }
                doRange = true;
                ++ctr;
                continue;
            }
            if (arg.equals(ARG_COLOR)) {
                try {
                    outputColor = Integer.parseInt(args[ctr + 1]);
                    outputColor %= 8;
                }
                catch (NumberFormatException nfe) {
                    AppLogger.info((Throwable)nfe);
                }
                ++ctr;
                continue;
            }
            if (arg.equals(ARG_LABEL)) {
                outputLabel = args[ctr + 1];
                ++ctr;
                continue;
            }
            if (arg.equals(ARG_SHRINK_WRAP)) {
                doShrinkWrap = true;
                continue;
            }
            if (!arg.equals(ARG_CONVEX_HULL)) continue;
            doConvexHull = true;
        }
        return ctr;
    }

    public void doOperation(File imageFile) throws InvalidHeaderException, IOException {
        Context context = Context.getContext();
        VolumeManager manager = context.makeNewVolumeManager(imageFile.toString());
        boolean isSeries = manager.getBaseVolume().getSeriesLength() > 1;
        double useMinThresh = manager.getVolumeDisplayRangeMin(manager.getBaseVolume());
        if (minThresh != Double.MAX_VALUE) {
            useMinThresh = minThresh;
        }
        double useMaxThresh = Double.MAX_VALUE;
        if (!MathUtilities.essentiallyEqual((double)maxThresh, (double)Double.MIN_VALUE)) {
            useMaxThresh = maxThresh;
        }
        manager.setRoiColor(outputColor);
        if (doRange) {
            AppLogger.info((String)("Thresholding " + imageFile.getName() + TEXT_IN_RANGE + useMinThresh + TEXT_TO + useMaxThresh + TEXT_ETCETERA));
            manager.runRangeToROI(useMinThresh, useMaxThresh, false, doExcludeZero, isSeries, false);
        } else if (doShrinkWrap) {
            if (do3d) {
                AppLogger.info((String)("Shrink wrapping (3D) " + imageFile.getName() + " from " + useMinThresh + TEXT_ETCETERA));
                manager.runThresholdToShrinkWrapROI(useMinThresh, false, doExcludeZero, isSeries, false);
            } else {
                int direction = 0;
                if (doAxial) {
                    direction = 0;
                } else if (doCoronal) {
                    direction = 1;
                } else if (doSagittal) {
                    direction = 2;
                }
                AppLogger.info((String)("Shrink wrapping (" + DIR_LABELS.get(direction) + ") " + imageFile.getName() + " from " + useMinThresh + TEXT_ETCETERA));
                manager.runThresholdToShrinkWrapROIAllSlices(useMinThresh, direction, false, doExcludeZero, isSeries, false);
            }
        } else if (doConvexHull) {
            AppLogger.info((String)("Making convex hull of " + imageFile.getName() + " from " + useMinThresh + TEXT_ETCETERA));
            manager.runThresholdToConvexHullROI(useMinThresh, false, doExcludeZero, isSeries, false);
        } else {
            AppLogger.info((String)("Thresholding " + imageFile.getName() + " at " + useMinThresh + TEXT_ETCETERA));
            manager.runThresholdToROI(useMinThresh, false, doExcludeZero, isSeries, false);
        }
        if (outputLabel != null) {
            ((Manager)manager).getROIManager().setLabel(outputColor, outputLabel);
        }
        manager.saveROI(manager.makeFilename(NII_EXT));
        AppLogger.info((String)" done!");
    }

    @Override
    public String getUsage() {
        String usage = "";
        usage = usage + "Makes a ROI based on image threshold (v" + Mango.getVersionString() + " b-" + Mango.getBuildNumberString() + ")\n";
        usage = usage + "Usage (simple threshold): makeroi [-min <value>] <files>\n";
        usage = usage + "Usage (shrink wrap): makeroi -s [-axi | -cor | -sag | -3d] [-min <value>] <files>\n";
        usage = usage + "Usage (convex hull): makeroi -c [-min <value>] <files>\n";
        usage = usage + "Options:\n";
        usage = usage + "-min  lower threshold (default: based on display range)\n";
        usage = usage + "-max  upper threshold\n";
        usage = usage + "-0  exclude zero\n";
        usage = usage + "-s  shrink wrap\n";
        usage = usage + "-c  convex hull\n";
        usage = usage + "-axi, -cor, -sag, -3d  shrink wrap direction (default: axi)\n";
        usage = usage + "-color  use ROI color 0 - 7 (default: 0)\n";
        usage = usage + "-label  add a label for this ROI color\n";
        return usage;
    }

    @Override
    public String getCommandLineName() {
        return COMMAND_LINE_NAME;
    }

    static {
        maxThresh = Double.MIN_VALUE;
        minThresh = Double.MAX_VALUE;
        DIR_LABELS = CollectionUtilities.immutable((String[])new String[]{"axial", "coronal", "sagittal"});
    }
}

