/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.cli.convert2dcm;

import edu.uthscsa.ric.cli.CLIUtils;
import edu.uthscsa.ric.cli.Utility;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.JVMUtilities;
import edu.uthscsa.ric.utilities.StringUtilities;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeIOException;
import edu.uthscsa.ric.volume.formats.dicom.ExportableSOPClass;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class Convert2DCM
implements Utility {
    private String outputName;
    private boolean mr;
    private boolean pet;
    private final Vector<String> infiles = new Vector();
    public static final String COMMAND_LINE_NAME = "convert2dcm";
    public static final String OPTION_OUTPUT = "-out";
    public static final String OPTION_PET = "-pet";
    public static final String OPTION_MR = "-mr";
    public static final String PET_SUFFIX = "_pet";
    public static final String MR_SUFFIX = "_mr";
    public static final String SC_SUFFIX = "_sc";

    public static void main(String[] args) {
        try {
            CLIUtils.prepUtilityProgram();
            CLIUtils.addAllPlugins();
            JVMUtilities.addLibraryDir((String)Platform.getLibDir().toString());
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        Convert2DCM converter = new Convert2DCM();
        if (converter.readArgs(args)) {
            converter.process();
        } else {
            AppLogger.error((String)converter.getUsage());
        }
    }

    @Override
    public String getUsage() {
        String usage = "";
        usage = usage + "Converts recognized file formats to DICOM format (v" + Mango.getVersionString() + " b-" + Mango.getBuildNumberString() + ")\n";
        usage = usage + "Usage: convert2dcm [-mr | -pet] [-out file] <file>\n";
        usage = usage + "Options:\n";
        usage = usage + "-pet  output as PET DICOM type\n";
        usage = usage + "-mr  output as MR DICOM type\n";
        usage = usage + "-out  specify output file\n";
        return usage;
    }

    private void process() {
        HashSet<File> usedFiles = new HashSet<File>();
        for (String path : this.infiles) {
            File file = new File(path).getAbsoluteFile();
            if (usedFiles.contains(file)) continue;
            String name = file.getName();
            if (name.indexOf(46) != -1) {
                name = name.substring(0, name.indexOf(46));
            }
            try {
                File outfile;
                boolean applyDataScales;
                boolean fitPrecision;
                Volume volume = new Volume(file);
                URI[] files = volume.getMultiImageFiles();
                if (files != null) {
                    for (URI file2 : files) {
                        usedFiles.add(new File(file2).getAbsoluteFile());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)volume.getTitle())) {
                    name = StringUtilities.convertToLetterDigitOnly((String)volume.getTitle()).replaceAll("\\s", "_");
                }
                volume.updateMaxMin(volume.findRangeSeriesSlowly());
                volume.setImageFileName(name);
                ImageType itNew = ExportableSOPClass.getPreferredImageType();
                ImageType itOld = volume.getImageType();
                boolean hasGlobalDataScales = volume.hasGlobalDataScale();
                int numBytesImage = itOld.getNumBytesPerVoxel();
                int numBytesSelected = itNew.getNumBytesPerVoxel();
                if (numBytesSelected < numBytesImage) {
                    fitPrecision = true;
                    applyDataScales = true;
                } else if (numBytesSelected == numBytesImage && itOld.isInteger() && itNew.isInteger() && itOld.getByteType() != itNew.getByteType() && numBytesImage < 4) {
                    fitPrecision = true;
                    applyDataScales = false;
                } else if (hasGlobalDataScales) {
                    double typeRange;
                    double typeMax = itNew.getTypeMax(false);
                    double typeMin = itNew.getTypeMin(false);
                    double imageMin = volume.getMinImageDiskValue();
                    double imageMax = volume.getMaxImageDiskValue();
                    double imageRange = imageMax - imageMin;
                    fitPrecision = (imageRange > (typeRange = typeMax - typeMin) || imageMin < typeMin || imageMax > typeMax) && itNew.getByteType() != 4;
                    applyDataScales = (imageRange > typeRange || imageMin < typeMin || imageMax > typeMax) && itNew.getByteType() != 4;
                } else {
                    fitPrecision = true;
                    applyDataScales = true;
                }
                File outputFile = null;
                if (StringUtils.isNotBlank((CharSequence)this.outputName)) {
                    File tempFile = new File(this.outputName);
                    outputFile = tempFile.isAbsolute() ? tempFile : new File(file.getParent(), this.outputName);
                }
                if (this.pet) {
                    outfile = CLIUtils.makeOutputFile(file, outputFile, null, outputFile != null ? null : PET_SUFFIX, ".dcm", false);
                    volume.writeFilesAs(outfile, "DICOM (PET)", ExportableSOPClass.getPreferredImageType(), null, applyDataScales, fitPrecision);
                    continue;
                }
                if (this.mr) {
                    outfile = CLIUtils.makeOutputFile(file, outputFile, null, outputFile != null ? null : MR_SUFFIX, ".dcm", false);
                    volume.writeFilesAs(outfile, "DICOM (MR)", ExportableSOPClass.getPreferredImageType(), null, applyDataScales, fitPrecision);
                    continue;
                }
                outfile = CLIUtils.makeOutputFile(file, outputFile, null, outputFile != null ? null : SC_SUFFIX, ".dcm", false);
                volume.writeFilesAs(outfile, "DICOM (SC)", ExportableSOPClass.getPreferredImageType(), null, applyDataScales, fitPrecision);
            }
            catch (InvalidHeaderException ex) {
                AppLogger.error((String)("Header could not be read: " + file));
            }
            catch (VolumeIOException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
    }

    private boolean readArgs(String[] args) {
        for (int ctr = 0; ctr < args.length; ++ctr) {
            if (args[ctr].equals(OPTION_PET)) {
                this.pet = true;
                continue;
            }
            if (args[ctr].equals(OPTION_MR)) {
                this.mr = true;
                continue;
            }
            if (args[ctr].equals(OPTION_OUTPUT)) {
                this.outputName = args[ctr + 1];
                ++ctr;
                continue;
            }
            this.infiles.add(args[ctr]);
        }
        return this.infiles.size() > 0;
    }

    @Override
    public String getCommandLineName() {
        return COMMAND_LINE_NAME;
    }
}

