/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.cli;

import edu.uthscsa.ric.cli.CLIUtils;
import edu.uthscsa.ric.cli.Context;
import edu.uthscsa.ric.cli.Utility;
import edu.uthscsa.ric.mango.MangoContext;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.JVMUtilities;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Proxy
implements Utility {
    public static final String USAGE_MESSAGE = "This is a proxy program to call plugin main methods.";

    public static void displayUsage() {
        AppLogger.error((String)new Proxy().getUsage());
    }

    public static void main(String[] args) {
        try {
            CLIUtils.prepUtilityProgram();
            CLIUtils.addAllPlugins();
            JVMUtilities.addLibraryDir((String)Platform.getLibDir().toString());
            if (args.length > 0) {
                Class<?> cls = Class.forName(args[0]);
                Object obj = cls.newInstance();
                Method meth = cls.getMethod("doOperation", MangoContext.class, String[].class);
                String[] argsNew = new String[args.length - 1];
                for (int ctr = 0; ctr < argsNew.length; ++ctr) {
                    argsNew[ctr] = args[ctr + 1];
                }
                Context ctx = Context.getContext();
                meth.invoke(obj, ctx, argsNew);
            } else {
                Proxy.displayUsage();
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (InstantiationException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (SecurityException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    @Override
    public String getUsage() {
        return USAGE_MESSAGE;
    }

    @Override
    public String getCommandLineName() {
        return null;
    }
}

