/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.cli;

import edu.uthscsa.ric.cli.CLIUtils;
import edu.uthscsa.ric.cli.Context;
import edu.uthscsa.ric.cli.ScriptablePlugin;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoContext;
import edu.uthscsa.ric.mango.MangoData;
import edu.uthscsa.ric.mango.MangoImage;
import edu.uthscsa.ric.mango.MangoROI;
import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.ScreenImage;
import edu.uthscsa.ric.mango.SliceListener;
import edu.uthscsa.ric.mango.components.progressbar.ProgressBar;
import edu.uthscsa.ric.mango.core.Capturable;
import edu.uthscsa.ric.mango.dialogs.modal.PluginManagerDialog;
import edu.uthscsa.ric.mango.dialogs.script.ScriptManager;
import edu.uthscsa.ric.mango.dialogs.snapshot.Snapshot;
import edu.uthscsa.ric.mango.dialogs.stats.AnalysisPointImpl;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerprojection.ProjectionManager;
import edu.uthscsa.ric.mango.viewerprojection.operations.building.BuildProjectionParameters;
import edu.uthscsa.ric.mango.viewerprojection.operations.building.ProjectionBuilder;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cine.CineSlice;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.ClusterImpl;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.ClusterRejectionData;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.ClusterStat;
import edu.uthscsa.ric.mango.viewerslice.dialogs.cluster.operations.ClusterOperations;
import edu.uthscsa.ric.mango.viewerslice.dialogs.layout.Layout;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.Logical;
import edu.uthscsa.ric.mango.viewerslice.dialogs.logical.operations.LogicalOperations;
import edu.uthscsa.ric.mango.viewerslice.dialogs.webpage.Webpage;
import edu.uthscsa.ric.mango.viewerslice.dialogs.webpage.WebpageImageImpl;
import edu.uthscsa.ric.mango.viewerslice.dialogs.webpage.WebpageSurfaceImpl;
import edu.uthscsa.ric.mango.viewerslice.operations.LineOps;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LookupTableManager;
import edu.uthscsa.ric.mango.viewersurface.SurfaceManager;
import edu.uthscsa.ric.mango.viewersurface.SurfacePosition;
import edu.uthscsa.ric.mango.viewersurface.core.CompositeSurface;
import edu.uthscsa.ric.mango.viewersurface.operations.building.SurfaceBuildParameters;
import edu.uthscsa.ric.mango.viewersurface.operations.building.SurfaceFactory;
import edu.uthscsa.ric.mango.viewersurface.operations.io.SurfaceIOListener;
import edu.uthscsa.ric.mango.viewersurface.operations.io.SurfaceReader;
import edu.uthscsa.ric.mango.viewersurface.operations.io.formats.mango.MangoFormat;
import edu.uthscsa.ric.mango.viewersurface.operations.measurement.SurfaceArea;
import edu.uthscsa.ric.mango.viewersurface.operations.measurement.SurfaceVolume;
import edu.uthscsa.ric.roi.EquivalentSetManager;
import edu.uthscsa.ric.roi.Line;
import edu.uthscsa.ric.roi.Metadata;
import edu.uthscsa.ric.roi.MetadataUser;
import edu.uthscsa.ric.roi.PointsManager;
import edu.uthscsa.ric.roi.ROI;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.roi.ROIData;
import edu.uthscsa.ric.roi.ROIMaskManager;
import edu.uthscsa.ric.roi.ROIOperationTreeNode;
import edu.uthscsa.ric.roi.ShapesManager;
import edu.uthscsa.ric.roi.lines.LineListener;
import edu.uthscsa.ric.roi.lines.LineUser;
import edu.uthscsa.ric.roi.lines.display.LOIShape;
import edu.uthscsa.ric.roi.lines.manager.LOIManager;
import edu.uthscsa.ric.roi.mask.Mask;
import edu.uthscsa.ric.roi.mask.buffers.AbstractROIBuffer;
import edu.uthscsa.ric.roi.mask.display.ROIShape;
import edu.uthscsa.ric.roi.mask.manager.ROIManager;
import edu.uthscsa.ric.roi.mask.manager.ROIUser;
import edu.uthscsa.ric.roi.points.POI;
import edu.uthscsa.ric.roi.points.PointUser;
import edu.uthscsa.ric.roi.points.manager.POIManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.StringUtilities;
import edu.uthscsa.ric.visualization.surface.io.SurfaceFormat;
import edu.uthscsa.ric.visualization.surface.io.SurfaceFormatException;
import edu.uthscsa.ric.visualization.surface.primitives.Surface;
import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.Cluster;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Coordinate4D;
import edu.uthscsa.ric.volume.Header;
import edu.uthscsa.ric.volume.Histogram;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageRange;
import edu.uthscsa.ric.volume.ImageTransform;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.LabelListener;
import edu.uthscsa.ric.volume.Orientation;
import edu.uthscsa.ric.volume.ReadableHeader;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeIOException;
import edu.uthscsa.ric.volume.VolumeListener;
import edu.uthscsa.ric.volume.VolumeUser;
import edu.uthscsa.ric.volume.WritableHeader;
import edu.uthscsa.ric.volume.operations.OperationBuilder;
import edu.uthscsa.ric.volume.operations.calculation.CalcOp;
import edu.uthscsa.ric.volume.operations.calculation.CalcSeriesOp;
import edu.uthscsa.ric.volume.operations.calculation.ImageCalcExpression;
import edu.uthscsa.ric.volume.operations.calculation.ImageCalcExpressionImpl;
import edu.uthscsa.ric.volume.operations.calculation.ImageOperationTreeNode;
import edu.uthscsa.ric.volume.operations.filter.AbstractFilter;
import edu.uthscsa.ric.volume.operations.filter.AbstractFilterRank;
import edu.uthscsa.ric.volume.operations.filter.FilterBuffer;
import edu.uthscsa.ric.volume.operations.filter.FilterManager;
import edu.uthscsa.ric.volume.operations.filter.FilterOp;
import edu.uthscsa.ric.volume.operations.filter.FilterRankSlice;
import edu.uthscsa.ric.volume.operations.filter.FilterRankTime;
import edu.uthscsa.ric.volume.operations.filter.FilterRankVolume;
import edu.uthscsa.ric.volume.operations.histogram.AnalysisHistogramImpl;
import edu.uthscsa.ric.volume.operations.histogram.HistogramOp;
import edu.uthscsa.ric.volume.operations.histogram.HistogramROIOp;
import edu.uthscsa.ric.volume.operations.range.Range;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import edu.uthscsa.ric.volume.operations.stats.LineStatROIOp;
import edu.uthscsa.ric.volume.operations.stats.PointStatROIOp;
import edu.uthscsa.ric.volume.operations.stats.SeriesStatOp;
import edu.uthscsa.ric.volume.operations.stats.SeriesStatROIOp;
import edu.uthscsa.ric.volume.operations.stats.SliceStatOp;
import edu.uthscsa.ric.volume.operations.stats.SliceStatROIOp;
import edu.uthscsa.ric.volume.operations.stats.VolumeStatOp;
import edu.uthscsa.ric.volume.operations.stats.VolumeStatROIOp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFrame;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class Manager
implements Capturable,
LabelListener,
LineListener,
LineUser,
MetadataUser,
PointUser,
ProjectionManager,
ROIUser,
SurfaceManager,
VolumeManager,
VolumeUser,
VolumeListener {
    private BufferedImage overlayMixer;
    private BufferedImage screenSlice;
    private BufferedImage screenSliceFiltered;
    private BufferedImage[] overlayScreenSlice;
    private BufferedImage[] overlayScreenSliceFiltered;
    private FilterBuffer filterBuffer;
    private Histogram histogram;
    private LOIManager loiManagerAxial;
    private LOIManager loiManagerCoronal;
    private LOIManager loiManagerSagittal;
    private Object scriptResult;
    private POIManager poiManager;
    private ROIManager roiManager;
    private SurfaceBuildParameters surfaceParameters;
    private URI loadedURI;
    private boolean hasScreenData;
    private boolean showROI = true;
    private boolean usingTransform;
    private int captureSize = 512;
    private int currentVolume;
    private int sliceDirection;
    private int[] overlayMixerData;
    private int[] rgbData;
    private int[][] overlayRGBData;
    private final Coordinate currentCoordinate = new Coordinate();
    private final List<ScreenVolume> volumes = new ArrayList<ScreenVolume>();
    private final List<edu.uthscsa.ric.visualization.surface.primitives.Shape> lines;
    private final List<edu.uthscsa.ric.visualization.surface.primitives.Shape> points;
    private final List<Surface> surfaces = new ArrayList<Surface>();
    private final Map<ImageVolume, ClusterRejectionData> clusterDataMap;
    private transient ROIShape[] roi;
    public static final String TEXT_LOAD_ERROR = "Load Error";
    public static final String TEXT_PROBLEM_LOADING_ROI = "Problem loading ROI!\n";
    public static final int DEFAULT_CAPTURE_SIZE = 512;

    public void setCaptureSize(int captureSize) {
        this.captureSize = captureSize;
    }

    public Manager() {
        this.points = new ArrayList<edu.uthscsa.ric.visualization.surface.primitives.Shape>();
        this.lines = new ArrayList<edu.uthscsa.ric.visualization.surface.primitives.Shape>();
        this.clusterDataMap = new HashMap<ImageVolume, ClusterRejectionData>();
    }

    public void addMoreROIColors() {
        this.roiManager.increaseColors();
    }

    public void addOverlay(String openLocation, boolean parametric) {
        try {
            ScreenVolume positives = this.addNewVolume(new File(openLocation).toURI());
            if (parametric) {
                ScreenVolume negatives = this.addNewVolume(new File(openLocation).toURI());
                negatives.setScreenMin(positives.getImageMin());
                negatives.setScreenMax(positives.getImageMax());
            }
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        this.hasScreenData = false;
    }

    public void addOverlayOnto(VolumeManager manager, String colorTable) {
        ((Manager)manager).addNewVolume(this.getBaseVolume(), this.getLoadedURI());
    }

    @Deprecated
    public void createWebpage(String saveLocation, String title, boolean useOverlays, boolean useAtlas, boolean useKioskMode, boolean outputSingleFile) {
        this.createWebpage(saveLocation, title, useOverlays, useAtlas, false, useKioskMode, outputSingleFile);
    }

    public void createWebpage(String saveLocation, String title, boolean useOverlays, boolean useAtlas, boolean useSurfaces, boolean useKioskMode, boolean outputSingleFile) {
        WebpageImageImpl baseImage = new WebpageImageImpl(this.volumes.get(0));
        Vector<WebpageImageImpl> overlayImages = new Vector<WebpageImageImpl>();
        int numOverlays = this.getOverlays().size();
        if (numOverlays > 0) {
            ScreenVolume[] overlays;
            for (ScreenVolume overlay : overlays = this.getOverlayScreenVolumes().toArray(new ScreenVolume[numOverlays])) {
                if (overlay == null) continue;
                boolean parametric = overlay.isParametric();
                boolean negative = overlay.isNegative();
                if (parametric && negative) continue;
                ScreenVolume parametricPartner = Webpage.findParametricPartner(overlays, overlay);
                WebpageImageImpl ip = new WebpageImageImpl(overlay, parametricPartner);
                overlayImages.add(ip);
            }
        }
        Vector<WebpageSurfaceImpl> surfacePanels = new Vector<WebpageSurfaceImpl>();
        int numSurfaces = this.getSurfaces().length;
        if (numSurfaces > 0) {
            for (Surface surface : this.getSurfaces()) {
                surfacePanels.add(new WebpageSurfaceImpl(surface));
            }
        }
        Webpage.doCreateWebpage(this, saveLocation, baseImage, overlayImages, surfacePanels, true, useOverlays, useSurfaces, this.isWorldMode(), false, true, true, !Context.getContext().isMultisliceMode(), useKioskMode, false, true, outputSingleFile, title, null, useAtlas, null, true, false, false, true, false, false);
    }

    private List<ScreenVolume> getOverlayScreenVolumes() {
        return this.volumes.subList(1, this.volumes.size());
    }

    public boolean decrement(int direction) {
        int oldValue;
        int newValue;
        boolean baseImageIsCurrent;
        boolean hasBaseImageTimeseries = this.getBaseVolume().getSeriesLength() > 1;
        boolean hasOverlayTimeseries = this.hasOverlayTimeseries();
        boolean bl = baseImageIsCurrent = !this.isCurrentVolumeOverlay();
        if (direction == 3) {
            ImageVolume refTimeseries;
            boolean didIncrement = false;
            if (baseImageIsCurrent && hasBaseImageTimeseries) {
                didIncrement = this.getCurrentVolume().getCurrentSeriesPoint() > 0;
                if (didIncrement) {
                    this.getBaseVolume().setCurrentSeriesPoint(this.getBaseVolume().getCurrentSeriesPoint() - 1);
                }
            } else if (hasOverlayTimeseries && (didIncrement = (refTimeseries = this.findTopOverlayTimeseries()).getCurrentSeriesPoint() > 0)) {
                refTimeseries.setCurrentSeriesPoint(refTimeseries.getCurrentSeriesPoint() - 1);
                this.reconcileOverlayTimeseries(refTimeseries);
            }
            return didIncrement;
        }
        if (direction == 0) {
            int oldValue2 = this.currentCoordinate.zInt;
            int newValue2 = oldValue2 - 1;
            if (newValue2 >= 0) {
                this.currentCoordinate.zInt = newValue2;
                this.currentCoordinate.zDbl = this.currentCoordinate.zInt;
                return true;
            }
        } else if (direction == 1) {
            int oldValue3 = this.currentCoordinate.yInt;
            int newValue3 = oldValue3 - 1;
            if (newValue3 >= 0) {
                this.currentCoordinate.yInt = newValue3;
                this.currentCoordinate.yDbl = this.currentCoordinate.yInt;
                return true;
            }
        } else if (direction == 2 && (newValue = (oldValue = this.currentCoordinate.xInt) - 1) >= 0) {
            this.currentCoordinate.xInt = newValue;
            this.currentCoordinate.xDbl = this.currentCoordinate.xInt;
            return true;
        }
        return false;
    }

    public void deleteROI(ROI roi) {
        if (roi instanceof Mask) {
            if (this.isMultiSliceMode()) {
                this.roiManager.clear(1L << roi.getColor(), true, true);
            } else {
                int sliceDirection = this.getSliceDirection();
                Volume volume = (Volume)this.getBaseVolume();
                int zMin = 0;
                int yMin = 0;
                int xMin = 0;
                int xMax = volume.getXDim();
                int yMax = volume.getYDim();
                int zMax = volume.getZDim();
                if (sliceDirection == 0) {
                    zMin = zMax = this.roiManager.getSelectedSlice(sliceDirection);
                } else if (sliceDirection == 1) {
                    yMin = yMax = this.roiManager.getSelectedSlice(sliceDirection);
                } else if (sliceDirection == 2) {
                    xMin = xMax = this.roiManager.getSelectedSlice(sliceDirection);
                }
                this.roiManager.clear(xMin, xMax, yMin, yMax, zMin, zMax, 1L << roi.getColor(), true, true);
            }
        } else if (roi instanceof LOIShape) {
            if (this.loiManagerAxial.containsLOI((LOIShape)roi)) {
                this.loiManagerAxial.removeLOI((LOIShape)roi, true);
            } else if (this.loiManagerCoronal.containsLOI((LOIShape)roi)) {
                this.loiManagerCoronal.removeLOI((LOIShape)roi, true);
            } else if (this.loiManagerSagittal.containsLOI((LOIShape)roi)) {
                this.loiManagerSagittal.removeLOI((LOIShape)roi, true);
            }
        } else if (roi instanceof POI) {
            this.poiManager.removePOI((POI)roi, true, true);
        }
    }

    public void disposeVolumeManager() {
        Context.getContext().removeVolumeManager(this);
        this.clear();
    }

    private void clear() {
        this.filterBuffer = null;
        this.histogram = null;
        this.loiManagerAxial = null;
        this.loiManagerCoronal = null;
        this.loiManagerSagittal = null;
        this.poiManager = null;
        this.roiManager = null;
        this.surfaceParameters = null;
        this.loadedURI = null;
        this.volumes.clear();
        this.lines.clear();
        this.points.clear();
        this.surfaces.clear();
        this.clusterDataMap.clear();
    }

    public void exportTo(String saveLocation, String surfaceFormat, Surface surface, String options) {
        Collection<SurfaceFormat> values = SurfaceReader.getLoadedFormats().values();
        for (SurfaceFormat aFormat : values) {
            String formatName = PluginManagerDialog.getPluginName(aFormat);
            if (!surfaceFormat.equals(formatName)) continue;
            try {
                Class<?> aClass = Class.forName(aFormat.getClass().getName());
                SurfaceFormat surfaceWriter = (SurfaceFormat)aClass.newInstance();
                surfaceWriter.getOptionsPanel(this.surfaces.toArray(new Surface[this.surfaces.size()]), this.getShapeData(), (VolumeManager)this);
                surfaceWriter.setOptions(options);
                if (surfaceWriter == null) break;
                try {
                    Surface[] surfaceArray;
                    File file = new File(saveLocation);
                    if (surface != null) {
                        Surface[] surfaceArray2 = new Surface[1];
                        surfaceArray = surfaceArray2;
                        surfaceArray2[0] = surface;
                    } else {
                        surfaceArray = this.surfaces.toArray(new Surface[this.surfaces.size()]);
                    }
                    surfaceWriter.writeSurfaceFile(file, surfaceArray, this.getShapeData(), (VolumeManager)this);
                }
                catch (AbstractMethodError err) {
                    Surface[] surfaceArray;
                    AppLogger.info((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
                    File file = new File(saveLocation);
                    if (surface != null) {
                        Surface[] surfaceArray3 = new Surface[1];
                        surfaceArray = surfaceArray3;
                        surfaceArray3[0] = surface;
                    } else {
                        surfaceArray = this.surfaces.toArray(new Surface[this.surfaces.size()]);
                    }
                    surfaceWriter.writeSurfaceFile(file, surfaceArray, this.getShapeData(), (VolumeManager)this);
                }
                catch (NoSuchMethodError err) {
                    Surface[] surfaceArray;
                    AppLogger.info((String)("This plugin is missing required methods and should be updated. (" + err.getMessage() + ")"));
                    File file = new File(saveLocation);
                    if (surface != null) {
                        Surface[] surfaceArray4 = new Surface[1];
                        surfaceArray = surfaceArray4;
                        surfaceArray4[0] = surface;
                    } else {
                        surfaceArray = this.surfaces.toArray(new Surface[this.surfaces.size()]);
                    }
                    surfaceWriter.writeSurfaceFile(file, surfaceArray, this.getShapeData(), (VolumeManager)this);
                }
            }
            catch (ClassNotFoundException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (InstantiationException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (SurfaceFormatException ex) {
                AppLogger.error((Throwable)ex);
            }
            break;
        }
    }

    public double[] getViewTransform() {
        return CollectionUtilities.arrayDoubles(SurfacePosition.DEFAULT_ROTATION);
    }

    public ImageVolume getVolume(int index) {
        return this.volumes.get(index).getImageVolume();
    }

    public double getVolumeDisplayAlpha(ImageVolume volume) {
        return this.findScreenVolume(volume).getAlpha();
    }

    public String getVolumeDisplayColorTable(ImageVolume volume) {
        return this.findScreenVolume(volume).getLookupTableManager().getName();
    }

    public double getVolumeDisplayRangeMax(ImageVolume volume) {
        return this.findScreenVolume(volume).getScreenMax();
    }

    public double getVolumeDisplayRangeMin(ImageVolume volume) {
        return this.findScreenVolume(volume).getScreenMin();
    }

    public int getVolumeIndex(ImageVolume volume) {
        for (int ctr = 0; ctr < this.volumes.size(); ++ctr) {
            if (this.volumes.get(ctr).getImageVolume() != volume) continue;
            return ctr;
        }
        return -1;
    }

    private ScreenVolume findScreenVolume(ImageVolume volume) {
        for (int ctr = 0; ctr < this.volumes.size(); ++ctr) {
            if (this.volumes.get(ctr).getImageVolume() != volume) continue;
            return this.volumes.get(ctr);
        }
        return null;
    }

    public List<ImageVolume> getVolumes() {
        ArrayList<ImageVolume> imageVols = new ArrayList<ImageVolume>();
        for (ScreenVolume screenVol : this.volumes) {
            imageVols.add(screenVol.getImageVolume());
        }
        return imageVols;
    }

    public int getXDim() {
        return this.getBaseVolume().getXDim();
    }

    @Override
    public void labelChanged() {
    }

    public void lineToShape(edu.uthscsa.ric.visualization.surface.primitives.Shape fromShape, edu.uthscsa.ric.visualization.surface.primitives.Shape toShape) {
    }

    public void loadROI(String openLocation) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            this.loadROI(new File(openLocation).toURI());
        }
    }

    public void loadROIURL(String url, boolean forceImport, boolean forceWorld) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            try {
                URI uri = new URL(url).toURI();
                if (forceImport) {
                    this.doImportROI(uri, forceWorld, false);
                } else {
                    this.doLoadMangoROI(uri);
                }
            }
            catch (URISyntaxException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (MalformedURLException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
    }

    public SurfaceManager loadSurface(String openLocation) {
        SurfaceReader sr = new SurfaceReader();
        SurfaceIOListener listener = new SurfaceIOListener(){

            @Override
            public void surfaceFileRead(boolean success, Surface[] surfaces, Vector<edu.uthscsa.ric.visualization.surface.primitives.Shape> shapes, String message) {
                for (Surface surf : surfaces) {
                    Manager.this.surfaces.add(surf);
                }
                for (edu.uthscsa.ric.visualization.surface.primitives.Shape shape : shapes) {
                    if (shape.getPoints().length > 1) {
                        Manager.this.lines.add(shape);
                        continue;
                    }
                    Manager.this.points.add(shape);
                }
            }

            @Override
            public void surfaceFileWritten(boolean success, File file, String message) {
            }
        };
        sr.doReadFile(new File(openLocation), this, listener, true, null);
        return this;
    }

    public List<Analysis> runSeriesROI(ROI roi) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager() && roi != null) {
            int numTimepoints = this.getCurrentVolume().getSeriesLength();
            for (int ctr = 0; ctr < numTimepoints; ++ctr) {
                stats.add(roi.getStats(ctr));
            }
        }
        return Context.getContext().addAnalysis(stats);
    }

    public Analysis runSeriesStats() {
        Volume vol = (Volume)this.getCurrentVolume();
        SeriesStatOp op = new SeriesStatOp(this, vol);
        OperationBuilder<Analysis> builder = new OperationBuilder<Analysis>(this, op);
        Analysis analysis = builder.runSynchronously();
        return Context.getContext().addAnalysis(analysis);
    }

    public List<Analysis> runSeriesStatsROI(long roiMask, boolean includePointsAndLines, boolean onlySelectedPoints, boolean onlySelectedLines) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        if (includePointsAndLines) {
            stats.addAll(this.runSeriesStatsROIPoints(onlySelectedPoints));
            stats.addAll(this.runSeriesStatsROILines(onlySelectedLines));
        }
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            Volume vol = (Volume)this.getCurrentVolume();
            SeriesStatROIOp op = new SeriesStatROIOp(this, vol, this.roiManager.getBuffer(), roiMask, this.roiManager);
            OperationBuilder<Map<Long, Analysis>> builder = new OperationBuilder<Map<Long, Analysis>>(this, op);
            Map<Long, Analysis> results = builder.runSynchronously();
            stats.addAll(new ArrayList<Analysis>(results.values()));
        }
        return Context.getContext().addAnalysis(stats);
    }

    public void runShrinkWrapROI(long roiMask, int roiOutputColorIndex) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            this.roiManager.runShrinkWrap3D(-1.7976931348623157E308, Double.MAX_VALUE, (Volume)this.getCurrentVolume(), true, roiMask, roiOutputColorIndex, false, this.roiManager.isUsing4dROI(), false);
        }
    }

    public void runShrinkWrapROIAllSlices(int sliceDirection, long roiMask, int roiOutputColorIndex) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            this.roiManager.shrinkWrap2D(-1, sliceDirection, -1.7976931348623157E308, Double.MAX_VALUE, true, roiMask, roiOutputColorIndex, false, this.roiManager.isUsing4dROI(), false, true);
        }
    }

    public void runShrinkWrapROISlice(int sliceDirection, int sliceNumber, long roiMask, int roiOutputColorIndex) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            this.roiManager.shrinkWrap2D(sliceNumber, sliceDirection, -1.7976931348623157E308, Double.MAX_VALUE, true, roiMask, roiOutputColorIndex, false, this.roiManager.isUsing4dROI(), false, true);
        }
    }

    public Analysis runSliceStats(int sliceDirection, int sliceNumber) {
        Volume volume = (Volume)this.getCurrentVolume();
        SliceStatOp op = new SliceStatOp(this, volume);
        if (sliceDirection == 0) {
            return Context.getContext().addAnalysis(op.process(new ImageBounds(0, volume.getXDim() - 1, 0, volume.getYDim() - 1, sliceNumber, sliceNumber)));
        }
        if (sliceDirection == 1) {
            return Context.getContext().addAnalysis(op.process(new ImageBounds(0, volume.getXDim() - 1, sliceNumber, sliceNumber, 0, volume.getZDim() - 1)));
        }
        return Context.getContext().addAnalysis(op.process(new ImageBounds(sliceNumber, sliceNumber, 0, volume.getYDim() - 1, 0, volume.getZDim() - 1)));
    }

    public List<Analysis> runSliceStatsROI(int sliceStatsDirection, int sliceStatsCurrentSlice, long roiMask, boolean includePointsAndLines, boolean onlySelectedPoints, boolean onlySelectedLines) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        if (includePointsAndLines) {
            stats.addAll(this.runSliceStatsROIPoints(sliceStatsDirection, sliceStatsCurrentSlice, onlySelectedPoints));
            stats.addAll(this.runSliceStatsROILines(sliceStatsDirection, sliceStatsCurrentSlice, onlySelectedLines));
        }
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            Volume vol = (Volume)this.getCurrentVolume();
            Volume volBase = (Volume)this.getBaseVolume();
            Map<Long, Analysis> results = null;
            SliceStatROIOp op = new SliceStatROIOp(this, vol, this.roiManager.getBuffer(), roiMask, this.roiManager);
            results = sliceStatsDirection == 0 ? op.process(new ImageBounds(0, volBase.getXDim() - 1, 0, volBase.getYDim() - 1, sliceStatsCurrentSlice, sliceStatsCurrentSlice)) : (sliceStatsDirection == 1 ? op.process(new ImageBounds(0, volBase.getXDim() - 1, sliceStatsCurrentSlice, sliceStatsCurrentSlice, 0, volBase.getZDim() - 1)) : op.process(new ImageBounds(sliceStatsCurrentSlice, sliceStatsCurrentSlice, 0, volBase.getYDim() - 1, 0, volBase.getZDim() - 1)));
            stats.addAll(new ArrayList<Analysis>(results.values()));
        }
        return Context.getContext().addAnalysis(stats);
    }

    public void runSmooth(ROI roi) {
        if (roi instanceof LOIShape) {
            LOIShape loi = (LOIShape)roi;
            if (this.loiManagerAxial.containsLOI(loi)) {
                this.loiManagerAxial.smoothLine(loi);
            } else if (this.loiManagerCoronal.containsLOI(loi)) {
                this.loiManagerCoronal.smoothLine(loi);
            } else if (this.loiManagerSagittal.containsLOI(loi)) {
                this.loiManagerSagittal.smoothLine(loi);
            }
        }
    }

    public Analysis runStat(ROI roi) {
        return Context.getContext().addAnalysis(roi.getStats(this.getCurrentVolume().getCurrentSeriesPoint()));
    }

    public List<Analysis> runSurfaceAreaStats(Surface surface) {
        SurfaceArea sa = new SurfaceArea(this, (CompositeSurface)surface, null, null);
        sa.calculateSurfaceAreaSync(null);
        ArrayList<Analysis> list = new ArrayList<Analysis>();
        list.add(sa.getVisibleSurfaceStat());
        return Context.getContext().addAnalysis(list);
    }

    public List<Analysis> runSurfaceVolumeStats(Surface surface) {
        SurfaceVolume sa = new SurfaceVolume(this, (CompositeSurface)surface, null, null);
        sa.calculateSurfaceVolumeSync(null);
        ArrayList<Analysis> list = new ArrayList<Analysis>();
        list.add(sa.getVisibleSurfaceStat());
        return Context.getContext().addAnalysis(list);
    }

    public void runThresholdToConvexHullROI(double threshold, boolean percentMax, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            double threshMin = threshold;
            if (percentMax) {
                Volume vol = (Volume)this.getCurrentVolume();
                vol.updateMaxMin(vol, vol.findRangeSeries());
                double imageMax = vol.getImageMax();
                threshMin = imageMax * (threshold / 100.0);
            }
            this.roiManager.runConvexHull(threshMin, Double.MAX_VALUE, excludeZero, false, 0L, 0, false, isSeries, isDynamicThreshold);
        }
    }

    public void runThresholdToConvexHullROISlice(double threshold, int sliceDirection, int sliceNum, boolean percentMax, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            double threshMin = threshold;
            if (percentMax) {
                Volume vol = (Volume)this.getCurrentVolume();
                vol.updateMaxMin(vol, vol.findRangeSeries());
                double imageMax = vol.getImageMax();
                threshMin = imageMax * (threshold / 100.0);
            }
            this.roiManager.runConvexHullROI(sliceNum, sliceDirection, threshMin, Double.MAX_VALUE, excludeZero, false, 0L, 0, false, isSeries, isDynamicThreshold);
        }
    }

    public boolean runThresholdToROI(double threshold, boolean percentMax, boolean excludeZero, boolean makeSeriesROI, boolean seriesUsesDynamicThreshold) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            double threshMin = threshold;
            if (percentMax) {
                Volume vol = (Volume)this.getCurrentVolume();
                vol.updateMaxMin(vol, vol.findRangeSeries());
                double imageMax = vol.getImageMax();
                threshMin = imageMax * (threshold / 100.0);
            }
            this.roiManager.updateROIBufferSeries(makeSeriesROI);
            return this.roiManager.runThresholdROI(threshMin, excludeZero, makeSeriesROI, seriesUsesDynamicThreshold);
        }
        return false;
    }

    public boolean runThresholdToROISlice(double threshold, int sliceDirection, int sliceNumber, boolean percentMax, boolean excludeZero, boolean makeSeriesROI, boolean seriesUsesDynamicThreshold) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            double threshMin = threshold;
            if (percentMax) {
                Volume vol = (Volume)this.getCurrentVolume();
                vol.updateMaxMin(vol, vol.findRangeSeries());
                double imageMax = vol.getImageMax();
                threshMin = imageMax * (threshold / 100.0);
            }
            this.roiManager.updateROIBufferSeries(makeSeriesROI);
            return this.roiManager.runThresholdROI(sliceNumber, sliceDirection, threshMin, excludeZero, makeSeriesROI, seriesUsesDynamicThreshold);
        }
        return false;
    }

    public boolean runThresholdToShrinkWrapROI(double threshold, boolean percentMax, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            double threshMin = threshold;
            if (percentMax) {
                Volume vol = (Volume)this.getCurrentVolume();
                vol.updateMaxMin(vol, vol.findRangeSeries());
                double imageMax = vol.getImageMax();
                threshMin = imageMax * (threshold / 100.0);
            }
            return this.roiManager.runShrinkWrap3D(threshMin, Double.MAX_VALUE, (Volume)this.getCurrentVolume(), false, this.roiManager.getBuffer().getSelected(), this.roiManager.getCurrentROI(), excludeZero, isSeries, isDynamicThreshold);
        }
        return false;
    }

    public boolean runThresholdToShrinkWrapROIAllSlices(double threshold, int sliceDirection, boolean percentMax, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            double threshMin = threshold;
            if (percentMax) {
                Volume vol = (Volume)this.getCurrentVolume();
                vol.updateMaxMin(vol, vol.findRangeSeries());
                double imageMax = vol.getImageMax();
                threshMin = imageMax * (threshold / 100.0);
            }
            return this.roiManager.shrinkWrap2D(-1, sliceDirection, threshMin, Double.MAX_VALUE, false, this.roiManager.getBuffer().getSelected(), this.roiManager.getCurrentROI(), excludeZero, isSeries, isDynamicThreshold, true);
        }
        return false;
    }

    public boolean runThresholdToShrinkWrapROISlice(double threshold, int sliceDirection, int sliceNumber, boolean percentMax, boolean excludeZero, boolean isSeries, boolean isDynamicThreshold) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            double threshMin = threshold;
            if (percentMax) {
                Volume vol = (Volume)this.getCurrentVolume();
                vol.updateMaxMin(vol, vol.findRangeSeries());
                double imageMax = vol.getImageMax();
                threshMin = imageMax * (threshold / 100.0);
            }
            return this.roiManager.shrinkWrap2D(sliceNumber, sliceDirection, threshMin, Double.MAX_VALUE, false, this.roiManager.getBuffer().getSelected(), this.roiManager.getCurrentROI(), excludeZero, isSeries, isDynamicThreshold, true);
        }
        return false;
    }

    public Analysis runVolumeStats() {
        Volume vol = (Volume)this.getCurrentVolume();
        VolumeStatOp op = new VolumeStatOp(this, vol);
        OperationBuilder<Analysis> builder = new OperationBuilder<Analysis>(this, op);
        Analysis analysis = builder.runSynchronously();
        return Context.getContext().addAnalysis(analysis);
    }

    public void selectAll() {
        if (this.poiManager != null) {
            this.poiManager.selectAll();
        }
        if (this.loiManagerAxial != null) {
            this.loiManagerAxial.selectAll();
        }
        if (this.loiManagerCoronal != null) {
            this.loiManagerCoronal.selectAll();
        }
        if (this.loiManagerSagittal != null) {
            this.loiManagerSagittal.selectAll();
        }
        if (this.roiManager != null) {
            this.roiManager.selectAll();
        }
    }

    public List<Analysis> runVolumeStatsROI(long roiMask, boolean includePointsAndLines, boolean onlySelectedPoints, boolean onlySelectedLines) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            if (includePointsAndLines) {
                stats.addAll(this.runVolumeStatsROIPoints(onlySelectedPoints));
                stats.addAll(this.runVolumeStatsROILines(onlySelectedLines));
            }
            Volume vol = (Volume)this.getCurrentVolume();
            VolumeStatROIOp op = new VolumeStatROIOp(this, vol, this.roiManager.getBuffer(), roiMask, this.roiManager);
            OperationBuilder<Map<Long, Analysis>> builder = new OperationBuilder<Map<Long, Analysis>>(this, op);
            Map<Long, Analysis> results = builder.runSynchronously();
            stats.addAll(Context.getContext().addAnalysis(new ArrayList<Analysis>(results.values())));
        }
        return stats;
    }

    public List<Analysis> runVolumeStatsROILines(boolean onlySelected) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        Volume volume = (Volume)this.getBaseVolume();
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            Analysis result;
            LineStatROIOp op;
            Volume vol;
            LOIShape shape;
            int ctr;
            for (ctr = 0; ctr < volume.getZDim(); ++ctr) {
                if (!this.loiManagerAxial.hasShapes(ctr)) continue;
                for (shape = this.loiManagerAxial.getShape(ctr); shape != null; shape = shape.getNext()) {
                    if (onlySelected && !shape.isSelected()) continue;
                    vol = (Volume)this.getCurrentVolume();
                    op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                    result = op.process(shape, 0, volume.getCurrentTimepoint());
                    stats.add(result);
                }
            }
            for (ctr = 0; ctr < volume.getYDim(); ++ctr) {
                if (!this.loiManagerCoronal.hasShapes(ctr)) continue;
                for (shape = this.loiManagerCoronal.getShape(ctr); shape != null; shape = shape.getNext()) {
                    if (onlySelected && !shape.isSelected()) continue;
                    vol = (Volume)this.getCurrentVolume();
                    op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                    result = op.process(shape, 1, volume.getCurrentTimepoint());
                    stats.add(result);
                }
            }
            for (ctr = 0; ctr < volume.getXDim(); ++ctr) {
                if (!this.loiManagerSagittal.hasShapes(ctr)) continue;
                for (shape = this.loiManagerSagittal.getShape(ctr); shape != null; shape = shape.getNext()) {
                    if (onlySelected && !shape.isSelected()) continue;
                    vol = (Volume)this.getCurrentVolume();
                    op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                    result = op.process(shape, 2, volume.getCurrentTimepoint());
                    stats.add(result);
                }
            }
        }
        return Context.getContext().addAnalysis(stats);
    }

    public List<Analysis> runVolumeStatsROIPoints(boolean onlySelected) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        if (this.initializePointManager()) {
            Volume volume = (Volume)this.getBaseVolume();
            for (int ctr = 0; ctr < volume.getZDim(); ++ctr) {
                for (POI poi = this.poiManager.getPOIs(ctr, 0); poi != null; poi = poi.getNextAxial()) {
                    if (onlySelected && !poi.isSelected()) continue;
                    Volume vol = (Volume)this.getCurrentVolume();
                    PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                    Analysis result = op.process(poi, vol.getCurrentTimepoint());
                    stats.add(result);
                }
            }
        }
        return Context.getContext().addAnalysis(stats);
    }

    public void save() {
        if (this.loadedURI != null) {
            Volume volume = (Volume)this.getBaseVolume();
            try {
                volume.writeFiles(new File(this.loadedURI), true);
            }
            catch (VolumeIOException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (InvalidHeaderException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
    }

    public void saveAs(String saveLocation, String headerFormat, int datatype, int numBytes, boolean littleEndian, boolean compress, int xMin, int xMax, int yMin, int yMax, int zMin, int zMax, int tMin, int tMax, double xSize, double ySize, double zSize, double tSize, String orientation, boolean applyTransform, boolean applyOverlay, boolean overlayThreshold, boolean overlayMix, int interpolation, boolean applyDataScales, boolean fitPrecision, boolean maintainZero) {
        Volume volume = (Volume)this.getBaseVolume();
        if (fitPrecision || overlayThreshold) {
            volume.updateMaxMin(volume.findRangeSeries());
        }
        try {
            this.loadedURI = new File(saveLocation).toURI();
            ImageBounds ib = new ImageBounds(xMin, xMax, yMin, yMax, zMin, zMax);
            ib.setRangeT(tMin, tMax);
            ImageType it = new ImageType(numBytes, datatype, numBytes * 8, littleEndian);
            it.setCompressionType(compress ? 1 : 0);
            volume.writeFilesAs(new File(saveLocation), it, applyTransform ? 1 : 0, orientation, volume.getOrigin(), true, headerFormat, applyDataScales, this.isWorldMode(), applyOverlay ? this.getCurrentScreenVolume() : null, true, 0, interpolation == 0, interpolation == 1, interpolation == 2, overlayThreshold, this.getCurrentScreenVolume().getScreenMin(), overlayMix, fitPrecision, maintainZero, ib, xSize, ySize, zSize, tSize, true);
            this.reload();
        }
        catch (VolumeIOException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    public void saveAs(String saveLocation, Surface surface, boolean includeLinesAndPoints) {
        Surface[] surfaceArray;
        MangoFormat mangoFormat = new MangoFormat();
        File file = new File(saveLocation);
        if (surface != null) {
            Surface[] surfaceArray2 = new Surface[1];
            surfaceArray = surfaceArray2;
            surfaceArray2[0] = surface;
        } else {
            surfaceArray = this.surfaces.toArray(new Surface[this.surfaces.size()]);
        }
        mangoFormat.writeSurfaceFile(file, surfaceArray, includeLinesAndPoints ? this.getShapeData() : null, this);
    }

    public void saveOverlays() {
    }

    public void saveROI(String saveLocation) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            this.roiManager.doSaveROI(new File(saveLocation), -1);
        }
    }

    public void saveSingleROI(String saveLocation, int index) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            this.roiManager.doSaveROI(new File(saveLocation), index);
        }
    }

    public void select(ROI roi, boolean select) {
        if (roi instanceof Mask) {
            int index = roi.getColor();
            if (this.isMultiSliceMode()) {
                this.roiManager.setSelectedState(index, select);
            } else {
                this.roiManager.setSelectedState(index, this.getSliceNumber(), this.getSliceDirection(), select);
            }
        } else if (roi instanceof LOIShape) {
            LOIShape line = (LOIShape)roi;
            line.setSelectedState(select);
        } else if (roi instanceof POI) {
            POI poi = (POI)roi;
            poi.setSelectedState(select);
        }
    }

    public void setBackground(int rgb) {
    }

    @Deprecated
    public void setCoordinateSpace(int index) {
        this.setOrientationOption(this.getBaseVolume(), index);
    }

    public void setCurrentPosition(Coordinate coord) {
        this.currentCoordinate.setValues(coord);
    }

    public void setCurrentSeriesPoint(int val) {
        block5: {
            Volume volume = (Volume)this.getCurrentVolume();
            if (val < 0 || val >= volume.getNumTimepoints()) break block5;
            volume.setCurrentTimepoint(val);
            if (this.getBaseVolume() != volume) {
                if (this.isWorldMode()) {
                    for (ImageVolume overlay : this.getOverlays()) {
                        if (overlay.getSeriesLength() <= 1) continue;
                        ((Volume)overlay).setCurrentTimepoint(volume.getTimeframe() * (double)volume.getCurrentTimepoint());
                    }
                } else {
                    for (ImageVolume overlay : this.getOverlays()) {
                        if (overlay.getSeriesLength() <= 1) continue;
                        overlay.setCurrentSeriesPoint(val);
                    }
                }
            }
        }
    }

    public void setCurrentVolumeIndex(int index) {
        this.currentVolume = index;
    }

    public void selectMenuOption(String name) {
        AppLogger.warn((String)("selectMenuOption(\"" + name + "\") is not supported at the command-line"));
    }

    public List<Analysis> measureAll() {
        ArrayList<Analysis> list = new ArrayList<Analysis>();
        for (Surface surface : this.surfaces) {
            if (surface.isBaseSurface()) continue;
            list.addAll(this.runSurfaceAreaStats(surface));
            list.addAll(this.runSurfaceVolumeStats(surface));
        }
        for (edu.uthscsa.ric.visualization.surface.primitives.Shape line : this.lines) {
            list.add(this.measureLine(line));
        }
        return Context.getContext().addAnalysis(list);
    }

    public void pauseScriptForUserInput() {
    }

    public String prepareImageOperationTreeNode(String input, List<VolumeManager> managerList, VolumeManager originatingManager, List<Double> valueList) {
        double[] parsedValues;
        StringBuffer sb = new StringBuffer(input);
        for (double value : parsedValues = ImageOperationTreeNode.makeReplacements(sb, originatingManager)) {
            valueList.add(value);
        }
        return sb.toString();
    }

    public void recordPluginAction(String pluginName, String ... args) {
    }

    public String makeFilename(String ext) {
        URI uri = this.getLoadedURI();
        File outputFile = null;
        int index = 1;
        do {
            String suffix = "";
            if (index > 1) {
                suffix = String.valueOf(index);
            }
            if (FileUtilities.uriIsFile((URI)uri)) {
                File file = new File(uri);
                if (StringUtils.isBlank((CharSequence)ext)) {
                    outputFile = file.getParentFile();
                } else {
                    File dir = file.getParentFile();
                    String filename = FileUtilities.removeExtension((String)file.getName());
                    filename = filename + suffix;
                    filename = filename + ext;
                    outputFile = new File(dir, filename);
                }
            } else {
                File dir = Platform.getDesktopDir();
                String filename = FileUtilities.removeExtension((String)FileUtilities.getName((URI)uri));
                filename = filename + suffix;
                filename = filename + ext;
                outputFile = new File(dir, filename);
            }
            ++index;
        } while (outputFile.exists() || outputFile.isDirectory());
        return outputFile.toString();
    }

    @Override
    public int getXDim(int sliceDirection) {
        if (sliceDirection == 0) {
            return this.getXDim();
        }
        if (sliceDirection == 1) {
            return this.getXDim();
        }
        return this.getYDim();
    }

    public double getXSize() {
        return this.getBaseVolume().getXSize();
    }

    @Override
    public double getXSize(int sliceDirection) {
        if (sliceDirection == 0) {
            return this.getXSize();
        }
        if (sliceDirection == 1) {
            return this.getXSize();
        }
        return this.getYSize();
    }

    public void captureLayout(String saveLocation, int rows, int columns, int startSlice, int skipSlices, boolean series, boolean useLabels, boolean useColorBars, boolean useText, String title, String footnote) {
        Layout layout = new Layout(Context.getContext(), this, true);
        layout.setParametersAndSave(saveLocation, rows, columns, startSlice, skipSlices, series, useLabels, useColorBars, useText, title, footnote);
    }

    public void captureSnapshot(String location) {
        Snapshot.takeSnapshot(location, this);
    }

    public void captureVideoStart(String saveLocation, int videoFormat, int videoQuality, int fps, boolean animate) {
        if (animate) {
            CineSlice.startSilentFreeRecording(this, fps, videoQuality, videoFormat, new File(saveLocation), animate);
        } else {
            AppLogger.warn((String)"Free-form video recording is not supported at the command-line");
        }
    }

    public void captureVideoStop() {
    }

    public void continueScript() {
    }

    public void addOverlayURL(String url) {
        try {
            this.addNewVolume(new URL(url).toURI());
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (URISyntaxException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    public Surface addShapeFromLogical(List<ImageVolume> overlays, String name, int rgb, double logicalThreshold, boolean shrinkWrap, boolean maximum, boolean imageSmoothing, double width, int kernelSize, double resX, double resY, double resZ, boolean surfaceSmoothing, double pointError, double featureAngle, int iterations) {
        SurfaceBuildParameters params = new SurfaceBuildParameters(this.getBaseVolume());
        params.setUseImageSmoothing(imageSmoothing);
        params.setUseSurfaceSmoothing(surfaceSmoothing);
        params.setSmoothingKernel(kernelSize);
        params.setSurfaceSmoothingIterations(iterations);
        params.setThreshold((float)logicalThreshold);
        params.setUseNegative(maximum);
        params.setSmoothingWidth((float)width);
        params.setResX((float)resX);
        params.setResY((float)resY);
        params.setResZ((float)resZ);
        params.setFeatureError((float)pointError);
        params.setFeatureAngle((float)featureAngle);
        params.setUseShrinkWrap(shrinkWrap);
        Logical logical = new Logical(null);
        for (ImageVolume vol : overlays) {
            logical.addOverlay((Volume)vol);
        }
        SurfaceFactory factory = new SurfaceFactory(params, (Volume)this.getBaseVolume());
        factory.setSameThread(true);
        factory.setViewer(this);
        return factory.createLogicalSurface(null, logical, name, new Color(rgb));
    }

    public Surface addShapeFromOverlay(ImageVolume overlay, String name, int rgb, double threshold, boolean shrinkWrap, boolean maximum, boolean imageSmoothing, double width, int kernelSize, double resX, double resY, double resZ, boolean surfaceSmoothing, double pointError, double featureAngle, int iterations) {
        SurfaceBuildParameters params = new SurfaceBuildParameters(overlay);
        params.setUseImageSmoothing(imageSmoothing);
        params.setUseSurfaceSmoothing(surfaceSmoothing);
        params.setSmoothingKernel(kernelSize);
        params.setSurfaceSmoothingIterations(iterations);
        params.setThreshold((float)threshold);
        params.setUseNegative(maximum);
        params.setSmoothingWidth((float)width);
        params.setResX((float)resX);
        params.setResY((float)resY);
        params.setResZ((float)resZ);
        params.setFeatureError((float)pointError);
        params.setFeatureAngle((float)featureAngle);
        params.setUseShrinkWrap(shrinkWrap);
        SurfaceFactory factory = new SurfaceFactory(params, (Volume)this.getBaseVolume());
        factory.setSameThread(true);
        factory.setViewer(this);
        return factory.createOverlaySurface(null, (Volume)overlay, name, new Color(rgb));
    }

    public Surface addShapeFromROI(int roiColorIndex, String name, int rgb, double roiThreshold, boolean shrinkWrap, boolean maximum, boolean imageSmoothing, double width, int kernelSize, double resX, double resY, double resZ, boolean surfaceSmoothing, double pointError, double featureAngle, int iterations) {
        SurfaceBuildParameters params = new SurfaceBuildParameters(this.getBaseVolume());
        params.setUseImageSmoothing(imageSmoothing);
        params.setUseSurfaceSmoothing(surfaceSmoothing);
        params.setSmoothingKernel(kernelSize);
        params.setSurfaceSmoothingIterations(iterations);
        params.setThreshold((float)roiThreshold);
        params.setUseNegative(maximum);
        params.setSmoothingWidth((float)width);
        params.setResX((float)resX);
        params.setResY((float)resY);
        params.setResZ((float)resZ);
        params.setFeatureError((float)pointError);
        params.setFeatureAngle((float)featureAngle);
        params.setUseShrinkWrap(shrinkWrap);
        SurfaceFactory factory = new SurfaceFactory(params, (Volume)this.getBaseVolume());
        factory.setSameThread(true);
        factory.setViewer(this);
        return factory.createROISurface(null, this.roiManager, roiColorIndex, name, new Color(rgb));
    }

    public List<Surface> addShapesFromFile(String openLocation) {
        SurfaceReader sr = new SurfaceReader();
        Vector<edu.uthscsa.ric.visualization.surface.primitives.Shape> shapes = new Vector<edu.uthscsa.ric.visualization.surface.primitives.Shape>();
        Surface[] surfaces = sr.doReadFile(new File(openLocation), this, null, false, shapes);
        for (Surface surface : surfaces) {
            this.surfaces.add(surface);
        }
        for (edu.uthscsa.ric.visualization.surface.primitives.Shape shape : shapes) {
            if (shape.getPoints().length > 1) {
                this.lines.add(shape);
                continue;
            }
            this.points.add(shape);
        }
        return Arrays.asList(surfaces);
    }

    public void associatePluginWindow(String title, JFrame window) {
    }

    public ProjectionManager buildProjection(int rankType, int sliceDirection, double resX, double resY, double resZ, int rotationAxis, int projectionQuality) {
        BuildProjectionParameters bpp = new BuildProjectionParameters();
        bpp.axisOfRotation = rotationAxis;
        bpp.planeOfProjection = sliceDirection;
        bpp.smoothness = projectionQuality;
        bpp.resX = (float)resX;
        bpp.resY = (float)resY;
        bpp.resZ = (float)resZ;
        bpp.rankType = rankType;
        ProjectionBuilder pb = new ProjectionBuilder(this, bpp);
        pb.project(null, null, true);
        return this;
    }

    public SurfaceManager buildSurface(double threshold, boolean percentMax, boolean shrinkWrap, boolean maximum, boolean imageSmoothing, double width, int kernelSize, double resX, double resY, double resZ, boolean surfaceSmoothing, double pointError, double featureAngle, int iterations) {
        this.surfaceParameters = new SurfaceBuildParameters(this.getBaseVolume());
        this.surfaceParameters.setUseImageSmoothing(imageSmoothing);
        this.surfaceParameters.setUseSurfaceSmoothing(surfaceSmoothing);
        this.surfaceParameters.setSmoothingKernel(kernelSize);
        this.surfaceParameters.setSurfaceSmoothingIterations(iterations);
        this.surfaceParameters.setThreshold(percentMax ? (float)(threshold / 100.0 * ((Volume)this.getBaseVolume()).getImageMax()) : (float)threshold);
        this.surfaceParameters.setUseNegative(maximum);
        this.surfaceParameters.setSmoothingWidth((float)width);
        this.surfaceParameters.setResX((float)resX);
        this.surfaceParameters.setResY((float)resY);
        this.surfaceParameters.setResZ((float)resZ);
        this.surfaceParameters.setFeatureError((float)pointError);
        this.surfaceParameters.setFeatureAngle((float)featureAngle);
        this.surfaceParameters.setUseShrinkWrap(shrinkWrap);
        SurfaceFactory factory = new SurfaceFactory(this.surfaceParameters, (Volume)this.getBaseVolume());
        factory.setSameThread(true);
        factory.setViewer(this);
        Surface surf = factory.createSurface(null);
        this.surfaces.add(surf);
        return this;
    }

    public Point findGoodPluginWindowLocation(Dimension dimension) {
        return new Point(0, 0);
    }

    public void flipOrientation(ImageVolume volume, int sliceDirection) {
        Volume vol = (Volume)volume;
        if (sliceDirection == 0) {
            vol.flipSI();
        } else if (sliceDirection == 1) {
            vol.flipAP();
        } else if (sliceDirection == 2) {
            vol.flipLR();
        }
    }

    public List<Surface> getAddedShapes() {
        return this.surfaces.subList(1, this.surfaces.size());
    }

    public List<edu.uthscsa.ric.visualization.surface.primitives.Shape> getAllPointsAndLines() {
        ArrayList<edu.uthscsa.ric.visualization.surface.primitives.Shape> list = new ArrayList<edu.uthscsa.ric.visualization.surface.primitives.Shape>();
        list.addAll(this.points);
        list.addAll(this.lines);
        return list;
    }

    @Override
    public int getAxialSliceNumber() {
        return this.currentCoordinate.zInt;
    }

    public Surface getBaseSurface() {
        return this.surfaces.get(0);
    }

    public ImageVolume getBaseVolume() {
        return this.volumes.get(0).getImageVolume();
    }

    @Override
    public int getCoronalSliceNumber() {
        return this.currentCoordinate.yInt;
    }

    public Coordinate getCurrentPosition() {
        try {
            return (Coordinate)this.currentCoordinate.clone();
        }
        catch (CloneNotSupportedException ex) {
            AppLogger.error((Throwable)ex);
            return null;
        }
    }

    public Coordinate getCurrentWorldPosition() {
        Volume volume = (Volume)this.getBaseVolume();
        Coordinate coorReturn = new Coordinate();
        Coordinate originImage = volume.getOrigin();
        coorReturn.setValues((double)(this.currentCoordinate.xInt - originImage.xInt) * volume.getXSize(), (double)(originImage.yInt - this.currentCoordinate.yInt) * volume.getYSize(), (double)(originImage.zInt - this.currentCoordinate.zInt) * volume.getZSize());
        return coorReturn;
    }

    public ImageVolume getCurrentVolume() {
        return this.volumes.get(this.currentVolume).getImageVolume();
    }

    private ScreenVolume getCurrentScreenVolume() {
        return this.volumes.get(this.currentVolume);
    }

    public JFrame getFrame() {
        return null;
    }

    public Histogram getHistogramAnalysis() {
        return this.histogram;
    }

    public List<edu.uthscsa.ric.visualization.surface.primitives.Shape> getLines() {
        return this.lines;
    }

    public URI getLoadedURI() {
        return this.loadedURI;
    }

    public URI getLoadedURI(ImageVolume volume) {
        ScreenVolume screenVol = this.findScreenVolume(volume);
        if (screenVol != null) {
            return screenVol.getURI();
        }
        return null;
    }

    @Override
    public LOIManager getLOIManagerAxial() {
        return this.loiManagerAxial;
    }

    @Override
    public LOIManager getLOIManagerCoronal() {
        return this.loiManagerCoronal;
    }

    public LOIManager getLOIManagerMain() {
        int sliceDirection = this.getSliceDirection();
        if (sliceDirection == 0) {
            return this.loiManagerAxial;
        }
        if (sliceDirection == 1) {
            return this.loiManagerCoronal;
        }
        return this.loiManagerSagittal;
    }

    @Override
    public LOIManager getLOIManagerSagittal() {
        return this.loiManagerSagittal;
    }

    @Deprecated
    public MangoData getMangoData() {
        return new MangoData(this.getBaseMangoImage(), this.getOverlayMangoImages(), (ScreenImage[])this.volumes.toArray(new ScreenVolume[this.volumes.size()]), this.getRoiData());
    }

    public MangoImage[] getOverlayMangoImages() {
        MangoImage[] overlayMangos = null;
        int numOverlays = this.getOverlays().size();
        if (numOverlays > 0) {
            overlayMangos = new MangoImage[numOverlays];
            for (int ctr = 1; ctr < numOverlays; ++ctr) {
                Volume currentVol = this.volumes.get(ctr).getVolume();
                File file = null;
                URI uri = this.volumes.get(ctr).getURI();
                if (uri != null) {
                    file = new File(uri);
                }
                overlayMangos[ctr] = new MangoImage((ImageVolume)currentVol, currentVol.getImageDimensions(), currentVol.getVoxelDimensions(), currentVol.getImageType(), currentVol.getImageRange(), currentVol.getImageDescription(), currentVol.getFormatSpecificInfo(), currentVol.getOrigin(), currentVol.getOriginNative(), null, (ScreenImage)this.volumes.get(ctr), file, currentVol.getOrientationString());
            }
        }
        return overlayMangos;
    }

    @Override
    public String getMangoVersion() {
        return Mango.getVersionString();
    }

    public Coordinate getOrigin() {
        return this.getBaseVolume().getOrigin();
    }

    public String toString() {
        Volume volume = (Volume)this.getBaseVolume();
        String name = volume.getTitle();
        if (StringUtils.isBlank((CharSequence)name)) {
            name = StringUtilities.makeNiceImageName((String)FileUtilities.getName((URI)this.getLoadedURI()));
        }
        return name;
    }

    public List<ImageVolume> getOverlays() {
        ArrayList<ImageVolume> imageVols = new ArrayList<ImageVolume>();
        for (int ctr = 1; ctr < this.volumes.size(); ++ctr) {
            imageVols.add(this.volumes.get(ctr).getImageVolume());
        }
        return imageVols;
    }

    @Override
    public POIManager getPOIManager() {
        return this.poiManager;
    }

    public List<edu.uthscsa.ric.visualization.surface.primitives.Shape> getPoints() {
        return this.points;
    }

    public ProjectionManager getProjectionManager() {
        return this;
    }

    public int getRoiColor() {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            return this.roiManager.getCurrentROI();
        }
        return -1;
    }

    public ROIData getRoiData() {
        return new MangoROI((ROIMaskManager)this.roiManager, new ShapesManager[]{this.loiManagerAxial, this.loiManagerCoronal, this.loiManagerSagittal}, null, (PointsManager)this.poiManager, null);
    }

    @Override
    public ROIManager getROIManager() {
        return this.roiManager;
    }

    @Override
    public int getSagittalSliceNumber() {
        return this.currentCoordinate.xInt;
    }

    public String getScriptObjectName() {
        int index = Context.getContext().getAllVolumeManagers().indexOf(this);
        if (index == 0) {
            return ScriptManager.DEFAULT_VOLMAN_MANAGER;
        }
        return ScriptManager.DEFAULT_VOLMAN_MANAGER + (index + 1);
    }

    public edu.uthscsa.ric.visualization.surface.primitives.Shape[] getShapeData() {
        ArrayList<edu.uthscsa.ric.visualization.surface.primitives.Shape> list = new ArrayList<edu.uthscsa.ric.visualization.surface.primitives.Shape>();
        list.addAll(this.lines);
        list.addAll(this.points);
        edu.uthscsa.ric.visualization.surface.primitives.Shape[] shapeData = null;
        if (list.size() > 0) {
            shapeData = list.toArray(new edu.uthscsa.ric.visualization.surface.primitives.Shape[list.size()]);
        }
        return shapeData;
    }

    public int getSliceDirection() {
        return this.sliceDirection;
    }

    public int getSliceNumber() {
        if (this.sliceDirection == 0) {
            return this.currentCoordinate.zInt;
        }
        if (this.sliceDirection == 1) {
            return this.currentCoordinate.yInt;
        }
        return this.currentCoordinate.xInt;
    }

    public SurfaceManager getSurfaceManager() {
        return this;
    }

    public Surface[] getSurfaces() {
        return this.surfaces.toArray(new Surface[this.surfaces.size()]);
    }

    @Override
    public File getTempDir() {
        return Platform.getTempDir();
    }

    public float getThreshold() {
        return this.surfaceParameters.getThreshold();
    }

    public int getYDim() {
        return this.getBaseVolume().getYDim();
    }

    @Override
    public int getYDim(int sliceDirection) {
        if (sliceDirection == 0) {
            return this.getYDim();
        }
        if (sliceDirection == 1) {
            return this.getZDim();
        }
        return this.getZDim();
    }

    public double getYSize() {
        return this.getBaseVolume().getYSize();
    }

    @Override
    public double getYSize(int sliceDirection) {
        if (sliceDirection == 0) {
            return this.getYSize();
        }
        if (sliceDirection == 1) {
            return this.getZSize();
        }
        return this.getZSize();
    }

    public double getSliceSize(int sliceDirection) {
        if (sliceDirection == 0) {
            return this.getZSize();
        }
        if (sliceDirection == 1) {
            return this.getYSize();
        }
        return this.getXSize();
    }

    public int getSliceDim(int sliceDirection) {
        if (sliceDirection == 0) {
            return this.getZDim();
        }
        if (sliceDirection == 1) {
            return this.getYDim();
        }
        return this.getXDim();
    }

    public int getZDim() {
        return this.getBaseVolume().getZDim();
    }

    public double getZSize() {
        return this.getBaseVolume().getZSize();
    }

    public void goToShape(edu.uthscsa.ric.visualization.surface.primitives.Shape shape) {
    }

    public void hideAll(boolean hidden) {
        for (Surface surface : this.surfaces) {
            if (surface.isBaseSurface()) continue;
            surface.setHidden(hidden);
        }
        for (edu.uthscsa.ric.visualization.surface.primitives.Shape shape : this.lines) {
            shape.setVisible(!hidden);
        }
        for (edu.uthscsa.ric.visualization.surface.primitives.Shape shape : this.points) {
            shape.setVisible(!hidden);
        }
    }

    public boolean increment(int direction) {
        int oldValue;
        int newValue;
        boolean baseImageIsCurrent;
        boolean hasBaseImageTimeseries = this.getBaseVolume().getSeriesLength() > 1;
        boolean hasOverlayTimeseries = this.hasOverlayTimeseries();
        boolean bl = baseImageIsCurrent = !this.isCurrentVolumeOverlay();
        if (direction == 3) {
            ImageVolume refTimeseries;
            boolean didIncrement = false;
            if (baseImageIsCurrent && hasBaseImageTimeseries) {
                didIncrement = this.getCurrentVolume().getCurrentSeriesPoint() < this.getCurrentVolume().getSeriesLength() - 1;
                if (didIncrement) {
                    this.getBaseVolume().setCurrentSeriesPoint(this.getBaseVolume().getCurrentSeriesPoint() + 1);
                }
            } else if (hasOverlayTimeseries && (refTimeseries = this.findTopOverlayTimeseries()) != null && (didIncrement = refTimeseries.getCurrentSeriesPoint() < refTimeseries.getSeriesLength() - 1)) {
                refTimeseries.setCurrentSeriesPoint(refTimeseries.getCurrentSeriesPoint() + 1);
                this.reconcileOverlayTimeseries(refTimeseries);
            }
            return didIncrement;
        }
        if (direction == 0) {
            int oldValue2 = this.currentCoordinate.zInt;
            int newValue2 = oldValue2 + 1;
            if (newValue2 < this.getBaseVolume().getZDim()) {
                this.currentCoordinate.zInt = newValue2;
                this.currentCoordinate.zDbl = this.currentCoordinate.zInt;
                return true;
            }
        } else if (direction == 1) {
            int oldValue3 = this.currentCoordinate.yInt;
            int newValue3 = oldValue3 + 1;
            if (newValue3 < this.getBaseVolume().getYDim()) {
                this.currentCoordinate.yInt = newValue3;
                this.currentCoordinate.yDbl = this.currentCoordinate.yInt;
                return true;
            }
        } else if (direction == 2 && (newValue = (oldValue = this.currentCoordinate.xInt) + 1) < this.getBaseVolume().getXDim()) {
            this.currentCoordinate.xInt = newValue;
            this.currentCoordinate.xDbl = this.currentCoordinate.xInt;
            return true;
        }
        return false;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    public boolean isCurrentVolumeOverlay() {
        return this.getCurrentVolume() != this.getBaseVolume();
    }

    public boolean isCurrentVolumeUsingTransform() {
        return !((Volume)this.getCurrentVolume()).isIdentityTransform();
    }

    public boolean isMultiSliceMode() {
        return Context.getContext().isMultisliceMode();
    }

    @Override
    public boolean isShowingROI() {
        return this.showROI;
    }

    public boolean isVolumeDisplayHidden(ImageVolume volume) {
        return this.findScreenVolume(volume).isHidden();
    }

    public boolean isVolumeDisplayNegative(ImageVolume volume) {
        return this.findScreenVolume(volume).isNegative();
    }

    public boolean isVolumeOverlay(ImageVolume volume) {
        return volume != this.getBaseVolume();
    }

    public boolean isVolumeUsingTransform(ImageVolume volume) {
        if (this.isVolumeOverlay(volume)) {
            return !((Volume)volume).isIdentityTransform();
        }
        return !((Volume)volume).isIdentityTransform() && this.usingTransform;
    }

    public void reload() {
        Volume volume = (Volume)this.getBaseVolume();
        this.filterBuffer = null;
        volume.clear(true);
        volume.preload();
        volume.setUser(this);
        volume.addListener(this);
        volume.setLabelListener(this);
        try {
            volume.readHeader(this.loadedURI);
            volume.doReadFiles();
            volume.readLabelData();
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (VolumeIOException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
        }
        if (volume.getImageMax() <= volume.getImageMin()) {
            volume.updateMaxMin(volume.findRangeSeries());
        }
        volume.updateDisplayRangeToImageRange();
        this.volumeReloaded(true);
    }

    public void removeAll() {
        Surface surface = this.surfaces.get(0);
        this.surfaces.clear();
        this.surfaces.add(surface);
    }

    public void removeShape(edu.uthscsa.ric.visualization.surface.primitives.Shape shape) {
        if (shape.getPoints().length > 1) {
            this.lines.remove(shape);
        } else {
            this.points.remove(shape);
        }
    }

    public void removeSurface(Surface surface) {
        this.surfaces.remove(surface);
    }

    public void removeOverlay(ImageVolume volume) {
        ScreenVolume toRemove = null;
        for (ScreenVolume screenVol : this.volumes) {
            if (screenVol.getImageVolume() != volume) continue;
            toRemove = screenVol;
            break;
        }
        this.volumes.remove(toRemove);
        this.hasScreenData = false;
    }

    public void removeAllOverlays() {
        ScreenVolume vol = this.volumes.get(0);
        this.volumes.clear();
        this.volumes.add(vol);
        this.hasScreenData = false;
    }

    public void runAddROI(Coordinate coor, double size, boolean sphere) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            Volume volume = (Volume)this.getBaseVolume();
            int sizeX = (int)Math.round(size / volume.getXSize());
            int sizeY = (int)Math.round(size / volume.getYSize());
            int sizeZ = (int)Math.round(size / volume.getZSize());
            this.roiManager.runAddShape(coor, sizeX, sizeY, sizeZ, size, !sphere, sphere);
        }
    }

    public void runAddROISlice(int sliceDirection, Coordinate coor, double size, boolean circle) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            Volume volume = (Volume)this.getBaseVolume();
            int sizeX = (int)Math.round(size / volume.getXSize());
            int sizeY = (int)Math.round(size / volume.getYSize());
            int sizeZ = (int)Math.round(size / volume.getZSize());
            this.roiManager.addShape2D(coor, sliceDirection, sizeX, sizeY, sizeZ, size, !circle, circle);
        }
    }

    public List<Analysis> runAllSliceStats(int sliceDirection) {
        SliceStatOp op = new SliceStatOp(this, (Volume)this.getCurrentVolume());
        return Context.getContext().addAnalysis(op.calculateAllSliceStatsSync(sliceDirection, null));
    }

    public List<Analysis> runAllSliceStatsROI(int sliceDirection, long roiMask, boolean includeLinesAndPoints, boolean onlySelectedPoints, boolean onlySelectedLines) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        if (includeLinesAndPoints) {
            stats.addAll(this.runAllSliceStatsROIPoints(sliceDirection, onlySelectedPoints));
            stats.addAll(this.runAllSliceStatsROILines(sliceDirection, onlySelectedLines));
        }
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            SliceStatROIOp op = new SliceStatROIOp(this, (Volume)this.getCurrentVolume(), this.roiManager.getBuffer(), roiMask, this.roiManager);
            stats.addAll(op.calculateAllSliceStatsSync(sliceDirection, null));
        }
        return Context.getContext().addAnalysis(stats);
    }

    public List<Analysis> runAllVolumeStats() {
        VolumeStatOp op = new VolumeStatOp(this, (Volume)this.getCurrentVolume());
        return Context.getContext().addAnalysis(op.calculateAllVolumesStatsSync(null));
    }

    public List<Analysis> runAllVolumeStatsROI(long roiMask, boolean includePointsAndLines, boolean onlySelectedPoints, boolean onlySelectedLines) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        if (includePointsAndLines) {
            stats.addAll(this.runAllVolumeStatsROIPoints(onlySelectedPoints));
            stats.addAll(this.runAllVolumeStatsROILines(onlySelectedLines));
        }
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            VolumeStatROIOp op = new VolumeStatROIOp(this, (Volume)this.getCurrentVolume(), this.roiManager.getBuffer(), roiMask, this.roiManager);
            stats.addAll(op.calculateAllVolumesStatsSync(null));
        }
        return Context.getContext().addAnalysis(stats);
    }

    public void runCloseROI(long roiMask, int kernel) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            this.roiManager.runClose3D(kernel, roiMask);
        }
    }

    public void runCloseROISlice(int sliceDirection, int sliceNum, long roiMask, int kernel) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            this.roiManager.runClose2D(sliceNum, sliceDirection, kernel, roiMask);
        }
    }

    public List<Cluster> runClusterAnalysis(ImageVolume overlay, double threshold) {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            ClusterRejectionData crd = new ClusterRejectionData();
            crd.buffer = ROIManager.createROIFileBuffer3D(this.roiManager.getXDim(), this.roiManager.getYDim(), this.roiManager.getZDim()).asIntBuffer();
            crd.clusters = new EquivalentSetManager(true);
            this.clusterDataMap.put(overlay, crd);
            this.roiManager.findComponentMapVolume(threshold, false, (Volume)overlay, crd.buffer, crd.clusters);
            Vector<ClusterStat> stats = ClusterOperations.analyzeClusters(this, (Volume)overlay, crd);
            for (ClusterStat stat : stats) {
                clusters.add(new ClusterImpl(stat.makeAnalysis((Volume)overlay), overlay));
            }
        }
        return clusters;
    }

    public List<Cluster> runComponentAnalysisROI(int roiColorIndex) {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            ClusterRejectionData crd;
            Volume volume = (Volume)this.getCurrentVolume();
            if (this.roiManager.getClusterData(roiColorIndex) == null) {
                crd = new ClusterRejectionData();
                crd.buffer = ROIManager.createROIFileBuffer3D(this.roiManager.getXDim(), this.roiManager.getYDim(), this.roiManager.getZDim()).asIntBuffer();
                this.roiManager.setClusterData(crd, roiColorIndex);
            } else {
                this.roiManager.getClusterData((int)roiColorIndex).buffer.rewind();
            }
            crd = this.roiManager.getClusterData(roiColorIndex);
            crd.clusters = new EquivalentSetManager(true);
            this.roiManager.findComponentMapROI(roiColorIndex, crd.buffer, crd.clusters);
            Vector<ClusterStat> stats = ClusterOperations.analyzeClusters(this, volume, this.roiManager.getClusterData(roiColorIndex));
            for (ClusterStat stat : stats) {
                clusters.add(new ClusterImpl(stat.makeAnalysis(volume), volume));
            }
        }
        return clusters;
    }

    public void runComponentSplitROI(int roiColorIndex, int voxelCountThreshold) {
        String label = (this.roiManager.getLabel(roiColorIndex, "") + " " + "Cluster").trim();
        ClusterOperations.makeROIOfCluster(this.roiManager, this.roiManager.getClusterData(roiColorIndex), voxelCountThreshold, AbstractROIBuffer.getMasks()[roiColorIndex], label);
    }

    public void runConvexHull(ROI roi) {
        if (roi instanceof Mask) {
            if (this.isMultiSliceMode()) {
                this.roiManager.runConvexHull(0.0, 0.0, true, true, 1L << roi.getColor(), roi.getColor(), false, false, false);
            } else {
                this.roiManager.runConvexHullROI(this.getSliceNumber(), this.getSliceDirection(), 0.0, 0.0, true, true, 1L << roi.getColor(), roi.getColor(), false, false, false);
            }
        } else if (roi instanceof LOIShape) {
            LOIShape loi = (LOIShape)roi;
            if (this.loiManagerAxial.containsLOI(loi)) {
                this.loiManagerAxial.convexHull(loi);
            } else if (this.loiManagerCoronal.containsLOI(loi)) {
                this.loiManagerCoronal.convexHull(loi);
            } else if (this.loiManagerSagittal.containsLOI(loi)) {
                this.loiManagerSagittal.convexHull(loi);
            }
        }
    }

    public void runConvexHullROI(long roiMask, int roiOutputColorIndex) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            this.roiManager.runConvexHull(Double.MAX_VALUE, Double.MAX_VALUE, false, true, roiMask, roiOutputColorIndex, false, this.roiManager.isUsing4dROI(), false);
        }
    }

    public void runConvexHullROISlice(int sliceDirection, int sliceNumber, long roiMask, int roiOutputColorIndex) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            this.roiManager.runConvexHullROI(sliceNumber, sliceDirection, Double.MAX_VALUE, Double.MAX_VALUE, false, true, roiMask, roiOutputColorIndex, false, this.roiManager.isUsing4dROI(), false);
        }
    }

    public double[] runCrosssectionMM(Line line, double step) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager() && line != null) {
            LineOps op = new LineOps(this);
            return op.getValues(line, false, -1.0);
        }
        return CollectionUtilities.EMPTY_DOUBLE_ARRAY;
    }

    public double[] runCrosssectionVoxels(Line line) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager() && line != null) {
            LineOps op = new LineOps(this);
            return op.getValues(line, false, -1.0);
        }
        return CollectionUtilities.EMPTY_DOUBLE_ARRAY;
    }

    public void runDilateROI(long roiMask, int kernel) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            this.roiManager.runDilate3D(kernel, roiMask);
        }
    }

    public void runDilateROISlice(int sliceDirection, int sliceNum, long roiMask, int kernel) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            this.roiManager.runDilate2D(sliceNum, sliceDirection, kernel, roiMask);
        }
    }

    public void runErodeROI(long roiMask, int kernel) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            this.roiManager.runErode3D(kernel, roiMask);
        }
    }

    public void runErodeROISlice(int sliceDirection, int sliceNum, long roiMask, int kernel) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            this.roiManager.runErode2D(sliceNum, sliceDirection, kernel, roiMask);
        }
    }

    public void runFilter(String name) {
        this.prepareFilter();
        AbstractFilter filter = FilterManager.getFilter(name);
        if (filter != null) {
            FilterOp filterOp = new FilterOp(this, this);
            filterOp.runFilter(filter, null, this.filterBuffer, true, false);
        }
    }

    public void runGenerateClusterROI(ImageVolume overlay, int numberOfVoxelsThreshold) {
        ClusterOperations.makeROIOfCluster(this.roiManager, this.clusterDataMap.get(overlay), numberOfVoxelsThreshold, 0L, null);
    }

    public void runGenerateHistogramROI(Histogram hist) {
        List selectedColors = hist.getSelectedColors();
        for (Integer selectedHistogramColor : selectedColors) {
            double[] mins = hist.getBinRangeMinimums();
            double[] maxs = hist.getBinRangeMaximums();
            int minIndex = hist.getSelectedBinStartIndex(selectedHistogramColor.intValue());
            int maxIndex = hist.getSelectedBinEndIndex(selectedHistogramColor.intValue());
            if (minIndex == -1 || maxIndex == -1) continue;
            double threshMin = mins[minIndex];
            double threshMax = maxs[maxIndex];
            this.roiManager.doMakeBoundRangeROI(this.roiManager.getImageBounds(), threshMin, threshMax, false, 0L, selectedHistogramColor);
        }
    }

    public void runGenerateHistogramROISlice(int sliceDirection, int sliceNumber, Histogram hist) {
        List selectedColors = hist.getSelectedColors();
        for (Integer selectedHistogramColor : selectedColors) {
            double[] mins = hist.getBinRangeMinimums();
            double[] maxs = hist.getBinRangeMaximums();
            int minIndex = hist.getSelectedBinStartIndex(selectedHistogramColor.intValue());
            int maxIndex = hist.getSelectedBinEndIndex(selectedHistogramColor.intValue());
            if (minIndex == -1 || maxIndex == -1) continue;
            double threshMin = mins[minIndex];
            double threshMax = maxs[maxIndex];
            this.roiManager.makeBoundRangeROI(sliceNumber, sliceDirection, threshMin, threshMax, false, 0L, selectedHistogramColor);
        }
    }

    public void runGenerateHistogramWithinROI(Histogram hist, long roiMask) {
        List selectedColors = hist.getSelectedColors();
        for (Integer selectedHistogramColor : selectedColors) {
            double[] mins = hist.getBinRangeMinimums();
            double[] maxs = hist.getBinRangeMaximums();
            int minIndex = hist.getSelectedBinStartIndex(selectedHistogramColor.intValue());
            int maxIndex = hist.getSelectedBinEndIndex(selectedHistogramColor.intValue());
            if (minIndex == -1 || maxIndex == -1) continue;
            double threshMin = mins[minIndex];
            double threshMax = maxs[maxIndex];
            this.roiManager.doMakeBoundRangeROI(this.roiManager.getImageBounds(), threshMin, threshMax, true, roiMask, selectedHistogramColor);
        }
    }

    public void runGenerateHistogramWithinROISlice(int sliceDirection, int sliceNumber, Histogram hist, long roiMask) {
        List selectedColors = hist.getSelectedColors();
        for (Integer selectedHistogramColor : selectedColors) {
            double[] mins = hist.getBinRangeMinimums();
            double[] maxs = hist.getBinRangeMaximums();
            int minIndex = hist.getSelectedBinStartIndex(selectedHistogramColor.intValue());
            int maxIndex = hist.getSelectedBinEndIndex(selectedHistogramColor.intValue());
            if (minIndex == -1 || maxIndex == -1) continue;
            double threshMin = mins[minIndex];
            double threshMax = maxs[maxIndex];
            this.roiManager.makeBoundRangeROI(sliceNumber, sliceDirection, threshMin, threshMax, true, roiMask, selectedHistogramColor);
        }
    }

    public void runGenerateLogicalROI(List<ImageVolume> volumes) {
        Logical logical = new Logical(null);
        for (ImageVolume vol : volumes) {
            logical.addOverlay((Volume)vol);
        }
        Volume volume = (Volume)this.getBaseVolume();
        this.roiManager.doMakeLogicalROI(logical, new ImageBounds(0, volume.getXDim() - 1, 0, volume.getYDim() - 1, 0, volume.getZDim() - 1));
    }

    public Histogram runHistogram(int numBinsVal, double min, double max, boolean excludeZero, boolean integerMode) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            int numBins = numBinsVal;
            if (integerMode) {
                numBins = HistogramOp.getValidAutoBinNumber(this.getCurrentVolume(), new double[]{min, max});
            }
            AnalysisHistogramImpl stat = new AnalysisHistogramImpl(numBins, min, max, this.roiManager.getMaximumColors());
            stat.setExcludeZero(excludeZero);
            stat.setIntegerMode(integerMode);
            HistogramOp op = new HistogramOp(this, (Volume)this.getCurrentVolume(), stat);
            OperationBuilder<Histogram> builder = new OperationBuilder<Histogram>(this, op);
            this.histogram = builder.runSynchronously();
        }
        return this.histogram;
    }

    public Histogram runHistogramROI(int numBins, double min, double max, long roiMask, boolean excludeZero, boolean integerMode) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            AnalysisHistogramImpl stat = new AnalysisHistogramImpl(numBins, min, max, this.roiManager.getMaximumColors());
            stat.setExcludeZero(excludeZero);
            stat.setIntegerMode(integerMode);
            HistogramROIOp op = new HistogramROIOp(this, (Volume)this.getCurrentVolume(), this.getROIManager().getBuffer(), this.getROIManager().getAvailableMask(), stat);
            OperationBuilder<Histogram> builder = new OperationBuilder<Histogram>(this, op);
            this.histogram = builder.runSynchronously();
        }
        return this.histogram;
    }

    public Analysis runLogicalAnalysis(List<ImageVolume> volumes) {
        Logical logical = new Logical(null);
        for (ImageVolume vol : volumes) {
            logical.addOverlay((Volume)vol);
        }
        Volume volume = (Volume)this.getBaseVolume();
        LogicalOperations op = new LogicalOperations(this, null);
        return Context.getContext().addAnalysis(op.doAnalyze(logical, 0, volume.getXDim() - 1, 0, volume.getYDim() - 1, 0, volume.getZDim() - 1));
    }

    public void runOpenROI(long roiMask, int kernel) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            this.roiManager.runOpen3D(kernel, roiMask);
        }
    }

    public void runOpenROISlice(int sliceDirection, int sliceNum, long roiMask, int kernel) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            this.roiManager.runOpen2D(sliceNum, sliceDirection, kernel, roiMask);
        }
    }

    public VolumeManager runOperation(String expression, int selectionArea, boolean outputNewImage, boolean allSeriesPoints, boolean roiSlicesOnly) {
        ImageCalcExpressionImpl op = new ImageCalcExpressionImpl(expression, this, selectionArea, allSeriesPoints, roiSlicesOnly);
        if (outputNewImage) {
            Manager ctx = (Manager)this.makeNewManager(op);
            ctx.doOperationImage(op);
            return ctx;
        }
        this.doOperationImage(op);
        return this;
    }

    public void runOperationROILogic(String expression, int roiOutputColorIndex) {
        String operationString = ROIOperationTreeNode.makeReplacements(expression, this.roiManager);
        ROIOperationTreeNode startNode = ROIOperationTreeNode.makeOperationTree(operationString);
        if (startNode != null) {
            startNode.setOriginalOperation(expression);
            if (this.isMultiSliceMode()) {
                this.roiManager.setCurrentROI(roiOutputColorIndex);
                this.roiManager.operationROI(startNode, true);
            } else {
                this.roiManager.setCurrentROI(roiOutputColorIndex);
                this.roiManager.operationROI(startNode, this.getSliceNumber(), this.sliceDirection, true);
            }
        }
    }

    public VolumeManager runOperationSeriesStatistic(int startingSeriesIndex, int endingSeriesIndex, int seriesGroupSize, int statisticType) {
        ImageCalcExpressionImpl op = new ImageCalcExpressionImpl(this, startingSeriesIndex, endingSeriesIndex, seriesGroupSize, statisticType);
        Manager ctx = (Manager)this.makeNewManager(op);
        CalcSeriesOp calcOp = new CalcSeriesOp(this, this);
        calcOp.runOperationSeriesStat(op);
        return ctx;
    }

    public Object runPlugin(String pluginName, String[] args) {
        if (CLIUtils.isScriptablePlugin(pluginName)) {
            ScriptablePlugin sp = (ScriptablePlugin)CLIUtils.findPlugin(pluginName);
            return sp.doOperation((MangoContext)Context.getContext(), (VolumeManager)this, true, args);
        }
        this.showErrorMessage("This plugin is not scriptable from the command-line!", "Error");
        return null;
    }

    public void runPropagateROISlice(int sliceDirection, int sliceNumber, int startSlice, int endSlice, long roiMask, int roiOutputColorIndex) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            this.roiManager.runPropagate(sliceDirection, sliceNumber, startSlice, endSlice, roiMask, roiOutputColorIndex);
        }
    }

    public boolean runRangeToROI(double min, double max, boolean percentMax, boolean excludeZero, boolean makeSeriesROI, boolean seriesUsesDynamicThreshold) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            double threshMin = min;
            double threshMax = max;
            if (percentMax) {
                Volume vol = (Volume)this.getCurrentVolume();
                vol.updateMaxMin(vol, vol.findRangeSeries());
                double imageMax = vol.getImageMax();
                threshMin = imageMax * (min / 100.0);
                threshMax = imageMax * (max / 100.0);
            }
            return this.roiManager.runRangeROI(threshMin, threshMax, excludeZero, makeSeriesROI, seriesUsesDynamicThreshold);
        }
        return false;
    }

    public boolean runRangeToROISlice(double min, double max, int sliceDirection, int sliceNumber, boolean percentMax, boolean excludeZero, boolean makeSeriesROI, boolean seriesUsesDynamicThreshold) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            double threshMin = min;
            double threshMax = max;
            if (percentMax) {
                Volume vol = (Volume)this.getCurrentVolume();
                vol.updateMaxMin(vol.findRangeSeries());
                double imageMax = vol.getImageMax();
                threshMin = imageMax * (min / 100.0);
                threshMax = imageMax * (max / 100.0);
            }
            return this.roiManager.runRangeROI(sliceNumber, sliceDirection, threshMin, threshMax, excludeZero, makeSeriesROI, seriesUsesDynamicThreshold);
        }
        return false;
    }

    public void runRankFilter(int size, int rankType, int filterType) {
        this.prepareFilter();
        AbstractFilterRank filter = null;
        if (filterType == 1) {
            filter = new FilterRankTime(rankType, size);
        } else if (filterType == 2) {
            filter = new FilterRankSlice(rankType, size);
        } else if (filterType == 4) {
            filter = new FilterRankVolume(rankType, size);
        }
        if (filter != null) {
            FilterOp filterOp = new FilterOp(this, this);
            filterOp.runRankfilter(filter, this.filterBuffer);
        }
    }

    public void runReflectROI(int sliceDirection, int axis, boolean vertical, boolean includePointsAndLines, boolean onlySelectedLines, boolean onlySelectedPoints) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            if (includePointsAndLines) {
                this.poiManager.reflectPOIs(sliceDirection, vertical, axis, this.roiManager.getCurrentROI(), onlySelectedPoints);
                this.getLOIManagerMain().reflect(axis, vertical, this.roiManager.getCurrentROI(), onlySelectedLines);
            }
            this.roiManager.runReflection(sliceDirection, axis, vertical);
        }
    }

    public void runReflectROISlice(int sliceDirection, int sliceNumber, int axis, boolean vertical, boolean includePointsAndLines, boolean onlySelectedLines, boolean onlySelectedPoints) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            if (includePointsAndLines) {
                this.poiManager.reflectSlicePOIs(sliceDirection, sliceNumber, vertical, axis, this.roiManager.getCurrentROI(), onlySelectedPoints);
                this.getLOIManagerMain().reflectSlice(axis, vertical, sliceNumber, this.roiManager.getCurrentROI(), onlySelectedLines);
            }
            this.roiManager.runReflection(sliceDirection, axis, vertical);
        }
    }

    public void setDisplayRangeToImageRange(ImageVolume volume, boolean entireSeries) {
        Volume vol = (Volume)volume;
        Range op = entireSeries ? vol.findRangeSeries() : vol.findRangeVolume();
        vol.updateMaxMin(op);
    }

    public void setLabel(ROI roi, String label) {
        if (roi instanceof Mask) {
            this.roiManager.setLabel(roi.getColor(), label);
        } else if (roi instanceof LOIShape) {
            LOIShape line = (LOIShape)roi;
            line.setName(label);
            int dir = line.getSliceDirection();
            if (dir == 0) {
                this.loiManagerAxial.setDirty(true);
            } else if (dir == 1) {
                this.loiManagerCoronal.setDirty(true);
            } else if (dir == 2) {
                this.loiManagerSagittal.setDirty(true);
            }
            this.labelChanged();
        } else if (roi instanceof POI) {
            POI point = (POI)roi;
            point.setName(label);
            this.poiManager.setDirty(true);
            this.labelChanged();
        }
    }

    public void setLighting(double ambient, double diffuse, double specular, double horizontal, double vertical) {
    }

    public void setMaterial(Surface surface, int rgb, boolean showOverlayColors, boolean showOnlyThisOverlayColor, boolean flatShading, int renderType, double transparency, double emmisivity, double shininess, double searchDistance) {
    }

    public void setNotes(String text) {
        Volume volume = (Volume)this.getBaseVolume();
        volume.setImageDescription(text);
    }

    public void setOptions(String colorTable, double thresholdMin, double thresholdMax) {
    }

    public void setOrigin(Coordinate origin) {
        this.getBaseVolume().setOrigin(origin);
    }

    public void setRoiColor(int color) {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            this.roiManager.setCurrentROI(color);
        }
    }

    @Override
    public void setShowROI(boolean showROI) {
        this.showROI = showROI;
    }

    public void setSliceDirection(int sliceDirection) {
        this.sliceDirection = sliceDirection;
    }

    public boolean setSliceNumber(int sliceNumber) {
        if (this.sliceDirection == 0) {
            if (this.currentCoordinate.zInt != sliceNumber) {
                this.currentCoordinate.zInt = sliceNumber;
                this.currentCoordinate.zDbl = this.currentCoordinate.zInt;
                return true;
            }
        } else if (this.sliceDirection == 1) {
            if (this.currentCoordinate.yInt != sliceNumber) {
                this.currentCoordinate.yInt = sliceNumber;
                this.currentCoordinate.yDbl = this.currentCoordinate.yInt;
                return true;
            }
        } else if (this.sliceDirection == 2 && this.currentCoordinate.xInt != sliceNumber) {
            this.currentCoordinate.xInt = sliceNumber;
            this.currentCoordinate.xDbl = this.currentCoordinate.xInt;
            return true;
        }
        return false;
    }

    public void setTransformMode(boolean transform) {
        this.usingTransform = transform;
    }

    public void setMenuOption(String name, boolean value) {
        AppLogger.warn((String)("setMenuOption(\"" + name + "\", " + value + ") is not supported at the command-line"));
    }

    public void setVolumeDisplayAlpha(ImageVolume volume, double alpha) {
        this.findScreenVolume(volume).setAlpha(alpha);
    }

    public void setVolumeDisplayColorTable(ImageVolume volume, String colorTable) {
        this.findScreenVolume(volume).getLookupTableManager().replaceKnots(LookupTableManager.getLUTKnots(colorTable));
    }

    public void setVolumeDisplayHidden(ImageVolume volume, boolean hidden) {
        this.findScreenVolume(volume).setHidden(hidden);
    }

    public void setVolumeDisplayIndex(ImageVolume volume, int index) {
        ScreenVolume toRemove = null;
        for (ScreenVolume screenVol : this.volumes) {
            if (screenVol.getImageVolume() != volume) continue;
            toRemove = screenVol;
            break;
        }
        this.volumes.remove(toRemove);
        this.volumes.add(index, toRemove);
    }

    public void setVolumeDisplayRange(ImageVolume volume, double screenMin, double screenMax) {
        this.findScreenVolume(volume).setScreenMin(screenMin);
        this.findScreenVolume(volume).setScreenMax(screenMax);
    }

    public void setVoxelValue(Coordinate coordinate, int seriesPoint, double value) {
        Volume volume = (Volume)this.getBaseVolume();
        volume.putVoxelValueAtIndex(coordinate.xInt, coordinate.yInt, coordinate.zInt, seriesPoint, value);
        volume.setImageAsDirty();
    }

    public void showErrorMessage(String message, String title) {
        AppLogger.error((String)message);
    }

    public void showWarningMessage(String message, String title) {
        AppLogger.warn((String)message);
    }

    public void surfaceToShape(edu.uthscsa.ric.visualization.surface.primitives.Shape fromPoint, edu.uthscsa.ric.visualization.surface.primitives.Shape toPoint) {
    }

    public void transform(ImageVolume volume, double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23, double m30, double m31, double m32, double m33) {
        double[][] mat = new double[4][4];
        mat[0][0] = m00;
        mat[0][1] = m01;
        mat[0][2] = m02;
        mat[0][3] = m03;
        mat[1][0] = m10;
        mat[1][1] = m11;
        mat[1][2] = m12;
        mat[1][3] = m13;
        mat[2][0] = m20;
        mat[2][1] = m21;
        mat[2][2] = m22;
        mat[2][3] = m23;
        mat[3][0] = m30;
        mat[3][1] = m31;
        mat[3][2] = m32;
        mat[3][3] = m33;
        ((Volume)volume).getImageTransform().updateTransform(mat);
        this.usingTransform = true;
    }

    @Override
    public void updateAllLines() {
    }

    @Override
    public void updateAllPoints() {
    }

    public void updateSurface() {
    }

    public void updateViewer() {
    }

    @Override
    public void volumeChanged() {
    }

    @Override
    public void volumeChanged(Volume volume, boolean forceUpdate) {
    }

    @Override
    public void volumeDataLoaded(int volIndex) {
    }

    @Override
    public void volumeLoaded(boolean success) {
    }

    @Override
    public void volumeOperationCompleted(boolean success, Volume volume) {
    }

    @Override
    public void volumeRangeChanged(Volume volume, Object source, boolean sameThread) {
    }

    @Override
    public void volumeReloaded(boolean success) {
    }

    @Override
    public void volumeRevertedToSaved(boolean success) {
    }

    @Override
    public void volumeSaved(Volume vol, boolean success, boolean reload, ProgressBar pb, Volume overlayToClear, boolean isCopy, boolean sameThread) {
    }

    @Override
    public void volumeTimepointChanged(Volume volume) {
    }

    @Override
    public void volumeTransformChanged(Volume volume) {
    }

    @Override
    public void volumeTransformLoaded() {
        this.usingTransform = true;
    }

    protected ScreenVolume addNewVolume(ImageVolume volumeNew, URI uri) {
        Volume volume = (Volume)volumeNew;
        ScreenVolume screenVol = null;
        screenVol = this.volumes.size() == 0 ? new ScreenVolume(volume, this.getLoadedURI(), "Grayscale", true) : new ScreenVolume(volume, uri, this.getNextLUTType(), false);
        double gMin = screenVol.getVolume().getImageMin();
        double gMax = screenVol.getVolume().getImageMax();
        double dMin = screenVol.getVolume().getDisplayMin();
        double dMax = screenVol.getVolume().getDisplayMax();
        if (screenVol.isNegative() || dMax <= dMin || dMin == gMin && dMax == gMax || dMin < 0.0 && dMax > 0.0) {
            screenVol.setNegativeState(screenVol.getVolume().updateDisplayRangeBasedOnImageRange(screenVol.isNegative()));
        }
        double min = screenVol.getVolume().getDisplayMin();
        double max = screenVol.getVolume().getDisplayMax();
        screenVol.setScreenMin(min);
        screenVol.setScreenMax(max);
        this.volumes.add(screenVol);
        this.currentVolume = this.volumes.size() - 1;
        volume.setUser(this);
        volume.addListener(this);
        volume.setLabelListener(this);
        try {
            volume.readLabelData();
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
        }
        volume.updateMaxMin(volume.findRangeSeries());
        return screenVol;
    }

    private String getNextLUTType() {
        int numMagentaUsed = 0;
        int numCyanUsed = 0;
        int numBlueUsed = 0;
        int numGreenUsed = 0;
        int numRedUsed = 0;
        for (int ctr = 1; ctr < this.volumes.size(); ++ctr) {
            ScreenVolume overlay = this.volumes.get(ctr);
            if (overlay.getLookupTableManager().getName().equals("Red Overlay")) {
                ++numRedUsed;
            }
            if (overlay.getLookupTableManager().getName().equals("Green Overlay")) {
                ++numGreenUsed;
            }
            if (!overlay.getLookupTableManager().getName().equals("Blue Overlay")) continue;
            ++numBlueUsed;
        }
        if (numRedUsed <= numGreenUsed && numRedUsed <= numBlueUsed && numRedUsed <= numCyanUsed && numRedUsed <= numMagentaUsed) {
            return "Red Overlay";
        }
        if (numGreenUsed <= numRedUsed && numGreenUsed <= numBlueUsed && numGreenUsed <= numCyanUsed && numGreenUsed <= numMagentaUsed) {
            return "Green Overlay";
        }
        if (numBlueUsed <= numRedUsed && numBlueUsed <= numGreenUsed && numBlueUsed <= numCyanUsed && numBlueUsed <= numMagentaUsed) {
            return "Blue Overlay";
        }
        return "Red Overlay";
    }

    public ScreenVolume addNewVolume(URI uri) throws InvalidHeaderException, IOException {
        Volume volume = new Volume();
        volume.setForceLoadInThead(true);
        volume.readFiles(uri);
        if (this.volumes.size() == 0) {
            this.loadedURI = uri;
            this.currentCoordinate.setValuesRound(Math.floor((double)volume.getXDim() / 2.0), Math.floor((double)volume.getYDim() / 2.0), Math.floor((double)volume.getZDim() / 2.0));
        }
        return this.addNewVolume(volume, uri);
    }

    private void doImportROI(URI uri, boolean forceWorld, boolean isMangoROI) {
        try {
            Volume importVolume = new Volume();
            importVolume.setReadOnly(isMangoROI);
            importVolume.setUser(this);
            importVolume.readFiles(uri);
            this.roiManager.makeROIBuffer();
            this.roiManager.doImportROI(importVolume, forceWorld, isMangoROI);
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
            this.showErrorMessage("Problem loading image file!\n" + ex.getMessage(), TEXT_LOAD_ERROR);
        }
        catch (VolumeIOException ex) {
            AppLogger.error((Throwable)ex);
            this.showErrorMessage("Problem loading image file!\n" + ex.getMessage(), TEXT_LOAD_ERROR);
        }
    }

    private void doLoadMangoROI(URI externalROIFile) {
        try {
            Volume roiVol = new Volume();
            roiVol.setReadOnly(true);
            roiVol.setUser(this);
            roiVol.readFiles(externalROIFile);
            byte[] vectorData = roiVol.getExtension();
            String xmlStr = null;
            if (vectorData != null && vectorData.length > 0) {
                boolean hasShapes;
                ByteBuffer vecBuffer = ByteBuffer.wrap(vectorData);
                vecBuffer.order(roiVol.getImageType().isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                boolean readOldMetaData = false;
                int poiStart = 8;
                vecBuffer.position(8);
                int poiSize = vecBuffer.getInt();
                int loiAxialStart = 8 + poiSize + 4;
                vecBuffer.position(loiAxialStart);
                int loiAxialSize = vecBuffer.getInt();
                int loiCoronalStart = loiAxialStart + loiAxialSize + 4;
                vecBuffer.position(loiCoronalStart);
                int loiCoronalSize = vecBuffer.getInt();
                int loiSagittalStart = loiCoronalStart + loiCoronalSize + 4;
                vecBuffer.position(loiSagittalStart);
                int loiSagittalSize = vecBuffer.getInt();
                int labelStaticStart = loiSagittalStart + loiSagittalSize + 4;
                vecBuffer.position(labelStaticStart);
                int labelStaticSize = 0;
                int remaining = vecBuffer.limit() - vecBuffer.position();
                if (remaining >= 4) {
                    labelStaticSize = vecBuffer.getInt();
                }
                if (poiSize > 0) {
                    readOldMetaData = true;
                    byte[] poiData = new byte[poiSize];
                    System.arraycopy(vectorData, 12, poiData, 0, poiData.length);
                    boolean hasPoints = this.poiManager.hasPoints();
                    this.poiManager.putData(poiData);
                    this.poiManager.setDirty(hasPoints);
                }
                if (loiAxialSize > 0) {
                    readOldMetaData = true;
                    byte[] loiAxialData = new byte[loiAxialSize];
                    System.arraycopy(vectorData, loiAxialStart + 4, loiAxialData, 0, loiAxialData.length);
                    hasShapes = this.loiManagerAxial.hasShapes();
                    this.loiManagerAxial.putData(loiAxialData);
                    this.loiManagerAxial.setDirty(hasShapes);
                }
                if (loiCoronalSize > 0) {
                    readOldMetaData = true;
                    byte[] loiCoronalData = new byte[loiCoronalSize];
                    System.arraycopy(vectorData, loiCoronalStart + 4, loiCoronalData, 0, loiCoronalData.length);
                    hasShapes = this.loiManagerCoronal.hasShapes();
                    this.loiManagerCoronal.putData(loiCoronalData);
                    this.loiManagerCoronal.setDirty(hasShapes);
                }
                if (loiSagittalSize > 0) {
                    readOldMetaData = true;
                    byte[] loiSagittalData = new byte[loiSagittalSize];
                    System.arraycopy(vectorData, loiSagittalStart + 4, loiSagittalData, 0, loiSagittalData.length);
                    hasShapes = this.loiManagerSagittal.hasShapes();
                    this.loiManagerSagittal.putData(loiSagittalData);
                    this.loiManagerSagittal.setDirty(hasShapes);
                }
                if (labelStaticSize > 0) {
                    readOldMetaData = true;
                    byte[] labelData = new byte[labelStaticSize];
                    System.arraycopy(vectorData, labelStaticStart + 4, labelData, 0, labelData.length);
                    this.roiManager.setLabelData(labelData);
                }
                if (!readOldMetaData) {
                    int headerSize = 28;
                    int xmlSize = vectorData.length - 28;
                    byte[] xmlData = new byte[xmlSize];
                    System.arraycopy(vectorData, 28, xmlData, 0, xmlSize);
                    xmlStr = new String(xmlData, "utf-8");
                }
            }
            boolean singleColor = this.roiManager.doLoadROI(roiVol, xmlStr, true);
            if (StringUtils.isNotBlank(xmlStr)) {
                try {
                    Metadata.readMetadata(this, singleColor, xmlStr);
                }
                catch (ParserConfigurationException e) {
                    AppLogger.error((Throwable)e);
                }
                catch (SAXException e) {
                    AppLogger.error((Throwable)e);
                }
                catch (IOException e) {
                    AppLogger.error((Throwable)e);
                }
            }
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
            this.showErrorMessage(TEXT_PROBLEM_LOADING_ROI + ex.getMessage(), TEXT_LOAD_ERROR);
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
            this.showErrorMessage(TEXT_PROBLEM_LOADING_ROI + ex.getMessage(), TEXT_LOAD_ERROR);
        }
        catch (VolumeIOException ex) {
            AppLogger.error((Throwable)ex);
            this.showErrorMessage(TEXT_PROBLEM_LOADING_ROI + ex.getMessage(), TEXT_LOAD_ERROR);
        }
    }

    private void doOperationImage(ImageCalcExpression expression) {
        CalcOp op = new CalcOp(Context.getContext(), this, expression);
        if (this.isMultiSliceMode()) {
            OperationBuilder<Void> builder = new OperationBuilder<Void>(this, op);
            builder.runSynchronously();
        } else {
            int sliceDirection = this.getSliceDirection();
            Volume volume = (Volume)this.getBaseVolume();
            int zMin = 0;
            int yMin = 0;
            int xMin = 0;
            int xMax = volume.getXDim() - 1;
            int yMax = volume.getYDim() - 1;
            int zMax = volume.getZDim() - 1;
            if (sliceDirection == 0) {
                zMin = zMax = this.getSliceNumber();
            } else if (sliceDirection == 1) {
                yMin = yMax = this.getSliceNumber();
            } else if (sliceDirection == 2) {
                xMin = xMax = this.getSliceNumber();
            }
            if (op.testProcessValidity()) {
                op.process(new ImageBounds(xMin, xMax, yMin, yMax, zMin, zMax));
            } else {
                this.showErrorMessage("Problem running that operation!", "Operation Error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReadOldROIFormat(URI externalROIFile) {
        this.roiManager.makeROIBuffer();
        BufferedInputStream input = null;
        byte[] buffer = new byte[2048];
        try {
            int totalBytesRead;
            int bytesRead;
            input = FileUtilities.getInputStream((URI)externalROIFile, (boolean)true);
            byte[] poiSizeBytes = new byte[4];
            for (totalBytesRead = bytesRead = input.read(poiSizeBytes); totalBytesRead < poiSizeBytes.length; totalBytesRead += bytesRead) {
                bytesRead = input.read(poiSizeBytes, totalBytesRead, poiSizeBytes.length - totalBytesRead);
            }
            ByteBuffer poiSizeBuffer = ByteBuffer.wrap(poiSizeBytes);
            int poiSize = poiSizeBuffer.getInt();
            if (poiSize > 0) {
                byte[] poiBytes = new byte[poiSize];
                for (totalBytesRead = bytesRead = input.read(poiBytes); totalBytesRead < poiSize; totalBytesRead += bytesRead) {
                    bytesRead = input.read(poiBytes, totalBytesRead, poiSize - totalBytesRead);
                }
                this.poiManager.putData(poiBytes);
            }
            byte[] loiSizeBytes = new byte[12];
            for (totalBytesRead = bytesRead = input.read(loiSizeBytes); totalBytesRead < loiSizeBytes.length; totalBytesRead += bytesRead) {
                bytesRead = input.read(loiSizeBytes, totalBytesRead, loiSizeBytes.length - totalBytesRead);
            }
            ByteBuffer loiSizeBuffer = ByteBuffer.wrap(loiSizeBytes);
            int axialLOISize = loiSizeBuffer.getInt();
            int coronalLOISize = loiSizeBuffer.getInt();
            int sagittalLOISize = loiSizeBuffer.getInt();
            if (axialLOISize > 0) {
                byte[] axialBytes = new byte[axialLOISize];
                for (totalBytesRead = bytesRead = input.read(axialBytes); totalBytesRead < axialLOISize; totalBytesRead += bytesRead) {
                    bytesRead = input.read(axialBytes, totalBytesRead, axialLOISize - totalBytesRead);
                }
                this.loiManagerAxial.putData(axialBytes);
            }
            if (coronalLOISize > 0) {
                byte[] coronalBytes = new byte[coronalLOISize];
                for (totalBytesRead = bytesRead = input.read(coronalBytes); totalBytesRead < coronalLOISize; totalBytesRead += bytesRead) {
                    bytesRead = input.read(coronalBytes, totalBytesRead, coronalLOISize - totalBytesRead);
                }
                this.loiManagerCoronal.putData(coronalBytes);
            }
            if (sagittalLOISize > 0) {
                byte[] sagittalBytes = new byte[sagittalLOISize];
                for (totalBytesRead = bytesRead = input.read(sagittalBytes); totalBytesRead < sagittalLOISize; totalBytesRead += bytesRead) {
                    bytesRead = input.read(sagittalBytes, totalBytesRead, sagittalLOISize - totalBytesRead);
                }
                this.loiManagerSagittal.putData(sagittalBytes);
            }
            if ((bytesRead = input.read(buffer)) != -1) {
                this.roiManager.makeROIBuffer();
                AbstractROIBuffer roiBuffer = this.roiManager.getBuffer();
                long bytesReadTotal = 0L;
                Volume volume = (Volume)this.getBaseVolume();
                int fileDims = (volume.getXDim() + 1) * (volume.getYDim() + 1) * (volume.getZDim() + 1);
                long roiMask = 0L;
                block21: while (bytesRead != -1) {
                    for (int ctr = 0; ctr < bytesRead; ++ctr) {
                        roiMask |= (long)buffer[ctr];
                        int offset = (int)(bytesReadTotal + (long)ctr);
                        if (offset >= fileDims) {
                            bytesReadTotal = -1L;
                            break block21;
                        }
                        roiBuffer.putCurrent(offset, buffer[ctr] & 0xFF);
                    }
                    bytesReadTotal += (long)bytesRead;
                    bytesRead = input.read(buffer);
                }
                if (bytesReadTotal != (long)fileDims) {
                    throw new IllegalStateException("ROI file size does not match image size!");
                }
                int maxColors = this.roiManager.getMaximumColors();
                if (roiBuffer != null) {
                    int ctr;
                    for (ctr = 0; ctr < maxColors; ++ctr) {
                        if ((roiMask >> ctr & 1L) != 1L) continue;
                        this.roiManager.initROI(ctr);
                    }
                    for (ctr = 0; ctr < maxColors && (roiMask >> ctr & 1L) != 1L; ++ctr) {
                    }
                    this.roiManager.setCurrentROI(ctr % maxColors);
                }
            }
        }
        catch (IllegalStateException ex) {
            AppLogger.error((Throwable)ex);
            this.showErrorMessage("Problem loading ROI file!\n" + ex.getMessage(), TEXT_LOAD_ERROR);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
            this.showErrorMessage("Problem loading ROI file!\n" + ex.getMessage(), TEXT_LOAD_ERROR);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
    }

    private ImageVolume findFirstOverlayTimeseries() {
        for (ImageVolume overlay : this.getOverlays()) {
            if (overlay.getSeriesLength() <= 1) continue;
            return overlay;
        }
        return null;
    }

    private ImageVolume findTopOverlayTimeseries() {
        if (this.getCurrentVolume() == this.getBaseVolume()) {
            return this.findFirstOverlayTimeseries();
        }
        if (this.getCurrentVolume().getSeriesLength() > 1) {
            return this.getCurrentVolume();
        }
        return this.findFirstOverlayTimeseries();
    }

    @Deprecated
    private MangoImage getBaseMangoImage() {
        Volume volume = (Volume)this.getBaseVolume();
        ImageTransform[] indexTransforms = null;
        boolean numIndex = true;
        indexTransforms = new ImageTransform[1];
        for (int ctr = 0; ctr < 1; ++ctr) {
            indexTransforms[ctr] = volume.getIndexImageTransform(ctr);
        }
        return new MangoImage((ImageVolume)volume, volume.getImageDimensions(), volume.getVoxelDimensions(), volume.getImageType(), volume.getImageRange(), volume.getImageDescription(), volume.getFormatSpecificInfo(), volume.getOrigin(), volume.getOriginNative(), indexTransforms, null, new File(this.getLoadedURI()), volume.getOrientationString());
    }

    private boolean hasOverlayTimeseries() {
        for (ImageVolume overlay : this.getOverlays()) {
            if (overlay.getSeriesLength() <= 1) continue;
            return true;
        }
        return false;
    }

    private boolean initializeLineManagers() {
        if (this.loiManagerAxial == null && this.volumes.size() > 0) {
            Volume volume = (Volume)this.getBaseVolume();
            this.loiManagerAxial = new LOIManager(volume.getZDim(), 0, null, this);
            this.loiManagerCoronal = new LOIManager(volume.getYDim(), 1, null, this);
            this.loiManagerSagittal = new LOIManager(volume.getXDim(), 2, null, this);
        }
        return this.loiManagerAxial != null;
    }

    private boolean initializePointManager() {
        if (this.poiManager == null && this.volumes.size() > 0) {
            Volume volume = (Volume)this.getBaseVolume();
            this.poiManager = new POIManager(volume.getXDim(), volume.getYDim(), volume.getZDim(), volume.getXSize(), volume.getYSize(), volume.getZSize(), null, this);
        }
        return this.poiManager != null;
    }

    private boolean initializeROIManager() {
        if (this.roiManager == null && this.volumes.size() > 0) {
            Volume volume = (Volume)this.getBaseVolume();
            this.roiManager = new ROIManager(null, this, null, volume.getXDim(), volume.getYDim(), volume.getZDim());
        }
        return this.roiManager != null;
    }

    private void loadROI(URI externalROIFile) {
        try {
            String roiFilename = FileUtilities.getName((URI)externalROIFile);
            if (roiFilename.endsWith(".roi.gz")) {
                this.doReadOldROIFormat(externalROIFile);
            } else {
                Header roiHeader = new Header(externalROIFile);
                ImageDimensions id = roiHeader.getImageDimensions();
                new Orientation(roiHeader.getOrientationString(), id, roiHeader.getVoxelDimensions(), roiHeader.getOrigin());
                int xDim = id.getX();
                int yDim = id.getY();
                int zDim = id.getZ();
                boolean sameDims = xDim == this.getXDim() && yDim == this.getYDim() && zDim == this.getZDim();
                ImageType it = roiHeader.getImageType();
                int datatype = it.getByteType();
                boolean isMangoROIFile = false;
                String description = roiHeader.getImageDescription().getDescription();
                if (description != null) {
                    isMangoROIFile = description.startsWith("Mango ROI");
                }
                boolean loadAsMangoROI = isMangoROIFile &= datatype == 3;
                if (loadAsMangoROI &= sameDims) {
                    this.doLoadMangoROI(externalROIFile);
                } else {
                    this.doImportROI(externalROIFile, false, isMangoROIFile);
                }
            }
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    private VolumeManager makeNewManager(ImageCalcExpression operation) {
        Manager manager = new Manager();
        ImageRange ir = new ImageRange(0.0, 0.0, 0.0, 0.0);
        ImageDimensions id = operation.getOriginatingManager().getBaseVolume().getImageDimensions();
        ir.setGlobalDataScaleIntercept(id.getSlices() * id.getTimepoints(), 0.0f);
        ir.setGlobalDataScaleSlope(id.getSlices() * id.getTimepoints(), 1.0f);
        Header header = ((Volume)operation.getOriginatingManager().getBaseVolume()).getHeaderCopyAndReplace(ImageType.getWorkBufferImageType(), ir);
        header.setImageFile(FileUtilities.findUniqueFilename((File)new File(operation.getOriginatingManager().getLoadedURI()), (String)"-new", (String)".img"));
        if (!operation.isAllSeriesPoints()) {
            header.getImageDimensions().setTimepoints(1);
        }
        Volume volume = null;
        try {
            volume = new Volume(header, false, null);
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
        }
        manager.addNewVolume(volume, null);
        volume.setUser(this);
        volume.addListener(this);
        volume.setLabelListener(this);
        try {
            volume.readLabelData();
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
        }
        volume.updateMaxMin(volume.findRangeSeries());
        Context.getContext().addVolumeManager(manager);
        return manager;
    }

    private Analysis measureLine(edu.uthscsa.ric.visualization.surface.primitives.Shape ml) {
        AnalysisImpl analysis = new AnalysisImpl();
        analysis.setRegionSize(ml.getDistance());
        analysis.setType(7);
        analysis.setDescription(ml.toString());
        return analysis;
    }

    private void prepareFilter() {
        if (this.filterBuffer == null) {
            ImageVolume volume = this.getBaseVolume();
            ImageDimensions id = volume.getImageDimensions();
            int sliceSize = id.getNumVoxelsSlice();
            this.filterBuffer = new FilterBuffer((Volume)volume, sliceSize, volume.getWorkBuffers(), volume.getVolumeIntercept());
        }
        if (!this.filterBuffer.isInitialized()) {
            this.filterBuffer.initialize();
        }
    }

    private void reconcileOverlayTimeseries(ImageVolume refTimeseries) {
        if (this.hasOverlayTimeseries() && this.isWorldMode()) {
            this.setOverlaysTimepoint(refTimeseries.getCurrentSeriesPoint());
        }
    }

    private List<Analysis> runAllSliceStatsROILines(int sliceDirection, boolean onlySelected) {
        ArrayList<Analysis> stats;
        block6: {
            Volume currentVolume;
            Volume baseVolume;
            block8: {
                block7: {
                    stats = new ArrayList<Analysis>();
                    if (!this.initializeROIManager() || !this.initializeLineManagers() || !this.initializeLineManagers()) break block6;
                    baseVolume = (Volume)this.getBaseVolume();
                    currentVolume = (Volume)this.getCurrentVolume();
                    if (sliceDirection != 0) break block7;
                    for (int ctr = 0; ctr < baseVolume.getZDim(); ++ctr) {
                        if (!this.loiManagerAxial.hasShapes(ctr)) continue;
                        for (LOIShape shape = this.loiManagerAxial.getShape(ctr); shape != null; shape = shape.getNext()) {
                            if (onlySelected && !shape.isSelected()) continue;
                            Volume vol = (Volume)this.getCurrentVolume();
                            LineStatROIOp op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                            Analysis result = op.process(shape, 0, currentVolume.getCurrentTimepoint());
                            stats.add(result);
                        }
                    }
                    break block6;
                }
                if (sliceDirection != 1) break block8;
                for (int ctr = 0; ctr < baseVolume.getYDim(); ++ctr) {
                    if (!this.loiManagerCoronal.hasShapes(ctr)) continue;
                    for (LOIShape shape = this.loiManagerCoronal.getShape(ctr); shape != null; shape = shape.getNext()) {
                        if (onlySelected && !shape.isSelected()) continue;
                        Volume vol = (Volume)this.getCurrentVolume();
                        LineStatROIOp op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                        Analysis result = op.process(shape, 1, currentVolume.getCurrentTimepoint());
                        stats.add(result);
                    }
                }
                break block6;
            }
            if (sliceDirection != 2) break block6;
            for (int ctr = 0; ctr < baseVolume.getXDim(); ++ctr) {
                if (!this.loiManagerSagittal.hasShapes(ctr)) continue;
                for (LOIShape shape = this.loiManagerSagittal.getShape(ctr); shape != null; shape = shape.getNext()) {
                    if (onlySelected && !shape.isSelected()) continue;
                    Volume vol = (Volume)this.getCurrentVolume();
                    LineStatROIOp op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                    Analysis result = op.process(shape, 2, currentVolume.getCurrentTimepoint());
                    stats.add(result);
                }
            }
        }
        return stats;
    }

    private List<Analysis> runAllSliceStatsROIPoints(int sliceDirection, boolean onlySelected) {
        ArrayList<Analysis> stats;
        block6: {
            Volume currentVolume;
            Volume baseVolume;
            block8: {
                block7: {
                    stats = new ArrayList<Analysis>();
                    if (!this.initializeROIManager() || !this.initializePointManager() || !this.initializeLineManagers()) break block6;
                    baseVolume = (Volume)this.getBaseVolume();
                    currentVolume = (Volume)this.getCurrentVolume();
                    if (sliceDirection != 0) break block7;
                    for (int ctr = 0; ctr < baseVolume.getZDim(); ++ctr) {
                        for (POI poi = this.poiManager.getPOIs(ctr, 0); poi != null; poi = poi.getNextAxial()) {
                            if (onlySelected && !poi.isSelected()) continue;
                            Volume vol = (Volume)this.getCurrentVolume();
                            PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                            Analysis result = op.process(poi, currentVolume.getCurrentTimepoint());
                            stats.add(result);
                        }
                    }
                    break block6;
                }
                if (sliceDirection != 1) break block8;
                for (int ctr = 0; ctr < baseVolume.getYDim(); ++ctr) {
                    for (POI poi = this.poiManager.getPOIs(ctr, 1); poi != null; poi = poi.getNextCoronal()) {
                        if (onlySelected && !poi.isSelected()) continue;
                        Volume vol = (Volume)this.getCurrentVolume();
                        PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                        Analysis result = op.process(poi, currentVolume.getCurrentTimepoint());
                        stats.add(result);
                    }
                }
                break block6;
            }
            if (sliceDirection != 2) break block6;
            for (int ctr = 0; ctr < baseVolume.getXDim(); ++ctr) {
                for (POI poi = this.poiManager.getPOIs(ctr, 2); poi != null; poi = poi.getNextSagittal()) {
                    if (onlySelected && !poi.isSelected()) continue;
                    Volume vol = (Volume)this.getCurrentVolume();
                    PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                    Analysis result = op.process(poi, currentVolume.getCurrentTimepoint());
                    stats.add(result);
                }
            }
        }
        return stats;
    }

    private List<Analysis> runAllVolumeStatsROILines(boolean onlySelected) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            int numTimepoints = this.getCurrentVolume().getSeriesLength();
            Volume volume = (Volume)this.getBaseVolume();
            for (int ctrT = 0; ctrT < numTimepoints; ++ctrT) {
                Analysis result;
                LineStatROIOp op;
                Volume vol;
                LOIShape shape;
                int ctr;
                for (ctr = 0; ctr < volume.getZDim(); ++ctr) {
                    if (!this.loiManagerAxial.hasShapes(ctr)) continue;
                    for (shape = this.loiManagerAxial.getShape(ctr); shape != null; shape = shape.getNext()) {
                        if (onlySelected && !shape.isSelected()) continue;
                        vol = (Volume)this.getCurrentVolume();
                        op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                        result = op.process(shape, 0, ctrT);
                        stats.add(result);
                    }
                }
                for (ctr = 0; ctr < volume.getYDim(); ++ctr) {
                    if (!this.loiManagerCoronal.hasShapes(ctr)) continue;
                    for (shape = this.loiManagerCoronal.getShape(ctr); shape != null; shape = shape.getNext()) {
                        if (onlySelected && !shape.isSelected()) continue;
                        vol = (Volume)this.getCurrentVolume();
                        op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                        result = op.process(shape, 1, ctrT);
                        stats.add(result);
                    }
                }
                for (ctr = 0; ctr < volume.getXDim(); ++ctr) {
                    if (!this.loiManagerSagittal.hasShapes(ctr)) continue;
                    for (shape = this.loiManagerSagittal.getShape(ctr); shape != null; shape = shape.getNext()) {
                        if (onlySelected && !shape.isSelected()) continue;
                        vol = (Volume)this.getCurrentVolume();
                        op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                        result = op.process(shape, 2, ctrT);
                        stats.add(result);
                    }
                }
            }
        }
        return stats;
    }

    private List<Analysis> runAllVolumeStatsROIPoints(boolean onlySelected) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        if (this.initializeROIManager() && this.initializePointManager() && this.initializeLineManagers()) {
            int numTimepoints = this.getCurrentVolume().getSeriesLength();
            int sliceStatsDirection = this.getSliceDirection();
            Volume volume = (Volume)this.getBaseVolume();
            for (int ctrT = 0; ctrT < numTimepoints; ++ctrT) {
                Analysis result;
                PointStatROIOp op;
                Volume vol;
                POI poi;
                int ctr;
                if (sliceStatsDirection == 0) {
                    for (ctr = 0; ctr < volume.getZDim(); ++ctr) {
                        for (poi = this.poiManager.getPOIs(ctr, 0); poi != null; poi = poi.getNextAxial()) {
                            if (onlySelected && !poi.isSelected()) continue;
                            vol = (Volume)this.getCurrentVolume();
                            op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                            result = op.process(poi, ctrT);
                            stats.add(result);
                        }
                    }
                    continue;
                }
                if (sliceStatsDirection == 1) {
                    for (ctr = 0; ctr < volume.getYDim(); ++ctr) {
                        for (poi = this.poiManager.getPOIs(ctr, 1); poi != null; poi = poi.getNextCoronal()) {
                            if (onlySelected && !poi.isSelected()) continue;
                            vol = (Volume)this.getCurrentVolume();
                            op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                            result = op.process(poi, ctrT);
                            stats.add(result);
                        }
                    }
                    continue;
                }
                if (sliceStatsDirection != 2) continue;
                for (ctr = 0; ctr < volume.getXDim(); ++ctr) {
                    for (poi = this.poiManager.getPOIs(ctr, 2); poi != null; poi = poi.getNextSagittal()) {
                        if (onlySelected && !poi.isSelected()) continue;
                        vol = (Volume)this.getCurrentVolume();
                        op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                        result = op.process(poi, ctrT);
                        stats.add(result);
                    }
                }
            }
        }
        return stats;
    }

    private List<Analysis> runSeriesStatsROILines(boolean onlySelected) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        if (this.initializeLineManagers() && this.initializeROIManager() && this.initializePointManager()) {
            AnalysisImpl result;
            LineStatROIOp op;
            Volume vol;
            LOIShape shape;
            int ctr;
            Volume volume = (Volume)this.getBaseVolume();
            for (ctr = 0; ctr < volume.getZDim(); ++ctr) {
                if (!this.loiManagerAxial.hasShapes(ctr)) continue;
                for (shape = this.loiManagerAxial.getShape(ctr); shape != null; shape = shape.getNext()) {
                    if (onlySelected && !shape.isSelected()) continue;
                    vol = (Volume)this.getCurrentVolume();
                    op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                    result = op.calculateSeriesLineROI(shape, 0);
                    stats.add(result);
                }
            }
            for (ctr = 0; ctr < volume.getYDim(); ++ctr) {
                if (!this.loiManagerCoronal.hasShapes(ctr)) continue;
                for (shape = this.loiManagerCoronal.getShape(ctr); shape != null; shape = shape.getNext()) {
                    if (onlySelected && !shape.isSelected()) continue;
                    vol = (Volume)this.getCurrentVolume();
                    op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                    result = op.calculateSeriesLineROI(shape, 1);
                    stats.add(result);
                }
            }
            for (ctr = 0; ctr < volume.getXDim(); ++ctr) {
                if (!this.loiManagerSagittal.hasShapes(ctr)) continue;
                for (shape = this.loiManagerSagittal.getShape(ctr); shape != null; shape = shape.getNext()) {
                    if (onlySelected && !shape.isSelected()) continue;
                    vol = (Volume)this.getCurrentVolume();
                    op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                    result = op.calculateSeriesLineROI(shape, 2);
                    stats.add(result);
                }
            }
        }
        return stats;
    }

    private List<Analysis> runSeriesStatsROIPoints(boolean onlySelected) {
        ArrayList<Analysis> stats;
        block6: {
            Volume volume;
            int sliceStatsDirection;
            block8: {
                block7: {
                    stats = new ArrayList<Analysis>();
                    if (!this.initializePointManager() || !this.initializeROIManager() || !this.initializeLineManagers()) break block6;
                    sliceStatsDirection = this.getSliceDirection();
                    volume = (Volume)this.getBaseVolume();
                    if (sliceStatsDirection != 0) break block7;
                    for (int ctr = 0; ctr < volume.getZDim(); ++ctr) {
                        for (POI poi = this.poiManager.getPOIs(ctr, 0); poi != null; poi = poi.getNextAxial()) {
                            if (onlySelected && !poi.isSelected()) continue;
                            Volume vol = (Volume)this.getCurrentVolume();
                            PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                            Analysis result = op.calculateSeriesPointROI(poi);
                            stats.add(result);
                        }
                    }
                    break block6;
                }
                if (sliceStatsDirection != 1) break block8;
                for (int ctr = 0; ctr < volume.getYDim(); ++ctr) {
                    for (POI poi = this.poiManager.getPOIs(ctr, 1); poi != null; poi = poi.getNextCoronal()) {
                        if (onlySelected && !poi.isSelected()) continue;
                        Volume vol = (Volume)this.getCurrentVolume();
                        PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                        Analysis result = op.calculateSeriesPointROI(poi);
                        stats.add(result);
                    }
                }
                break block6;
            }
            if (sliceStatsDirection != 2) break block6;
            for (int ctr = 0; ctr < volume.getXDim(); ++ctr) {
                for (POI poi = this.poiManager.getPOIs(ctr, 2); poi != null; poi = poi.getNextSagittal()) {
                    if (onlySelected && !poi.isSelected()) continue;
                    Volume vol = (Volume)this.getCurrentVolume();
                    PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                    Analysis result = op.calculateSeriesPointROI(poi);
                    stats.add(result);
                }
            }
        }
        return stats;
    }

    private List<Analysis> runSliceStatsROILines(int sliceStatsDirection, int sliceStatsCurrentSlice, boolean onlySelected) {
        ArrayList<Analysis> stats;
        block4: {
            Volume volume;
            block6: {
                block5: {
                    stats = new ArrayList<Analysis>();
                    if (!this.initializeROIManager() || !this.initializeLineManagers() || !this.initializePointManager()) break block4;
                    volume = (Volume)this.getCurrentVolume();
                    if (sliceStatsDirection != 0) break block5;
                    if (!this.loiManagerAxial.hasShapes(sliceStatsCurrentSlice)) break block4;
                    for (LOIShape shape = this.loiManagerAxial.getShape(sliceStatsCurrentSlice); shape != null; shape = shape.getNext()) {
                        if (onlySelected && !shape.isSelected()) continue;
                        Volume vol = (Volume)this.getCurrentVolume();
                        LineStatROIOp op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                        Analysis result = op.process(shape, 0, volume.getCurrentTimepoint());
                        stats.add(result);
                    }
                    break block4;
                }
                if (sliceStatsDirection != 1) break block6;
                if (!this.loiManagerCoronal.hasShapes(sliceStatsCurrentSlice)) break block4;
                for (LOIShape shape = this.loiManagerCoronal.getShape(sliceStatsCurrentSlice); shape != null; shape = shape.getNext()) {
                    if (onlySelected && !shape.isSelected()) continue;
                    Volume vol = (Volume)this.getCurrentVolume();
                    LineStatROIOp op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                    Analysis result = op.process(shape, 1, volume.getCurrentTimepoint());
                    stats.add(result);
                }
                break block4;
            }
            if (sliceStatsDirection == 2 && this.loiManagerSagittal.hasShapes(sliceStatsCurrentSlice)) {
                for (LOIShape shape = this.loiManagerSagittal.getShape(sliceStatsCurrentSlice); shape != null; shape = shape.getNext()) {
                    if (onlySelected && !shape.isSelected()) continue;
                    Volume vol = (Volume)this.getCurrentVolume();
                    LineStatROIOp op = new LineStatROIOp(this, vol, this.roiManager.getBuffer());
                    Analysis result = op.process(shape, 2, volume.getCurrentTimepoint());
                    stats.add(result);
                }
            }
        }
        return stats;
    }

    private List<Analysis> runSliceStatsROIPoints(int sliceStatsDirection, int sliceStatsCurrentSlice, boolean onlySelected) {
        ArrayList<Analysis> stats;
        block3: {
            block5: {
                block4: {
                    stats = new ArrayList<Analysis>();
                    if (!this.initializeROIManager() || !this.initializePointManager() || !this.initializeLineManagers()) break block3;
                    if (sliceStatsDirection != 0) break block4;
                    for (POI poi = this.poiManager.getPOIs(sliceStatsCurrentSlice, 0); poi != null; poi = poi.getNextAxial()) {
                        if (onlySelected && !poi.isSelected()) continue;
                        Volume vol = (Volume)this.getCurrentVolume();
                        PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                        Analysis result = op.process(poi, vol.getCurrentTimepoint());
                        stats.add(result);
                    }
                    break block3;
                }
                if (sliceStatsDirection != 1) break block5;
                for (POI poi = this.poiManager.getPOIs(sliceStatsCurrentSlice, 1); poi != null; poi = poi.getNextCoronal()) {
                    if (onlySelected && !poi.isSelected()) continue;
                    Volume vol = (Volume)this.getCurrentVolume();
                    PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                    Analysis result = op.process(poi, vol.getCurrentTimepoint());
                    stats.add(result);
                }
                break block3;
            }
            if (sliceStatsDirection != 2) break block3;
            for (POI poi = this.poiManager.getPOIs(sliceStatsCurrentSlice, 2); poi != null; poi = poi.getNextSagittal()) {
                if (onlySelected && !poi.isSelected()) continue;
                Volume vol = (Volume)this.getCurrentVolume();
                PointStatROIOp op = new PointStatROIOp(this, vol, this.roiManager.getBuffer());
                Analysis result = op.process(poi, vol.getCurrentTimepoint());
                stats.add(result);
            }
        }
        return stats;
    }

    private void setOverlaysTimepoint(int index) {
        for (ImageVolume overlay : this.getOverlays()) {
            if (overlay.getSeriesLength() <= 1) continue;
            overlay.setCurrentSeriesPoint(index);
        }
    }

    public boolean isWorldMode() {
        return Context.getContext().isWorldMode();
    }

    public ImageVolume makeNewVolume() {
        return Context.getContext().makeNewVolume();
    }

    public ProgressMeter makeProgressMeter() {
        return Context.getContext().makeProgressMeter();
    }

    public void runScript(String scriptName) {
        ScriptManager.runScriptSilently(scriptName, Context.getContext(), this);
    }

    @Override
    public void shapeAdded(LOIShape shape) {
    }

    @Override
    public void shapeChanged(LOIShape shape) {
    }

    @Override
    public void shapeDeleted(LOIShape shape) {
    }

    @Override
    public void shapeLabelChanged(LOIShape shape) {
    }

    @Override
    public void shapeSelectionChanged() {
    }

    public Object getScriptResult() {
        return this.scriptResult;
    }

    public void setScriptResult(Object scriptResult) {
        this.scriptResult = scriptResult;
    }

    private void initScreenData() {
        if (!this.hasScreenData) {
            this.hasScreenData = true;
            int xDim = this.getXDim(this.sliceDirection);
            int yDim = this.getYDim(this.sliceDirection);
            this.screenSlice = new BufferedImage(xDim, yDim, 2);
            this.screenSliceFiltered = new BufferedImage(xDim, yDim, 2);
            this.rgbData = ((DataBufferInt)this.screenSlice.getRaster().getDataBuffer()).getData();
            this.overlayMixer = new BufferedImage(xDim, yDim, 2);
            this.overlayMixerData = ((DataBufferInt)this.overlayMixer.getRaster().getDataBuffer()).getData();
            this.overlayRGBData = new int[8][];
            this.overlayScreenSlice = new BufferedImage[8];
            this.overlayScreenSliceFiltered = new BufferedImage[8];
            List<ImageVolume> overlays = this.getOverlays();
            for (int ctr = 0; ctr < overlays.size(); ++ctr) {
                if (this.overlayScreenSlice[ctr] != null) continue;
                this.overlayScreenSlice[ctr] = new BufferedImage(xDim, yDim, 2);
                this.overlayScreenSliceFiltered[ctr] = new BufferedImage(xDim, yDim, 2);
                this.overlayRGBData[ctr] = ((DataBufferInt)this.overlayScreenSlice[ctr].getRaster().getDataBuffer()).getData();
            }
        }
    }

    public void updateScreenSlice(int updateSlice) {
        Volume volume = (Volume)this.getBaseVolume();
        double screenImageBlack = this.getVolumeDisplayRangeMin(volume);
        double screenImageWhite = this.getVolumeDisplayRangeMax(volume);
        double screenImageRatio = 255.0 / (screenImageWhite - screenImageBlack);
        Coordinate origin = volume.getOrigin();
        boolean isWorldMode = this.isWorldMode();
        boolean isIndexTransformMode = this.isVolumeUsingTransform(volume);
        boolean hasOverlays = this.volumes.size() > 1;
        boolean isNegative = this.isVolumeDisplayNegative(volume);
        int xDim = this.getXDim(this.sliceDirection);
        int yDim = this.getYDim(this.sliceDirection);
        double xSize = this.getXSize(this.sliceDirection);
        double ySize = this.getYSize(this.sliceDirection);
        double sliceSize = this.getSliceSize(this.sliceDirection);
        double temp = 0.0;
        for (int ctrY = 0; ctrY < yDim; ++ctrY) {
            int offsetY = xDim * ctrY;
            for (int ctrX = 0; ctrX < xDim; ++ctrX) {
                int offset = offsetY + ctrX;
                if (isWorldMode) {
                    if (this.sliceDirection == 0) {
                        temp = volume.getVoxelValueAtCoordinate((double)(ctrX - origin.xInt) * xSize, (double)(origin.yInt - ctrY) * ySize, (double)(origin.zInt - updateSlice) * sliceSize, isIndexTransformMode);
                    } else if (this.sliceDirection == 1) {
                        temp = volume.getVoxelValueAtCoordinate((double)(ctrX - origin.xInt) * xSize, (double)(origin.yInt - updateSlice) * sliceSize, (double)(origin.zInt - ctrY) * ySize, isIndexTransformMode);
                    } else if (this.sliceDirection == 2) {
                        temp = volume.getVoxelValueAtCoordinate((double)(updateSlice - origin.xInt) * sliceSize, (double)(origin.yInt - ctrX) * xSize, (double)(origin.zInt - ctrY) * ySize, isIndexTransformMode);
                    }
                } else {
                    temp = this.sliceDirection == 0 ? volume.getVoxelValueAtIndex(ctrX, ctrY, updateSlice, isIndexTransformMode) : (this.sliceDirection == 1 ? volume.getVoxelValueAtIndex(ctrX, updateSlice, ctrY, isIndexTransformMode) : volume.getVoxelValueAtIndex(updateSlice, ctrX, ctrY, isIndexTransformMode));
                }
                if (!isNegative && temp <= screenImageBlack || isNegative && temp >= screenImageBlack) {
                    this.rgbData[offset] = -16777216;
                } else if (!isNegative && temp > screenImageWhite || isNegative && temp < screenImageWhite) {
                    this.rgbData[offset] = -1;
                } else {
                    int num = (int)((temp - screenImageBlack) * screenImageRatio + 0.5);
                    this.rgbData[offset] = num | num << 8 | num << 16 | 0xFF000000;
                }
                this.overlayMixerData[offset] = 0;
            }
        }
        if (hasOverlays) {
            List<ImageVolume> overlays = this.getOverlays();
            for (int ctr = 0; ctr < overlays.size(); ++ctr) {
                Volume overlay = (Volume)overlays.get(ctr);
                double overlayScreenMin = this.getVolumeDisplayRangeMin(overlay);
                double overlayScreenMax = this.getVolumeDisplayRangeMax(overlay);
                double overlayScreenRatio = 255.0 / (overlayScreenMax - overlayScreenMin);
                isNegative = this.isVolumeDisplayNegative(overlay);
                isIndexTransformMode = this.isVolumeUsingTransform(overlay);
                boolean usingTransform = this.isCurrentVolumeUsingTransform();
                for (int ctrY = 0; ctrY < yDim; ++ctrY) {
                    int offsetY = xDim * ctrY;
                    for (int ctrX = 0; ctrX < xDim; ++ctrX) {
                        int offset = offsetY + ctrX;
                        if (isWorldMode) {
                            if (this.sliceDirection == 0) {
                                temp = overlay.getVoxelValueAtCoordinate((double)(ctrX - origin.xInt) * xSize, (double)(origin.yInt - ctrY) * ySize, (double)(origin.zInt - updateSlice) * sliceSize, usingTransform && isIndexTransformMode);
                            } else if (this.sliceDirection == 1) {
                                temp = overlay.getVoxelValueAtCoordinate((double)(ctrX - origin.xInt) * xSize, (double)(origin.yInt - updateSlice) * sliceSize, (double)(origin.zInt - ctrY) * ySize, usingTransform && isIndexTransformMode);
                            } else if (this.sliceDirection == 2) {
                                temp = overlay.getVoxelValueAtCoordinate((double)(updateSlice - origin.xInt) * sliceSize, (double)(origin.yInt - ctrX) * xSize, (double)(origin.zInt - ctrY) * ySize, usingTransform && isIndexTransformMode);
                            }
                        } else if (this.sliceDirection == 0) {
                            temp = overlay.getVoxelValueAtMM((double)ctrX * xSize, (double)ctrY * ySize, (double)updateSlice * sliceSize, usingTransform, 0);
                        } else if (this.sliceDirection == 1) {
                            temp = overlay.getVoxelValueAtMM((double)ctrX * xSize, (double)updateSlice * sliceSize, (double)ctrY * ySize, usingTransform, 0);
                        } else if (this.sliceDirection == 2) {
                            temp = overlay.getVoxelValueAtMM((double)updateSlice * sliceSize, (double)ctrX * xSize, (double)ctrY * ySize, usingTransform, 0);
                        }
                        if (!isNegative && temp < overlayScreenMin || isNegative && temp > overlayScreenMin) {
                            this.overlayRGBData[ctr][offset] = 0;
                            continue;
                        }
                        if (!isNegative && temp > overlayScreenMax || isNegative && temp < overlayScreenMax) {
                            this.overlayRGBData[ctr][offset] = -1;
                            continue;
                        }
                        int num = (int)((temp - overlayScreenMin) * overlayScreenRatio + 0.5);
                        this.overlayRGBData[ctr][offset] = num | num << 8 | num << 16 | num << 24;
                    }
                }
            }
        }
    }

    private void drawShapes(Graphics2D g2d, AffineTransform xform) {
        int color;
        Vector<Integer> usedROIs = this.roiManager.getUsedIndicesCurrentLast();
        for (int ctr : usedROIs) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setColor(ROIColor.getTransparentColor(ctr));
            g2d.setColor(ROIColor.getColor(ctr));
            g2d.draw(this.roi[ctr]);
        }
        LOIManager managerLOI = this.getLOIManagerMain();
        int aSlice = this.getSliceNumber();
        if (managerLOI.hasShapes() && managerLOI.hasShapes(aSlice)) {
            for (LOIShape currentLOI = managerLOI.getShape(aSlice); currentLOI != null; currentLOI = currentLOI.getNext()) {
                color = currentLOI.getColor();
                g2d.setColor(ROIColor.getColor(color));
                currentLOI.setGraphics(g2d);
                g2d.draw(xform.createTransformedShape(currentLOI));
            }
        }
        if (this.poiManager.hasPoints(aSlice, this.sliceDirection)) {
            for (POI current = this.poiManager.getPOIs(aSlice, this.sliceDirection); current != null; current = current.getNext(this.sliceDirection)) {
                color = current.getColor();
                g2d.setColor(ROIColor.getColor(color));
                current.setGraphics(g2d);
                Shape currentShape = xform.createTransformedShape(current.getShape(this.sliceDirection));
                g2d.draw(currentShape);
            }
        }
    }

    private void updateROIShape(int updateSlice, int size) {
        if (this.initializeROIManager() && this.roiManager.hasROI()) {
            this.roi = this.roiManager.getShape(updateSlice, this.sliceDirection, this.makeScreenTransform(size));
        }
    }

    private void paintComponent(Graphics g, int size, boolean drawROI) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2d.setColor(Color.BLACK);
        g2d.fill(new Rectangle(0, 0, size, size));
        this.volumes.get(0).getLookupTableManager().getOp().filter(this.screenSlice, this.screenSliceFiltered);
        g2d.drawImage(this.screenSliceFiltered, this.makeScreenTransform(size), null);
        this.drawOverlays(g2d, size);
        if (this.showROI && drawROI) {
            this.drawShapes(g2d, this.makeScreenTransform(size));
        }
    }

    private AffineTransform makeScreenTransform(double width) {
        double scaleY;
        double scaleX;
        AffineTransform transform = new AffineTransform();
        int xDim = this.getXDim(this.sliceDirection);
        int yDim = this.getYDim(this.sliceDirection);
        double xSize = this.getXSize(this.sliceDirection);
        double ySize = this.getYSize(this.sliceDirection);
        double mmX = (double)xDim * xSize;
        double mmY = (double)yDim * ySize;
        double xyRatio = xSize / ySize;
        double yxRatio = ySize / xSize;
        if (mmX > mmY) {
            scaleX = width / (double)this.getLongestDim() * (xSize / this.getLongestDimSize());
            scaleY = width / (double)this.getLongestDim() * yxRatio * (xSize / this.getLongestDimSize());
        } else {
            scaleX = width / (double)this.getLongestDim() * xyRatio * (ySize / this.getLongestDimSize());
            scaleY = width / (double)this.getLongestDim() * (ySize / this.getLongestDimSize());
        }
        double transX = (width - (double)xDim * scaleX) / 2.0;
        double transY = (width - (double)yDim * scaleY) / 2.0;
        transform.setTransform(scaleX, 0.0, 0.0, scaleY, transX, transY);
        return transform;
    }

    private void drawOverlays(Graphics2D g2d, int size) {
        for (int ctr = 1; ctr < this.volumes.size(); ++ctr) {
            this.volumes.get(ctr).getLookupTableManager().getOp().filter(this.overlayScreenSlice[ctr - 1], this.overlayScreenSliceFiltered[ctr - 1]);
            g2d.drawImage(this.overlayScreenSliceFiltered[ctr - 1], this.makeScreenTransform(size), null);
        }
    }

    private int getLongestDim() {
        Volume volume = (Volume)this.getBaseVolume();
        int longestDim = volume.getXDim();
        double longestDimSize = volume.getXSize();
        if ((double)volume.getYDim() * volume.getYSize() > (double)longestDim * longestDimSize) {
            longestDim = volume.getYDim();
            longestDimSize = volume.getYSize();
        }
        if ((double)volume.getZDim() * volume.getZSize() > (double)longestDim * longestDimSize) {
            longestDim = volume.getZDim();
        }
        return longestDim;
    }

    private double getLongestDimSize() {
        Volume volume = (Volume)this.getBaseVolume();
        int longestDim = volume.getXDim();
        double longestDimSize = volume.getXSize();
        if ((double)volume.getYDim() * volume.getYSize() > (double)longestDim * longestDimSize) {
            longestDim = volume.getYDim();
            longestDimSize = volume.getYSize();
        }
        if ((double)volume.getZDim() * volume.getZSize() > (double)longestDim * longestDimSize) {
            longestDimSize = volume.getZSize();
        }
        return longestDimSize;
    }

    @Override
    public BufferedImage captureImage() {
        if (this.initializeROIManager() && this.initializeLineManagers() && this.initializePointManager()) {
            return this.getMainImage();
        }
        return null;
    }

    @Override
    public void recordAction(String name, String[] argValues, boolean forceNeedsUserInput) {
    }

    @Override
    public File getCaptureDir() {
        return null;
    }

    @Override
    public String getCaptureName() {
        return null;
    }

    @Override
    public String getCaptureType() {
        return null;
    }

    public BufferedImage getMainImage() {
        BufferedImage image = new BufferedImage(this.captureSize, this.captureSize, 2);
        this.initScreenData();
        this.updateScreenSlice(this.getSliceNumber());
        this.updateROIShape(this.getSliceNumber(), this.captureSize);
        this.paintComponent(image.getGraphics(), this.captureSize, true);
        return image;
    }

    public BufferedImage getMainImage(boolean exclude) {
        BufferedImage image = new BufferedImage(this.captureSize, this.captureSize, 2);
        this.initScreenData();
        this.updateScreenSlice(this.getSliceNumber());
        this.updateROIShape(this.getSliceNumber(), this.captureSize);
        this.paintComponent(image.getGraphics(), this.captureSize, !exclude);
        return image;
    }

    public BufferedImage getMainImage(BufferedImage image, int slice) {
        this.initScreenData();
        this.updateScreenSlice(slice);
        this.updateROIShape(slice, image.getWidth());
        this.paintComponent(image.getGraphics(), image.getWidth(), true);
        return image;
    }

    public int getCaptureSize() {
        return this.captureSize;
    }

    public int getVideoCaptureSize() {
        return this.captureSize / 2;
    }

    public BufferedImage getVideoImage() {
        return this.getMainImage(new BufferedImage(this.captureSize / 2, this.captureSize / 2, 1), this.getSliceNumber(), false);
    }

    public BufferedImage getMainImage(BufferedImage image, int slice, boolean exclude) {
        this.initScreenData();
        this.updateScreenSlice(slice);
        this.updateROIShape(slice, image.getWidth());
        this.paintComponent(image.getGraphics(), image.getWidth(), !exclude);
        return image;
    }

    public BufferedImage getMainImage(BufferedImage image, int slice, int timeIndex, boolean exclude) {
        this.initScreenData();
        this.getCurrentVolume().setCurrentSeriesPoint(timeIndex);
        this.updateScreenSlice(slice);
        this.updateROIShape(slice, image.getWidth());
        this.paintComponent(image.getGraphics(), image.getWidth(), !exclude);
        return image;
    }

    public String getManagerTitle() {
        return FileUtilities.removeExtension((String)FileUtilities.getName((URI)this.loadedURI));
    }

    public void convertIndexToWorldCoordinate(Coordinate coor) {
        ImageVolume baseVolume = this.getBaseVolume();
        Coordinate origin = baseVolume.getOrigin();
        coor.setValues((coor.xDbl - (double)origin.xInt) * baseVolume.getXSize(), ((double)origin.yInt - coor.yDbl) * baseVolume.getYSize(), ((double)origin.zInt - coor.zDbl) * baseVolume.getZSize());
    }

    public void convertWorldToIndexCoordinate(Coordinate coor) {
        ImageVolume baseVolume = this.getBaseVolume();
        Coordinate origin = baseVolume.getOrigin();
        coor.setValues((double)Math.round(coor.xDbl / baseVolume.getXSize() + (double)origin.xInt), (double)Math.round(coor.yDbl / -baseVolume.getYSize() + (double)origin.yInt), (double)Math.round(coor.zDbl / -baseVolume.getZSize() + (double)origin.zInt));
    }

    public String getVersion() {
        return Mango.getVersionString();
    }

    public void runShrinkWrapROI(double threshold, long roiMask, int roiOutputColorIndex, boolean percentMax, boolean seriesUsesDynamicThreshold) {
        double threshMin = threshold;
        if (percentMax) {
            Volume vol = (Volume)this.getCurrentVolume();
            vol.updateMaxMin(vol, vol.findRangeSeries());
            double imageMax = vol.getImageMax();
            threshMin = imageMax * (threshold / 100.0);
        }
        this.roiManager.runShrinkWrap3D(threshMin, Double.MAX_VALUE, (Volume)this.getCurrentVolume(), true, roiMask, roiOutputColorIndex, false, this.roiManager.isUsing4dROI(), seriesUsesDynamicThreshold);
    }

    public void runShrinkWrapROIAllSlices(double threshold, int sliceDirection, long roiMask, int roiOutputColorIndex, boolean percentMax, boolean seriesUsesDynamicThreshold) {
        double threshMin = threshold;
        if (percentMax) {
            Volume vol = (Volume)this.getCurrentVolume();
            vol.updateMaxMin(vol, vol.findRangeSeries());
            double imageMax = vol.getImageMax();
            threshMin = imageMax * (threshold / 100.0);
        }
        this.roiManager.shrinkWrap2D(-1, sliceDirection, threshMin, Double.MAX_VALUE, true, roiMask, roiOutputColorIndex, false, this.roiManager.isUsing4dROI(), seriesUsesDynamicThreshold, true);
    }

    public void runShrinkWrapROISlice(double threshold, int sliceDirection, int sliceNumber, long roiMask, int roiOutputColorIndex, boolean percentMax, boolean seriesUsesDynamicThreshold) {
        double threshMin = threshold;
        if (percentMax) {
            Volume vol = (Volume)this.getCurrentVolume();
            vol.updateMaxMin(vol, vol.findRangeSeries());
            double imageMax = vol.getImageMax();
            threshMin = imageMax * (threshold / 100.0);
        }
        this.roiManager.shrinkWrap2D(sliceNumber, sliceDirection, threshMin, Double.MAX_VALUE, true, roiMask, roiOutputColorIndex, false, this.roiManager.isUsing4dROI(), seriesUsesDynamicThreshold, true);
    }

    public String getName(ImageVolume volume) {
        String name = null;
        if (volume != null && StringUtils.isBlank((CharSequence)(name = ((Volume)volume).getTitle()))) {
            name = StringUtilities.makeNiceImageName((String)FileUtilities.getName((URI)this.getLoadedURI(volume)));
        }
        return name;
    }

    public BufferedImage makePluginOverlay(int sliceDirection) {
        AppLogger.warn((String)"makePluginOverlay() is not supported at the command-line");
        return null;
    }

    public void addSliceListener(SliceListener listener, int sliceDirection) {
        AppLogger.warn((String)"addSliceListener() is not supported at the command-line");
    }

    @Deprecated
    public void removePluginOverlays() {
        AppLogger.warn((String)"removePluginOverlays() is not supported at the command-line");
    }

    public void removeSliceListener(SliceListener listener, int sliceDirection) {
        AppLogger.warn((String)"removeSliceListener() is not supported at the command-line");
    }

    public void removePluginOverlay(BufferedImage pluginOverlay, int sliceDirection) {
        AppLogger.warn((String)"removePluginOverlay() is not supported at the command-line");
    }

    public void logPoint(Coordinate coordinate, String des) {
        Volume vol = (Volume)this.getCurrentVolume();
        Coordinate4D coor = new Coordinate4D((double)coordinate.xInt, (double)coordinate.yInt, (double)coordinate.zInt, vol.getCurrentSeriesPoint());
        PointStatROIOp op = new PointStatROIOp(this, vol, this.getROIManager().getBuffer());
        double result = op.process(coor, vol.getCurrentTimepoint());
        AnalysisPointImpl poi = new AnalysisPointImpl(coor, result, this, vol, des, "Point");
        Context.getContext().addAnalysisPoint(poi);
    }

    public void saveWithName(String saveLocation) {
        File file = new File(saveLocation);
        this.loadedURI = file.toURI();
        Volume volume = (Volume)this.getBaseVolume();
        ReadableHeader header = volume.getReadableHeader();
        if (header != null && header instanceof WritableHeader) {
            WritableHeader headerWritable = (WritableHeader)header;
            File imageFile = headerWritable.formatImageFile(file);
            volume.setImageFileName(imageFile.getName());
        }
        this.save();
    }

    public void addBookmark(Coordinate coord, String label) {
        ((Volume)this.getBaseVolume()).addBookmark(coord, label);
    }

    public void setOrientationOption(ImageVolume volume, int index) {
        ((Volume)volume).setSelectedCoordinateSpaceTransform(index);
    }
}

