/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.jpeg;

import edu.uthscsa.ric.volume.formats.jpeg.DataStream;
import java.io.IOException;

public class HuffmanTable {
    private final int[][][] l = new int[4][2][16];
    private final int[] th = new int[4];
    private final int[][][][] v = new int[4][2][16][200];
    private final int[][] tc = new int[4][2];
    public static final int MSB = Integer.MIN_VALUE;

    public HuffmanTable() {
        this.tc[0][0] = 0;
        this.tc[1][0] = 0;
        this.tc[2][0] = 0;
        this.tc[3][0] = 0;
        this.tc[0][1] = 0;
        this.tc[1][1] = 0;
        this.tc[2][1] = 0;
        this.tc[3][1] = 0;
        this.th[0] = 0;
        this.th[1] = 0;
        this.th[2] = 0;
        this.th[3] = 0;
    }

    protected int read(DataStream dataStream, int[][][] nArray) throws IOException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = dataStream.get16();
        n3 += 2;
        while (n3 < n4) {
            int n5;
            n2 = dataStream.get8();
            ++n3;
            n = n2 & 0xF;
            if (n > 3) {
                throw new IOException("ERROR: Huffman table ID > 3");
            }
            int n6 = n2 >> 4;
            if (n6 > 2) {
                throw new IOException("ERROR: Huffman table [Table class > 2 ]");
            }
            this.th[n] = 1;
            this.tc[n][n6] = 1;
            for (n5 = 0; n5 < 16; ++n5) {
                this.l[n][n6][n5] = dataStream.get8();
                ++n3;
            }
            for (n5 = 0; n5 < 16; ++n5) {
                for (int i = 0; i < this.l[n][n6][n5]; ++i) {
                    if (n3 > n4) {
                        throw new IOException("ERROR: Huffman table format error [count>Lh]");
                    }
                    this.v[n][n6][n5][i] = dataStream.get8();
                    ++n3;
                }
            }
        }
        if (n3 != n4) {
            throw new IOException("ERROR: Huffman table format error [count!=Lf]");
        }
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 2; ++n) {
                if (this.tc[n2][n] == 0) continue;
                this.buildHuffTable(nArray[n2][n], this.l[n2][n], this.v[n2][n]);
            }
        }
        return 1;
    }

    private void buildHuffTable(int[] nArray, int[] nArray2, int[][] nArray3) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = 256;
        int n5 = 0;
        for (n3 = 0; n3 < 8; ++n3) {
            for (n2 = 0; n2 < nArray2[n3]; ++n2) {
                for (n = 0; n < n4 >> n3 + 1; ++n) {
                    nArray[n5] = nArray3[n3][n2] | n3 + 1 << 8;
                    ++n5;
                }
            }
        }
        n3 = 1;
        while (n5 < 256) {
            nArray[n5] = n3 | Integer.MIN_VALUE;
            ++n3;
            ++n5;
        }
        int n6 = 1;
        n5 = 0;
        for (n3 = 8; n3 < 16; ++n3) {
            for (n2 = 0; n2 < nArray2[n3]; ++n2) {
                for (n = 0; n < n4 >> n3 - 7; ++n) {
                    nArray[n6 * 256 + n5] = nArray3[n3][n2] | n3 + 1 << 8;
                    ++n5;
                }
                if (n5 < 256) continue;
                if (n5 > 256) {
                    throw new IOException("ERROR: Huffman table error(1)!");
                }
                n5 = 0;
                ++n6;
            }
        }
    }
}

