/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.jpeg;

import edu.uthscsa.ric.volume.formats.jpeg.ComponentSpec;
import edu.uthscsa.ric.volume.formats.jpeg.DataStream;
import java.io.IOException;

public class FrameHeader {
    private ComponentSpec[] components;
    private int dimX;
    private int dimY;
    private int numComp;
    private int precision;

    public ComponentSpec[] getComponents() {
        return (ComponentSpec[])this.components.clone();
    }

    public int getDimX() {
        return this.dimX;
    }

    public int getDimY() {
        return this.dimY;
    }

    public int getNumComponents() {
        return this.numComp;
    }

    public int getPrecision() {
        return this.precision;
    }

    protected int read(DataStream dataStream) throws IOException {
        int n = 0;
        int n2 = dataStream.get16();
        n += 2;
        this.precision = dataStream.get8();
        ++n;
        this.dimY = dataStream.get16();
        n += 2;
        this.dimX = dataStream.get16();
        n += 2;
        this.numComp = dataStream.get8();
        ++n;
        this.components = new ComponentSpec[256];
        for (int i = 1; i <= this.numComp; ++i) {
            if (n > n2) {
                throw new IOException("ERROR: frame format error");
            }
            int n3 = dataStream.get8();
            if (++n >= n2) {
                throw new IOException("ERROR: frame format error [c>=Lf]");
            }
            int n4 = dataStream.get8();
            ++n;
            if (this.components[n3] == null) {
                this.components[n3] = new ComponentSpec();
            }
            this.components[n3].hSamp = n4 >> 4;
            this.components[n3].vSamp = n4 & 0xF;
            this.components[n3].quantTableSel = dataStream.get8();
            ++n;
        }
        if (n != n2) {
            throw new IOException("ERROR: frame format error [Lf!=count]");
        }
        return 1;
    }
}

