/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.procaddress;

import com.jogamp.gluegen.CMethodBindingEmitter;
import com.jogamp.gluegen.JavaType;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.cgram.types.FunctionSymbol;
import com.jogamp.gluegen.cgram.types.PointerType;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.procaddress.ProcAddressEmitter;
import java.io.PrintWriter;

public class ProcAddressCMethodBindingEmitter
extends CMethodBindingEmitter {
    private boolean callThroughProcAddress;
    private boolean hasProcAddrTypedef;
    private String localTypedefCallingConvention;
    private static final String procAddressJavaTypeName = JavaType.createForClass(Long.TYPE).jniTypeName();
    private ProcAddressEmitter emitter;

    public ProcAddressCMethodBindingEmitter(CMethodBindingEmitter cMethodBindingEmitter, final boolean bl, boolean bl2, String string, ProcAddressEmitter procAddressEmitter) {
        super(new MethodBinding(cMethodBindingEmitter.getBinding()){

            @Override
            public String getImplName() {
                if (bl) {
                    return "dispatch_" + super.getImplName();
                }
                return super.getImplName();
            }
        }, cMethodBindingEmitter.getDefaultOutput(), cMethodBindingEmitter.getJavaPackageName(), cMethodBindingEmitter.getJavaClassName(), cMethodBindingEmitter.getIsOverloadedBinding(), cMethodBindingEmitter.getIsJavaMethodStatic(), true, cMethodBindingEmitter.forIndirectBufferAndArrayImplementation(), cMethodBindingEmitter.getMachineDataInfo(), procAddressEmitter.getConfiguration());
        if (cMethodBindingEmitter.getReturnValueCapacityExpression() != null) {
            this.setReturnValueCapacityExpression(cMethodBindingEmitter.getReturnValueCapacityExpression());
        }
        if (cMethodBindingEmitter.getReturnValueLengthExpression() != null) {
            this.setReturnValueLengthExpression(cMethodBindingEmitter.getReturnValueLengthExpression());
        }
        this.setTemporaryCVariableDeclarations(cMethodBindingEmitter.getTemporaryCVariableDeclarations());
        this.setTemporaryCVariableAssignments(cMethodBindingEmitter.getTemporaryCVariableAssignments());
        this.setCommentEmitter(defaultCommentEmitter);
        this.callThroughProcAddress = bl;
        this.hasProcAddrTypedef = bl2;
        this.localTypedefCallingConvention = string;
        this.emitter = procAddressEmitter;
    }

    @Override
    protected int emitArguments(PrintWriter printWriter) {
        int n = super.emitArguments(printWriter);
        if (this.callThroughProcAddress) {
            if (n > 0) {
                printWriter.print(", ");
            }
            printWriter.print(procAddressJavaTypeName);
            printWriter.print(" procAddress");
            ++n;
        }
        return n;
    }

    @Override
    protected void emitBodyVariableDeclarations(PrintWriter printWriter) {
        if (this.callThroughProcAddress) {
            FunctionSymbol functionSymbol = this.binding.getCSymbol();
            String string = this.emitter.getFunctionPointerTypedefName(functionSymbol);
            String string2 = "_local_" + string;
            String string3 = this.hasProcAddrTypedef ? string : string2;
            PointerType pointerType = new PointerType(null, functionSymbol.getType(), 0);
            printWriter.print("  typedef ");
            printWriter.print(pointerType.toString(string2, this.localTypedefCallingConvention));
            printWriter.println(";");
            printWriter.print("  ");
            printWriter.print(string3);
            printWriter.print(" ptr_");
            printWriter.print(this.getNativeName());
            printWriter.println(";");
        }
        super.emitBodyVariableDeclarations(printWriter);
    }

    @Override
    protected void emitBodyVariablePreCallSetup(PrintWriter printWriter) {
        super.emitBodyVariablePreCallSetup(printWriter);
        if (this.callThroughProcAddress) {
            String string = this.emitter.getFunctionPointerTypedefName(this.binding.getCSymbol());
            String string2 = "_local_" + string;
            String string3 = this.hasProcAddrTypedef ? string : string2;
            String string4 = "ptr_" + this.getNativeName();
            if (this.hasProcAddrTypedef) {
                printWriter.println("  // implicit type validation of " + string2 + " -> " + string3);
            }
            printWriter.print("  ");
            printWriter.print(string4);
            printWriter.print(" = (");
            printWriter.print(string2);
            printWriter.println(") (intptr_t) procAddress;");
            printWriter.println("  assert(" + string4 + " != NULL);");
        }
    }

    @Override
    protected void emitBodyCallCFunction(PrintWriter printWriter) {
        if (!this.callThroughProcAddress) {
            super.emitBodyCallCFunction(printWriter);
        } else {
            MethodBinding methodBinding;
            printWriter.print("  ");
            Type type = this.binding.getCReturnType();
            if (!type.isVoid()) {
                printWriter.print("_res = (");
                printWriter.print(type.getCName(false));
                printWriter.print(") ");
            }
            if ((methodBinding = this.getBinding()).hasContainingType()) {
                throw new IllegalStateException("Cannot call through function pointer because binding has containing type: " + methodBinding);
            }
            printWriter.print("(* ptr_");
            printWriter.print(this.getNativeName());
            printWriter.print(") ");
            printWriter.print("(");
            this.emitBodyPassCArguments(printWriter);
            printWriter.println(");");
        }
    }

    @Override
    protected String jniMangle(MethodBinding methodBinding) {
        StringBuilder stringBuilder = new StringBuilder(super.jniMangle(methodBinding));
        if (this.callThroughProcAddress) {
            this.jniMangle(Long.TYPE, stringBuilder, false);
        }
        return stringBuilder.toString();
    }
}

