/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.jcpp;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.CheckForNull;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class NumericValue
extends Number {
    public static final int F_UNSIGNED = 1;
    public static final int F_INT = 2;
    public static final int F_LONG = 4;
    public static final int F_LONGLONG = 8;
    public static final int F_FLOAT = 16;
    public static final int F_DOUBLE = 32;
    public static final int FF_SIZE = 62;
    private final int base;
    private final String integer;
    private String fraction;
    private int expbase = 0;
    private String exponent;
    private int flags;

    public NumericValue(int n, String string) {
        this.base = n;
        this.integer = string;
    }

    @Nonnegative
    public int getBase() {
        return this.base;
    }

    @Nonnull
    public String getIntegerPart() {
        return this.integer;
    }

    @CheckForNull
    public String getFractionalPart() {
        return this.fraction;
    }

    void setFractionalPart(String string) {
        this.fraction = string;
    }

    @CheckForSigned
    public int getExponentBase() {
        return this.expbase;
    }

    @CheckForNull
    public String getExponent() {
        return this.exponent;
    }

    void setExponent(int n, String string) {
        this.expbase = n;
        this.exponent = string;
    }

    public int getFlags() {
        return this.flags;
    }

    void setFlags(int n) {
        this.flags = n;
    }

    @Nonnull
    public BigDecimal toBigDecimal() {
        String string;
        int n = 0;
        String string2 = this.getIntegerPart();
        String string3 = this.getFractionalPart();
        if (string3 != null) {
            string2 = string2 + this.getFractionalPart();
            n += string3.length();
        }
        if ((string = this.getExponent()) != null) {
            n -= Integer.parseInt(string);
        }
        BigInteger bigInteger = new BigInteger(string2, this.getBase());
        return new BigDecimal(bigInteger, n);
    }

    @Nonnull
    public Number toJavaLangNumber() {
        int n = this.getFlags();
        if ((n & 0x20) != 0) {
            return this.doubleValue();
        }
        if ((n & 0x10) != 0) {
            return Float.valueOf(this.floatValue());
        }
        if ((n & 0xC) != 0) {
            return this.longValue();
        }
        if ((n & 2) != 0) {
            return this.intValue();
        }
        if (this.getFractionalPart() != null) {
            return this.doubleValue();
        }
        if (this.getExponent() != null) {
            return this.doubleValue();
        }
        return this.intValue();
    }

    private int exponentValue() {
        return Integer.parseInt(this.exponent, 10);
    }

    @Override
    public int intValue() {
        int n;
        int n2 = n = this.integer.isEmpty() ? 0 : Integer.parseInt(this.integer, this.base);
        if (this.expbase == 2) {
            n <<= this.exponentValue();
        } else if (this.expbase != 0) {
            n = (int)((double)n * Math.pow(this.expbase, this.exponentValue()));
        }
        return n;
    }

    @Override
    public long longValue() {
        long l;
        long l2 = l = this.integer.isEmpty() ? 0L : Long.parseLong(this.integer, this.base);
        if (this.expbase == 2) {
            l <<= this.exponentValue();
        } else if (this.expbase != 0) {
            l = (long)((double)l * Math.pow(this.expbase, this.exponentValue()));
        }
        return l;
    }

    @Override
    public float floatValue() {
        if (this.getBase() != 10) {
            return this.longValue();
        }
        return Float.parseFloat(this.toString());
    }

    @Override
    public double doubleValue() {
        if (this.getBase() != 10) {
            return this.longValue();
        }
        return Double.parseDouble(this.toString());
    }

    private boolean appendFlags(StringBuilder stringBuilder, String string, int n) {
        if ((this.getFlags() & n) != n) {
            return false;
        }
        stringBuilder.append(string);
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.base) {
            case 8: {
                stringBuilder.append('0');
                break;
            }
            case 10: {
                break;
            }
            case 16: {
                stringBuilder.append("0x");
                break;
            }
            case 2: {
                stringBuilder.append('b');
                break;
            }
            default: {
                stringBuilder.append("[base-").append(this.base).append("]");
            }
        }
        stringBuilder.append(this.getIntegerPart());
        if (this.getFractionalPart() != null) {
            stringBuilder.append('.').append(this.getFractionalPart());
        }
        if (this.getExponent() != null) {
            stringBuilder.append(this.base > 10 ? (char)'p' : 'e');
            stringBuilder.append(this.getExponent());
        }
        return stringBuilder.toString();
    }
}

