/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.visualization.surface.io.formats.gifti;

import edu.uthscsa.ric.visualization.surface.io.formats.gifti.DataArray;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.GIFTI;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.GiftiFormatException;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.GiftiTransform;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.GiftiUtils;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.GiftiWriterDataHandler;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.Label;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.Deflater;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class GiftiWriter {
    private final GIFTI gifti;
    private final File file;
    private int level;
    private final boolean lineBreaks;
    public static final int BUFFER_SIZE = 8192;
    private final byte[] buffer = new byte[8192];
    public static final String INDENT = "   ";

    public GiftiWriter(GIFTI gifti, File file) {
        this(gifti, file, false);
    }

    public GiftiWriter(GIFTI gifti, File file, boolean lineBreaks) {
        this.gifti = gifti;
        this.file = file;
        this.lineBreaks = lineBreaks;
    }

    public void writeGiftiXML() throws GiftiFormatException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(this.file);
            XMLStreamWriter out = XMLOutputFactory.newInstance().createXMLStreamWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
            this.writeStartDocument(out);
            this.writeDTD(out, "<!DOCTYPE GIFTI SYSTEM \"http://gifti.projects.nitrc.org/gifti.dtd\">");
            this.writeStartElement(out, "GIFTI", this.gifti.getAttributes(), false);
            this.writeMetadata(out, this.gifti.getMetadata());
            Map<Integer, Label> labelTable = this.gifti.getLabelTable();
            if (labelTable != null) {
                this.writeStartElement(out, "LabelTable", null, false);
                for (Map.Entry<Integer, Label> entry : labelTable.entrySet()) {
                    Integer key = entry.getKey();
                    Label label = entry.getValue();
                    Map<String, String> labelAtts = label.getAttributes();
                    labelAtts.put("Key", String.valueOf(key));
                    this.writeStartElement(out, "Label", labelAtts, Label.ORDER, true);
                    this.writeCData(out, label.getLabel());
                    this.writeEndElement(out, true);
                }
                this.writeEndElement(out, false);
            } else {
                this.writeEmptyElement(out, "LabelTable");
            }
            if (this.gifti.getNumDataArrays() > 0) {
                for (DataArray da : this.gifti.getDataArrays()) {
                    this.writeStartElement(out, "DataArray", da.getAttributes(), false);
                    this.writeMetadata(out, da.getMetadata());
                    Vector<GiftiTransform> xforms = da.getTransforms();
                    if (xforms != null && xforms.size() > 0) {
                        for (GiftiTransform xform : xforms) {
                            this.writeStartElement(out, "CoordinateSystemTransformMatrix", null, false);
                            this.writeStartElement(out, "DataSpace", null, true);
                            this.writeCData(out, xform.dataSpace);
                            this.writeEndElement(out, true);
                            this.writeStartElement(out, "TransformedSpace", null, true);
                            this.writeCData(out, xform.xformSpace);
                            this.writeEndElement(out, true);
                            this.writeStartElement(out, "MatrixData", null, true);
                            this.writeCharacters(out, xform.getXformAsString());
                            this.writeEndElement(out, true);
                            this.writeEndElement(out, false);
                        }
                    }
                    this.writeStartElement(out, "Data", null, false);
                    this.writeData(out, da);
                    this.writeEndElement(out, false);
                    this.writeEndElement(out, true);
                }
            }
            this.writeEndElement(out, false);
            out.writeEndDocument();
            out.close();
        }
        catch (FileNotFoundException ex) {
            throw new GiftiFormatException(ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new GiftiFormatException(ex);
        }
        catch (XMLStreamException ex) {
            throw new GiftiFormatException(ex);
        }
        catch (FactoryConfigurationError ex) {
            throw new GiftiFormatException(ex);
        }
        finally {
            try {
                os.close();
            }
            catch (Exception exception) {}
        }
    }

    private void writeStartElement(XMLStreamWriter out, String tag, boolean containsData) throws XMLStreamException {
        this.writeStartElement(out, tag, null, null, containsData);
    }

    private void writeStartElement(XMLStreamWriter out, String tag, Map<String, String> atts, boolean containsData) throws XMLStreamException {
        this.writeStartElement(out, tag, atts, null, containsData);
    }

    private void writeStartElement(XMLStreamWriter out, String tag, Map<String, String> atts, List<String> attOrder, boolean containsData) throws XMLStreamException {
        for (int x = 0; x < this.level; ++x) {
            out.writeCharacters(INDENT);
        }
        out.writeStartElement(tag);
        if (atts != null && atts.size() > 0) {
            if (attOrder != null) {
                for (String name : attOrder) {
                    String value = atts.get(name);
                    out.writeAttribute(name, value);
                }
            } else {
                for (String name : atts.keySet()) {
                    String value = atts.get(name);
                    out.writeAttribute(name, value);
                }
            }
        }
        if (!containsData) {
            out.writeCharacters("\n");
        }
        ++this.level;
    }

    private void writeEndElement(XMLStreamWriter out, boolean containsData) throws XMLStreamException {
        --this.level;
        if (!containsData) {
            for (int x = 0; x < this.level; ++x) {
                out.writeCharacters(INDENT);
            }
        }
        out.writeEndElement();
        out.writeCharacters("\n");
    }

    private void writeStartDocument(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartDocument();
        out.writeCharacters("\n");
    }

    private void writeCData(XMLStreamWriter out, String str) throws XMLStreamException {
        out.writeCData(str);
    }

    private void writeCharacters(XMLStreamWriter out, String str) throws XMLStreamException {
        out.writeCharacters(str);
    }

    private void writeDTD(XMLStreamWriter out, String dtd) throws XMLStreamException {
        out.writeDTD(dtd);
        out.writeCharacters("\n");
    }

    private void writeMetadata(XMLStreamWriter out, Map<String, String> metadata) throws XMLStreamException {
        if (metadata != null && metadata.size() > 0) {
            this.writeStartElement(out, "MetaData", false);
            for (String name : metadata.keySet()) {
                String value = metadata.get(name);
                this.writeStartElement(out, "MD", false);
                this.writeStartElement(out, "Name", true);
                this.writeCData(out, name);
                this.writeEndElement(out, true);
                this.writeStartElement(out, "Value", true);
                this.writeCData(out, value);
                this.writeEndElement(out, true);
                this.writeEndElement(out, false);
            }
            this.writeEndElement(out, false);
        }
    }

    private void writeEmptyElement(XMLStreamWriter out, String str) throws XMLStreamException {
        for (int x = 0; x < this.level; ++x) {
            out.writeCharacters(INDENT);
        }
        out.writeEmptyElement(str);
        out.writeCharacters("\n");
    }

    private void writeData(XMLStreamWriter out, DataArray dataArray) throws XMLStreamException, UnsupportedEncodingException {
        GiftiWriterDataHandler it = new GiftiWriterDataHandler(dataArray);
        Deflater deflater = new Deflater();
        int leftover = 0;
        int bufferMark = 0;
        String currentString = "";
        int numValues = dataArray.getNumValues();
        int valueCt = 0;
        byte[] deflatedBuffer = new byte[8192];
        while (it.hasNext()) {
            boolean lastValue;
            int dataValue = it.next();
            boolean bl = lastValue = ++valueCt == numValues;
            if (dataArray.isLittleEndian()) {
                this.buffer[bufferMark++] = (byte)(dataValue >> 0 & 0xFF);
                this.buffer[bufferMark++] = (byte)(dataValue >> 8 & 0xFF);
                this.buffer[bufferMark++] = (byte)(dataValue >> 16 & 0xFF);
                this.buffer[bufferMark++] = (byte)(dataValue >> 24 & 0xFF);
            } else {
                this.buffer[bufferMark++] = (byte)(dataValue >> 24 & 0xFF);
                this.buffer[bufferMark++] = (byte)(dataValue >> 16 & 0xFF);
                this.buffer[bufferMark++] = (byte)(dataValue >> 8 & 0xFF);
                this.buffer[bufferMark++] = (byte)(dataValue >> 0 & 0xFF);
            }
            if (bufferMark != 8192) continue;
            deflater.setInput(this.buffer);
            if (lastValue) {
                deflater.finish();
            }
            while (!lastValue && !deflater.needsInput() || lastValue && !deflater.finished()) {
                int numBytesDeflated = deflater.deflate(deflatedBuffer, leftover, deflatedBuffer.length - leftover) + leftover;
                if (numBytesDeflated <= 0) continue;
                int numValid = numBytesDeflated / 3 * 3;
                leftover = numBytesDeflated % 3;
                byte[] encoded = GiftiUtils.encode(deflatedBuffer, 0, numValid);
                if (this.lineBreaks) {
                    currentString = currentString + new String(encoded, "UTF-8");
                    while (currentString.length() > 76) {
                        out.writeCharacters(currentString.substring(0, 76) + "\r\n");
                        currentString = currentString.substring(76);
                    }
                } else {
                    out.writeCharacters(new String(encoded, "UTF-8"));
                }
                if (leftover <= 0) continue;
                System.arraycopy(deflatedBuffer, numValid, deflatedBuffer, 0, leftover);
            }
            bufferMark = 0;
        }
        if (bufferMark > 0) {
            deflater.setInput(this.buffer, 0, bufferMark);
            deflater.finish();
            while (!deflater.finished()) {
                int numBytesDeflated = deflater.deflate(deflatedBuffer, leftover, deflatedBuffer.length - leftover) + leftover;
                if (numBytesDeflated <= 0) continue;
                int numValid = numBytesDeflated / 3 * 3;
                leftover = numBytesDeflated % 3;
                byte[] encoded = GiftiUtils.encode(deflatedBuffer, 0, numValid);
                if (this.lineBreaks) {
                    currentString = currentString + new String(encoded, "UTF-8");
                    while (currentString.length() > 76) {
                        out.writeCharacters(currentString.substring(0, 76) + "\r\n");
                        currentString = currentString.substring(76);
                    }
                } else {
                    out.writeCharacters(new String(encoded, "UTF-8"));
                }
                if (leftover <= 0) continue;
                System.arraycopy(deflatedBuffer, numValid, deflatedBuffer, 0, leftover);
            }
            if (leftover > 0) {
                byte[] encoded = GiftiUtils.encode(deflatedBuffer, 0, leftover);
                if (this.lineBreaks) {
                    currentString = currentString + new String(encoded, "UTF-8");
                    while (currentString.length() > 76) {
                        out.writeCharacters(currentString.substring(0, 76) + "\r\n");
                        currentString = currentString.substring(76);
                    }
                } else {
                    out.writeCharacters(new String(encoded, "UTF-8"));
                }
            }
        }
        if (currentString.length() > 0) {
            out.writeCharacters(currentString);
        }
        if (this.lineBreaks) {
            out.writeCharacters("\r\n");
        }
        deflater.end();
    }
}

