/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.visualization.surface.io.formats.gifti;

import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;

public class GiftiUtils {
    public static byte[] encode(byte[] data, int offset, int length) {
        int i;
        if (data == null) {
            return null;
        }
        if (offset < 0 || offset > data.length) {
            throw new IndexOutOfBoundsException("Can't encode at index " + offset + " which is beyond array bounds 0.." + data.length);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Can't encode a negative amount of data");
        }
        if (offset + length > data.length) {
            throw new IndexOutOfBoundsException("Can't encode beyond right edge of array");
        }
        byte[] dest = new byte[(length + 2) / 3 * 4];
        int j = 0;
        for (i = 0 + offset; i < offset + length - 2; i += 3) {
            dest[j++] = (byte)(data[i] >>> 2 & 0x3F);
            dest[j++] = (byte)(data[i + 1] >>> 4 & 0xF | data[i] << 4 & 0x3F);
            dest[j++] = (byte)(data[i + 2] >>> 6 & 3 | data[i + 1] << 2 & 0x3F);
            dest[j++] = (byte)(data[i + 2] & 0x3F);
        }
        if (i < offset + length) {
            dest[j++] = (byte)(data[i] >>> 2 & 0x3F);
            if (i < offset + length - 1) {
                dest[j++] = (byte)(data[i + 1] >>> 4 & 0xF | data[i] << 4 & 0x3F);
                dest[j++] = (byte)(data[i + 1] << 2 & 0x3F);
            } else {
                dest[j++] = (byte)(data[i] << 4 & 0x3F);
            }
        }
        for (i = 0; i < j; ++i) {
            dest[i] = dest[i] < 26 ? (int)(dest[i] + 65) : (dest[i] < 52 ? (int)(dest[i] + 97 - 26) : (dest[i] < 62 ? (int)(dest[i] + 48 - 52) : (dest[i] < 63 ? 43 : 47)));
        }
        while (i < dest.length) {
            dest[i] = 61;
            ++i;
        }
        return dest;
    }

    public static Map<String, String> attributesToMap(Attributes atts) {
        HashMap<String, String> map = null;
        if (atts != null) {
            map = new HashMap<String, String>();
            int numAtts = atts.getLength();
            for (int ctr = 0; ctr < numAtts; ++ctr) {
                String name = atts.getQName(ctr);
                String value = atts.getValue(name);
                map.put(name, value);
            }
        }
        return map;
    }

    public static int swapInt(byte[] b, int i) {
        return Integer.reverseBytes(GiftiUtils.bytesToInt(b, i));
    }

    private static int bytesToInt(byte[] b, int i) {
        return (b[i + 3] & 0xFF) << 0 | (b[i + 2] & 0xFF) << 8 | (b[i + 1] & 0xFF) << 16 | (b[i + 0] & 0xFF) << 24;
    }

    public static int getInt(byte[] b, int i) {
        return GiftiUtils.bytesToInt(b, i);
    }

    public static float swapFloat(byte[] b, int i) {
        return Float.intBitsToFloat(GiftiUtils.swapInt(b, i));
    }

    public static float getFloat(byte[] b, int i) {
        return GiftiUtils.bytesToFloat(b, i);
    }

    private static float bytesToFloat(byte[] b, int i) {
        return Float.intBitsToFloat(GiftiUtils.bytesToInt(b, i));
    }

    public static boolean isIdentity(float[][] aMatParams, boolean abs) {
        for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
            for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                if (ctrOut == ctrIn && (abs && Math.abs(aMatParams[ctrOut][ctrIn]) != 1.0f || !abs && aMatParams[ctrOut][ctrIn] != 1.0f)) {
                    return false;
                }
                if (ctrOut == ctrIn || aMatParams[ctrOut][ctrIn] == 0.0f) continue;
                return false;
            }
        }
        return true;
    }
}

