/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.visualization.surface.io.formats.gifti;

import edu.uthscsa.ric.visualization.surface.io.formats.gifti.DataArray;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.GIFTI;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.GiftiFormatException;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.GiftiReaderDataHandler;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.GiftiTransform;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.GiftiUtils;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.Label;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.MD;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.MetadataHolder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.zip.DataFormatException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.codec.binary.Base64;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GiftiReader
extends DefaultHandler {
    private final File file;
    private GIFTI gifti;
    private MetadataHolder currentMetadataHolder;
    private DataArray currentDataArray;
    private GiftiTransform currentTransform;
    private Map<String, String> metadata;
    private MD currentMD;
    private StringBuffer currentString;
    private GiftiReaderDataHandler dataHandler;
    private int leftOverBytes;
    private final Base64 base64;
    private boolean isReadingName;
    private boolean isReadingValue;
    private boolean isReadingData;
    private boolean isReadingXform;
    private boolean isReadingTransformedSpace;
    private boolean isReadingDataSpace;
    private boolean isReadingLabel;
    private boolean headerOnly;
    private Map<Integer, Label> labelTable;
    private Label currentLabel;
    private ByteBuffer currentBuffer;
    public static final String TAG_COORDINATESYSTEMTRANSFORMMATRIX = "CoordinateSystemTransformMatrix";
    public static final String TAG_DATA = "Data";
    public static final String TAG_DATAARRAY = "DataArray";
    public static final String TAG_DATASPACE = "DataSpace";
    public static final String TAG_GIFTI = "GIFTI";
    public static final String TAG_LABEL = "Label";
    public static final String TAG_LABELTABLE = "LabelTable";
    public static final String TAG_MATRIXDATA = "MatrixData";
    public static final String TAG_METADATA = "MetaData";
    public static final String TAG_MD = "MD";
    public static final String TAG_NAME = "Name";
    public static final String TAG_TRANSFORMEDSPACE = "TransformedSpace";
    public static final String TAG_VALUE = "Value";
    public static final int BUFFER_SIZE = 8192;
    private final byte[] buffer = new byte[8192];

    public GiftiReader(File file) {
        this.file = file;
        this.base64 = new Base64();
    }

    public GIFTI parseGiftiXML() throws GiftiFormatException {
        return this.parseGiftiXML(false);
    }

    public GIFTI parseGiftiXML(boolean headerOnly) throws GiftiFormatException {
        this.headerOnly = headerOnly;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        try {
            SAXParser saxParser = factory.newSAXParser();
            FileInputStream inputStream = new FileInputStream(this.file);
            BufferedInputStream bis = new BufferedInputStream(inputStream, 8192);
            InputStreamReader reader = new InputStreamReader((InputStream)bis, "UTF-8");
            InputSource is = new InputSource(reader);
            is.setEncoding("UTF-8");
            saxParser.parse(is, (DefaultHandler)this);
        }
        catch (ParserConfigurationException ex) {
            throw new GiftiFormatException(ex);
        }
        catch (SAXException ex) {
            throw new GiftiFormatException(ex);
        }
        catch (FileNotFoundException ex) {
            throw new GiftiFormatException(ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new GiftiFormatException(ex);
        }
        catch (IOException ex) {
            throw new GiftiFormatException(ex);
        }
        return this.gifti;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equalsIgnoreCase(TAG_GIFTI)) {
            this.gifti = new GIFTI(GiftiUtils.attributesToMap(attributes));
            this.currentMetadataHolder = this.gifti;
        } else if (qName.equalsIgnoreCase(TAG_LABELTABLE)) {
            this.labelTable = new TreeMap<Integer, Label>();
            this.gifti.setLabelTable(this.labelTable);
        } else if (qName.equalsIgnoreCase(TAG_LABEL)) {
            Map<String, String> atts = GiftiUtils.attributesToMap(attributes);
            this.currentLabel = new Label(Double.parseDouble(atts.get("Red")), Double.parseDouble(atts.get("Green")), Double.parseDouble(atts.get("Blue")), Double.parseDouble(atts.get("Alpha")));
            this.labelTable.put(Integer.parseInt(atts.get("Key")), this.currentLabel);
            this.isReadingLabel = true;
            this.currentString = new StringBuffer();
        } else if (qName.equalsIgnoreCase(TAG_DATAARRAY)) {
            this.currentDataArray = new DataArray(GiftiUtils.attributesToMap(attributes), this.headerOnly);
            this.currentMetadataHolder = this.currentDataArray;
            this.currentBuffer = this.currentDataArray.getAsByteBuffer();
            this.gifti.addDataArray(this.currentDataArray);
        } else if (qName.equalsIgnoreCase(TAG_METADATA)) {
            this.metadata = new HashMap<String, String>();
        } else if (qName.equalsIgnoreCase(TAG_MD)) {
            this.currentMD = new MD();
        } else if (qName.equalsIgnoreCase(TAG_NAME)) {
            this.isReadingName = true;
            this.currentString = new StringBuffer();
        } else if (qName.equalsIgnoreCase(TAG_VALUE)) {
            this.isReadingValue = true;
            this.currentString = new StringBuffer();
        } else if (qName.equalsIgnoreCase(TAG_DATA)) {
            this.isReadingData = true;
            this.currentString = new StringBuffer();
            this.leftOverBytes = 0;
            this.dataHandler = new GiftiReaderDataHandler(this.currentDataArray.isGzipBase64Binary());
        } else if (qName.equalsIgnoreCase(TAG_COORDINATESYSTEMTRANSFORMMATRIX)) {
            this.currentTransform = new GiftiTransform();
        } else if (qName.equalsIgnoreCase(TAG_TRANSFORMEDSPACE)) {
            this.isReadingTransformedSpace = true;
            this.currentString = new StringBuffer();
        } else if (qName.equalsIgnoreCase(TAG_DATASPACE)) {
            this.isReadingDataSpace = true;
            this.currentString = new StringBuffer();
        } else if (qName.equalsIgnoreCase(TAG_MATRIXDATA)) {
            this.isReadingXform = true;
            this.currentString = new StringBuffer();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isReadingName) {
            this.isReadingName = false;
            this.currentString.append(ch, start, length);
        } else if (this.isReadingValue) {
            this.isReadingValue = false;
            this.currentString.append(ch, start, length);
        } else if (this.isReadingXform) {
            this.currentString.append(ch, start, length);
        } else if (this.isReadingTransformedSpace) {
            this.currentString.append(ch, start, length);
        } else if (this.isReadingLabel) {
            this.currentString.append(ch, start, length);
        } else if (this.isReadingDataSpace) {
            this.currentString.append(ch, start, length);
        } else if (this.isReadingData && !this.headerOnly) {
            if (this.currentDataArray.isAscii()) {
                this.currentString.append(ch, start, length);
                int spaceIndex = this.currentString.lastIndexOf(" ");
                int tabIndex = this.currentString.lastIndexOf("\t");
                int newlineIndex = this.currentString.lastIndexOf("\n");
                int index = spaceIndex;
                if (tabIndex > index) {
                    index = tabIndex;
                }
                if (newlineIndex > index) {
                    index = newlineIndex;
                }
                String string = this.currentString.substring(0, index);
                this.currentString.delete(0, index);
                this.handleAsciiData(string);
            } else {
                String str = new String(ch, start, length);
                str = str.replaceAll("\\s", "");
                this.currentString.append(str);
                int actualLength = this.currentString.length();
                int validLength = actualLength / 4 * 4;
                String string = null;
                if (actualLength != validLength) {
                    string = this.currentString.substring(0, validLength);
                    this.currentString.delete(0, validLength);
                } else {
                    string = this.currentString.toString();
                    this.currentString.delete(0, actualLength);
                }
                try {
                    this.handleBinaryData(string.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException ex) {
                    throw new SAXException(ex);
                }
                catch (DataFormatException ex) {
                    throw new SAXException(ex);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!qName.equalsIgnoreCase(TAG_GIFTI)) {
            if (qName.equalsIgnoreCase(TAG_LABEL)) {
                this.isReadingLabel = false;
                this.currentLabel.setLabel(this.currentString.toString().trim());
            } else if (!qName.equalsIgnoreCase(TAG_DATAARRAY)) {
                if (qName.equalsIgnoreCase(TAG_METADATA)) {
                    this.currentMetadataHolder.addMetadata(this.metadata);
                } else if (qName.equalsIgnoreCase(TAG_MD)) {
                    this.metadata.put(this.currentMD.name, this.currentMD.value);
                } else if (qName.equalsIgnoreCase(TAG_NAME)) {
                    this.isReadingName = false;
                    this.currentMD.name = this.currentString.toString().trim();
                } else if (qName.equalsIgnoreCase(TAG_VALUE)) {
                    this.isReadingValue = false;
                    this.currentMD.value = this.currentString.toString().trim();
                } else if (qName.equalsIgnoreCase(TAG_DATA)) {
                    this.isReadingData = false;
                } else if (qName.equalsIgnoreCase(TAG_TRANSFORMEDSPACE)) {
                    this.isReadingTransformedSpace = false;
                    this.currentTransform.xformSpace = this.currentString.toString().trim();
                } else if (qName.equalsIgnoreCase(TAG_DATASPACE)) {
                    this.isReadingDataSpace = false;
                    this.currentTransform.dataSpace = this.currentString.toString().trim();
                } else if (qName.equalsIgnoreCase(TAG_MATRIXDATA)) {
                    this.isReadingXform = false;
                    try {
                        this.handleTransform();
                    }
                    catch (GiftiFormatException ex) {
                        throw new SAXException(ex);
                    }
                }
            }
        }
    }

    private void handleTransform() throws GiftiFormatException {
        try (Scanner scanner = new Scanner(this.currentString.toString());){
            float[][] xform = new float[4][4];
            for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    if (!scanner.hasNextFloat()) {
                        throw new GiftiFormatException("Could not read the coordinate transform matrix!");
                    }
                    xform[ctrOut][ctrIn] = scanner.nextFloat();
                }
            }
            this.currentTransform.xform = xform;
            if (!GiftiUtils.isIdentity(xform, false)) {
                this.currentDataArray.addTransform(this.currentTransform);
            }
        }
    }

    private void handleBinaryData(byte[] data) throws DataFormatException {
        boolean isByte = this.currentDataArray.isUnsignedInt8();
        boolean isFloat = this.currentDataArray.isFloat32();
        boolean isInt = this.currentDataArray.isInt32();
        boolean swap = !isByte && this.currentDataArray.isLittleEndian();
        int numBytes = isByte ? 1 : 4;
        this.dataHandler.setData(this.base64.decode(data));
        while (this.dataHandler.hasMoreData()) {
            int ctr;
            int bytesRead = this.dataHandler.readData(this.buffer, this.leftOverBytes, this.buffer.length - this.leftOverBytes) + this.leftOverBytes;
            int validBytes = bytesRead / numBytes * numBytes;
            for (ctr = 0; ctr < validBytes; ctr += numBytes) {
                if (swap) {
                    if (isFloat) {
                        this.currentBuffer.putFloat(GiftiUtils.swapFloat(this.buffer, ctr));
                        continue;
                    }
                    if (isInt) {
                        this.currentBuffer.putInt(GiftiUtils.swapInt(this.buffer, ctr));
                        continue;
                    }
                    this.currentBuffer.put(this.buffer[ctr]);
                    continue;
                }
                if (isFloat) {
                    this.currentBuffer.putFloat(GiftiUtils.getFloat(this.buffer, ctr));
                    continue;
                }
                if (isInt) {
                    this.currentBuffer.putInt(GiftiUtils.getInt(this.buffer, ctr));
                    continue;
                }
                this.currentBuffer.put(this.buffer[ctr]);
            }
            for (ctr = validBytes; ctr < bytesRead; ++ctr) {
                this.buffer[ctr - validBytes] = this.buffer[ctr];
            }
            this.leftOverBytes = bytesRead - validBytes;
        }
    }

    private void handleAsciiData(String str) {
        StringTokenizer scanner = new StringTokenizer(str);
        while (scanner.hasMoreTokens()) {
            this.currentBuffer.putFloat(Float.valueOf(scanner.nextToken()).floatValue());
        }
    }
}

