/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.time;

import java.util.Date;
import net.jcip.annotations.Immutable;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.time.CalendarPeriod;

@Immutable
public class CalendarDate
implements Comparable<CalendarDate> {
    public static final double MILLISECS_IN_SECOND = 1000.0;
    public static final double MILLISECS_IN_MINUTE = 60000.0;
    public static final double MILLISECS_IN_HOUR = 3600000.0;
    public static final double MILLISECS_IN_DAY = 8.64E7;
    public static final double MILLISECS_IN_YEAR = 3.15569259747E10;
    public static final double MILLISECS_IN_MONTH = 2.629743831225E9;
    private final DateTime dateTime;
    private final Calendar cal;
    private int hashCode = 0;

    public static CalendarDate present() {
        return new CalendarDate(null, new DateTime());
    }

    public static CalendarDate of(Calendar cal, int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute) {
        Chronology base = Calendar.getChronology(cal);
        DateTime dt = new DateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, base);
        if (!Calendar.isDefaultChronology(cal)) {
            dt = dt.withChronology(Calendar.getChronology(cal));
        }
        dt = dt.withZone(DateTimeZone.UTC);
        return new CalendarDate(cal, dt);
    }

    public static CalendarDate withDoy(Calendar cal, int year, int doy, int hourOfDay, int minuteOfHour, int secondOfMinute) {
        Chronology base = Calendar.getChronology(cal);
        DateTime dt = new DateTime(year, 1, 1, hourOfDay, minuteOfHour, secondOfMinute, base);
        dt = dt.withZone(DateTimeZone.UTC);
        dt = dt.withDayOfYear(doy);
        if (!Calendar.isDefaultChronology(cal)) {
            dt = dt.withChronology(Calendar.getChronology(cal));
        }
        return new CalendarDate(cal, dt);
    }

    public static CalendarDate of(Date date) {
        DateTime dt = new DateTime((Object)date, DateTimeZone.UTC);
        return new CalendarDate(null, dt);
    }

    public static CalendarDate of(long msecs) {
        DateTime dt = new DateTime(msecs, DateTimeZone.UTC);
        return new CalendarDate(null, dt);
    }

    public static CalendarDate of(Calendar cal, long msecs) {
        Chronology base = Calendar.getChronology(cal);
        DateTime dt = new DateTime(msecs, base);
        return new CalendarDate(cal, dt);
    }

    public static CalendarDate parseISOformat(String calendarName, String isoDateString) {
        Calendar cal = Calendar.get(calendarName);
        if (cal == null) {
            cal = Calendar.getDefault();
        }
        return CalendarDateFormatter.isoStringToCalendarDate(cal, isoDateString);
    }

    public static CalendarDate parseISOformatOld(String calendarName, String isoDateString) {
        Date date = CalendarDateFormatter.isoStringToDate(isoDateString);
        Calendar cal = Calendar.get(calendarName);
        Chronology chronology = Calendar.getChronology(cal);
        DateTime dt = new DateTime((Object)date, chronology);
        return new CalendarDate(cal, dt);
    }

    public static CalendarDate parseUdunits(String calendarName, String udunits) {
        int pos = udunits.indexOf(32);
        if (pos < 0) {
            return null;
        }
        String valString = udunits.substring(0, pos).trim();
        String unitString = udunits.substring(pos + 1).trim();
        CalendarDateUnit cdu = CalendarDateUnit.of(calendarName, unitString);
        double val = Double.parseDouble(valString);
        return cdu.makeCalendarDate(val);
    }

    static CalendarDate of(Calendar cal, DateTime dateTime) {
        return new CalendarDate(cal, dateTime);
    }

    CalendarDate(Calendar cal, DateTime dateTime) {
        this.cal = cal == null ? Calendar.getDefault() : cal;
        this.dateTime = dateTime;
    }

    public Calendar getCalendar() {
        return this.cal;
    }

    public long getMillis() {
        return this.dateTime.getMillis();
    }

    DateTime getDateTime() {
        return this.dateTime;
    }

    @Override
    public int compareTo(CalendarDate o) {
        return this.dateTime.compareTo((ReadableInstant)o.dateTime);
    }

    public boolean isAfter(CalendarDate o) {
        return this.dateTime.isAfter((ReadableInstant)o.dateTime);
    }

    public boolean isBefore(CalendarDate o) {
        return this.dateTime.isBefore((ReadableInstant)o.dateTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CalendarDate)) {
            return false;
        }
        CalendarDate other = (CalendarDate)o;
        return other.cal == this.cal && other.dateTime.equals((Object)this.dateTime);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            if (this.cal != null) {
                result += 37 * result + this.cal.hashCode();
            }
            result += 37 * result + this.dateTime.hashCode();
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public String toString() {
        return CalendarDateFormatter.toDateTimeStringISO(this);
    }

    public int getHourOfDay() {
        return this.dateTime.getHourOfDay();
    }

    public int getDayOfMonth() {
        return this.dateTime.getDayOfMonth();
    }

    public CalendarDate add(double value, CalendarPeriod.Field unit) {
        switch (unit) {
            case Millisec: {
                return new CalendarDate(this.cal, this.dateTime.plus(Math.round(value)));
            }
            case Second: {
                return new CalendarDate(this.cal, this.dateTime.plus(Math.round(value * 1000.0)));
            }
            case Minute: {
                return new CalendarDate(this.cal, this.dateTime.plus(Math.round(value * 60000.0)));
            }
            case Hour: {
                return new CalendarDate(this.cal, this.dateTime.plus(Math.round(value * 3600000.0)));
            }
            case Day: {
                return new CalendarDate(this.cal, this.dateTime.plus(Math.round(value * 8.64E7)));
            }
            case Month: {
                return new CalendarDate(this.cal, this.dateTime.plus(Math.round(value * 2.629743831225E9)));
            }
            case Year: {
                return new CalendarDate(this.cal, this.dateTime.plus(Math.round(value * 3.15569259747E10)));
            }
        }
        throw new UnsupportedOperationException("period units = " + (Object)((Object)unit));
    }

    public CalendarDate add(CalendarPeriod period) {
        switch (period.getField()) {
            case Millisec: {
                return new CalendarDate(this.cal, this.dateTime.plusMillis(period.getValue()));
            }
            case Second: {
                return new CalendarDate(this.cal, this.dateTime.plusSeconds(period.getValue()));
            }
            case Minute: {
                return new CalendarDate(this.cal, this.dateTime.plusMinutes(period.getValue()));
            }
            case Hour: {
                return new CalendarDate(this.cal, this.dateTime.plusHours(period.getValue()));
            }
            case Day: {
                return new CalendarDate(this.cal, this.dateTime.plusDays(period.getValue()));
            }
            case Month: {
                return new CalendarDate(this.cal, this.dateTime.plusMonths(period.getValue()));
            }
            case Year: {
                return new CalendarDate(this.cal, this.dateTime.plusYears(period.getValue()));
            }
        }
        throw new UnsupportedOperationException("period units = " + period);
    }

    public CalendarDate subtract(CalendarPeriod period) {
        switch (period.getField()) {
            case Millisec: {
                return new CalendarDate(this.cal, this.dateTime.minusMillis(period.getValue()));
            }
            case Second: {
                return new CalendarDate(this.cal, this.dateTime.minusSeconds(period.getValue()));
            }
            case Minute: {
                return new CalendarDate(this.cal, this.dateTime.minusMinutes(period.getValue()));
            }
            case Hour: {
                return new CalendarDate(this.cal, this.dateTime.minusHours(period.getValue()));
            }
            case Day: {
                return new CalendarDate(this.cal, this.dateTime.minusDays(period.getValue()));
            }
            case Month: {
                return new CalendarDate(this.cal, this.dateTime.minusMonths(period.getValue()));
            }
            case Year: {
                return new CalendarDate(this.cal, this.dateTime.minusYears(period.getValue()));
            }
        }
        throw new UnsupportedOperationException("period units = " + period);
    }

    public CalendarDate truncate(CalendarPeriod.Field fld) {
        switch (fld) {
            case Minute: {
                return CalendarDate.of(this.cal, this.dateTime.getYear(), this.dateTime.getMonthOfYear(), this.dateTime.getDayOfMonth(), this.dateTime.getHourOfDay(), this.dateTime.getMinuteOfHour(), 0);
            }
            case Hour: {
                return CalendarDate.of(this.cal, this.dateTime.getYear(), this.dateTime.getMonthOfYear(), this.dateTime.getDayOfMonth(), this.dateTime.getHourOfDay(), 0, 0);
            }
            case Day: {
                return CalendarDate.of(this.cal, this.dateTime.getYear(), this.dateTime.getMonthOfYear(), this.dateTime.getDayOfMonth(), 0, 0, 0);
            }
            case Month: {
                return CalendarDate.of(this.cal, this.dateTime.getYear(), this.dateTime.getMonthOfYear(), 1, 0, 0, 0);
            }
            case Year: {
                return CalendarDate.of(this.cal, this.dateTime.getYear(), 1, 1, 0, 0, 0);
            }
        }
        return this;
    }

    public Date toDate() {
        return this.dateTime.toDate();
    }

    public long getDifferenceInMsecs(CalendarDate o) {
        return this.dateTime.getMillis() - o.dateTime.getMillis();
    }

    public static void main(String[] args) {
        CalendarDate dt = CalendarDate.parseUdunits(null, "calendar Month since 2012-01-19T18:00:00.000Z");
        System.out.printf("%s%n", dt);
    }
}

