/*
 * Decompiled with CFR 0.152.
 */
package virtual.tools;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import rad.dicom.dcm.DcmDataObject;
import virtual.tools.DcmImage;
import virtual.tools.FFTTools;
import virtual.tools.ImagePanel;
import virtual.tools.ImagePlus;

public class KSpaceManipulatorCanvas
extends JPanel {
    private ImagePlus sourceImg = null;
    ImagePlus destImg;
    private Image sourceKSpace = null;
    private float[][] targetKSpaceReal;
    private float[][] targetKSpaceImag;
    private Image targetKSpace = null;
    private Image targetImg = null;
    private ImagePanel backReference;

    public KSpaceManipulatorCanvas(ImagePanel ip) {
        this.setBackground(Color.black);
        this.backReference = ip;
    }

    public void setSourceImg(ImagePlus i) {
        this.sourceImg = i;
    }

    public void setSourceKSpace(Image i) {
        this.sourceKSpace = i;
    }

    public void setTargetKSpace(float[][] re, float[][] im, int[] mag) {
        this.targetKSpaceReal = re;
        this.targetKSpaceImag = im;
        this.targetKSpace = this.createImage(new MemoryImageSource(256, 256, mag, 0, 256));
    }

    public void recalcTargetImage() {
        float[][] reFFT = FFTTools.getReshiftedIFFT(this.targetKSpaceReal, this.targetKSpaceImag);
        short[] intIFFT = new short[65536];
        for (int y = 0; y < 256; ++y) {
            for (int x = 0; x < 256; ++x) {
                intIFFT[y * 256 + x] = (short)reFFT[x][y];
            }
        }
        DcmDataObject myddo = this.sourceImg.getDDO();
        DcmImage dcmimg = null;
        try {
            dcmimg = new DcmImage(myddo);
            dcmimg.pixel16 = intIFFT;
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        this.destImg = new ImagePlus(dcmimg);
        this.destImg.setDDO(myddo);
        this.destImg.setCurrentDate();
        this.destImg.optimalWindowing();
        this.destImg.updateAWTImage();
        this.targetImg = this.destImg.getAWTImage();
    }

    public void setTragetImage(Image img) {
        this.targetImg = img;
    }

    public void paint(Graphics g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, 512, 512);
        g.setColor(Color.green);
        if (this.sourceImg != null) {
            g.drawImage(this.sourceImg.getAWTImage(), 0, 0, 256, 256, this);
            g.drawString(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulatorcanvas.original.title"), 5, 15);
        }
        if (this.sourceKSpace != null) {
            g.drawImage(this.sourceKSpace, 256, 0, 256, 256, this);
            g.drawString(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulatorcanvas.kspace.original.title"), 261, 15);
        }
        if (this.targetKSpace != null) {
            g.drawImage(this.targetKSpace, 0, 256, 256, 256, this);
            g.drawString(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulatorcanvas.kspace.manipulated.title"), 5, 271);
        }
        if (this.targetImg != null) {
            g.drawImage(this.targetImg, 256, 256, 256, 256, this);
            g.drawString(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulatorcanvas.kspace.reversed.title"), 261, 271);
        }
        g.setColor(Color.white);
        g.drawRect(0, 0, 511, 511);
        g.drawLine(0, 256, 512, 256);
        g.drawLine(256, 0, 256, 512);
    }

    public ImagePlus getDestinationImage() {
        return this.destImg;
    }
}

