/*
 * Decompiled with CFR 0.152.
 */
package virtual.tools;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.MemoryImageSource;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import virtual.tools.FFTTools;
import virtual.tools.ImagePanel;
import virtual.tools.ImagePlus;
import virtual.tools.KSpaceManipulatorCanvas;
import virtual.tools.LabelTFLabelPanel;
import virtual.tools.LabelTFLabel_1Panel;

public class KSpaceManipulator
extends JFrame {
    private final Cursor DEFAULT_CURSOR = new Cursor(0);
    private final Cursor WINDOW_CURSOR = new Cursor(13);
    ImagePlus sourceImg;
    float[][] origKSpaceReal;
    float[][] origKSpaceImag;
    float[][] manipKSpaceReal;
    float[][] manipKSpaceImag;
    int[] intKSpace;
    int[] manipIntKSpace;
    private int lastMouseClickX;
    private int lastMouseClickY;
    private long lastTime;
    private int lastCenter;
    private int lastWindow;
    KSpaceManipulatorCanvas pCanvas;
    JPanel pToolbar = new JPanel();
    JPanel pDeleteMargins = new JPanel();
    JPanel pDeleteRect = new JPanel();
    JPanel pDeleteLines = new JPanel();
    JCheckBox cbDeleteMargins = new JCheckBox();
    JCheckBox cbDeleteRect = new JCheckBox();
    JCheckBox cbDeleteLines = new JCheckBox();
    JButton pbCalcImage = new JButton();
    JButton pbtoDV = new JButton();
    LabelTFLabelPanel tfDelLeftColumns = new LabelTFLabelPanel(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.margin.left.title"), "0", ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.margin.left.unit"));
    LabelTFLabelPanel tfDelRightColumns = new LabelTFLabelPanel(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.margin.right.title"), "0", ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.margin.right.unit"));
    LabelTFLabelPanel tfDelTopRows = new LabelTFLabelPanel(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.margin.top.title"), "0", ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.margin.top.unit"));
    LabelTFLabelPanel tfDelBottomRows = new LabelTFLabelPanel(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.margin.bottom.title"), "0", ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.margin.bottom.unit"));
    LabelTFLabelPanel tfDelRectWidth = new LabelTFLabelPanel(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.rect.width.title"), "0", ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.rect.width.unit"));
    LabelTFLabelPanel tfDelRectHeight = new LabelTFLabelPanel(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.rect.height.title"), "0", ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.rect.height.unit"));
    LabelTFLabel_1Panel tfDelRows = new LabelTFLabel_1Panel(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.row.title"), "0", ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.row.unit"));
    LabelTFLabel_1Panel tfDelColumns = new LabelTFLabel_1Panel(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.col.title"), "0", ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.col.unit"));
    ImagePanel theImagePanel;

    public KSpaceManipulator(ImagePlus i, ImagePanel ip) {
        this.theImagePanel = ip;
        this.pCanvas = new KSpaceManipulatorCanvas(this.theImagePanel);
        this.sourceImg = i;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Dimension scrRes = this.getToolkit().getScreenSize();
        Dimension fs = this.getSize();
        this.setLocation((scrRes.width - fs.width) / 2, (scrRes.height - fs.height) / 2);
        this.origKSpaceReal = FFTTools.shift(this.sourceImg.getFFTImageReal(), 128, 128);
        this.origKSpaceImag = FFTTools.shift(this.sourceImg.getFFTImageImag(), 128, 128);
        this.manipKSpaceReal = new float[this.origKSpaceReal.length][this.origKSpaceReal[0].length];
        this.manipKSpaceImag = new float[this.origKSpaceImag.length][this.origKSpaceImag[0].length];
        this.intKSpace = FFTTools.getShiftedFFTImageSource(this.sourceImg);
        Image kSpace = this.createImage(new MemoryImageSource(256, 256, this.intKSpace, 0, 256));
        this.manipIntKSpace = new int[this.intKSpace.length];
        this.pCanvas.setSourceImg(this.sourceImg);
        this.pCanvas.setSourceKSpace(kSpace);
        this.pCanvas.setTargetKSpace(this.origKSpaceReal, this.origKSpaceImag, this.intKSpace);
        this.pCanvas.repaint();
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(null);
        if (System.getSecurityManager() == null) {
            this.setSize(800, 547);
        } else {
            this.setSize(800, 565);
        }
        this.setTitle(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.title"));
        this.pCanvas.setBounds(new Rectangle(0, 0, 512, 512));
        this.getContentPane().add((Component)this.pCanvas, null);
        this.pCanvas.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                KSpaceManipulator.this.pCanvas_mousePressed(e);
            }

            public void mouseReleased(MouseEvent e) {
                KSpaceManipulator.this.pCanvas_mouseReleased(e);
            }
        });
        this.pCanvas.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                KSpaceManipulator.this.pCanvas_mouseDragged(e);
            }
        });
        this.pToolbar.setLayout(null);
        this.pToolbar.setBounds(new Rectangle(515, 0, 280, 512));
        this.getContentPane().add((Component)this.pToolbar, null);
        this.pDeleteMargins.setLayout(null);
        this.pDeleteMargins.setBorder(BorderFactory.createEtchedBorder());
        this.pDeleteMargins.setBounds(new Rectangle(2, 2, 275, 115));
        this.pToolbar.add((Component)this.pDeleteMargins, null);
        this.cbDeleteMargins.setText(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.check.margin.title"));
        this.cbDeleteMargins.setBounds(new Rectangle(4, 2, 200, 18));
        this.pDeleteMargins.add((Component)this.cbDeleteMargins, null);
        this.cbDeleteMargins.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KSpaceManipulator.this.updateKSpaceImage();
            }
        });
        this.tfDelLeftColumns.setBounds(4, 21, 265, 20);
        this.tfDelLeftColumns.setRange(0, 255);
        this.pDeleteMargins.add((Component)this.tfDelLeftColumns, null);
        this.tfDelLeftColumns.getTextFieldReference().addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                KSpaceManipulator.this.updateKSpaceImage();
            }
        });
        this.tfDelRightColumns.setBounds(4, 44, 265, 20);
        this.tfDelRightColumns.setRange(0, 255);
        this.pDeleteMargins.add((Component)this.tfDelRightColumns, null);
        this.tfDelRightColumns.getTextFieldReference().addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                KSpaceManipulator.this.updateKSpaceImage();
            }
        });
        this.tfDelTopRows.setBounds(4, 67, 265, 20);
        this.tfDelTopRows.setRange(0, 255);
        this.pDeleteMargins.add((Component)this.tfDelTopRows, null);
        this.tfDelTopRows.getTextFieldReference().addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                KSpaceManipulator.this.updateKSpaceImage();
            }
        });
        this.tfDelBottomRows.setBounds(4, 90, 265, 20);
        this.tfDelBottomRows.setRange(0, 255);
        this.pDeleteMargins.add((Component)this.tfDelBottomRows, null);
        this.tfDelBottomRows.getTextFieldReference().addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                KSpaceManipulator.this.updateKSpaceImage();
            }
        });
        this.pDeleteRect.setLayout(null);
        this.pDeleteRect.setBorder(BorderFactory.createEtchedBorder());
        this.pDeleteRect.setBounds(new Rectangle(2, 119, 275, 69));
        this.pToolbar.add((Component)this.pDeleteRect, null);
        this.cbDeleteRect.setText(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.check.rect.title"));
        this.cbDeleteRect.setBounds(new Rectangle(4, 2, 200, 18));
        this.pDeleteRect.add((Component)this.cbDeleteRect, null);
        this.cbDeleteRect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KSpaceManipulator.this.updateKSpaceImage();
            }
        });
        this.tfDelRectWidth.setBounds(4, 21, 265, 20);
        this.tfDelRectWidth.setRange(0, 255);
        this.pDeleteRect.add((Component)this.tfDelRectWidth, null);
        this.tfDelRectWidth.getTextFieldReference().addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                KSpaceManipulator.this.updateKSpaceImage();
            }
        });
        this.tfDelRectHeight.setBounds(4, 44, 265, 20);
        this.tfDelRectHeight.setRange(0, 255);
        this.pDeleteRect.add((Component)this.tfDelRectHeight, null);
        this.tfDelRectHeight.getTextFieldReference().addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                KSpaceManipulator.this.updateKSpaceImage();
            }
        });
        this.pDeleteLines.setLayout(null);
        this.pDeleteLines.setBorder(BorderFactory.createEtchedBorder());
        this.pDeleteLines.setBounds(new Rectangle(2, 190, 275, 69));
        this.pToolbar.add((Component)this.pDeleteLines, null);
        this.cbDeleteLines.setText(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.check.rowcol.title"));
        this.cbDeleteLines.setBounds(new Rectangle(4, 2, 200, 18));
        this.pDeleteLines.add((Component)this.cbDeleteLines, null);
        this.cbDeleteLines.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KSpaceManipulator.this.updateKSpaceImage();
            }
        });
        this.tfDelRows.setBounds(4, 21, 265, 20);
        this.tfDelRows.setRange(2, 256);
        this.pDeleteLines.add((Component)this.tfDelRows, null);
        this.tfDelRows.getTextFieldReference().addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                KSpaceManipulator.this.updateKSpaceImage();
            }
        });
        this.tfDelColumns.setBounds(4, 44, 265, 20);
        this.tfDelColumns.setRange(2, 256);
        this.pDeleteLines.add((Component)this.tfDelColumns, null);
        this.tfDelColumns.getTextFieldReference().addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                KSpaceManipulator.this.updateKSpaceImage();
            }
        });
        this.pbCalcImage.setText(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.btn.reverse.title"));
        this.pbCalcImage.setBounds(new Rectangle(52, 280, 175, 26));
        this.pToolbar.add((Component)this.pbCalcImage, null);
        this.pbCalcImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KSpaceManipulator.this.pbCalcImage_actionPerformed(e);
            }
        });
        this.pbtoDV.setText(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspacemanipulator.btn.takeover.title"));
        this.pbtoDV.setBounds(new Rectangle(52, 485, 175, 26));
        this.pbtoDV.setEnabled(false);
        this.pToolbar.add((Component)this.pbtoDV, null);
        this.pbtoDV.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KSpaceManipulator.this.pbtoDV_actionPerformed(e);
            }
        });
    }

    private void deleteLines() {
        int rows = 0;
        int columns = 0;
        if (this.cbDeleteLines.isSelected()) {
            int y;
            try {
                rows = this.tfDelRows.getValue();
                columns = this.tfDelColumns.getValue();
            }
            catch (Exception err) {
                // empty catch block
            }
            if (rows > 0) {
                for (int x = 0; x < 256; ++x) {
                    for (y = 0; y < 256; ++y) {
                        if (y % rows != 0) continue;
                        this.manipIntKSpace[256 * y + x] = 0;
                        this.manipKSpaceReal[x][y] = 0.0f;
                        this.manipKSpaceImag[x][y] = 0.0f;
                    }
                }
            }
            if (columns > 0) {
                for (int x = 0; x < 256; ++x) {
                    for (y = 0; y < 256; ++y) {
                        if (x % columns != 0) continue;
                        this.manipIntKSpace[256 * y + x] = 0;
                        this.manipKSpaceReal[x][y] = 0.0f;
                        this.manipKSpaceImag[x][y] = 0.0f;
                    }
                }
            }
        }
    }

    private void deleteRect() {
        int width = 0;
        int height = 0;
        if (this.cbDeleteRect.isSelected()) {
            try {
                width = this.tfDelRectWidth.getValue();
                height = this.tfDelRectHeight.getValue();
            }
            catch (Exception err) {
                // empty catch block
            }
            if (width > 0 && height > 0) {
                for (int x = 128 - width / 2; x < 128 + width / 2; ++x) {
                    for (int y = 128 - height / 2; y < 128 + height / 2; ++y) {
                        this.manipIntKSpace[256 * y + x] = 0;
                        this.manipKSpaceReal[x][y] = 0.0f;
                        this.manipKSpaceImag[x][y] = 0.0f;
                    }
                }
            }
        }
    }

    private void deleteMargins() {
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        if (this.cbDeleteMargins.isSelected()) {
            int y;
            try {
                left = this.tfDelLeftColumns.getValue();
                right = this.tfDelRightColumns.getValue();
                top = this.tfDelTopRows.getValue();
                bottom = this.tfDelBottomRows.getValue();
            }
            catch (Exception err) {
                // empty catch block
            }
            if (left > 0) {
                for (int x = 0; x <= left; ++x) {
                    for (y = 0; y < 256; ++y) {
                        this.manipIntKSpace[y * 256 + x] = 0;
                        this.manipKSpaceReal[x][y] = 0.0f;
                        this.manipKSpaceImag[x][y] = 0.0f;
                    }
                }
            }
            if (right > 0) {
                for (int x = 256 - right; x < 256; ++x) {
                    for (y = 0; y < 256; ++y) {
                        this.manipIntKSpace[y * 256 + x] = 0;
                        this.manipKSpaceReal[x][y] = 0.0f;
                        this.manipKSpaceImag[x][y] = 0.0f;
                    }
                }
            }
            if (top > 0) {
                for (int x = 0; x < 256; ++x) {
                    for (y = 0; y <= top; ++y) {
                        this.manipIntKSpace[y * 256 + x] = 0;
                        this.manipKSpaceReal[x][y] = 0.0f;
                        this.manipKSpaceImag[x][y] = 0.0f;
                    }
                }
            }
            if (bottom > 0) {
                for (int x = 0; x < 256; ++x) {
                    for (y = 256 - bottom; y < 256; ++y) {
                        this.manipIntKSpace[y * 256 + x] = 0;
                        this.manipKSpaceReal[x][y] = 0.0f;
                        this.manipKSpaceImag[x][y] = 0.0f;
                    }
                }
            }
        }
    }

    public void updateKSpaceImage() {
        for (int x = 0; x < 256; ++x) {
            for (int y = 0; y < 256; ++y) {
                this.manipIntKSpace[256 * y + x] = this.intKSpace[256 * y + x];
                this.manipKSpaceReal[x][y] = this.origKSpaceReal[x][y];
                this.manipKSpaceImag[x][y] = this.origKSpaceImag[x][y];
            }
        }
        this.deleteMargins();
        this.deleteLines();
        this.deleteRect();
        this.pCanvas.setTargetKSpace(this.manipKSpaceReal, this.manipKSpaceImag, this.manipIntKSpace);
        this.pCanvas.repaint();
    }

    private void pbCalcImage_actionPerformed(ActionEvent e) {
        this.updateKSpaceImage();
        this.pCanvas.recalcTargetImage();
        this.pCanvas.repaint();
        this.pbtoDV.setEnabled(true);
    }

    private void pbtoDV_actionPerformed(ActionEvent e) {
        ImagePlus ip = this.pCanvas.getDestinationImage();
        this.theImagePanel.createNewImage(ip);
        this.theImagePanel.repaint();
        this.pbtoDV.setEnabled(false);
    }

    private void pCanvas_mousePressed(MouseEvent e) {
        this.lastMouseClickX = e.getX();
        this.lastMouseClickY = e.getY();
        this.lastCenter = this.pCanvas.getDestinationImage().getCenter();
        this.lastWindow = this.pCanvas.getDestinationImage().getWindow();
        this.lastTime = e.getWhen();
    }

    private void pCanvas_mouseReleased(MouseEvent e) {
        this.pCanvas.setCursor(this.DEFAULT_CURSOR);
    }

    private void pCanvas_mouseDragged(MouseEvent e) {
        this.pCanvas.setCursor(this.WINDOW_CURSOR);
        long curWhen = e.getWhen();
        int difT = (int)(curWhen - this.lastTime);
        if (difT < 100) {
            return;
        }
        int curX = e.getX();
        int curY = e.getY();
        int difX = curX - this.lastMouseClickX;
        int difY = this.lastMouseClickY - curY;
        if (Math.abs(difX) > 10) {
            difX *= 10;
        }
        if (Math.abs(difY) > 10) {
            difY *= 10;
        }
        if (this.lastCenter + difY <= 4095 && this.lastCenter + difY >= 0) {
            this.pCanvas.getDestinationImage().setCenter(this.lastCenter + difY);
            this.lastCenter += difY;
        }
        if (this.lastWindow + difX <= 4096 && this.lastWindow + difX >= 1) {
            this.pCanvas.getDestinationImage().setWindow(this.lastWindow + difX);
            this.lastWindow += difX;
        }
        this.lastMouseClickX = curX;
        this.lastMouseClickY = curY;
        this.lastTime = curWhen;
        this.pCanvas.getDestinationImage().updateAWTImage();
        this.pCanvas.setTragetImage(this.pCanvas.getDestinationImage().getAWTImage());
        this.pCanvas.repaint();
    }
}

