/*
 * Decompiled with CFR 0.152.
 */
package virtual.tools;

import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import jigl.image.ComplexImage;
import jigl.image.RealGrayImage;
import rad.dicom.dcm.DcmDataObject;
import rad.dicom.dcm.DcmValue;
import virtual.tools.DcmImage;
import virtual.tools.FFTTools;

public class ImagePlus {
    private Image img;
    private DcmImage DcmImg;
    private DcmDataObject ddo;
    private float[][] fftImageReal = null;
    private float[][] fftImageImag = null;
    private boolean fftOK = false;
    private String[] textNW;
    private String[] textNE;
    private String[] textSW;
    private String[] textSE;
    private int size;

    public ImagePlus() {
    }

    public ImagePlus(DcmImage di) {
        this.DcmImg = di;
        this.size = this.DcmImg.rows;
    }

    public String[] getTextNW() {
        this.textNW = new String[6];
        this.textNW[0] = ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("imageplus.text.nw.sequence") + this.getSequence();
        this.textNW[1] = this.getTR() != "" ? "TR: " + Double.valueOf(this.getTR()) : "TR: ";
        this.textNW[2] = this.getTI() != "" ? "TI: " + Double.valueOf(this.getTI()) : "TI: ";
        this.textNW[3] = this.getTE() != "" ? "TE: " + Double.valueOf(this.getTE()) : "TE: ";
        this.textNW[4] = this.getFA() != "" ? "FA: " + Double.valueOf(this.getFA()) : "FA: ";
        this.textNW[5] = "ETL :" + this.getETL();
        return this.textNW;
    }

    public String[] getTextNE() {
        this.textNE = new String[4];
        this.textNE[0] = ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("imageplus.text.ne.examdate");
        this.textNE[0] = this.textNE[0] + DateFormat.getDateInstance().format(this.getDate());
        this.textNE[1] = ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("imageplus.text.ne.name") + this.getPatientName();
        this.textNE[2] = ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("imageplus.text.nw.birthdate");
        this.textNE[2] = this.textNE[2] + DateFormat.getDateInstance().format(this.getPatientBirthdate());
        this.textNE[3] = ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("imageplus.text.nw.sex") + this.getPatientSex();
        return this.textNE;
    }

    public String[] getTextSW() {
        this.textSW = new String[3];
        this.textSW[2] = "SP: " + this.getSliceLocation();
        this.textSW[1] = "C: " + this.getCenter();
        this.textSW[0] = "W: " + this.getWindow();
        return this.textSW;
    }

    public String[] getTextSE() {
        this.textSE = null;
        return this.textSE;
    }

    public String getSequence() {
        return this.ddo.getString(144);
    }

    public String getTR() {
        return this.ddo.getString(170);
    }

    public String getTI() {
        return this.ddo.getString(172);
    }

    public String getTE() {
        return this.ddo.getString(171);
    }

    public String getETL() {
        return this.ddo.getString(181);
    }

    public String getSliceLocation() {
        return this.ddo.getString(467);
    }

    public String getFA() {
        return this.ddo.getString(303);
    }

    public String getPatientName() {
        return this.ddo.getString(104);
    }

    public Date getPatientBirthdate() {
        Date dat = new Date();
        if (this.ddo != null) {
            String date = this.ddo.getString(107);
            Calendar.getInstance().set(Integer.parseInt(date.substring(0, 4)) - 1900, Integer.parseInt(date.substring(4, 6)) - 1, Integer.parseInt(date.substring(6)));
        }
        return dat;
    }

    public String getPatientSex() {
        return this.ddo.getString(109);
    }

    public double getPixelSpacing() {
        return this.getPixelSpacingRow();
    }

    public double getPixelSpacingRow() {
        String[] sa = DcmValue.str2StringArray(this.ddo.getString(486), "\\");
        double pixelSpacingRow = 0.0;
        double pixelSpacingColumn = 0.0;
        if (sa.length > 0) {
            pixelSpacingRow = DcmValue.str2Double(sa[0], 0.0);
        }
        if (sa.length > 1) {
            pixelSpacingColumn = DcmValue.str2Double(sa[1], 0.0);
        }
        return pixelSpacingRow;
    }

    public double getPixelSpacingColumn() {
        String[] sa = DcmValue.str2StringArray(this.ddo.getString(486), "\\");
        double pixelSpacingRow = 0.0;
        double pixelSpacingColumn = 0.0;
        if (sa.length > 0) {
            pixelSpacingRow = DcmValue.str2Double(sa[0], 0.0);
        }
        if (sa.length > 1) {
            pixelSpacingColumn = DcmValue.str2Double(sa[1], 0.0);
        }
        return pixelSpacingColumn;
    }

    public Date getDate() {
        Date dat = new Date();
        if (this.ddo != null) {
            String imgdate = this.ddo.getString(12);
            String imgtime = this.ddo.getString(18);
            Calendar.getInstance().set(Integer.parseInt(imgdate.substring(0, 4)) - 1900, Integer.parseInt(imgdate.substring(4, 6)) - 1, Integer.parseInt(imgdate.substring(6)), Integer.parseInt(imgtime.substring(0, 2)), Integer.parseInt(imgtime.substring(2, 4)), Integer.parseInt(imgtime.substring(4, 6)));
        }
        return dat;
    }

    public int getCenter() {
        return this.DcmImg.getCenter();
    }

    public int getWindow() {
        return this.DcmImg.getWidth();
    }

    public void setSequence(String s) {
        this.ddo.setString(144, s);
    }

    public void setTR(double tr) {
        this.ddo.setString(170, new Double(tr).toString());
    }

    public void setTI(double ti) {
        this.ddo.setString(172, new Double(ti).toString());
    }

    public void setTE(double te) {
        this.ddo.setString(171, new Double(te).toString());
    }

    public void setETL(int etl) {
        this.ddo.setString(181, new Integer(etl).toString());
    }

    public void setESP(double esp) {
    }

    public void setSliceLocation(double sl) {
        this.ddo.setString(467, new Double(sl).toString());
    }

    public void setFA(double fa) {
        this.ddo.setString(303, new Double(fa).toString());
    }

    public void setPatientName(String name) {
        this.ddo.setString(104, name);
    }

    public void setPatientSex(String s) {
        this.ddo.setString(109, s);
    }

    public void setDDO(DcmDataObject d) {
        d.removeObject(1388);
        this.ddo = d;
    }

    public DcmDataObject getDDO() {
        return this.ddo;
    }

    public Image getAWTImage() {
        if (this.img == null) {
            JFrame dummy = new JFrame();
            dummy.getToolkit();
            this.img = Toolkit.getDefaultToolkit().createImage(this.DcmImg.imgSource);
        }
        return this.img;
    }

    public int getGrayValue(int x, int y) {
        short gw = this.DcmImg.pixel16[this.size * y + x];
        return gw;
    }

    public short[][] get8BitImageShort() {
        int[] pixels = new int[this.size * this.size];
        PixelGrabber grabber = new PixelGrabber(this.img, 0, 0, this.size, this.size, pixels, 0, this.size);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        short[][] shortImage = new short[this.size][this.size];
        for (int y = 0; y < this.size; ++y) {
            for (int x = 0; x < this.size; ++x) {
                shortImage[x][y] = (short)(pixels[y * this.size + x] & 0xFF);
            }
        }
        return shortImage;
    }

    public Image getImagePart(int x, int y, int w, int h) {
        int[] pixels = new int[w * h];
        PixelGrabber grabber = new PixelGrabber(this.img, x, y, w, h, pixels, 0, w);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Frame dummy = new Frame();
        dummy.getToolkit();
        Image imagePart = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(w, h, pixels, 0, w));
        return imagePart;
    }

    public void mirrorHor() {
        short[] mirrorImage = new short[this.size * this.size];
        for (int x = 0; x < this.size; ++x) {
            for (int y = 0; y < this.size; ++y) {
                mirrorImage[this.size * y + x] = this.DcmImg.pixel16[this.size * y + (this.size - 1 - x)];
            }
        }
        this.DcmImg.pixel16 = mirrorImage;
        this.updateAWTImage();
        this.fftOK = false;
    }

    public void updateAWTImage() {
        this.DcmImg.updateImageSource();
        Frame dummy = new Frame();
        dummy.getToolkit();
        this.img = Toolkit.getDefaultToolkit().createImage(this.DcmImg.imgSource);
    }

    public void rotate90CW() {
        short[] rotateImage = new short[this.DcmImg.pixel16.length];
        for (int x = 0; x < this.size; ++x) {
            for (int y = 0; y < this.size; ++y) {
                rotateImage[this.size * y + x] = this.DcmImg.pixel16[this.size * (this.size - 1 - x) + y];
            }
        }
        this.DcmImg.pixel16 = rotateImage;
        this.updateAWTImage();
        this.fftOK = false;
    }

    public int getSize() {
        return this.size;
    }

    public void invert() {
        for (int i = 0; i < this.size * this.size; ++i) {
            this.DcmImg.pixel16[i] = (short)(4095 - this.DcmImg.pixel16[i]);
        }
        this.updateAWTImage();
        this.fftOK = false;
    }

    public short[] getImage12BitShort() {
        return this.DcmImg.pixel16;
    }

    public void setCurrentDate() {
        SimpleDateFormat fd = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat ft = new SimpleDateFormat("HHmmss.SSS");
        SimpleDateFormat fs = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        Date cdt = new Date();
        String dateAndTimeSuffix = fs.format(cdt);
        String studyDate = fd.format(cdt);
        String studyTime = ft.format(cdt);
        String dateOfSecondaryCapture = fd.format(cdt);
        String timeOfSecondaryCapture = ft.format(cdt);
        String imageDate = fd.format(cdt);
        String imageTime = ft.format(cdt);
        this.ddo.setString(12, imageDate);
        this.ddo.setString(18, imageTime);
        this.ddo.setString(9, studyDate);
        this.ddo.setString(15, studyDate);
    }

    public void setCW(int c, int w) {
        this.ddo.setString(506, Integer.toString(c));
        this.ddo.setString(507, Integer.toString(w));
        this.DcmImg.setCW(c, w);
        this.updateAWTImage();
    }

    public void setCenter(int c) {
        this.ddo.setString(506, Integer.toString(c));
        this.DcmImg.setCenter(c);
        this.updateAWTImage();
    }

    public void setWindow(int w) {
        this.ddo.setString(507, Integer.toString(w));
        this.DcmImg.setWindow(w);
        this.updateAWTImage();
    }

    public int getMinGrayValue12Bit() {
        short s;
        int n = 999999;
        for (int x = 0; x < this.DcmImg.pixel16.length; ++x) {
            if (this.DcmImg.pixel16[x] >= s) continue;
            s = this.DcmImg.pixel16[x];
        }
        return s;
    }

    public int getMaxGrayValue12Bit() {
        short maxg = 0;
        for (int x = 0; x < this.DcmImg.pixel16.length; ++x) {
            if (this.DcmImg.pixel16[x] <= maxg) continue;
            maxg = this.DcmImg.pixel16[x];
        }
        return maxg;
    }

    public void optimalWindowing() {
        int min = this.getMinGrayValue12Bit();
        int max = this.getMaxGrayValue12Bit();
        int width = max - min;
        int center = min + width / 2;
        this.setCW(center, width);
    }

    private void calcFFT() {
        RealGrayImage rgImg = FFTTools.makeRealGrayImage(this.size, this.size, this.DcmImg.pixel16);
        ComplexImage cImg = FFTTools.forwardFFT(rgImg);
        this.fftImageReal = new float[this.size][this.size];
        this.fftImageImag = new float[this.size][this.size];
        for (int x = 0; x < this.size; ++x) {
            for (int y = 0; y < this.size; ++y) {
                this.fftImageReal[x][y] = cImg.getReal(x, y);
                this.fftImageImag[x][y] = cImg.getImag(x, y);
            }
        }
        this.fftOK = true;
    }

    public float[][] getFFTImageReal() {
        if (this.fftImageReal == null || !this.fftOK) {
            this.calcFFT();
        }
        return this.fftImageReal;
    }

    public float[][] getFFTImageImag() {
        if (this.fftImageImag == null || !this.fftOK) {
            this.calcFFT();
        }
        return this.fftImageImag;
    }
}

