/*
 * Decompiled with CFR 0.152.
 */
package virtual.tools;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import javax.swing.JFrame;

public class Histogramm
extends JFrame {
    private short[][] image;
    private double[] histogram;
    private double maxValue;
    private final int FRAME_WIDTH = 295;
    private final int FRAME_HEIGHT = 150;
    private final double PERCENTAGE = 0.05;
    private Frame parent = null;

    public Histogramm() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Histogramm(Frame p, short[][] img, String title) {
        super(title);
        this.parent = p;
        this.image = img;
        this.computeHistogramm();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void jbInit() throws Exception {
        this.setSize(295, 150);
        if (this.parent != null) {
            this.setLocation(this.parent.getLocationOnScreen().x + this.parent.getSize().width / 2 - this.getSize().width / 2, this.parent.getLocationOnScreen().y + this.parent.getSize().height / 2 - this.getSize().width / 2);
        } else {
            this.setLocation(200, 200);
        }
        this.setResizable(false);
    }

    public void setImage(short[][] i) {
        this.image = i;
    }

    public void computeHistogramm() {
        int total = 0;
        this.histogram = new double[256];
        for (int j = 0; j < this.histogram.length; ++j) {
            this.histogram[j] = 0.0;
        }
        for (int x = 0; x < this.image.length; ++x) {
            for (int y = 0; y < this.image[0].length; ++y) {
                short s = this.image[x][y];
                this.histogram[s] = this.histogram[s] + 1.0;
                ++total;
            }
        }
        this.maxValue = 0.0;
        int sum = 0;
        for (int i = 0; i < this.histogram.length; ++i) {
            sum = (int)((double)sum + this.histogram[i]);
            this.histogram[i] = this.histogram[i] / (double)total;
            if (!(this.histogram[i] < 0.05) || !(this.histogram[i] > this.maxValue)) continue;
            this.maxValue = this.histogram[i];
        }
    }

    public void paint(Graphics g) {
        g.setColor(Color.black);
        g.drawLine(24, 130, 24, 30);
        g.drawLine(24, 130, 280, 130);
        Font myFont = new Font("Arial", 0, 10);
        g.setFont(myFont);
        g.drawString("1", 20, 145);
        g.drawString("128", 145, 145);
        g.drawString("255", 274, 145);
        double yscale = 110.0 / this.maxValue;
        for (int i = 0; i < this.histogram.length; ++i) {
            if (this.histogram[i] > 0.05) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.black);
            }
            g.drawLine(i + 25, 130, i + 25, 130 - (int)(this.histogram[i] * yscale));
        }
    }
}

