/*
 * Decompiled with CFR 0.152.
 */
package virtual.mrt.sequences;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import virtual.mrt.sequences.PulsesequenceUI;
import virtual.mrt.sequences.TurboSpinEcho;
import virtual.tools.ErrorMessage;
import virtual.tools.LabelTFLabelETLPanel;
import virtual.tools.SliderPanel;

public class TurboSpinEchoUI
extends PulsesequenceUI {
    SliderPanel pESPPanel;
    SliderPanel ptrPanel;
    SliderPanel pteffPanel;
    LabelTFLabelETLPanel pETL = new LabelTFLabelETLPanel(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("turbospinecho.etl.title"), "1", "");
    private int ESPTime = 10;
    private int trTime = 1000;
    private int teffTime = 40;
    private int ETL = 3;

    void jbInit() throws Exception {
        this.pETL.setBounds(270, 199, 220, 20);
        this.pETL.setRange(1, 16);
        this.myPanel.add(this.pETL);
        this.pETL.getTextFieldReference().addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                TurboSpinEchoUI.this.updateTotalTime();
            }
        });
        this.ptrPanel = new SliderPanel(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("turbospinecho.tr.title"), 100, 6100, ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("turbospinecho.tr.unit"));
        this.ptrPanel.setBounds(new Rectangle(5, 5, 250, 70));
        this.ptrPanel.setToolTip(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("turbospinecho.tr.tooltip"));
        this.ptrPanel.setTextRange(100, 6100);
        this.ptrPanel.setTickSpacing(2000, 0);
        this.ptrPanel.fillPanel();
        this.ptrPanel.getTextFieldReference().addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                TurboSpinEchoUI.this.updateTotalTime();
            }
        });
        this.myPanel.add(this.ptrPanel);
        this.pESPPanel = new SliderPanel(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("turbospinecho.esp.title"), 2, 102, ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("turbospinecho.esp.unit"));
        this.pESPPanel.setBounds(new Rectangle(5, 78, 250, 70));
        this.pESPPanel.setToolTip(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("turbospinecho.esp.tooltip"));
        this.pESPPanel.setTextRange(2, 102);
        this.pESPPanel.setTickSpacing(20, 0);
        this.pESPPanel.fillPanel();
        this.myPanel.add(this.pESPPanel);
        this.pteffPanel = new SliderPanel(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("turbospinecho.teff.title"), 10, 1010, ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("turbospinecho.teff.unit"));
        this.pteffPanel.setBounds(new Rectangle(5, 151, 250, 70));
        this.pteffPanel.setToolTip(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("turbospinecho.teff.tooltip"));
        this.pteffPanel.setTextRange(10, 1010);
        this.pteffPanel.setTickSpacing(200, 0);
        this.pteffPanel.fillPanel();
        this.myPanel.add(this.pteffPanel);
        this.getValues();
        this.updateTotalTime();
    }

    public void getValues() {
        this.pESPPanel.setValue(this.ESPTime);
        this.ptrPanel.setValue(this.trTime);
        this.pteffPanel.setValue(this.teffTime);
        this.pETL.setValue("" + this.ETL);
    }

    public void setValues() {
        this.ESPTime = this.pESPPanel.getValue();
        this.trTime = this.ptrPanel.getValue();
        this.ETL = this.pETL.getValue();
        this.teffTime = this.pteffPanel.getValue();
    }

    void pbStart_actionPerformed(ActionEvent e) {
        if (this.pETL.getValue() * this.pESPPanel.getValue() >= this.ptrPanel.getValue()) {
            ErrorMessage.showMessage(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("turbospinecho.exception.etltr"));
        } else if (this.pteffPanel.getValue() >= this.ptrPanel.getValue()) {
            ErrorMessage.showMessage(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("turbospinecho.exception.tetr"));
        } else {
            super.pbStart_actionPerformed(e);
            this.sequence = new TurboSpinEcho();
            this.sequence.setUI(this);
            TurboSpinEcho tsesequence = (TurboSpinEcho)this.sequence;
            tsesequence.setTETime(this.pteffPanel.getValue());
            tsesequence.setTRTime(this.ptrPanel.getValue());
            tsesequence.setETL(this.pETL.getValue());
            tsesequence.setESPTime(this.pESPPanel.getValue());
            this.mainFrame.createIntensityImage(this.sequence);
        }
    }

    void pbStop_actionPerformed(ActionEvent e) {
        super.pbStop_actionPerformed(e);
        this.sequence.stop();
    }

    void updateTotalTime() {
        try {
            long totaltime = 256 * this.ptrPanel.getValue() * (this.pRect.getValue() / 8) / this.pETL.getValue();
            totaltime *= (long)this.pNEX.getValue();
            if (this.tbPhOS.isSelected() && this.pNEX.getValue() == 1) {
                totaltime *= 2L;
            }
            this.displayTotalTime(totaltime);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

