/*
 * Decompiled with CFR 0.152.
 */
package virtual.mrt.sequences;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import virtual.mrt.sequences.PulsesequenceUI;
import virtual.mrt.sequences.SpinEcho;
import virtual.tools.ErrorMessage;
import virtual.tools.SliderPanel;

public class SpinEchoUI
extends PulsesequenceUI {
    SliderPanel ptePanel;
    SliderPanel ptrPanel;
    private int teTime = 120;
    private int trTime = 3000;

    void jbInit() throws Exception {
        this.ptrPanel = new SliderPanel(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("spinecho.tr.title"), 100, 6100, ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("spinecho.tr.unit"));
        this.ptrPanel.setBounds(new Rectangle(5, 5, 250, 70));
        this.ptrPanel.setToolTip(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("spinecho.tr.tooltip"));
        this.ptrPanel.setTextRange(100, 6100);
        this.ptrPanel.setTickSpacing(2000, 0);
        this.ptrPanel.fillPanel();
        this.ptrPanel.getTextFieldReference().addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                SpinEchoUI.this.updateTotalTime();
            }
        });
        this.myPanel.add(this.ptrPanel);
        this.ptePanel = new SliderPanel(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("spinecho.te.title"), 10, 1010, ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("spinecho.te.unit"));
        this.ptePanel.setBounds(new Rectangle(5, 78, 250, 70));
        this.ptePanel.setToolTip(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("spinecho.te.tooltip"));
        this.ptePanel.setTextRange(10, 1010);
        this.ptePanel.setTickSpacing(200, 0);
        this.ptePanel.fillPanel();
        this.myPanel.add(this.ptePanel);
        this.getValues();
        this.updateTotalTime();
    }

    public void getValues() {
        this.ptePanel.setValue(this.teTime);
        this.ptrPanel.setValue(this.trTime);
    }

    public void setValues() {
        this.teTime = this.ptePanel.getValue();
        this.trTime = this.ptrPanel.getValue();
    }

    void pbStart_actionPerformed(ActionEvent e) {
        if (this.ptePanel.getValue() < this.ptrPanel.getValue()) {
            super.pbStart_actionPerformed(e);
            this.sequence = new SpinEcho();
            this.sequence.setUI(this);
            SpinEcho sesequence = (SpinEcho)this.sequence;
            sesequence.setTETime(this.ptePanel.getValue());
            sesequence.setTRTime(this.ptrPanel.getValue());
            this.mainFrame.createIntensityImage(this.sequence);
        } else {
            ErrorMessage.showMessage(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("spinecho.exception.tetr"));
        }
    }

    void pbStop_actionPerformed(ActionEvent e) {
        super.pbStop_actionPerformed(e);
        this.sequence.stop();
    }

    void updateTotalTime() {
        try {
            long totaltime = 256 * this.ptrPanel.getValue() * this.pRect.getValue() / 8;
            totaltime *= (long)this.pNEX.getValue();
            if (this.tbPhOS.isSelected() && this.pNEX.getValue() == 1) {
                totaltime *= 2L;
            }
            this.displayTotalTime(totaltime);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

