/*
 * Decompiled with CFR 0.152.
 */
package virtual.mrt.sequences;

import java.util.Random;
import java.util.ResourceBundle;
import javax.swing.JProgressBar;
import virtual.mrt.FileLoader;
import virtual.mrt.VMRTFrame;
import virtual.mrt.artefacts.Artefact;
import virtual.mrt.sequences.PulsesequenceUI;
import virtual.tools.ImagePlus;

public abstract class Pulsesequence
extends Thread {
    protected int[][] T1Matrix;
    protected int[][] T2Matrix;
    protected int[][] PDMatrix;
    protected int[][] IntensityMatrix;
    protected int[][] Result12Bit;
    protected ImagePlus ResultIP;
    protected int iTimeFactor;
    protected VMRTFrame mainFrame;
    protected JProgressBar progressBar;
    protected PulsesequenceUI myUIClass;

    public Pulsesequence() {
        this.setPriority(9);
    }

    public void setMainFrame(VMRTFrame vmrt) {
        this.mainFrame = vmrt;
        this.iTimeFactor = this.mainFrame.getTimeFactor();
        this.progressBar = this.mainFrame.getProgressBar();
    }

    public void run() {
        this.calculate();
        this.addSequenceParameterToImage();
    }

    protected void addSequenceParameterToImage() {
        this.ResultIP.setCurrentDate();
    }

    public void setRawData(FileLoader fl) throws NullPointerException {
        if (fl == null) {
            this.myUIClass.enableStartButton(true);
            this.myUIClass.enableStopButton(false);
            throw new NullPointerException(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequence.exception.nodata"));
        }
        this.T1Matrix = fl.getT1Matrix();
        this.T2Matrix = fl.getT2Matrix();
        this.PDMatrix = fl.getPDMatrix();
        this.IntensityMatrix = new int[this.PDMatrix.length][this.PDMatrix[0].length];
        this.Result12Bit = new int[this.PDMatrix.length][this.PDMatrix[0].length];
    }

    public void calculate() {
        this.checkIntensityMatrix();
        this.filterIntensityMatrix();
        String strArtmethod = this.myUIClass.getArtefactMethod();
        if (strArtmethod != null) {
            this.mainFrame.setStatusBar(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequence.statusbar.note.artefact"));
            Artefact art = this.myUIClass.getArtefact();
            art.setSequence(this);
            art.setIntensityImage(this.IntensityMatrix);
            this.IntensityMatrix = art.calculate(strArtmethod);
        }
        this.addNoise();
        this.simulateFreqAliasing(this.myUIClass.pFOV.getValue());
        this.simulatePhAliasing(this.myUIClass.pFOV.getValue());
        this.scaleFOV();
        this.simulateRectFOV();
        this.progressBar.setValue(0);
        this.mainFrame.setStatusBar(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequence.statusbar.note.finished"));
        this.convertIntensityMatrixTo12Bit();
        this.ResultIP = this.mainFrame.drawCreatedIntensityImage(this);
        this.myUIClass.pbStop.setEnabled(false);
        this.myUIClass.pbStart.setEnabled(true);
        this.myUIClass.displayRemainingTime(0L);
    }

    public void checkIntensityMatrix() {
        for (int x = 0; x < this.IntensityMatrix.length; ++x) {
            for (int y = 0; y < this.IntensityMatrix[0].length; ++y) {
                if (this.IntensityMatrix[x][y] >= 0) continue;
                this.IntensityMatrix[x][y] = 0;
            }
        }
    }

    public void filterIntensityMatrix() {
        for (int x = 1; x < this.IntensityMatrix.length - 1; ++x) {
            for (int y = 1; y < this.IntensityMatrix[0].length - 1; ++y) {
                int medianUmgebung = (this.IntensityMatrix[x - 1][y - 1] + this.IntensityMatrix[x][y - 1] + this.IntensityMatrix[x + 1][y - 1] + this.IntensityMatrix[x - 1][y] + this.IntensityMatrix[x + 1][y] + this.IntensityMatrix[x - 1][y + 1] + this.IntensityMatrix[x][y + 1] + this.IntensityMatrix[x + 1][y + 1]) / 8;
                int diff = medianUmgebung - this.IntensityMatrix[x][y];
                if (diff < 0) {
                    diff *= -1;
                }
                if (diff <= 2 * this.IntensityMatrix[x][y]) continue;
                this.IntensityMatrix[x][y] = medianUmgebung;
            }
        }
    }

    public int[][] getIntensityMatrix() {
        return this.IntensityMatrix;
    }

    public short[] getShort12BitMatrix() {
        short[] shortimg = new short[this.Result12Bit.length * this.Result12Bit[0].length];
        for (int x = 0; x < this.Result12Bit.length; ++x) {
            for (int y = 0; y < this.Result12Bit[0].length; ++y) {
                shortimg[y * this.Result12Bit[0].length + x] = (short)this.Result12Bit[x][y];
            }
        }
        return shortimg;
    }

    public void setUI(PulsesequenceUI ui) {
        this.myUIClass = ui;
    }

    public void convertIntensityMatrixTo12Bit() {
        int y;
        int x;
        int OriginBitNum = (int)Math.pow(2.0, 16.0);
        int ResultBitNum = (int)Math.pow(2.0, 12.0);
        int minPixelValue = 0;
        int maxPixelValue = OriginBitNum;
        int[] histogramm = new int[OriginBitNum];
        int maxint = 0;
        int minint = 999999;
        for (int x2 = 0; x2 < this.IntensityMatrix.length; ++x2) {
            for (int y2 = 0; y2 < this.IntensityMatrix[0].length; ++y2) {
                if (this.IntensityMatrix[x2][y2] > maxint) {
                    maxint = this.IntensityMatrix[x2][y2];
                }
                if (this.IntensityMatrix[x2][y2] >= minint) continue;
                minint = this.IntensityMatrix[x2][y2];
            }
        }
        double histfactor = 1.0;
        int hlp = 0;
        if ((double)maxint > Math.pow(2.0, 16.0) - 1.0) {
            histfactor = Math.pow(2.0, 16.0) / (double)maxint;
            for (x = 0; x < this.IntensityMatrix.length; ++x) {
                for (y = 0; y < this.IntensityMatrix[0].length; ++y) {
                    hlp = (int)((double)this.IntensityMatrix[x][y] * histfactor);
                    if (hlp >= 65536) {
                        hlp = 65535;
                    }
                    this.IntensityMatrix[x][y] = hlp;
                }
            }
        }
        for (x = 0; x < this.IntensityMatrix.length; ++x) {
            for (y = 0; y < this.IntensityMatrix[0].length; ++y) {
                int n = Math.abs(this.IntensityMatrix[x][y]);
                histogramm[n] = histogramm[n] + 1;
            }
        }
        int min = 0;
        int max = histogramm.length - 1;
        int width = max - min;
        int center = (min + max) / 2;
        int minImageValue = center - width / 2;
        int maxImageValue = center + width / 2;
        if (center > maxPixelValue) {
            center = maxPixelValue;
        }
        if (center < minPixelValue) {
            center = minPixelValue;
        }
        if (width > maxPixelValue) {
            width = maxPixelValue;
        }
        if (width < 1) {
            width = 1;
        }
        if (minImageValue < minPixelValue) {
            minImageValue = minPixelValue;
        }
        if (maxImageValue > maxPixelValue) {
            maxImageValue = maxPixelValue;
        }
        double step = (double)ResultBitNum / ((double)maxImageValue - (double)minImageValue + 1.0);
        int value = 0;
        for (x = 0; x < this.IntensityMatrix.length; ++x) {
            for (y = 0; y < this.IntensityMatrix[0].length; ++y) {
                value = this.IntensityMatrix[x][y] - minImageValue;
                if (value < 0) {
                    value = 0;
                }
                if ((value = (int)((double)value * step)) >= ResultBitNum) {
                    value = ResultBitNum - 1;
                }
                this.Result12Bit[x][y] = value;
            }
        }
    }

    public void simulateFreqAliasing(int freqFOV) {
        if (!this.myUIClass.tbFreqOS.isSelected() & freqFOV < 256) {
            int notvisible = 256 - freqFOV;
            int notvisibleDIV2 = notvisible / 2;
            for (int y = 0; y < 256; ++y) {
                for (int x = notvisibleDIV2; x < 256 - notvisibleDIV2; ++x) {
                    int hlpindex1 = x + freqFOV;
                    int hlpindex2 = x - freqFOV;
                    int hlpval1 = 0;
                    int hlpval2 = 0;
                    if (hlpindex1 < 256) {
                        hlpval1 = this.IntensityMatrix[hlpindex1][y];
                    }
                    if (hlpindex2 >= 0) {
                        hlpval2 = this.IntensityMatrix[hlpindex2][y];
                    }
                    this.IntensityMatrix[x][y] = this.IntensityMatrix[x][y] + hlpval1 + hlpval2;
                }
            }
        }
    }

    public void simulatePhAliasing(int phFOV) {
        if (!this.myUIClass.tbPhOS.isSelected() & phFOV < 256) {
            int notvisible = 256 - phFOV;
            int notvisibleDIV2 = notvisible / 2;
            for (int x = 0; x < 256; ++x) {
                for (int y = notvisibleDIV2; y < 256 - notvisibleDIV2; ++y) {
                    int hlpindex1 = y + phFOV;
                    int hlpindex2 = y - phFOV;
                    int hlpval1 = 0;
                    int hlpval2 = 0;
                    if (hlpindex1 < 256) {
                        hlpval1 = this.IntensityMatrix[x][hlpindex1];
                    }
                    if (hlpindex2 >= 0) {
                        hlpval2 = this.IntensityMatrix[x][hlpindex2];
                    }
                    this.IntensityMatrix[x][y] = this.IntensityMatrix[x][y] + hlpval1 + hlpval2;
                }
            }
        }
    }

    public void simulateRectFOV() {
        if (this.myUIClass.pRect.getValue() != 8) {
            int phFOV = this.myUIClass.pFOV.getValue() * this.myUIClass.pRect.getValue() / 8;
            this.simulatePhAliasing(phFOV);
            int notvisible = (256 - phFOV) / 2;
            for (int y = 0; y < 256; ++y) {
                if (!(y < notvisible | y >= phFOV + notvisible)) continue;
                for (int x = 0; x < 256; ++x) {
                    this.IntensityMatrix[x][y] = 0;
                }
            }
        }
    }

    public void addNoise() {
        int y;
        int x;
        double baseNoise = 0.0;
        int coil = this.myUIClass.getCoil();
        Random myRandomizer = new Random();
        double signalNoise = 0.0;
        double sum = 0.0;
        for (x = 0; x < 256; ++x) {
            for (y = 0; y < 256; ++y) {
                sum += (double)this.IntensityMatrix[x][y];
            }
        }
        double meanIntensity = sum / 65536.0;
        signalNoise = 1.0 - this.myUIClass.getSNRatio();
        if (signalNoise < 0.0) {
            signalNoise = 0.0;
        }
        signalNoise *= 0.1;
        for (x = 0; x < 256; ++x) {
            for (y = 0; y < 256; ++y) {
                switch (coil) {
                    case 0: {
                        baseNoise = 0.0;
                        break;
                    }
                    case 1: {
                        baseNoise = meanIntensity * 0.05;
                    }
                }
                int val = this.IntensityMatrix[x][y];
                int bn = (int)(baseNoise * myRandomizer.nextGaussian());
                int sn = (int)((double)val * signalNoise * myRandomizer.nextGaussian());
                int lVal = val + bn + sn;
                if (lVal < 0) {
                    lVal = 0;
                }
                if (lVal > Integer.MAX_VALUE) {
                    lVal = Integer.MAX_VALUE;
                }
                this.IntensityMatrix[x][y] = lVal;
            }
        }
    }

    public void scaleFOV() {
        int[][] resultMatrix = new int[256][256];
        int fov = this.myUIClass.pFOV.getValue();
        int xFOV = (256 - fov) / 2 - 1;
        int yFOV = (256 - fov) / 2 - 1;
        double xScale = 256.0 / (double)fov;
        double yScale = 256.0 / (double)fov;
        for (int y = 0; y < 256; ++y) {
            double ys = (double)y / yScale + (double)yFOV;
            for (int x = 0; x < 256; ++x) {
                double xs = (double)x / xScale + (double)xFOV;
                resultMatrix[x][y] = this.getInterpolatedPixel(xs, ys, this.IntensityMatrix);
            }
        }
        this.IntensityMatrix = resultMatrix;
    }

    private final int getInterpolatedPixel(double x, double y, int[][] pixel) {
        int lowerLeft = 0;
        int xbase = (int)x;
        int ybase = (int)y;
        double xFraction = x - (double)xbase;
        double yFraction = y - (double)ybase;
        try {
            lowerLeft = pixel[xbase][ybase];
            int lowerRight = pixel[xbase + 1][ybase];
            int upperLeft = pixel[xbase][ybase + 1];
            int upperRight = pixel[xbase + 1][ybase + 1];
            double upperAverage = (double)upperLeft + xFraction * (double)(upperRight - upperLeft);
            double lowerAverage = (double)lowerLeft + xFraction * (double)(lowerRight - lowerLeft);
            return (int)(lowerAverage + yFraction * (upperAverage - lowerAverage));
        }
        catch (Exception e) {
            return lowerLeft;
        }
    }
}

