/*
 * Decompiled with CFR 0.152.
 */
package virtual.mrt.sequences;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import virtual.mrt.sequences.InversionRecovery;
import virtual.mrt.sequences.PulsesequenceUI;
import virtual.tools.ErrorMessage;
import virtual.tools.SliderPanel;

public class InversionRecoveryUI
extends PulsesequenceUI {
    private SliderPanel ptrPanel;
    private SliderPanel ptiPanel;
    private int trTime = 1000;
    private int tiTime = 100;

    void jbInit() throws Exception {
        this.ptrPanel = new SliderPanel(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("inversionrecovery.tr.title"), 100, 6100, ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("inversionrecovery.tr.unit"));
        this.ptrPanel.setBounds(new Rectangle(5, 5, 250, 70));
        this.ptrPanel.setToolTip(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("inversionrecovery.tr.tooltip"));
        this.ptrPanel.setTextRange(100, 6100);
        this.ptrPanel.setTickSpacing(2000, 0);
        this.ptrPanel.fillPanel();
        this.myPanel.add(this.ptrPanel);
        this.ptrPanel.getTextFieldReference().addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                InversionRecoveryUI.this.updateTotalTime();
            }
        });
        this.ptiPanel = new SliderPanel(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("inversionrecovery.ti.title"), 10, 6010, ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("inversionrecovery.ti.unit"));
        this.ptiPanel.setBounds(new Rectangle(5, 78, 250, 70));
        this.ptiPanel.setToolTip(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("inversionrecovery.ti.tooltip"));
        this.ptiPanel.setTextRange(11, 6010);
        this.ptiPanel.setTickSpacing(2000, 0);
        this.ptiPanel.fillPanel();
        this.myPanel.add(this.ptiPanel);
        this.getValues();
        this.updateTotalTime();
    }

    public void getValues() {
        this.ptrPanel.setValue(this.trTime);
        this.ptiPanel.setValue(this.tiTime);
    }

    public void setValues() {
        this.trTime = this.ptrPanel.getValue();
        this.tiTime = this.ptiPanel.getValue();
    }

    void pbStart_actionPerformed(ActionEvent e) {
        if (this.ptiPanel.getValue() < this.ptrPanel.getValue()) {
            super.pbStart_actionPerformed(e);
            this.sequence = new InversionRecovery();
            this.sequence.setUI(this);
            InversionRecovery irsequence = (InversionRecovery)this.sequence;
            irsequence.setTITime(this.ptiPanel.getValue());
            irsequence.setTRTime(this.ptrPanel.getValue());
            this.mainFrame.createIntensityImage(this.sequence);
        } else {
            ErrorMessage.showMessage(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("inversionrecovery.exception.titr"));
        }
    }

    void pbStop_actionPerformed(ActionEvent e) {
        super.pbStop_actionPerformed(e);
        this.sequence.stop();
    }

    void updateTotalTime() {
        try {
            long totaltime = 256 * this.ptrPanel.getValue() * this.pRect.getValue() / 8;
            totaltime *= (long)this.pNEX.getValue();
            if (this.tbPhOS.isSelected() && this.pNEX.getValue() == 1) {
                totaltime *= 2L;
            }
            this.displayTotalTime(totaltime);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

