/*
 * Decompiled with CFR 0.152.
 */
package virtual.mrt.artefacts;

import java.util.ResourceBundle;
import jigl.image.ComplexImage;
import jigl.image.RealGrayImage;
import virtual.mrt.artefacts.Artefact;
import virtual.mrt.sequences.Flash;
import virtual.mrt.sequences.GERefocused;
import virtual.mrt.sequences.GESpoiled;
import virtual.mrt.sequences.InversionRecovery;
import virtual.mrt.sequences.SaturationRecovery;
import virtual.mrt.sequences.SpinEcho;
import virtual.mrt.sequences.TurboSpinEcho;
import virtual.tools.FFTTools;

public class PeriodicMotion
extends Artefact {
    private int xAmp;
    private int yAmp;
    private int freq;
    private int startTime;
    private int stopTime;
    private int trTime;
    private final int NUMSTEPS = 16;

    public int[][] calculate(String method) {
        String seqName = this.sequence.getClass().getName();
        if ((seqName = seqName.substring(seqName.lastIndexOf(46) + 1)).compareTo("Flash") == 0) {
            Flash flSequence = (Flash)this.sequence;
            this.trTime = flSequence.getTRTime();
        } else if (seqName.compareTo("GERefocused") == 0) {
            GERefocused gereSequence = (GERefocused)this.sequence;
            this.trTime = gereSequence.getTRTime();
        } else if (seqName.compareTo("GESpoiled") == 0) {
            GESpoiled gespSequence = (GESpoiled)this.sequence;
            this.trTime = gespSequence.getTRTime();
        } else if (seqName.compareTo("InversionRecovery") == 0) {
            InversionRecovery irSequence = (InversionRecovery)this.sequence;
            this.trTime = irSequence.getTRTime();
        } else if (seqName.compareTo("SaturationRecovery") == 0) {
            SaturationRecovery srSequence = (SaturationRecovery)this.sequence;
            this.trTime = srSequence.getTRTime();
        } else if (seqName.compareTo("SpinEcho") == 0) {
            SpinEcho seSequence = (SpinEcho)this.sequence;
            this.trTime = seSequence.getTRTime();
        } else if (seqName.compareTo("TurboSpinEcho") == 0) {
            TurboSpinEcho tseSequence = (TurboSpinEcho)this.sequence;
            this.trTime = tseSequence.getTRTime();
        } else {
            System.out.println(ResourceBundle.getBundle("virtual/mrt/artefacts/resources/artefacts_loc").getString("periodicmotion.warning.sequence.notsupported"));
        }
        int[][] result = null;
        if (method.compareTo("Motion_Std") == 0) {
            result = this.motion_Std();
        } else if (method.compareTo("Motion_TSE") == 0) {
            System.out.println(ResourceBundle.getBundle("virtual/mrt/artefacts/resources/artefacts_loc").getString("periodicmotion.warning.tse.notimplemented"));
        }
        return result;
    }

    public int[][] motion_Std() {
        int[][] res = new int[256][256];
        int dx = 0;
        int dy = 0;
        ComplexImage kSpace = new ComplexImage(256, 256);
        for (int i = 0; i < 16; ++i) {
            this.progressBar.setValue(i * 16);
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {
                // empty catch block
            }
            double t = i * 16 * this.trTime / 1000;
            if (t >= (double)this.stopTime) {
                t = this.stopTime;
            }
            if (t >= (double)this.startTime) {
                int relTime = (int)(t - (double)this.startTime);
                int absTime = 60 / this.freq;
                int absTimeDiv2 = 60 / this.freq / 2;
                if (relTime % absTime < absTimeDiv2) {
                    dx = relTime % absTime * this.xAmp / absTimeDiv2;
                    dy = relTime % absTime * this.yAmp / absTimeDiv2;
                } else {
                    dx = (relTime % absTime - absTimeDiv2) * this.xAmp / absTimeDiv2;
                    dy = (relTime % absTime - absTimeDiv2) * this.yAmp / absTimeDiv2;
                }
            }
            int[][] movedImage = this.move(dx, dy);
            RealGrayImage inComImg = new RealGrayImage(256, 256);
            for (int x = 0; x < 256; ++x) {
                for (int y = 0; y < 256; ++y) {
                    inComImg.set(x, y, movedImage[x][y]);
                }
            }
            ComplexImage transComImg = FFTTools.forwardFFT(inComImg);
            for (int line = i * 16; line < 16 * (i + 1); ++line) {
                for (int x = 0; x < 256; ++x) {
                    kSpace.setImag(x, line, transComImg.getImag(x, line));
                    kSpace.setReal(x, line, transComImg.getReal(x, line));
                }
            }
        }
        ComplexImage invImg = null;
        invImg = FFTTools.reverseFFT(kSpace);
        for (int x = 0; x < 256; ++x) {
            for (int y = 0; y < 256; ++y) {
                res[x][y] = (int)Math.sqrt(Math.pow(invImg.getImag(x, y), 2.0) + Math.pow(invImg.getReal(x, y), 2.0));
            }
        }
        return res;
    }

    public void setXAmplitude(int x) {
        this.xAmp = x;
    }

    public void setYAmplitude(int y) {
        this.yAmp = y;
    }

    public void setFrequency(int f) {
        this.freq = f;
    }

    public void setStartTime(int s) {
        this.startTime = s;
    }

    public void setStopTime(int s) {
        this.stopTime = s;
    }

    private int[][] move(int h, int v) {
        int[][] movedImg = new int[256][256];
        for (int x = 0; x < 256; ++x) {
            for (int y = 0; y < 256; ++y) {
                movedImg[x][y] = x - h > 0 && y - v > 0 ? this.intensityimg[x - h][y - v] : 0;
            }
        }
        return movedImg;
    }
}

