/*
 * Decompiled with CFR 0.152.
 */
package virtual.mrt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import rad.dicom.dcm.DcmDataObject;
import rad.dicom.dcm.DcmOutputStream;
import rad.dicom.ima.ImaUtil;
import rad.dicom.ima.SecondaryCaptureIOD;
import virtual.mrt.ArtefactsCombo;
import virtual.mrt.CaseInfoFrame;
import virtual.mrt.FileLoader;
import virtual.mrt.IDXFile;
import virtual.mrt.MRTPanel;
import virtual.mrt.SequenceCombo;
import virtual.mrt.artefacts.ArtefactUI;
import virtual.mrt.sequences.Pulsesequence;
import virtual.tools.AboutBox;
import virtual.tools.DcmImage;
import virtual.tools.ErrorMessage;
import virtual.tools.Histogramm;
import virtual.tools.ImagePlus;
import virtual.tools.KSpaceFrame;
import virtual.tools.KSpaceManipulator;
import virtual.tools.SliderPanel;

public class VMRTFrame
extends JFrame {
    ResourceBundle frameRsrc = PropertyResourceBundle.getBundle("virtual/mrt/resources/vmrt_frame");
    private final Cursor defaultCursor = new Cursor(0);
    private final Cursor windowCursor = new Cursor(13);
    private JMenuBar menuBar1 = new JMenuBar();
    private JMenu menuFile = new JMenu();
    private JMenuItem menuFileOpen = new JMenuItem();
    private JMenuItem menuFileSave = new JMenuItem();
    private JMenuItem menuFilePrint = new JMenuItem();
    private JMenuItem menuFileExit = new JMenuItem();
    private JMenu menuEdit = new JMenu();
    private JMenuItem menuEditClear = new JMenuItem();
    private JMenuItem menuEditClearAll = new JMenuItem();
    private JMenu menuTools = new JMenu();
    private JMenuItem menuToolsAbout = new JMenuItem();
    private ImageIcon iOpen;
    private ImageIcon iSave;
    private ImageIcon iPrint;
    private ImageIcon i1Image;
    private ImageIcon i4Images;
    private ImageIcon iInfoText;
    private ImageIcon iHistogram;
    private ImageIcon iKSpace;
    private ImageIcon iKSpaceMan;
    private ImageIcon iCaseInfo;
    private ImageIcon iRefIma;
    private ImageIcon iSampleIma;
    private ImageIcon winReset;
    private ImageIcon winOpt;
    private JLabel statusBar = new JLabel();
    private JLabel lPositionText = new JLabel();
    private JLabel lPosition = new JLabel();
    private JProgressBar prbarProgress = new JProgressBar();
    private JLayeredPane flPane = new JLayeredPane();
    public MRTPanel pCanvas = new MRTPanel(this);
    public JScrollBar sbVerScrollbar = new JScrollBar();
    private JPanel pToolbar = new JPanel();
    private JTabbedPane tpMain = new JTabbedPane();
    private JButton pbLoad = new JButton();
    private JButton pbSave = new JButton();
    private JButton pbPrint = new JButton();
    private JButton pbReferenceData = new JButton();
    private JButton pbSampleData = new JButton();
    private JButton pbCaseInfo = new JButton();
    private JPanel tpLayout = new JPanel();
    private JPanel tpWindow = new JPanel();
    private JPanel tpArtefact = new JPanel();
    private JPanel tpExtras = new JPanel();
    public JToggleButton rb1Image = new JToggleButton();
    private JToggleButton rb4Images = new JToggleButton();
    private ButtonGroup bgNumOfImages = new ButtonGroup();
    private JButton pbKSpace = new JButton();
    private JButton pbKSpaceManip = new JButton();
    private JButton pbHistogram = new JButton();
    public JToggleButton tbImageText = new JToggleButton();
    private SliderPanel pCenter;
    private SliderPanel pWindow;
    private JButton pbResetWindowing = new JButton();
    private JButton pbOptWindowing = new JButton();
    private JPanel pArtefacts = new JPanel();
    private ArtefactsCombo cbArtefacts = new ArtefactsCombo(this, this.pArtefacts);
    private SliderPanel pTimeFactor;
    private JPanel pNextImageAt = new JPanel();
    private JLabel lNextImageAt = new JLabel();
    public JRadioButton rbNextImageAtSelection = new JRadioButton();
    private JRadioButton rbNextImageAtFreePlace = new JRadioButton();
    private ButtonGroup bgPlaceNextImage = new ButtonGroup();
    public JCheckBox chbActivateNewImg = new JCheckBox();
    private JLabel lSequence = new JLabel();
    private JPanel pSequence = new JPanel();
    private JPanel pSequenceSettings = new JPanel();
    private SequenceCombo cbSequence = new SequenceCombo(this, this.pSequenceSettings, this.pSequence);
    private int curr_x;
    private int curr_y;
    private int lastMouseClickX;
    private int lastMouseClickY;
    private long lastTime;
    private int lastCenter;
    private int lastWindow;
    private FileLoader myFileLoader = null;
    private boolean unsavedChanges = false;
    private Properties preferences = new Properties();
    private boolean isApplication = true;

    public VMRTFrame() {
        this(true);
    }

    public VMRTFrame(boolean isApplication) {
        this.isApplication = isApplication;
        AboutBox aBox = this.showAboutBox();
        this.enableEvents(64L);
        try {
            this.jbInit();
            this.chbActivateNewImg.setSelected(true);
            ErrorMessage.setMainFrame(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (isApplication) {
            this.loadPreferences();
        } else {
            this.pbLoad.setEnabled(false);
            this.pbSave.setEnabled(false);
            this.menuFileOpen.setEnabled(false);
            this.menuFileSave.setEnabled(false);
        }
        aBox.dispose();
    }

    public static void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AboutBox showAboutBox() {
        AboutBox abox = new AboutBox();
        abox.setFileURL(this.getClass().getResource(this.frameRsrc.getString("vmrt.splash")));
        Dimension aboxSize = abox.getSize();
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        abox.setLocation((scrSize.width - aboxSize.width) / 2, (scrSize.height - aboxSize.height) / 2);
        abox.setVisible(true);
        return abox;
    }

    public void showCentered() {
        this.validate();
        Dimension frameSize = this.getSize();
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((scrSize.width - frameSize.width) / 2, (scrSize.height - frameSize.height) / 2);
        this.setVisible(true);
        this.toFront();
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(null);
        if (System.getSecurityManager() == null) {
            this.setSize(new Dimension(800, 585));
        } else {
            this.setSize(new Dimension(800, 600));
        }
        this.setResizable(false);
        this.setTitle(this.frameRsrc.getString("vmrtframe.title"));
        this.flPane.setLayout(null);
        this.flPane.setSize(this.getSize());
        this.getContentPane().add((Component)this.flPane, null);
        this.iOpen = new ImageIcon(this.getClass().getResource("resources/openfile.gif"));
        this.iSave = new ImageIcon(this.getClass().getResource("resources/save.gif"));
        this.iPrint = new ImageIcon(this.getClass().getResource("resources/print.gif"));
        this.i1Image = new ImageIcon(this.getClass().getResource("resources/1image.gif"));
        this.i4Images = new ImageIcon(this.getClass().getResource("resources/4images.gif"));
        this.iInfoText = new ImageIcon(this.getClass().getResource("resources/imageinfo.gif"));
        this.iHistogram = new ImageIcon(this.getClass().getResource("resources/histogramm.gif"));
        this.iKSpace = new ImageIcon(this.getClass().getResource("resources/k_raum.gif"));
        this.iKSpaceMan = new ImageIcon(this.getClass().getResource("resources/k_raum_man.gif"));
        this.iCaseInfo = new ImageIcon(this.getClass().getResource("resources/caseinfo.gif"));
        this.iRefIma = new ImageIcon(this.getClass().getResource("resources/refima.gif"));
        this.iSampleIma = new ImageIcon(this.getClass().getResource("resources/sampleima.gif"));
        this.winReset = new ImageIcon(this.getClass().getResource("resources/winreset.gif"));
        this.winOpt = new ImageIcon(this.getClass().getResource("resources/winopt.gif"));
        this.menuBar1.add(this.menuFile);
        this.menuBar1.add(this.menuEdit);
        this.menuBar1.add(this.menuTools);
        this.setJMenuBar(this.menuBar1);
        this.menuFile.setText(this.frameRsrc.getString("vmrtframe.menu.file"));
        this.menuFileOpen.setText(this.frameRsrc.getString("vmrtframe.menu.file.open"));
        this.menuFileOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VMRTFrame.this.fileOpen_actionPerformed();
            }
        });
        this.menuFileSave.setText(this.frameRsrc.getString("vmrtframe.menu.file.saveas"));
        this.menuFileSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VMRTFrame.this.fileSave_actionPerformed();
            }
        });
        this.menuFilePrint.setText(this.frameRsrc.getString("vmrtframe.menu.file.print"));
        this.menuFilePrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VMRTFrame.this.filePrint_actionPerformed();
            }
        });
        this.menuFileExit.setText(this.frameRsrc.getString("vmrtframe.menu.file.exit"));
        this.menuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VMRTFrame.this.fileExit_actionPerformed();
            }
        });
        this.menuFile.add(this.menuFileOpen);
        this.menuFile.add(this.menuFileSave);
        this.menuFile.add(this.menuFilePrint);
        this.menuFile.add(this.menuFileExit);
        this.menuEdit.setText(this.frameRsrc.getString("vmrtframe.menu.edit"));
        this.menuEditClear.setText(this.frameRsrc.getString("vmrtframe.menu.edit.delete"));
        this.menuEditClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VMRTFrame.this.editClear_actionPerformed();
            }
        });
        this.menuEditClearAll.setText(this.frameRsrc.getString("vmrtframe.menu.edit.deleteall"));
        this.menuEditClearAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VMRTFrame.this.editClearAll_actionPerformed();
            }
        });
        this.menuEdit.add(this.menuEditClear);
        this.menuEdit.add(this.menuEditClearAll);
        this.menuTools.setText(this.frameRsrc.getString("vmrtframe.menu.tools"));
        this.menuToolsAbout.setText(this.frameRsrc.getString("vmrtframe.menu.tools.about"));
        this.menuToolsAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VMRTFrame.this.helpAbout_actionPerformed();
            }
        });
        this.menuTools.add(this.menuToolsAbout);
        this.pSequenceSettings.setBounds(0, 256, 513, 256);
        this.pSequenceSettings.setBorder(BorderFactory.createEtchedBorder());
        this.pSequenceSettings.setVisible(false);
        this.flPane.add((Component)this.pSequenceSettings, JLayeredPane.DRAG_LAYER);
        this.statusBar.setText(this.frameRsrc.getString("vmrtframe.statusbar.title"));
        this.statusBar.setForeground(Color.black);
        this.statusBar.setFont(new Font("Dialog", 0, 12));
        this.statusBar.setBounds(new Rectangle(1, 516, 512, 15));
        this.flPane.add(this.statusBar);
        this.pCanvas.setMaximumSize(new Dimension(512, 512));
        this.pCanvas.setPreferredSize(new Dimension(512, 512));
        this.pCanvas.setBackground(Color.black);
        this.pCanvas.setMinimumSize(new Dimension(512, 512));
        this.pCanvas.setBounds(new Rectangle(1, 0, 512, 512));
        this.pCanvas.setLayout(null);
        this.flPane.add((Component)this.pCanvas, null);
        this.pCanvas.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent e) {
                VMRTFrame.this.pCanvas_mouseExited(e);
            }

            public void mouseClicked(MouseEvent e) {
                VMRTFrame.this.pCanvas_mouseClicked(e);
            }

            public void mousePressed(MouseEvent e) {
                VMRTFrame.this.pCanvas_mousePressed(e);
            }

            public void mouseReleased(MouseEvent e) {
                VMRTFrame.this.pCanvas_mouseReleased(e);
            }
        });
        this.pCanvas.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                VMRTFrame.this.pCanvas_mouseMoved(e);
            }

            public void mouseDragged(MouseEvent e) {
                VMRTFrame.this.pCanvas_mouseDragged(e);
            }
        });
        this.sbVerScrollbar = this.pCanvas.createVerticalScrollBar();
        this.sbVerScrollbar.setBounds(new Rectangle(513, 1, 20, 512));
        this.sbVerScrollbar.setBorder(BorderFactory.createEtchedBorder());
        this.sbVerScrollbar.setMinimum(0);
        this.sbVerScrollbar.setMaximum(1024);
        this.sbVerScrollbar.setVisibleAmount(511);
        this.sbVerScrollbar.setBlockIncrement(512);
        this.sbVerScrollbar.setUnitIncrement(512);
        this.flPane.add((Component)this.sbVerScrollbar, null);
        this.sbVerScrollbar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                VMRTFrame.this.sbVerScrollbar_adjustmentValueChanged();
            }
        });
        this.pToolbar.setBounds(new Rectangle(535, 0, 255, 514));
        this.pToolbar.setLayout(null);
        this.pToolbar.add((Component)this.tpMain, null);
        this.flPane.add((Component)this.pToolbar, null);
        this.pbReferenceData.setMargin(new Insets(2, 2, 2, 2));
        this.pbReferenceData.setIcon(this.iRefIma);
        this.pbReferenceData.setBounds(new Rectangle(3, 12, 27, 26));
        this.pbReferenceData.setToolTipText(this.frameRsrc.getString("vmrtframe.btn.irefima.tooltip"));
        this.pbReferenceData.setEnabled(true);
        this.pToolbar.add((Component)this.pbReferenceData, null);
        this.pbReferenceData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VMRTFrame.this.pbReferenceData_actionPerformed();
            }
        });
        this.pbSampleData.setMargin(new Insets(2, 2, 2, 2));
        this.pbSampleData.setIcon(this.iSampleIma);
        this.pbSampleData.setBounds(new Rectangle(40, 12, 27, 26));
        this.pbSampleData.setToolTipText(this.frameRsrc.getString("vmrtframe.btn.isampleima.tooltip"));
        this.pbSampleData.setEnabled(true);
        this.pToolbar.add((Component)this.pbSampleData, null);
        this.pbSampleData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VMRTFrame.this.pbSampleData_actionPerformed();
            }
        });
        this.pbLoad.setMargin(new Insets(2, 2, 2, 2));
        this.pbLoad.setIcon(this.iOpen);
        this.pbLoad.setBounds(new Rectangle(77, 12, 27, 26));
        this.pbLoad.setToolTipText(this.frameRsrc.getString("vmrtframe.btn.open.tooltip"));
        this.pToolbar.add((Component)this.pbLoad, null);
        this.pbLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VMRTFrame.this.pbLoad_actionPerformed();
            }
        });
        this.pbSave.setMargin(new Insets(2, 2, 2, 2));
        this.pbSave.setBounds(new Rectangle(114, 12, 27, 26));
        this.pbSave.setToolTipText(this.frameRsrc.getString("vmrtframe.btn.save.tooltip"));
        this.pbSave.setIcon(this.iSave);
        this.pToolbar.add((Component)this.pbSave, null);
        this.pbSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VMRTFrame.this.pbSave_actionPerformed();
            }
        });
        this.pbPrint.setMargin(new Insets(2, 2, 2, 2));
        this.pbPrint.setBounds(new Rectangle(151, 12, 27, 26));
        this.pbPrint.setIcon(this.iPrint);
        this.pbPrint.setToolTipText(this.frameRsrc.getString("vmrtframe.btn.print.tooltip"));
        this.pToolbar.add((Component)this.pbPrint, null);
        this.pbPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VMRTFrame.this.pbPrint_actionPerformed();
            }
        });
        this.tpMain.setBounds(new Rectangle(3, 45, 249, 185));
        this.tpLayout.setLayout(null);
        this.tpMain.add((Component)this.tpLayout, this.frameRsrc.getString("vmrtframe.tab.layout.title"));
        this.rb1Image.setMargin(new Insets(2, 2, 2, 2));
        this.rb1Image.setIcon(this.i1Image);
        this.rb1Image.setSelected(true);
        this.rb1Image.setToolTipText(this.frameRsrc.getString("vmrtframe.btn.1image.tooltip"));
        this.rb1Image.setBounds(new Rectangle(5, 10, 27, 27));
        this.tpLayout.add((Component)this.rb1Image, null);
        this.rb1Image.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VMRTFrame.this.rb1Image_actionPerformed();
            }
        });
        this.rb4Images.setMargin(new Insets(2, 2, 2, 2));
        this.rb4Images.setIcon(this.i4Images);
        this.rb4Images.setToolTipText(this.frameRsrc.getString("vmrtframe.btn.4image.tooltip"));
        this.rb4Images.setBounds(new Rectangle(42, 10, 27, 27));
        this.tpLayout.add((Component)this.rb4Images, null);
        this.rb4Images.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VMRTFrame.this.rb4Images_actionPerformed();
            }
        });
        this.bgNumOfImages.add(this.rb1Image);
        this.bgNumOfImages.add(this.rb4Images);
        this.tbImageText.setIcon(this.iInfoText);
        this.tbImageText.setToolTipText(this.frameRsrc.getString("vmrtframe.btn.infotext.tooltip"));
        this.tbImageText.setBounds(new Rectangle(79, 10, 27, 27));
        this.tpLayout.add((Component)this.tbImageText, null);
        this.tbImageText.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                VMRTFrame.this.tbImageText_mouseClicked();
            }
        });
        this.pbHistogram.setIcon(this.iHistogram);
        this.pbHistogram.setToolTipText(this.frameRsrc.getString("vmrtframe.btn.histogramm.tooltip"));
        this.pbHistogram.setBounds(new Rectangle(116, 10, 27, 27));
        this.tpLayout.add((Component)this.pbHistogram, null);
        this.pbHistogram.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VMRTFrame.this.pbHistogram_actionPerformed();
            }
        });
        this.pbKSpaceManip.setIcon(this.iKSpaceMan);
        this.pbKSpaceManip.setToolTipText(this.frameRsrc.getString("vmrtframe.btn.kspaceman.tooltip"));
        this.pbKSpaceManip.setBounds(new Rectangle(190, 10, 27, 27));
        this.tpLayout.add((Component)this.pbKSpaceManip, null);
        this.pbKSpaceManip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VMRTFrame.this.pbKSpaceManip_actionPerformed();
            }
        });
        this.pbKSpace.setIcon(this.iKSpace);
        this.pbKSpace.setToolTipText(this.frameRsrc.getString("vmrtframe.btn.kspace.tooltip"));
        this.pbKSpace.setBounds(new Rectangle(153, 10, 27, 27));
        this.tpLayout.add((Component)this.pbKSpace, null);
        this.pbKSpace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VMRTFrame.this.pbKSpace_actionPerformed();
            }
        });
        this.pbCaseInfo.setMargin(new Insets(2, 2, 2, 2));
        this.pbCaseInfo.setIcon(this.iCaseInfo);
        this.pbCaseInfo.setBounds(new Rectangle(5, 47, 27, 27));
        this.pbCaseInfo.setToolTipText(this.frameRsrc.getString("vmrtframe.btn.caseinfo.tooltip"));
        this.pbCaseInfo.setEnabled(true);
        this.tpLayout.add((Component)this.pbCaseInfo, null);
        this.pbCaseInfo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VMRTFrame.this.pbCaseInfo_actionPerformed();
            }
        });
        this.tpWindow.setLayout(null);
        this.tpMain.add((Component)this.tpWindow, this.frameRsrc.getString("vmrtframe.tab.window.title"));
        this.pCenter = new SliderPanel(this.frameRsrc.getString("vmrtframe.window.slider.center"), 0, 4096, "");
        this.pCenter.setBounds(new Rectangle(2, 5, 187, 70));
        this.pCenter.setToolTipText(this.frameRsrc.getString("vmrtframe.window.slider.center.tooltip"));
        this.pCenter.setTextRange(0, 4095);
        this.pCenter.setTickSpacing(1024, 0);
        this.pCenter.fillPanel();
        this.pCenter.setSliderMaximum(4095);
        this.tpWindow.add(this.pCenter);
        this.pCenter.setValue(2048);
        this.pCenter.getTextFieldReference().addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                VMRTFrame.this.updateCenter();
                VMRTFrame.this.pCanvas.repaint();
            }
        });
        this.pWindow = new SliderPanel(this.frameRsrc.getString("vmrtframe.window.slider.width"), 0, 4096, "");
        this.pWindow.setBounds(new Rectangle(2, 80, 187, 70));
        this.pWindow.setToolTipText(this.frameRsrc.getString("vmrtframe.window.slider.width.tooltip"));
        this.pWindow.setTextRange(1, 4096);
        this.pWindow.setTickSpacing(1024, 0);
        this.pWindow.fillPanel();
        this.tpWindow.add(this.pWindow);
        this.pWindow.setValue(4096);
        this.pWindow.setSliderMinimum(1);
        this.pWindow.getTextFieldReference().addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                VMRTFrame.this.updateWindow();
                VMRTFrame.this.pCanvas.repaint();
            }
        });
        this.pbOptWindowing.setBounds(203, 81, 27, 27);
        this.pbOptWindowing.setIcon(this.winOpt);
        this.pbOptWindowing.setToolTipText(this.frameRsrc.getString("vmrtframe.window.btn.opt.tooltip"));
        this.tpWindow.add(this.pbOptWindowing);
        this.pbOptWindowing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VMRTFrame.this.pbOptWindowing_actionPerformed();
            }
        });
        this.pbResetWindowing.setBounds(203, 123, 27, 27);
        this.pbResetWindowing.setIcon(this.winReset);
        this.pbResetWindowing.setToolTipText(this.frameRsrc.getString("vmrtframe.window.btn.reset.tooltip"));
        this.tpWindow.add(this.pbResetWindowing);
        this.pbResetWindowing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VMRTFrame.this.pWindow.setValue(4096);
                VMRTFrame.this.pCenter.setValue(2048);
                VMRTFrame.this.updateCW();
                VMRTFrame.this.pCanvas.repaint();
            }
        });
        this.tpArtefact.setLayout(null);
        this.tpMain.add((Component)this.tpArtefact, this.frameRsrc.getString("vmrtframe.tab.artefact.title"));
        this.pArtefacts.setBounds(new Rectangle(1, 32, 258, 122));
        this.pArtefacts.setLayout(null);
        this.cbArtefacts.setBounds(new Rectangle(1, 2, 243, 27));
        this.cbArtefacts.getArtefacts();
        this.tpArtefact.add((Component)this.cbArtefacts, null);
        this.tpArtefact.add((Component)this.pArtefacts, null);
        this.tpExtras.setLayout(null);
        this.tpMain.add((Component)this.tpExtras, this.frameRsrc.getString("vmrtframe.tab.extras.title"));
        this.chbActivateNewImg.setText(this.frameRsrc.getString("vmrtframe.extras.activate"));
        this.chbActivateNewImg.setBounds(5, 5, 240, 25);
        this.tpExtras.add((Component)this.chbActivateNewImg, null);
        this.pNextImageAt.setBounds(2, 30, 240, 45);
        this.pNextImageAt.setLayout(null);
        this.pNextImageAt.setBorder(BorderFactory.createEtchedBorder());
        this.lNextImageAt.setText(this.frameRsrc.getString("vmrtframe.extras.position"));
        this.lNextImageAt.setBounds(7, 0, 240, 20);
        this.pNextImageAt.add(this.lNextImageAt);
        this.rbNextImageAtSelection.setText(this.frameRsrc.getString("vmrtframe.extras.position.selection"));
        this.rbNextImageAtSelection.setBounds(7, 22, 120, 20);
        this.pNextImageAt.add((Component)this.rbNextImageAtSelection, null);
        this.rbNextImageAtFreePlace.setText(this.frameRsrc.getString("vmrtframe.extras.position.freeplace"));
        this.rbNextImageAtFreePlace.setBounds(130, 22, 100, 20);
        this.pNextImageAt.add((Component)this.rbNextImageAtFreePlace, null);
        this.rbNextImageAtFreePlace.setSelected(true);
        this.bgPlaceNextImage.add(this.rbNextImageAtSelection);
        this.bgPlaceNextImage.add(this.rbNextImageAtFreePlace);
        this.tpExtras.add((Component)this.pNextImageAt, null);
        this.pTimeFactor = new SliderPanel(this.frameRsrc.getString("vmrtframe.extras.simulation"), 0, 100, "%");
        this.pTimeFactor.setBounds(2, 95, 240, 60);
        this.pTimeFactor.setTickSpacing(10, 5);
        this.pTimeFactor.setTextRange(0, 100);
        this.pTimeFactor.setToolTipText(this.frameRsrc.getString("vmrtframe.extras.simulation.tooltip"));
        this.pTimeFactor.fillPanel();
        this.tpExtras.add((Component)this.pTimeFactor, null);
        this.cbSequence.setToolTipText(this.frameRsrc.getString("vmrtframe.sequence.tooltip"));
        this.cbSequence.setBounds(new Rectangle(3, 256, 249, 27));
        this.pToolbar.add((Component)this.cbSequence, null);
        this.lSequence.setText(this.frameRsrc.getString("vmrtframe.sequence"));
        this.lSequence.setForeground(Color.black);
        this.lSequence.setBounds(new Rectangle(3, 237, 250, 15));
        this.pToolbar.add((Component)this.lSequence, null);
        this.cbSequence.getSequences();
        this.pSequence.setBorder(BorderFactory.createEtchedBorder());
        this.pSequence.setToolTipText(this.frameRsrc.getString("vmrtframe.sequence.settings.tooltip"));
        this.pSequence.setLayout(null);
        this.pSequence.setBounds(new Rectangle(3, 292, 249, 221));
        this.pToolbar.add((Component)this.pSequence, null);
        this.prbarProgress.setToolTipText(this.frameRsrc.getString("vmrtframe.statusbar.progress"));
        this.prbarProgress.setBounds(new Rectangle(675, 516, 112, 15));
        this.prbarProgress.setMinimum(0);
        this.prbarProgress.setMaximum(255);
        this.prbarProgress.setValue(0);
        this.flPane.add((Component)this.prbarProgress, null);
        this.lPosition.setText("");
        this.lPosition.setForeground(Color.black);
        this.lPosition.setFont(new Font("Dialog", 0, 12));
        this.lPosition.setBounds(new Rectangle(600, 516, 95, 15));
        this.flPane.add((Component)this.lPosition, null);
        this.lPositionText.setText(this.frameRsrc.getString("vmrtframe.statusbar.position"));
        this.lPositionText.setForeground(Color.black);
        this.lPositionText.setFont(new Font("Dialog", 0, 12));
        this.lPositionText.setBounds(new Rectangle(510, 516, 100, 15));
        this.flPane.add((Component)this.lPositionText, null);
    }

    private void editClear_actionPerformed() {
        int response = JOptionPane.showConfirmDialog(null, this.frameRsrc.getString("vmrtframe.dialog.delete1"));
        if (response == 0) {
            this.pCanvas.getImageStack().deletePictureAtPos(this.pCanvas.getActiveImage());
            this.pCanvas.updateScrollbar();
            this.pCanvas.repaint();
            this.setVisible(true);
        }
    }

    private void editClearAll_actionPerformed() {
        int response = JOptionPane.showConfirmDialog(null, this.frameRsrc.getString("vmrtframe.dialog.deleteall"));
        if (response == 0) {
            this.pCanvas.getImageStack().clearImageStack();
            this.pCanvas.updateScrollbar();
            this.pCanvas.repaint();
            this.setVisible(true);
        }
    }

    private void pCanvas_mouseDragged(MouseEvent e) {
        this.pCanvas.setCursor(this.windowCursor);
        long curWhen = e.getWhen();
        int difT = (int)(curWhen - this.lastTime);
        if (difT < 100) {
            return;
        }
        int curX = e.getX();
        int curY = e.getY();
        int difX = curX - this.lastMouseClickX;
        int difY = this.lastMouseClickY - curY;
        if (Math.abs(difX) > 10) {
            difX *= 10;
        }
        if (Math.abs(difY) > 10) {
            difY *= 10;
        }
        if (this.lastCenter + difY < 4096 && this.lastCenter + difY >= 0) {
            this.pCenter.setValue(this.lastCenter + difY);
            this.lastCenter += difY;
        }
        if (this.lastWindow + difX <= 4096 && this.lastWindow + difX > 0) {
            this.pWindow.setValue(this.lastWindow + difX);
            this.lastWindow += difX;
        }
        this.lastMouseClickX = curX;
        this.lastMouseClickY = curY;
        this.lastTime = curWhen;
        this.updateCW();
        this.pCanvas.repaint();
    }

    private void helpAbout_actionPerformed() {
        this.showAboutBox();
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            if (this.isApplication) {
                this.savePreferences();
            }
            this.fileExit_actionPerformed();
        }
    }

    private void updateCW() {
        ImagePlus ip = null;
        ip = this.getSelectedImage();
        if (ip != null) {
            try {
                int c = this.pCenter.getValue();
                int w = this.pWindow.getValue();
                ip.setCW(c, w);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void updateCenter() {
        ImagePlus ip = null;
        ip = this.getSelectedImage();
        if (ip != null) {
            try {
                int c = this.pCenter.getValue();
                ip.setCenter(c);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void updateWindow() {
        ImagePlus ip = null;
        ip = this.getSelectedImage();
        if (ip != null) {
            try {
                int w = this.pWindow.getValue();
                ip.setWindow(w);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setStdDirectory(JFileChooser fd) {
        File myPath = new File(System.getProperty("user.dir"));
        fd.setCurrentDirectory(myPath);
        String pathStr = (String)this.preferences.get("Path");
        if (pathStr != null) {
            myPath = new File(pathStr);
            if (myPath.exists()) {
                fd.setCurrentDirectory(myPath);
            } else {
                Exception e = new Exception(this.frameRsrc.getString("vmrtframe.exception.path"));
                ErrorMessage.showMessage(e);
            }
        }
    }

    private void pbReferenceData_actionPerformed() {
        this.myFileLoader = new FileLoader();
        this.myFileLoader.loadReferenceData();
        this.setTitle(this.myFileLoader.getCaseInfoTitle());
        CaseInfoFrame cif = new CaseInfoFrame();
        cif.setInfo(this.myFileLoader.getCaseInfoURL(), this.myFileLoader.getCaseInfoTitle());
        cif.show();
    }

    private void pbSampleData_actionPerformed() {
        this.myFileLoader = new FileLoader();
        this.myFileLoader.loadSampleData();
        this.setTitle(this.myFileLoader.getCaseInfoTitle());
        CaseInfoFrame cif = new CaseInfoFrame();
        cif.setInfo(this.myFileLoader.getCaseInfoURL(), this.myFileLoader.getCaseInfoTitle());
        cif.show();
    }

    private void pbLoad_actionPerformed() {
        JFileChooser fd = new JFileChooser();
        IDXFile ff = new IDXFile();
        fd.addChoosableFileFilter(ff);
        fd.setFileFilter(ff);
        fd.setDialogTitle(this.frameRsrc.getString("vmrtframe.dialog.open.title"));
        this.setStdDirectory(fd);
        fd.showOpenDialog(this);
        File theFile = fd.getSelectedFile();
        if (theFile == null) {
            return;
        }
        String strFile = fd.getSelectedFile().getName();
        String strDirectory = fd.getSelectedFile().getParent();
        this.preferences.put("Path", strDirectory);
        this.myFileLoader = new FileLoader();
        this.myFileLoader.loadData(strDirectory, strFile);
        this.setTitle(this.myFileLoader.getCaseInfoTitle());
        if (this.myFileLoader.getCaseInfoTitle() != null) {
            CaseInfoFrame cif = new CaseInfoFrame();
            cif.setInfo(this.myFileLoader.getCaseInfoURL(), this.myFileLoader.getCaseInfoTitle());
            cif.show();
        }
    }

    private void pbSave_actionPerformed() {
        JFileChooser fd = new JFileChooser();
        fd.setDialogTitle(this.frameRsrc.getString("vmrtframe.dialog.save.title"));
        this.setStdDirectory(fd);
        fd.showSaveDialog(this);
        String strFile = fd.getSelectedFile().getName();
        String strDirectory = fd.getSelectedFile().getParent();
        ImagePlus currentImage = this.getSelectedImage();
        short[] dcmPixels = currentImage.getImage12BitShort();
        SecondaryCaptureIOD scIOD = new SecondaryCaptureIOD();
        scIOD.setPublicFields(currentImage.getDDO());
        scIOD.set16UBitGrayImage(dcmPixels, 256, 256, 15);
        int[] w = ImaUtil.calcAutomaticCW(dcmPixels, 15, true);
        scIOD.setVOILUTModule(w[0], w[1]);
        try {
            File f = new File(strDirectory + File.separator + strFile);
            DcmDataObject ddo = scIOD.getDDO(1, 16, 128);
            DcmOutputStream.saveDDO(ddo, f);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    private void pbPrint_actionPerformed() {
        PrintJob pj = this.getToolkit().getPrintJob(this, this.frameRsrc.getString("vmrtframe.print.job.title"), null);
        if (pj != null) {
            Graphics gc = pj.getGraphics();
            this.pCanvas.paint(gc);
            gc.dispose();
            pj.end();
        }
    }

    private void pbCaseInfo_actionPerformed() {
        CaseInfoFrame cif = new CaseInfoFrame();
        if (this.myFileLoader == null) {
            return;
        }
        cif.setInfo(this.myFileLoader.getCaseInfoURL(), this.myFileLoader.getCaseInfoTitle());
        cif.show();
    }

    private void pCanvas_mouseMoved(MouseEvent e) {
        int y;
        int x;
        int small = 2;
        this.curr_x = x = e.getX();
        this.curr_y = y = e.getY();
        int img_x = x / 2;
        int img_y = y / 2;
        if (this.rb4Images.isSelected()) {
            small = 1;
            int bildnr = 1 + 2 * (y / 256) + x / 256;
            switch (bildnr) {
                case 1: {
                    break;
                }
                case 2: {
                    x -= 256;
                    break;
                }
                case 3: {
                    y -= 256;
                    break;
                }
                case 4: {
                    x -= 256;
                    y -= 256;
                }
            }
            img_x = x;
            img_y = y;
        }
        this.lPosition.setText(x + " ; " + y);
    }

    private void pCanvas_mouseExited(MouseEvent e) {
        this.lPosition.setText("");
        this.pCanvas.setCursor(this.defaultCursor);
        this.pCanvas.repaint();
    }

    private void rb4Images_actionPerformed() {
        this.pCanvas.setFourImages();
        this.pCanvas.repaint();
    }

    private void rb1Image_actionPerformed() {
        this.pCanvas.setOneImage();
        this.pCanvas.repaint();
    }

    private void pCanvas_mousePressed(MouseEvent e) {
        this.lastMouseClickX = e.getX();
        this.lastMouseClickY = e.getY();
        this.lastCenter = this.pCenter.getValue();
        this.lastWindow = this.pWindow.getValue();
        this.lastTime = e.getWhen();
    }

    private void pCanvas_mouseReleased(MouseEvent e) {
        this.pCanvas.setCursor(this.defaultCursor);
    }

    private void pCanvas_mouseClicked(MouseEvent e) {
        ImagePlus ip = null;
        ip = this.getSelectedImage();
        if (ip != null) {
            ip.setCW(this.pCenter.getValue(), this.pWindow.getValue());
        }
        int actImage = this.getImageMouseIsOn(e.getX(), e.getY());
        this.pCanvas.setActiveImage(actImage);
        ip = this.pCanvas.getImageStack().getPictureAtPos(actImage);
        if (ip != null) {
            this.pWindow.setValue(ip.getWindow());
            this.pCenter.setValue(ip.getCenter());
        }
        this.pCanvas.repaint();
    }

    private void tbImageText_mouseClicked() {
        this.pCanvas.repaint();
    }

    private void fileOpen_actionPerformed() {
        this.pbLoad_actionPerformed();
    }

    private void fileSave_actionPerformed() {
        this.pbSave_actionPerformed();
    }

    private void filePrint_actionPerformed() {
        this.pbPrint_actionPerformed();
    }

    public void fileExit_actionPerformed() {
        if (this.isApplication) {
            System.exit(0);
        } else {
            this.dispose();
        }
    }

    private void pbOptWindowing_actionPerformed() {
        ImagePlus ip = this.getSelectedImage();
        ip.optimalWindowing();
        this.pWindow.setValue(ip.getWindow());
        this.pCenter.setValue(ip.getCenter());
        this.pCanvas.repaint();
    }

    private void pbHistogram_actionPerformed() {
        short[][] myShortImage = null;
        int actImage = this.pCanvas.getActiveImage();
        ImagePlus ip = this.getSelectedImage();
        if (ip != null) {
            myShortImage = ip.get8BitImageShort();
            Histogramm myHist = new Histogramm(this, myShortImage, this.frameRsrc.getString("vmrtframe.dialog.histogram.title") + actImage);
            myHist.setVisible(true);
        }
    }

    private void pbKSpace_actionPerformed() {
        ImagePlus ip = this.getSelectedImage();
        if (ip != null) {
            KSpaceFrame myOrig = new KSpaceFrame(ip);
            myOrig.setVisible(true);
        }
    }

    private void pbKSpaceManip_actionPerformed() {
        ImagePlus ip = this.getSelectedImage();
        KSpaceManipulator manipulator = new KSpaceManipulator(ip, this.pCanvas);
        manipulator.show();
    }

    private void sbVerScrollbar_adjustmentValueChanged() {
        this.pCanvas.repaint();
        this.pCanvas.updateScrollbar();
    }

    private int getImageMouseIsOn(int x, int y) {
        int bildnr;
        if (this.rb4Images.isSelected()) {
            int off = this.sbVerScrollbar.getValue() / 256;
            bildnr = 1 + 2 * (y / 256) + x / 256 + 2 * off;
        } else {
            int off = this.sbVerScrollbar.getValue() / 512;
            bildnr = 1 + off;
        }
        if (x < 0 || x > 512 || y < 0 || y > 512) {
            bildnr = -1;
        }
        return bildnr;
    }

    public void createIntensityImage(Pulsesequence sequence) {
        try {
            sequence.setRawData(this.myFileLoader);
        }
        catch (Exception e) {
            ErrorMessage.showMessage(e);
            return;
        }
        sequence.setMainFrame(this);
        sequence.start();
    }

    public ImagePlus drawCreatedIntensityImage(Pulsesequence sequence) {
        short[] shortIntensityImage = sequence.getShort12BitMatrix();
        DcmImage dcmimg = null;
        try {
            dcmimg = new DcmImage(this.myFileLoader.getDcmDataObject());
            dcmimg.pixel16 = shortIntensityImage;
            dcmimg.updateAWTImage();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        ImagePlus ip = this.pCanvas.createNewImage(dcmimg);
        DcmDataObject mynewddo = new DcmDataObject();
        mynewddo = this.myFileLoader.getDcmDataObject().getCopyOfMe();
        ip.setDDO(mynewddo);
        ip.optimalWindowing();
        ImagePlus selip = this.getSelectedImage();
        this.pWindow.setValue(selip.getWindow());
        this.pCenter.setValue(selip.getCenter());
        ip.setCurrentDate();
        this.pCanvas.repaint();
        return ip;
    }

    public JProgressBar getProgressBar() {
        return this.prbarProgress;
    }

    public int getTimeFactor() {
        return this.pTimeFactor.getValue();
    }

    public ImagePlus getSelectedImage() {
        int actImage = this.pCanvas.getActiveImage();
        ImagePlus ip = null;
        if (actImage >= 0) {
            ip = this.pCanvas.getImageStack().getPictureAtPos(actImage);
        }
        return ip;
    }

    public FileLoader getFileLoader() {
        return this.myFileLoader;
    }

    public void setStatusBar(String txt) {
        this.statusBar.setText(txt);
    }

    public String getStatusText() {
        return this.statusBar.getText();
    }

    public void setProgressBar(int val) {
        this.prbarProgress.setValue(val);
    }

    public ArtefactUI getSelectedArtefactUI() {
        return this.cbArtefacts.getSelectedArtefactUI();
    }

    public void loadPreferences() {
        try {
            this.preferences.load(new FileInputStream("vmrt_preferences.properties"));
        }
        catch (Exception e) {
            System.out.println(this.frameRsrc.getString("vmrtframe.exception.preferences.open"));
            return;
        }
    }

    public void savePreferences() {
        try {
            this.preferences.store(new FileOutputStream("vmrt_preferences.properties"), "");
        }
        catch (Exception e) {
            System.out.println(this.frameRsrc.getString("vmrtframe.exception.preferences.write"));
        }
    }
}

