/*
 * Decompiled with CFR 0.152.
 */
package virtual.mrt;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferUShort;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import rad.dicom.dcm.DcmDataObject;
import rad.dicom.dcm.DcmInputStream;
import rad.dicom.ima.SecondaryCaptureIOD;
import virtual.tools.DcmImage;
import virtual.tools.Tools;

public class FileLoader {
    ResourceBundle frameRsrc = PropertyResourceBundle.getBundle("virtual/mrt/resources/vmrt_frame");
    private final int MATRIX_T1 = 0;
    private final int MATRIX_T2 = 1;
    private final int MATRIX_PD = 2;
    private final int MATRIX_SZ = 3;
    private final int MATRIX_FL = 4;
    private int[][] t1Matrix = new int[256][256];
    private int[][] t2Matrix = new int[256][256];
    private int[][] pdMatrix = new int[256][256];
    private int[][] szMatrix = new int[256][256];
    private int[][] flMatrix = new int[256][256];
    private DcmDataObject ddo = null;
    private String caseInfoTitle = "";
    private URL caseInfoURL = null;
    private boolean isReferenceData = false;

    public int[][] getT1Matrix() {
        return this.t1Matrix;
    }

    public int[][] getT2Matrix() {
        return this.t2Matrix;
    }

    public int[][] getPDMatrix() {
        return this.pdMatrix;
    }

    public int[][] getSZMatrix() {
        return this.szMatrix;
    }

    public int[][] getFLMatrix() {
        return this.flMatrix;
    }

    public DcmDataObject getDcmDataObject() {
        return this.ddo;
    }

    public String getCaseInfoTitle() {
        return this.caseInfoTitle;
    }

    public URL getCaseInfoURL() {
        return this.caseInfoURL;
    }

    public void loadData(String dir, String file) {
        File f;
        FileInputStream fis = null;
        Properties prop = new Properties();
        try {
            fis = new FileInputStream(dir + File.separator + file);
            prop.load(fis);
        }
        catch (Exception e) {
            System.out.println(this.frameRsrc.getString("fileloader.exception.load"));
            return;
        }
        String s = prop.getProperty("name.t1");
        if (s != null) {
            this.loadImage(0, s, dir);
        }
        if ((s = prop.getProperty("name.t2")) != null) {
            this.loadImage(1, s, dir);
        }
        if ((s = prop.getProperty("name.pd")) != null) {
            this.loadImage(2, s, dir);
        }
        if ((s = prop.getProperty("name.fl")) != null) {
            this.loadImage(4, s, dir);
        }
        if ((s = prop.getProperty("name.sz")) != null) {
            this.loadImage(3, s, dir);
        }
        if ((s = prop.getProperty("name.title")) != null) {
            this.caseInfoTitle = s;
        }
        if ((s = prop.getProperty("name.filename")) != null && (f = new File(dir, s)) != null) {
            this.caseInfoURL = Tools.file2URL(f);
        }
    }

    private void loadImage(int type, String filename, String path) {
        File f = new File(path + File.separator + filename);
        this.loadImage(type, f);
    }

    private void loadImage(int type, File f) {
        FileInputStream fis;
        try {
            fis = new FileInputStream(f);
        }
        catch (IOException e) {
            System.out.println(this.frameRsrc.getString("fileloader.exception.load"));
            return;
        }
        byte[] buf = this.readFirst256ByteAndClose(fis);
        if (buf == null) {
            System.out.println(this.frameRsrc.getString("fileloader.exception.load"));
            return;
        }
        try {
            fis = new FileInputStream(f);
        }
        catch (IOException e) {
            System.out.println(this.frameRsrc.getString("fileloader.exception.load"));
            return;
        }
        this.loadImage(buf, type, fis);
    }

    private void loadImage(int type, URL url) {
        InputStream is;
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            System.out.println(this.frameRsrc.getString("fileloader.exception.load"));
            return;
        }
        byte[] buf = this.readFirst256ByteAndClose(is);
        if (buf == null) {
            System.out.println(this.frameRsrc.getString("fileloader.exception.load"));
            return;
        }
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            System.out.println(this.frameRsrc.getString("fileloader.exception.load"));
            return;
        }
        this.loadImage(buf, type, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFirst256ByteAndClose(InputStream is) {
        byte[] buf = new byte[256];
        try {
            is.read(buf);
        }
        catch (Exception e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
        return buf;
    }

    private void loadImage(byte[] buf, int type, InputStream is) {
        if (buf[0] == 77 && buf[1] == 77 || buf[0] == 73 && buf[1] == 73) {
            this.loadTiffImage(type, is);
        } else {
            this.loadDcmImage(type, is);
        }
        for (int x = 0; x < 256; ++x) {
            int y = 0;
            while (y < 256) {
                int[] nArray = this.pdMatrix[x];
                int n = y++;
                nArray[n] = nArray[n] * 25;
            }
        }
    }

    private void loadTiffImage(int type, InputStream is) {
        DcmDataObject tmpddo;
        BufferedImage bi = null;
        ImageReader reader = null;
        Iterator<ImageReader> iter = null;
        iter = ImageIO.getImageReadersByFormatName("TIFF");
        if (iter == null) {
            System.out.println(this.frameRsrc.getString("fileloader.exception.load"));
            return;
        }
        reader = iter.next();
        if (reader == null) {
            System.out.println(this.frameRsrc.getString("fileloader.exception.load"));
            return;
        }
        reader.setInput(new MemoryCacheImageInputStream(is));
        try {
            try {
                bi = reader.read(0);
            }
            catch (IOException e) {
                System.out.println(this.frameRsrc.getString("fileloader.exception.load"));
                return;
            }
        }
        catch (Exception e) {
            System.out.println(this.frameRsrc.getString("fileloader.exeption.tiffcodec"));
            return;
        }
        if (bi.getType() != 11) {
            System.out.println(this.frameRsrc.getString("fileloader.exception.load"));
            return;
        }
        DataBuffer buf = bi.getData().getDataBuffer();
        if (!(buf instanceof DataBufferUShort)) {
            System.out.println(this.frameRsrc.getString("fileloader.exception.load"));
            return;
        }
        if (buf.getNumBanks() != 1) {
            System.out.println(this.frameRsrc.getString("fileloader.exception.load"));
            return;
        }
        if (bi.getWidth() != 256 || bi.getHeight() != 256) {
            System.out.println(this.frameRsrc.getString("fileloader.exception.load"));
            return;
        }
        switch (type) {
            case 0: {
                int y;
                int x;
                this.t1Matrix = new int[256][256];
                for (x = 0; x < 256; ++x) {
                    for (y = 0; y < 256; ++y) {
                        this.t1Matrix[x][y] = buf.getElem(y * 256 + x);
                    }
                }
                break;
            }
            case 1: {
                int y;
                int x;
                this.t2Matrix = new int[256][256];
                for (x = 0; x < 256; ++x) {
                    for (y = 0; y < 256; ++y) {
                        this.t2Matrix[x][y] = buf.getElem(y * 256 + x);
                    }
                }
                break;
            }
            case 3: {
                int y;
                int x;
                this.szMatrix = new int[256][256];
                for (x = 0; x < 256; ++x) {
                    for (y = 0; y < 256; ++y) {
                        this.szMatrix[x][y] = buf.getElem(y * 256 + x);
                    }
                }
                break;
            }
            case 4: {
                int y;
                int x;
                this.flMatrix = new int[256][256];
                for (x = 0; x < 256; ++x) {
                    for (y = 0; y < 256; ++y) {
                        this.flMatrix[x][y] = buf.getElem(y * 256 + x);
                    }
                }
                break;
            }
            case 2: {
                int y;
                int x;
                this.pdMatrix = new int[256][256];
                for (x = 0; x < 256; ++x) {
                    for (y = 0; y < 256; ++y) {
                        this.pdMatrix[x][y] = buf.getElem(y * 256 + x);
                    }
                }
                break;
            }
        }
        SecondaryCaptureIOD scIOD = new SecondaryCaptureIOD();
        short[] tmpPixels = new short[65536];
        scIOD.set16UBitGrayImage(tmpPixels, 256, 256, 15);
        this.ddo = tmpddo = scIOD.getDDO(1, 16, 128);
    }

    private void loadDcmImage(int type, InputStream is) {
        DcmImage di = null;
        DcmDataObject sddo = null;
        try {
            sddo = DcmInputStream.loadDDO(is);
            di = new DcmImage(sddo);
        }
        catch (Exception err) {
            System.out.println(this.frameRsrc.getString("fileloader.exception.load"));
        }
        try {
            is.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        switch (type) {
            case 0: {
                this.t1Matrix = new int[256][256];
                if (di == null) break;
                for (int x = 0; x < 256; ++x) {
                    for (int y = 0; y < 256; ++y) {
                        this.t1Matrix[x][y] = di.pixel16[y * 256 + x];
                    }
                }
                break;
            }
            case 1: {
                this.t2Matrix = new int[256][256];
                if (di == null) break;
                for (int x = 0; x < 256; ++x) {
                    for (int y = 0; y < 256; ++y) {
                        this.t2Matrix[x][y] = di.pixel16[y * 256 + x];
                    }
                }
                break;
            }
            case 3: {
                this.szMatrix = new int[256][256];
                if (di == null) break;
                for (int x = 0; x < 256; ++x) {
                    for (int y = 0; y < 256; ++y) {
                        this.szMatrix[x][y] = di.pixel16[y * 256 + x];
                    }
                }
                break;
            }
            case 4: {
                this.flMatrix = new int[256][256];
                if (di == null) break;
                for (int x = 0; x < 256; ++x) {
                    for (int y = 0; y < 256; ++y) {
                        this.flMatrix[x][y] = di.pixel16[y * 256 + x];
                    }
                }
                break;
            }
            case 2: {
                this.pdMatrix = new int[256][256];
                if (di == null) break;
                for (int x = 0; x < 256; ++x) {
                    for (int y = 0; y < 256; ++y) {
                        this.pdMatrix[x][y] = di.pixel16[y * 256 + x];
                    }
                }
                this.ddo = sddo;
            }
        }
    }

    public void loadSampleData() {
        this.caseInfoTitle = this.frameRsrc.getString("fileloader.sampledata.title");
        this.caseInfoURL = this.getClass().getResource(this.frameRsrc.getString("fileloader.sampledata.filename"));
        this.loadImage(0, this.getClass().getResource(this.frameRsrc.getString("fileloader.sampledata.t1")));
        this.loadImage(1, this.getClass().getResource(this.frameRsrc.getString("fileloader.sampledata.t2")));
        this.loadImage(2, this.getClass().getResource(this.frameRsrc.getString("fileloader.sampledata.pd")));
    }

    public void loadReferenceData() {
        DcmDataObject tmpddo;
        this.isReferenceData = true;
        this.caseInfoTitle = this.frameRsrc.getString("fileloader.refdata.title");
        this.caseInfoURL = this.getClass().getResource(this.frameRsrc.getString("fileloader.refdata.filename"));
        this.t1Matrix = new int[256][256];
        this.pdMatrix = new int[256][256];
        this.t2Matrix = new int[256][256];
        short[] tmpPixels = new short[65536];
        SecondaryCaptureIOD scIOD = new SecondaryCaptureIOD();
        scIOD.set16UBitGrayImage(tmpPixels, 256, 256, 15);
        this.ddo = tmpddo = scIOD.getDDO(1, 16, 128);
        tmpPixels = null;
        this.drawRelaxRect(16, 16, 32, 32, 280, 50, 80);
        this.drawRelaxRect(80, 16, 32, 32, 460, 106, 86);
        this.drawRelaxRect(144, 16, 32, 32, 510, 67, 54);
        this.drawRelaxRect(208, 16, 32, 32, 760, 77, 62);
        this.drawRelaxRect(16, 80, 32, 32, 900, 126, 77);
        this.drawRelaxRect(80, 80, 32, 32, 1080, 215, 100);
        this.drawRelaxRect(144, 80, 32, 32, 2650, 280, 89);
        this.drawRelaxRect(208, 80, 32, 32, 4000, 4000, 100);
        this.drawRelaxRect(16, 144, 96, 96, 280, 50, 80);
        this.drawRelaxRect(63, 144, 3, 96, 0, 0, 0);
        this.drawRelaxRect(16, 191, 96, 3, 0, 0, 0);
        this.drawRelaxRect(144, 144, 96, 96, 4000, 4000, 100);
        this.drawRelaxRect(191, 191, 3, 3, 0, 0, 0);
    }

    private void drawRelaxRect(int x, int y, int b, int h, int t1, int t2, int pd) {
        if (pd > 100) {
            pd = 100;
        }
        for (int ix = x; ix < x + b; ++ix) {
            for (int iy = y; iy < y + h; ++iy) {
                this.t1Matrix[ix][iy] = t1;
                this.t2Matrix[ix][iy] = t2;
                this.pdMatrix[ix][iy] = 65530 * pd / 100;
            }
        }
    }
}

