/*
 * Decompiled with CFR 0.152.
 */
package jigl.image;

import jigl.image.InvalidKernelException;
import jigl.image.RealGrayImage;

public class ImageKernel
extends RealGrayImage {
    public final int UNIFORM = 0;
    public final int SOBEL_X = 1;
    public final int SOBEL_Y = 2;
    public final int PREWITT_X = 3;
    public final int PREWITT_Y = 4;
    public final int LAPLACIAN = 5;
    public final int LAPLACIAN_8 = 6;
    public final int UNSHARP = 7;
    public final int UNSHARP_8 = 8;

    public ImageKernel(int val) throws InvalidKernelException {
        super(3, 3);
        Object data2 = null;
        switch (val) {
            case 0: {
                float[][] data1 = new float[][]{{1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 1.0f}};
                data2 = data1;
                break;
            }
            case 1: {
                float[][] data1 = new float[][]{{-1.0f, 0.0f, 1.0f}, {-2.0f, 0.0f, 2.0f}, {-1.0f, 0.0f, 1.0f}};
                data2 = data1;
                break;
            }
            case 2: {
                float[][] data1 = new float[][]{{-1.0f, -2.0f, -1.0f}, {0.0f, 0.0f, 0.0f}, {1.0f, 2.0f, 1.0f}};
                data2 = data1;
                break;
            }
            case 3: {
                float[][] data1 = new float[][]{{-1.0f, 0.0f, 1.0f}, {-1.0f, 0.0f, 1.0f}, {-1.0f, 0.0f, 1.0f}};
                data2 = data1;
                break;
            }
            case 4: {
                float[][] data1 = new float[][]{{-1.0f, -1.0f, -1.0f}, {0.0f, 0.0f, 0.0f}, {1.0f, 1.0f, 1.0f}};
                data2 = data1;
                break;
            }
            case 5: {
                float[][] data1 = new float[][]{{0.0f, 1.0f, 0.0f}, {1.0f, -4.0f, 1.0f}, {0.0f, 1.0f, 0.0f}};
                data2 = data1;
                break;
            }
            case 6: {
                float[][] data1 = new float[][]{{1.0f, 1.0f, 1.0f}, {1.0f, -8.0f, 1.0f}, {1.0f, 1.0f, 1.0f}};
                data2 = data1;
                break;
            }
            case 7: {
                float[][] data1 = new float[][]{{0.0f, -1.0f, 0.0f}, {-1.0f, 5.0f, -1.0f}, {0.0f, -1.0f, 0.0f}};
                data2 = data1;
                break;
            }
            case 8: {
                float[][] data1 = new float[][]{{-1.0f, -1.0f, -1.0f}, {-1.0f, 9.0f, -1.0f}, {-1.0f, -1.0f, -1.0f}};
                data2 = data1;
                break;
            }
            case 9: {
                float[][] data1 = new float[][]{{0.0f, 0.0f, 0.0f}, {1.0f, 1.0f, 0.0f}, {0.0f, 1.0f, 0.0f}};
                data2 = data1;
                break;
            }
            default: {
                throw new InvalidKernelException();
            }
        }
        this.data = data2;
    }

    public ImageKernel(float val, int dimension) {
        super(dimension, dimension);
        for (int x = 0; x < dimension; ++x) {
            for (int y = 0; y < dimension; ++y) {
                this.data[x][y] = val;
            }
        }
    }

    public ImageKernel(float[][] dat) {
        super(dat.length, dat.length);
        this.data = dat;
    }

    public ImageKernel(RealGrayImage img) {
        super(img);
    }

    public void normalize() {
        for (int x = 0; x < this.X; ++x) {
            for (int y = 0; y < this.Y; ++y) {
                this.data[y][x] = this.data[y][x] / 255.0f;
            }
        }
    }
}

