/*
 * Decompiled with CFR 0.152.
 */
package rad.ijplugin.dcm;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import rad.dicom.dcm.DcmDataObject;
import rad.dicom.dcm.DcmValue;
import rad.ijplugin.dcm.GridBagConstraints2;
import rad.ijplugin.util.Util;

public class DumpPanel
extends JPanel {
    private File outputDir;
    JTabbedPane tabbedPane = new JTabbedPane();
    JScrollPane overviewJScrollPane = new JScrollPane();
    JScrollPane detailsJScrollPane = new JScrollPane();
    JTextArea overviewText = new JTextArea();
    JButton saveBtn = new JButton();
    JTextArea detailsText = new JTextArea();
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public DumpPanel(File outD) {
        this.outputDir = outD;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void processDcmDataObject(DcmDataObject orgDDO) throws Exception {
        this.processDcmDataObject(null, orgDDO);
    }

    /*
     * WARNING - void declaration
     */
    public void processDcmDataObject(DcmDataObject metaDDO, DcmDataObject orgDDO) throws Exception {
        DcmValue vr;
        String ovStr = "";
        String trStr = "";
        String deStr = "";
        DcmDataObject ddo = new DcmDataObject();
        if (orgDDO == null) {
            throw new Exception("processDICOMDataObject: Not a DICOM Data Object");
        }
        ddo = orgDDO.getCopyOfMe();
        while ((vr = ddo.pop()) != null) {
            void var11_8;
            int dd_type = var11_8.getType();
            if (dd_type == 0) continue;
            ovStr = ovStr + var11_8.toString(true, 28, false, 256, true) + "\n";
        }
        trStr = orgDDO.getEncoding() == 1 ? trStr + "LITTLE_ENDIAN\n" : trStr + "BIG_ENDIAN\n";
        trStr = orgDDO.getStructure() == 16 ? trStr + "EXPLICITE_VR\n" : trStr + "IMPLICITE_VR\n";
        if (orgDDO.getStorage() == 128) {
            trStr = trStr + "META_STORAGE\n";
            if (metaDDO != null) {
                trStr = trStr + "\nFile Meta Information:\n" + metaDDO.getCopyOfMe().toString() + "\nDICM\n";
            }
        } else {
            trStr = trStr + "PLAIN_STORAGE\n";
        }
        trStr = trStr + "\n";
        this.overviewText.setText(ovStr);
        this.detailsText.setText(trStr + orgDDO.toString());
    }

    public String getOverviewText() {
        return this.overviewText.getText();
    }

    public String getDetailsText() {
        return this.detailsText.getText();
    }

    public void save() throws Exception {
        String fName;
        String theText;
        Component c = this.tabbedPane.getSelectedComponent();
        if (c == this.overviewJScrollPane) {
            theText = this.getOverviewText();
            fName = "DICOM_Dump_Overview.txt";
        } else {
            theText = this.getDetailsText();
            fName = "DICOM_Dump_Details.txt";
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Save Dump...");
        if (this.outputDir != null) {
            chooser.setCurrentDirectory(this.outputDir);
        }
        chooser.setSelectedFile(new File(fName));
        chooser.showSaveDialog(this);
        File f = chooser.getSelectedFile();
        if (f == null) {
            return;
        }
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(f));
            out.writeBytes(theText);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new Exception("DumpPanel.save: Can't write output-file");
        }
    }

    void saveBtn_actionPerformed(ActionEvent e) {
        try {
            this.save();
        }
        catch (Exception err) {
            Util.showErrorDialog(err.getMessage());
        }
    }

    void jbInit() throws Exception {
        this.setMinimumSize(new Dimension(620, 450));
        this.setPreferredSize(new Dimension(620, 450));
        this.saveBtn.setText("Save as Text");
        this.saveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DumpPanel.this.saveBtn_actionPerformed(e);
            }
        });
        this.setLayout(this.gridBagLayout1);
        this.overviewJScrollPane.getViewport();
        this.overviewText.setFont(new Font("Monospaced", 0, 12));
        this.detailsText.setFont(new Font("Monospaced", 0, 12));
        this.overviewJScrollPane.getViewport().add((Component)this.overviewText, null);
        this.detailsJScrollPane.getViewport().add((Component)this.detailsText, null);
        this.tabbedPane.addTab("Overview", this.overviewJScrollPane);
        this.tabbedPane.addTab("Details", this.detailsJScrollPane);
        this.add((Component)this.tabbedPane, new GridBagConstraints2(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 391, 221));
        this.add((Component)this.saveBtn, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
    }
}

