/*
 * Decompiled with CFR 0.152.
 */
package rad.dicom.ima;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.text.SimpleDateFormat;
import java.util.Date;
import rad.dicom.dcm.DcmDDE;
import rad.dicom.dcm.DcmDataObject;
import rad.dicom.dcm.DcmValue;

public class SecondaryCaptureIOD {
    public String patientName = "Patient Name";
    public String patientID = "Patient ID";
    public String patientBirthDate = "19991231";
    public String patientSex = "O";
    public String referringPhysicianName = "";
    public String studyID = "ST000001";
    public String accessionNumber = "";
    public String seriesNumber = "1";
    public String imageNumber = "1";
    public String lrPatientOrientation = "";
    public String tbPatientOrientation = "";
    private String studyInstanceUID = "1.2.3.4711.1.0";
    private String studyDate = "19991231";
    private String studyTime = "235959.123";
    private final String modality = "OT";
    private String seriesInstanceUID = "1.2.3.4711.2.0";
    private String imageDate = "19991231";
    private String imageTime = "235959.123";
    private final String imageType = "DERIVED\\SECONDARY";
    private final String conversionType = "WSD";
    private final String secondaryCaptureDeviceID = "IMAGEJ";
    private final String secondaryCaptureDeviceSoftwareVersion = "1.0";
    private String dateOfSecondaryCapture = "19991231";
    private String timeOfSecondaryCapture = "235959.123";
    private boolean includeVOILUTModule = false;
    private String windowCenter = "0";
    private String windowWidth = "1";
    private final String sopClassUID = "1.2.840.10008.5.1.4.1.1.7";
    private String sopInstanceUID = "1.2.3.4711.3.0";
    private int samplesPerPixel = 1;
    private String photometricInterpretation = "MONOCHROME2";
    private int rows = 1;
    private int columns = 1;
    private int bitsAllocated = 16;
    private int bitsStored = 12;
    private int highBit = 11;
    private int pixelRepresentation = 0;
    private byte[] pixelData = new byte[2];
    private final String pixelAspectRatio = "1\\1";
    private boolean includeLUTModule = false;
    private byte[] redPaletteColorLookupTableDescriptor = new byte[0];
    private byte[] greenPaletteColorLookupTableDescriptor = new byte[0];
    private byte[] bluePaletteColorLookupTableDescriptor = new byte[0];
    private byte[] redPaletteColorLookupTableData = new byte[0];
    private byte[] greenPaletteColorLookupTableData = new byte[0];
    private byte[] bluePaletteColorLookupTableData = new byte[0];
    private DcmDataObject ddo = null;
    private static String dateAndTimeSuffix;
    public String orgRootUID = "1.2.3.4711";

    public DcmDataObject getDDO(int enc, int str, int sto) {
        this.ddo = new DcmDataObject(enc, str, sto);
        this.setTimeAndDateData();
        this.addInformationEntities();
        return this.ddo;
    }

    public void setPublicFields(DcmDataObject ddo) {
        this.patientName = ddo.getString(104);
        this.patientID = ddo.getString(105);
        this.patientBirthDate = ddo.getString(107);
        this.patientSex = ddo.getString(109);
        this.referringPhysicianName = ddo.getString(34);
        this.studyID = ddo.getString(441);
        this.accessionNumber = ddo.getString(22);
        this.seriesNumber = ddo.getString(442);
        this.imageNumber = ddo.getString(444);
        String[] sa = DcmValue.str2StringArray(ddo.getString(451), "\\");
        if (sa.length > 0) {
            this.lrPatientOrientation = sa[0].trim();
        }
        if (sa.length > 1) {
            this.tbPatientOrientation = sa[1].trim();
        }
    }

    private void setTimeAndDateData() {
        SimpleDateFormat fd = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat ft = new SimpleDateFormat("HHmmss.SSS");
        SimpleDateFormat fs = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        Date cdt = new Date();
        dateAndTimeSuffix = fs.format(cdt);
        this.studyDate = fd.format(cdt);
        this.studyTime = ft.format(cdt);
        this.dateOfSecondaryCapture = fd.format(cdt);
        this.timeOfSecondaryCapture = ft.format(cdt);
        this.imageDate = fd.format(cdt);
        this.imageTime = ft.format(cdt);
    }

    public void setVOILUTModule(int wCenter, int wWidth) {
        this.windowCenter = Integer.toString(wCenter);
        this.windowWidth = Integer.toString(wWidth);
        this.includeVOILUTModule = true;
    }

    private void addInformationEntities() {
        this.addPatientIE();
        this.addStudyIE();
        this.addSeriesIE();
        this.addGeneralImageIE();
        this.addImagePixelIE();
        this.addSCEquipmentIE();
        this.addSCImageIE();
        this.addSOPCommon();
        if (this.includeLUTModule) {
            this.addLUTModule();
        }
        if (this.includeVOILUTModule) {
            this.addVOILUTModule();
        }
    }

    private void addPatientIE() {
        this.ddo.setString(104, this.patientName);
        this.ddo.setString(105, this.patientID);
        this.ddo.setString(107, this.patientBirthDate);
        this.ddo.setString(109, this.patientSex);
    }

    private void addStudyIE() {
        this.ddo.setString(439, this.orgRootUID + ".1" + "." + dateAndTimeSuffix);
        this.ddo.setString(9, this.studyDate);
        this.ddo.setString(15, this.studyTime);
        this.ddo.setString(34, this.referringPhysicianName);
        this.ddo.setString(441, this.studyID);
        this.ddo.setString(22, this.accessionNumber);
    }

    private void addSeriesIE() {
        this.ddo.setString(26, "OT");
        this.ddo.setString(440, this.orgRootUID + ".2" + "." + dateAndTimeSuffix);
        this.ddo.setString(442, this.seriesNumber);
    }

    private void addSCEquipmentIE() {
        this.ddo.setString(28, "WSD");
        this.ddo.setString(187, "IMAGEJ");
        this.ddo.setString(194, "1.0");
    }

    private void addGeneralImageIE() {
        this.ddo.setString(444, this.imageNumber);
        this.ddo.setString(451, this.lrPatientOrientation + "\\" + this.tbPatientOrientation);
        this.ddo.setString(12, this.imageDate);
        this.ddo.setString(18, this.imageTime);
        this.ddo.setString(3, "DERIVED\\SECONDARY");
    }

    private void addImagePixelIE() {
        this.ddo.setUS(477, this.samplesPerPixel);
        this.ddo.setString(478, this.photometricInterpretation);
        this.ddo.setUS(482, this.rows);
        this.ddo.setUS(483, this.columns);
        this.ddo.setUS(491, this.bitsAllocated);
        this.ddo.setUS(492, this.bitsStored);
        this.ddo.setUS(493, this.highBit);
        this.ddo.setUS(494, this.pixelRepresentation);
        DcmValue dv = new DcmValue(1388, this.pixelData);
        if (this.bitsAllocated <= 8) {
            dv.setVR(13);
        } else {
            dv.setVR(14);
        }
        this.ddo.push(dv);
        this.ddo.setString(489, "1\\1");
    }

    private void addSCImageIE() {
        this.ddo.setString(189, this.dateOfSecondaryCapture);
        this.ddo.setString(190, this.timeOfSecondaryCapture);
    }

    private void addSOPCommon() {
        this.ddo.setString(7, "1.2.840.10008.5.1.4.1.1.7");
        this.ddo.setString(8, this.orgRootUID + ".3" + "." + dateAndTimeSuffix);
    }

    private void addVOILUTModule() {
        this.ddo.setString(506, this.windowCenter.trim());
        this.ddo.setString(507, this.windowWidth.trim());
    }

    private void addLUTModule() {
        this.ddo.push(new DcmValue(DcmDDE.getDictGroup(513), DcmDDE.getDictElement(513), this.redPaletteColorLookupTableDescriptor));
        this.ddo.push(new DcmValue(DcmDDE.getDictGroup(514), DcmDDE.getDictElement(514), this.greenPaletteColorLookupTableDescriptor));
        this.ddo.push(new DcmValue(DcmDDE.getDictGroup(515), DcmDDE.getDictElement(515), this.bluePaletteColorLookupTableDescriptor));
        this.ddo.push(new DcmValue(DcmDDE.getDictGroup(517), DcmDDE.getDictElement(517), this.redPaletteColorLookupTableData));
        this.ddo.push(new DcmValue(DcmDDE.getDictGroup(518), DcmDDE.getDictElement(518), this.greenPaletteColorLookupTableData));
        this.ddo.push(new DcmValue(DcmDDE.getDictGroup(519), DcmDDE.getDictElement(519), this.bluePaletteColorLookupTableData));
    }

    public void set8BitGrayImage(byte[] pixel8, int nRows, int nColumns) {
        this.samplesPerPixel = 1;
        this.photometricInterpretation = "MONOCHROME2";
        this.rows = nRows;
        this.columns = nColumns;
        this.bitsAllocated = 8;
        this.bitsStored = 8;
        this.highBit = 7;
        this.pixelRepresentation = 0;
        this.pixelData = new byte[pixel8.length];
        int i = 0;
        while (i < pixel8.length) {
            this.pixelData[i] = pixel8[i];
            ++i;
        }
    }

    public void set8BitColorImage(byte[] pixel8, int nRows, int nColumns, ColorModel cModel) {
        this.samplesPerPixel = 1;
        this.photometricInterpretation = "PALETTE COLOR";
        this.rows = nRows;
        this.columns = nColumns;
        this.bitsAllocated = 8;
        this.bitsStored = 8;
        this.highBit = 7;
        this.pixelRepresentation = 0;
        this.pixelData = new byte[pixel8.length];
        int i = 0;
        while (i < pixel8.length) {
            this.pixelData[i] = pixel8[i];
            ++i;
        }
        this.includeLUTModule = true;
        int mapSize = ((IndexColorModel)cModel).getMapSize();
        byte mapSizeL = (byte)(mapSize & 0xFF);
        byte mapSizeH = (byte)(mapSize >>> 8);
        byte[] descriptor = new byte[6];
        descriptor[1] = mapSizeH;
        descriptor[0] = mapSizeL;
        descriptor[3] = 0;
        descriptor[2] = 0;
        descriptor[5] = 0;
        descriptor[4] = 8;
        this.redPaletteColorLookupTableDescriptor = descriptor;
        this.greenPaletteColorLookupTableDescriptor = descriptor;
        this.bluePaletteColorLookupTableDescriptor = descriptor;
        this.redPaletteColorLookupTableData = new byte[2 * mapSize];
        this.greenPaletteColorLookupTableData = new byte[2 * mapSize];
        this.bluePaletteColorLookupTableData = new byte[2 * mapSize];
        byte[] cTab = new byte[mapSize];
        ((IndexColorModel)cModel).getReds(cTab);
        i = 0;
        int k = 0;
        while (i < cTab.length) {
            this.redPaletteColorLookupTableData[k++] = cTab[i++];
            this.redPaletteColorLookupTableData[k++] = 0;
        }
        ((IndexColorModel)cModel).getGreens(cTab);
        i = 0;
        k = 0;
        while (i < cTab.length) {
            this.greenPaletteColorLookupTableData[k++] = cTab[i++];
            this.greenPaletteColorLookupTableData[k++] = 0;
        }
        ((IndexColorModel)cModel).getBlues(cTab);
        i = 0;
        k = 0;
        while (i < cTab.length) {
            this.bluePaletteColorLookupTableData[k++] = cTab[i++];
            this.bluePaletteColorLookupTableData[k++] = 0;
        }
    }

    public void set16UBitGrayImage(short[] pixel16, int nRows, int nColumns, int bits) {
        this.pixelRepresentation = 0;
        this.set16BitGrayImage(pixel16, nRows, nColumns, bits);
    }

    public void set16SBitGrayImage(short[] pixel16, int nRows, int nColumns, int bits) {
        this.pixelRepresentation = 1;
        this.set16BitGrayImage(pixel16, nRows, nColumns, bits);
    }

    private void set16BitGrayImage(short[] pixel16, int nRows, int nColumns, int bits) {
        this.samplesPerPixel = 1;
        this.photometricInterpretation = "MONOCHROME2";
        this.rows = nRows;
        this.columns = nColumns;
        this.bitsAllocated = 16;
        this.bitsStored = bits;
        this.highBit = bits - 1;
        byte[] buf = new byte[nRows * nColumns * 2];
        short bitMask = (short)(Math.pow(2.0, bits) - 1.0);
        int ip = 0;
        int ib = 0;
        while (ip < pixel16.length) {
            short p = (short)(pixel16[ip++] & bitMask);
            buf[ib++] = (byte)(p & 0xFF);
            buf[ib++] = (byte)(p >>> 8 & 0xFF);
        }
        this.pixelData = buf;
    }
}

