/*
 * Decompiled with CFR 0.152.
 */
package rad.dicom.ima;

import java.awt.Canvas;
import java.awt.Image;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import rad.dicom.ima.GeneralImageIOD;

public class ImaUtil {
    public static int[] calcAutomaticCW(GeneralImageIOD genIma) {
        return ImaUtil.calcAutomaticCW(genIma.pixel16, genIma.bitsStored, genIma.unsignedPixel);
    }

    public static int[] calcAutomaticCW(short[] pixel16, int bitsStored, boolean unsignedPixel) {
        int sum = 0;
        int[] window = new int[2];
        int nPixel = pixel16.length;
        int numPixelValues = (int)Math.pow(2.0, bitsStored);
        int[] histogram = new int[numPixelValues];
        int i = 0;
        while (i < nPixel) {
            short s = pixel16[i];
            histogram[s] = histogram[s] + 1;
            ++i;
        }
        sum = 0;
        int i2 = 0;
        while (i2 < numPixelValues) {
            sum += histogram[i2];
            ++i2;
        }
        int s = 0;
        int min = 0;
        int i3 = 0;
        while (i3 < numPixelValues) {
            if ((s += histogram[i3]) > sum / 10) {
                min = i3;
                break;
            }
            ++i3;
        }
        s = 0;
        int max = 0;
        int i4 = numPixelValues - 1;
        while (i4 >= 0) {
            if ((s += histogram[i4]) > sum / 10) {
                max = i4;
                break;
            }
            --i4;
        }
        if (!unsignedPixel) {
            min -= numPixelValues / 2;
            max -= numPixelValues / 2;
        }
        window[0] = (min + max) / 2;
        window[1] = max - min;
        return window;
    }

    public static Image GIODtoImage(GeneralImageIOD genIma, int theCenter, int theWidth) {
        MemoryImageSource imgSource = null;
        if (theCenter > genIma.maxPixelValue) {
            theCenter = genIma.maxPixelValue;
        }
        if (theCenter < genIma.minPixelValue) {
            theCenter = genIma.minPixelValue;
        }
        if (theWidth > genIma.maxPixelValue) {
            theWidth = genIma.maxPixelValue;
        }
        if (theWidth < 1) {
            theWidth = 1;
        }
        int minImageValue = theCenter - theWidth / 2;
        int maxImageValue = theCenter + theWidth / 2;
        if (minImageValue < genIma.minPixelValue) {
            minImageValue = genIma.minPixelValue;
        }
        if (maxImageValue > genIma.maxPixelValue) {
            maxImageValue = genIma.maxPixelValue;
        }
        byte[] pixel8 = new byte[genIma.pixel16.length];
        double step = (double)((IndexColorModel)genIma.cModel).getMapSize() / (double)(maxImageValue - minImageValue + 1);
        int i = 0;
        while (i < genIma.pixel16.length) {
            int value = genIma.unsignedPixel ? (genIma.oneBytePixel ? genIma.pixel16[i] & 0xFF : genIma.pixel16[i] & 0xFFFF) : genIma.pixel16[i];
            value = genIma.pixel16[i] - minImageValue;
            if (value < 0) {
                value = 0;
            }
            if ((value = (int)((double)value * step)) > 255) {
                value = 255;
            }
            pixel8[i] = (byte)(value & 0xFF);
            ++i;
        }
        imgSource = new MemoryImageSource(genIma.columns, genIma.rows, genIma.cModel, pixel8, 0, genIma.columns);
        return new Canvas().createImage(imgSource);
    }
}

