/*
 * Decompiled with CFR 0.152.
 */
package rad.dicom.ima;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import rad.dicom.dcm.DcmDataObject;
import rad.dicom.dcm.DcmValue;
import rad.dicom.ima.ImaUtil;

public class GeneralImageIOD {
    public static final int PI_UNSUPPORTED = 0;
    public static final int PI_MONOCHROME1 = 1;
    public static final int PI_MONOCHROME2 = 2;
    public static final int PI_PALETTE_COLOR = 3;
    public String patientName;
    public String patientBirthDate;
    public String studyID;
    public int seriesNumber;
    public int imageNumber;
    public double pixelSpacingRow;
    public double pixelSpacingColumn;
    public double sliceThickness;
    public double sliceLocation;
    public int samplesPPixel;
    public int photometricInterpretation = 0;
    public int rows;
    public int columns;
    public int bitsAllocated;
    public int bitsStored;
    public int highBit;
    public boolean oneBytePixel;
    public boolean unsignedPixel;
    public int rescaleIntercept;
    public int rescaleSlope;
    public int windowCenter;
    public int windowWidth;
    public boolean isCenterWidth = false;
    public String classUID;
    public String instanceUID;
    public DcmDataObject headerDDO;
    public short[] pixel16 = new short[0];
    public int minPixelValue = 0;
    public int maxPixelValue = 0;
    public ColorModel cModel = ColorModel.getRGBdefault();
    public int lastCenter;
    public int lastWidth;
    public int autoCenter;
    public int autoWidth;

    public GeneralImageIOD(DcmDataObject ddo) throws Exception {
        this(ddo, true);
    }

    public GeneralImageIOD(DcmDataObject ddo, boolean allowACRNema) throws Exception {
        if (ddo == null) {
            throw new Exception("GeneralImageIOD: No DcmDataObject specified");
        }
        this.extractImageValues(ddo);
        if (allowACRNema && this.photometricInterpretation == 0) {
            this.photometricInterpretation = 2;
        }
        if (this.samplesPPixel > 1) {
            throw new Exception("GeneralImageIOD: Only monochrom/palette color images supported");
        }
        if (this.bitsAllocated != 8 & this.bitsAllocated != 16) {
            throw new Exception("GeneralImageIOD: Only 8 or 16 bit/pixel supported");
        }
        if (this.photometricInterpretation == 0) {
            throw new Exception("GeneralImageIOD: Photometric Interpretation not supported");
        }
        if (this.unsignedPixel) {
            this.minPixelValue = 0;
            this.maxPixelValue = (int)Math.pow(2.0, this.bitsStored) - 1;
        } else {
            this.minPixelValue = -((int)Math.pow(2.0, this.bitsStored)) / 2;
            this.maxPixelValue = (int)Math.pow(2.0, this.bitsStored) / 2 - 1;
        }
        this.extractPixels(ddo);
        switch (this.photometricInterpretation) {
            case 1: {
                this.setMonochrome1ColorModel();
                break;
            }
            case 2: {
                this.setMonochrome2ColorModel();
                break;
            }
            case 3: {
                this.extractLUT(ddo);
            }
        }
        this.headerDDO = ddo.getHeaderCopyOfMe();
        int[] w = ImaUtil.calcAutomaticCW(this.pixel16, this.bitsStored, this.unsignedPixel);
        this.autoCenter = w[0];
        this.autoWidth = w[1];
        if (this.isCenterWidth) {
            if (this.classUID.compareTo("1.2.840.10008.5.1.4.1.1.2") == 0) {
                int[] window = new int[]{this.windowCenter, this.windowWidth};
                this.hu2pv(window);
                this.lastCenter = window[0];
                this.lastWidth = window[1];
            } else {
                this.lastCenter = this.windowCenter;
                this.lastWidth = this.windowWidth;
            }
        } else {
            this.lastCenter = this.autoCenter;
            this.lastWidth = this.autoWidth;
        }
    }

    public void hu2pv(int[] window) {
        if (this.rescaleSlope == 0) {
            return;
        }
        window[0] = (window[0] - this.rescaleIntercept) / this.rescaleSlope;
        window[1] = window[1] / this.rescaleSlope;
    }

    public void pv2hu(int[] window) {
        window[0] = this.rescaleSlope * window[0] + this.rescaleIntercept;
        window[1] = this.rescaleSlope * window[1];
    }

    private void extractImageValues(DcmDataObject ddo) throws Exception {
        this.patientName = ddo.getString(104);
        this.patientBirthDate = ddo.getString(107);
        this.studyID = ddo.getString(441);
        this.seriesNumber = (int)DcmValue.str2Long(ddo.getString(442), 1L);
        this.imageNumber = (int)DcmValue.str2Long(ddo.getString(444), 1L);
        String[] sa = DcmValue.str2StringArray(ddo.getString(486), "\\");
        this.pixelSpacingRow = 0.0;
        this.pixelSpacingColumn = 0.0;
        if (sa.length > 0) {
            this.pixelSpacingRow = DcmValue.str2Double(sa[0], 0.0);
        }
        if (sa.length > 1) {
            this.pixelSpacingColumn = DcmValue.str2Double(sa[1], 0.0);
        }
        this.sliceThickness = DcmValue.str2Double(ddo.getString(162), 1.0);
        this.sliceLocation = DcmValue.str2Double(ddo.getString(467), 0.0);
        this.samplesPPixel = ddo.getUS(477);
        String s = ddo.getString(478);
        if (s.compareTo("MONOCHROME1") == 0) {
            this.photometricInterpretation = 1;
        }
        if (s.compareTo("MONOCHROME2") == 0) {
            this.photometricInterpretation = 2;
        }
        if (s.compareTo("PALETTE COLOR") == 0) {
            this.photometricInterpretation = 3;
        }
        this.rows = ddo.getUS(482);
        this.columns = ddo.getUS(483);
        this.bitsAllocated = ddo.getUS(491);
        this.oneBytePixel = this.bitsAllocated <= 8;
        this.bitsStored = ddo.getUS(492);
        this.highBit = ddo.getUS(493);
        boolean bl = this.unsignedPixel = ddo.getUS(494) == 0;
        if (ddo.isAvailable(506) & ddo.hasValue(506)) {
            sa = DcmValue.str2StringArray(ddo.getString(506), "\\");
            this.windowCenter = (int)DcmValue.str2Long(sa[0], 2048L);
            sa = DcmValue.str2StringArray(ddo.getString(507), "\\");
            this.windowWidth = (int)DcmValue.str2Long(sa[0], 4096L);
            this.isCenterWidth = true;
        }
        this.classUID = ddo.getString(7);
        this.instanceUID = ddo.getString(8);
        if (this.classUID.compareTo("1.2.840.10008.5.1.4.1.1.2") == 0) {
            this.rescaleIntercept = (int)DcmValue.str2Long(ddo.getString(508), 0L);
            this.rescaleSlope = (int)DcmValue.str2Long(ddo.getString(509), 1L);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void extractPixels(DcmDataObject ddo) throws Exception {
        block5: {
            if (!ddo.hasValue(1388)) {
                throw new Exception("GeneralImageIOD.extractPixels: Can't find pixel data");
            }
            nPixel = this.rows * this.columns;
            dcv = ddo.getDcmValue(1388);
            data = dcv.getData();
            if (this.oneBytePixel != false ? data.length < nPixel : data.length < 2 * nPixel) {
                throw new Exception("GeneralImageIOD.extractPixels: Not enough pixel data");
            }
            this.pixel16 = new short[nPixel];
            numShift = this.bitsAllocated - this.bitsStored;
            bitMask = (int)Math.pow(2.0, this.bitsStored) - 1;
            i = 0;
            p = 0;
            if (!this.oneBytePixel) ** GOTO lbl24
            while (p < nPixel) {
                if (this.unsignedPixel) {
                    this.pixel16[p++] = (short)(data[i++] & bitMask);
                    continue;
                }
                v = data[i++];
                this.pixel16[p++] = (short)(v << numShift >> numShift);
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                v = (short)(data[i++] & 255 | (data[i++] & 255) << 8);
                this.pixel16[p++] = this.unsignedPixel != false ? (short)(v & bitMask) : (short)(v << numShift >> numShift);
lbl24:
                // 2 sources

                ** while (p < nPixel)
            }
        }
    }

    private void setMonochrome1ColorModel() {
        byte[] cTab = new byte[256];
        int i = 0;
        while (i < 256) {
            cTab[i] = (byte)(256 - i);
            ++i;
        }
        this.cModel = new IndexColorModel(8, 256, cTab, cTab, cTab);
    }

    private void setMonochrome2ColorModel() {
        byte[] cTab = new byte[256];
        int i = 0;
        while (i < 256) {
            cTab[i] = (byte)i;
            ++i;
        }
        this.cModel = new IndexColorModel(8, 256, cTab, cTab, cTab);
    }

    private void extractLUT(DcmDataObject ddo) throws Exception {
        DcmValue dcvDataBlue;
        DcmValue dcvDataGreen;
        DcmValue dcvDescBlue;
        DcmValue dcvDescGreen;
        DcmValue dcvDescRed = ddo.getDcmValue(513);
        if (dcvDescRed == null | (dcvDescGreen = ddo.getDcmValue(514)) == null | (dcvDescBlue = ddo.getDcmValue(515)) == null) {
            throw new Exception("GeneralImageIOD.extractLUT: Can't find LUT descriptors");
        }
        DcmValue dcvDataRed = ddo.getDcmValue(517);
        if (dcvDataRed == null | (dcvDataGreen = ddo.getDcmValue(518)) == null | (dcvDataBlue = ddo.getDcmValue(519)) == null) {
            throw new Exception("GeneralImageIOD.extractLUT: Can't find LUT data");
        }
        byte[] rTab = new byte[this.maxPixelValue + 1];
        byte[] gTab = new byte[this.maxPixelValue + 1];
        byte[] bTab = new byte[this.maxPixelValue + 1];
        this.setColorComponent(dcvDescRed, dcvDataRed, rTab);
        this.setColorComponent(dcvDescGreen, dcvDataGreen, gTab);
        this.setColorComponent(dcvDescBlue, dcvDataBlue, bTab);
        this.cModel = new IndexColorModel(this.bitsStored, rTab.length, rTab, gTab, bTab);
    }

    private void setColorComponent(DcmValue dcvDesc, DcmValue dcvData, byte[] cTab) throws Exception {
        int numEntries = DcmValue.bufToSS(dcvDesc.getData(), 0);
        short firstMappedPixel = DcmValue.bufToSS(dcvDesc.getData(), 2);
        short numBits = DcmValue.bufToSS(dcvDesc.getData(), 4);
        if (firstMappedPixel < 0) {
            throw new Exception("GeneralImageIOD.setColorComponent: Only unsigned integer pixel values supported");
        }
        if (numBits > 8) {
            throw new Exception("GeneralImageIOD.setColorComponent: Max. 8 bit/color component supported");
        }
        int lutMask = (int)Math.pow(2.0, numBits) - 1;
        int lastMappedPixel = firstMappedPixel + numEntries - 1;
        int idxLast = cTab.length - 1;
        if (lastMappedPixel > idxLast) {
            lastMappedPixel = idxLast;
            numEntries = lastMappedPixel - firstMappedPixel + 1;
        }
        int i = 0;
        while (i <= idxLast) {
            cTab[i] = (byte)(DcmValue.bufToUS(dcvData.getData(), i * 2) & lutMask);
            ++i;
        }
        this.isCenterWidth = true;
        this.windowWidth = numEntries;
        this.windowCenter = (lastMappedPixel - firstMappedPixel) / 2;
    }

    static {
        PI_UNSUPPORTED = 0;
        PI_MONOCHROME1 = 1;
        PI_MONOCHROME2 = 2;
        PI_PALETTE_COLOR = 3;
    }
}

