/*
 * Decompiled with CFR 0.152.
 */
package rad.dicom.dcm;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import rad.dicom.dcm.DcmDDE;

public class DcmValue
implements Cloneable,
Serializable {
    private int group;
    private int element;
    private byte[] data;
    private int type = 0;
    private int vr = 0;

    public DcmValue() {
        this.group = 0;
        this.element = 0;
        this.data = new byte[0];
    }

    public DcmValue(DcmValue o) {
        this.group = o.getGroup();
        this.element = o.getElement();
        this.data = o.getDataAsCopy();
        this.type = o.getType();
        this.vr = o.getVR();
    }

    public DcmValue(int type, byte[] d) {
        this(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type), d);
    }

    public DcmValue(int g, int e, byte[] d) {
        this.group = g;
        this.element = e;
        this.data = d != null ? d : new byte[0];
    }

    public int getGroup() {
        return this.group;
    }

    public int getElement() {
        return this.element;
    }

    public byte[] getData() {
        if (this.data != null) {
            return this.data;
        }
        return new byte[0];
    }

    public byte[] getDataAsCopy() {
        if (this.data == null) {
            return null;
        }
        byte[] res = new byte[this.data.length];
        int i = 0;
        while (i < this.data.length) {
            res[i] = this.data[i];
            ++i;
        }
        return res;
    }

    public int getType() {
        if (this.type != 0) {
            return this.type;
        }
        return DcmDDE.getDictType(this.group, this.element);
    }

    public int getVR() {
        if (this.vr != 0) {
            return this.vr;
        }
        return DcmDDE.getDictVRCode(this.group, this.element);
    }

    public void setVR(int v) {
        this.vr = v;
    }

    public Object clone() {
        return new DcmValue(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DcmValue)) {
            throw new IllegalArgumentException();
        }
        DcmValue e = (DcmValue)o;
        if (e.getGroup() != this.getGroup()) {
            return false;
        }
        if (e.getElement() != this.getElement()) {
            return false;
        }
        if (e.getType() != this.getType()) {
            return false;
        }
        if (e.getVR() != this.getVR()) {
            return false;
        }
        if (e.getData() != null && this.getData() != null) {
            if (e.getData().length != this.data.length) {
                return false;
            }
            int n = this.data.length;
            byte[] b1 = e.getData();
            byte[] b2 = this.getData();
            int i = 0;
            while (i < n) {
                if (b1[i] != b2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString(boolean withDes, int desLen, boolean withTag, int valueLen, boolean withQuotes) {
        int index;
        byte[] buf;
        String theStr = "";
        String endStr = "";
        int t = this.getType();
        int vr = this.getVR();
        String vrName = DcmDDE.vrCodeToString(vr);
        String description = DcmDDE.getDictName(t);
        if (withDes) {
            theStr = theStr + this.padOrTruncate(description, desLen) + " ";
        }
        if (withTag) {
            theStr = theStr + "[" + this.toHexString((short)this.getGroup()) + ", " + this.toHexString((short)this.getElement()) + ", " + this.toHexString(this.getData().length) + ", " + this.padOrTruncate(vrName, 2) + "] ";
        }
        if (withDes || withTag) {
            theStr = theStr + "= ";
        }
        if ((buf = this.getData()).length < 1) {
            theStr = theStr + "<null>";
            return theStr;
        }
        if (buf.length > valueLen) {
            byte[] newdata = new byte[valueLen];
            index = 0;
            while (index < valueLen) {
                newdata[index] = buf[index];
                ++index;
            }
            buf = newdata;
            endStr = "<...>";
        }
        switch (vr) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                String s = new String(buf);
                if (withQuotes) {
                    theStr = theStr + "\"" + s + "\"";
                    break;
                }
                theStr = theStr + s;
                break;
            }
            case 3: {
                int g = DcmValue.bufToUS(buf, 0);
                int e = DcmValue.bufToUS(buf, 4);
                theStr = theStr + "(" + this.toHexString((short)g) + ",";
                theStr = theStr + this.toHexString((short)e) + ")";
                break;
            }
            case 13: 
            case 24: {
                index = 0;
                while (index < buf.length) {
                    theStr = theStr + this.toHexString(buf[index]) + " ";
                    ++index;
                }
                break;
            }
            case 14: {
                index = 0;
                while (index < buf.length) {
                    short d = (short)DcmValue.bufToUS(buf, index);
                    theStr = theStr + this.toHexString(d) + " ";
                    index += 2;
                }
                break;
            }
            case 18: {
                theStr = theStr + "<Sequence Item>";
                break;
            }
            case 25: {
                index = 0;
                while (index < buf.length) {
                    theStr = theStr + String.valueOf(DcmValue.bufToUS(buf, index)) + " ";
                    index += 2;
                }
                break;
            }
            case 23: {
                index = 0;
                while (index < buf.length) {
                    theStr = theStr + String.valueOf(DcmValue.bufToUL(buf, index)) + " ";
                    index += 4;
                }
                break;
            }
            case 19: {
                index = 0;
                while (index < buf.length) {
                    theStr = theStr + String.valueOf(DcmValue.bufToSS(buf, index)) + " ";
                    index += 2;
                }
                break;
            }
            case 17: {
                index = 0;
                while (index < buf.length) {
                    theStr = theStr + String.valueOf(DcmValue.bufToSL(buf, index)) + " ";
                    index += 4;
                }
                break;
            }
            case 9: {
                index = 0;
                while (index < buf.length) {
                    theStr = theStr + String.valueOf(DcmValue.bufToFL(buf, index)) + " ";
                    index += 4;
                }
                break;
            }
            case 8: {
                index = 0;
                while (index < buf.length) {
                    theStr = theStr + String.valueOf(DcmValue.bufToFD(buf, index)) + " ";
                    index += 8;
                }
                break;
            }
            default: {
                index = 0;
                while (index < buf.length) {
                    theStr = theStr + this.toHexString(buf[index]) + " ";
                    ++index;
                }
                break block0;
            }
        }
        if (theStr.length() > valueLen) {
            theStr = theStr.substring(0, valueLen - 5);
            endStr = "<...>";
        }
        theStr = theStr.trim();
        theStr = theStr + endStr;
        return theStr;
    }

    public String toString() {
        return this.toString(true, 25, true, 70, true);
    }

    private String toHexString(byte data) {
        return "0x" + this.addLeadingZeros(Integer.toHexString(data), 2);
    }

    private String toHexString(short data) {
        return "0x" + this.addLeadingZeros(Integer.toHexString(data), 4);
    }

    private String toHexString(int data) {
        return "0x" + this.addLeadingZeros(Integer.toHexString(data), 8);
    }

    /*
     * Unable to fully structure code
     */
    private String padOrTruncate(String s, int length) {
        if (s != null) ** GOTO lbl4
        return s;
lbl-1000:
        // 1 sources

        {
            s = s + " ";
lbl4:
            // 2 sources

            ** while (s.length() < length)
        }
lbl5:
        // 1 sources

        return this.truncate(s, length);
    }

    private String truncate(String s, int length) {
        if (s == null) {
            return s;
        }
        if (s.length() > length) {
            s = s.substring(0, length);
        }
        return s;
    }

    private String addLeadingZeros(String str, int len) {
        String s = "0000000000000000000" + str;
        return s.substring(s.length() - len);
    }

    public static short bufToSS(byte[] buf, int offset) {
        return (short)((short)buf[offset++] & 0xFF | ((short)buf[offset] & 0xFF) << 8);
    }

    public static int bufToSL(byte[] buf, int offset) {
        return buf[offset++] & 0xFF | (buf[offset++] & 0xFF) << 8 | (buf[offset++] & 0xFF) << 16 | (buf[offset] & 0xFF) << 24;
    }

    public static float bufToFL(byte[] buf, int offset) {
        int bits = buf[offset++] & 0xFF | (buf[offset++] & 0xFF) << 8 | (buf[offset++] & 0xFF) << 16 | (buf[offset] & 0xFF) << 24;
        return Float.intBitsToFloat(bits);
    }

    public static double bufToFD(byte[] buf, int offset) {
        long bits = (long)buf[offset++] & 0xFFL | ((long)buf[offset++] & 0xFFL) << 8 | ((long)buf[offset++] & 0xFFL) << 16 | ((long)buf[offset++] & 0xFFL) << 24 | ((long)buf[offset++] & 0xFFL) << 32 | ((long)buf[offset++] & 0xFFL) << 40 | ((long)buf[offset++] & 0xFFL) << 48 | ((long)buf[offset] & 0xFFL) << 56;
        return Double.longBitsToDouble(bits);
    }

    public static int bufToUS(byte[] buf, int offset) {
        return buf[offset++] & 0xFF | (buf[offset] & 0xFF) << 8;
    }

    public static long bufToUL(byte[] buf, int offset) {
        return (long)buf[offset++] & 0xFFL | ((long)buf[offset++] & 0xFFL) << 8 | ((long)buf[offset++] & 0xFFL) << 16 | ((long)buf[offset] & 0xFFL) << 24;
    }

    public static void ssToBuf(short n, byte[] buf, int offset) {
        buf[offset++] = (byte)(n & 0xFF);
        buf[offset] = (byte)(n >> 8 & 0xFF);
    }

    public static void slToBuf(int n, byte[] buf, int offset) {
        buf[offset++] = (byte)(n & 0xFF);
        buf[offset++] = (byte)(n >> 8 & 0xFF);
        buf[offset++] = (byte)(n >> 16 & 0xFF);
        buf[offset] = (byte)(n >> 24 & 0xFF);
    }

    public static void usToBuf(int n, byte[] buf, int offset) {
        buf[offset++] = (byte)(n & 0xFF);
        buf[offset] = (byte)(n >>> 8 & 0xFF);
    }

    public static void ulToBuf(long n, byte[] buf, int offset) {
        buf[offset++] = (byte)(n & 0xFFL);
        buf[offset++] = (byte)(n >>> 8 & 0xFFL);
        buf[offset++] = (byte)(n >>> 16 & 0xFFL);
        buf[offset] = (byte)(n >>> 24 & 0xFFL);
    }

    public static void flToBuf(float f, byte[] buf, int offset) {
        int n = Float.floatToIntBits(f);
        buf[offset++] = (byte)(n & 0xFF);
        buf[offset++] = (byte)(n >>> 8 & 0xFF);
        buf[offset++] = (byte)(n >>> 16 & 0xFF);
        buf[offset] = (byte)(n >>> 24 & 0xFF);
    }

    public static void fdToBuf(double d, byte[] buf, int offset) {
        long n = Double.doubleToLongBits(d);
        buf[offset++] = (byte)(n & 0xFFL);
        buf[offset++] = (byte)(n >>> 8 & 0xFFL);
        buf[offset++] = (byte)(n >>> 16 & 0xFFL);
        buf[offset++] = (byte)(n >>> 24 & 0xFFL);
        buf[offset++] = (byte)(n >>> 32 & 0xFFL);
        buf[offset++] = (byte)(n >>> 40 & 0xFFL);
        buf[offset++] = (byte)(n >>> 48 & 0xFFL);
        buf[offset] = (byte)(n >>> 56 & 0xFFL);
    }

    public static void swapBuf(byte[] buf, int vr) {
        switch (vr) {
            case 3: 
            case 14: 
            case 19: 
            case 25: {
                int i = 0;
                while (i < buf.length) {
                    byte temp = buf[i];
                    buf[i] = buf[i + 1];
                    buf[i + 1] = temp;
                    i += 2;
                }
                break;
            }
            case 9: 
            case 17: 
            case 23: {
                int i = 0;
                while (i < buf.length) {
                    byte temp = buf[i];
                    buf[i] = buf[i + 3];
                    buf[i + 3] = temp;
                    temp = buf[i + 1];
                    buf[i + 1] = buf[i + 2];
                    buf[i + 2] = temp;
                    i += 4;
                }
                break;
            }
            case 8: {
                int i = 0;
                while (i < buf.length) {
                    byte temp = buf[i];
                    buf[i] = buf[i + 7];
                    buf[i + 7] = temp;
                    temp = buf[i + 1];
                    buf[i + 1] = buf[i + 6];
                    buf[i + 6] = temp;
                    temp = buf[i + 2];
                    buf[i + 2] = buf[i + 5];
                    buf[i + 5] = temp;
                    temp = buf[i + 3];
                    buf[i + 3] = buf[i + 4];
                    buf[i + 4] = temp;
                    i += 8;
                }
                break;
            }
        }
    }

    public static long str2Long(String s, long def) {
        try {
            return Long.parseLong(s.trim());
        }
        catch (Exception err) {
            return def;
        }
    }

    public static double str2Double(String s, double def) {
        try {
            return Double.valueOf(s.trim());
        }
        catch (Exception err) {
            return def;
        }
    }

    public static String[] str2StringArray(String s, String delim) {
        int index = -1;
        Vector values = new Vector();
        if (s == null | s.length() == 0) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(s, delim);
        int n = st.countTokens();
        String[] array = new String[n];
        int i = 0;
        while (i < n) {
            array[i] = st.nextToken();
            ++i;
        }
        return array;
    }
}

