/*
 * Decompiled with CFR 0.152.
 */
package rad.dicom.dcm;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import rad.dicom.dcm.DcmDDE;
import rad.dicom.dcm.DcmElements;
import rad.dicom.dcm.DcmValue;

public class DcmDataObject
implements Cloneable,
Serializable {
    public static final int LITTLE_ENDIAN = 1;
    public static final int BIG_ENDIAN = 2;
    public static final int AUTO_ENDIAN = 4;
    public static final int IMPLICITE_VR = 8;
    public static final int EXPLICITE_VR = 16;
    public static final int AUTO_VR = 32;
    public static final int PLAIN_STORAGE = 64;
    public static final int META_STORAGE = 128;
    public static final int AUTO_STORAGE = 256;
    Hashtable grouptable = new Hashtable();
    private transient boolean popNewGroup = true;
    private int encoding = 1;
    private int structure = 16;
    private int storage = 128;

    public DcmDataObject() {
    }

    public DcmDataObject(int enc, int str, int sto) {
        this.encoding = enc;
        this.structure = str;
        this.storage = sto;
    }

    public DcmDataObject(DcmDataObject o) {
        this.grouptable = (Hashtable)o.grouptable.clone();
        this.encoding = o.getEncoding();
        this.structure = o.getStructure();
        this.storage = o.getStorage();
    }

    public int getEncoding() {
        return this.encoding;
    }

    public int getStructure() {
        return this.structure;
    }

    public int getStorage() {
        return this.storage;
    }

    public void setStorage(int sto) {
        this.storage = sto;
    }

    public Object clone() {
        return this.getCopyOfMe();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DcmDataObject)) {
            throw new IllegalArgumentException();
        }
        DcmDataObject e = (DcmDataObject)o;
        if (this.getStorage() != e.getStorage()) {
            return false;
        }
        if (this.getEncoding() != e.getEncoding()) {
            return false;
        }
        if (this.getStructure() != e.getStructure()) {
            return false;
        }
        return this.grouptable.equals(this.grouptable);
    }

    /*
     * WARNING - void declaration
     */
    public DcmDataObject getCopyOfMe() {
        DcmValue dcmval;
        DcmDataObject newSDDO = new DcmDataObject(this.encoding, this.structure, this.storage);
        DcmDataObject saveSDDO = new DcmDataObject();
        while ((dcmval = this.pop()) != null) {
            void var3_3;
            newSDDO.push((DcmValue)var3_3);
            saveSDDO.push((DcmValue)var3_3);
        }
        while ((dcmval = saveSDDO.pop()) != null) {
            this.push(dcmval);
        }
        return newSDDO;
    }

    /*
     * WARNING - void declaration
     */
    public DcmDataObject getHeaderCopyOfMe() {
        DcmValue dcmval;
        DcmDataObject newSDDO = new DcmDataObject(this.encoding, this.structure, this.storage);
        DcmDataObject saveSDDO = new DcmDataObject();
        while ((dcmval = this.pop()) != null) {
            void var3_3;
            saveSDDO.push((DcmValue)var3_3);
            if (var3_3.getGroup() == 32736) continue;
            newSDDO.push((DcmValue)var3_3);
        }
        while ((dcmval = saveSDDO.pop()) != null) {
            this.push(dcmval);
        }
        return newSDDO;
    }

    public void push(DcmValue dcmval) {
        if (dcmval != null && dcmval.getElement() != 0) {
            DcmValue oldDcmValue;
            Integer group = new Integer(dcmval.getGroup());
            Integer element = new Integer(dcmval.getElement());
            DcmElements dcmElements = (DcmElements)this.grouptable.get(group);
            if (dcmElements == null) {
                dcmElements = new DcmElements();
                this.grouptable.put(group, dcmElements);
            }
            if ((oldDcmValue = (DcmValue)dcmElements.get(element)) != null) {
                dcmElements.subLength(oldDcmValue, this.structure);
            }
            dcmElements.put(element, dcmval);
            dcmElements.addLength(dcmval, this.structure);
        }
    }

    public DcmValue pop() {
        int hlp;
        int mingroup = 65536;
        int minelement = 65536;
        if (this.grouptable.size() == 0) {
            this.popNewGroup = true;
            return null;
        }
        Enumeration e = this.grouptable.keys();
        while (e.hasMoreElements()) {
            hlp = (Integer)e.nextElement();
            if (hlp >= mingroup) continue;
            mingroup = hlp;
        }
        DcmElements myGroup = (DcmElements)this.grouptable.get(new Integer(mingroup));
        if (this.popNewGroup) {
            this.popNewGroup = false;
            byte[] buf = new byte[4];
            DcmValue.ulToBuf(myGroup.getLength(), buf, 0);
            return new DcmValue(mingroup, 0, buf);
        }
        Enumeration e2 = myGroup.keys();
        while (e2.hasMoreElements()) {
            hlp = (Integer)e2.nextElement();
            if (hlp >= minelement) continue;
            minelement = hlp;
        }
        DcmValue myElement = (DcmValue)myGroup.get(new Integer(minelement));
        myGroup.remove(new Integer(minelement));
        if (myGroup.size() == 0) {
            this.grouptable.remove(new Integer(mingroup));
            this.popNewGroup = true;
        }
        return myElement;
    }

    public boolean isAvailable(int type) {
        return this.isAvailable(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type));
    }

    public boolean isAvailable(int group, int element) {
        return this.getDcmValue(group, element) != null;
    }

    public boolean hasValue(int type) {
        return this.hasValue(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type));
    }

    public boolean hasValue(int group, int element) {
        if (!this.isAvailable(group, element)) {
            return false;
        }
        DcmValue dcmval = this.getDcmValue(group, element);
        int length = dcmval.getData().length;
        if (dcmval != null) {
            switch (dcmval.getVR()) {
                case 19: 
                case 25: {
                    if (!(length >= 2 & length % 2 == 0)) break;
                    return true;
                }
                case 9: 
                case 17: 
                case 23: {
                    if (!(length >= 4 & length % 4 == 0)) break;
                    return true;
                }
                case 8: {
                    if (!(length >= 8 & length % 8 == 0)) break;
                    return true;
                }
                default: {
                    if (length <= 0) break;
                    return true;
                }
            }
        }
        return false;
    }

    public int getMultiplicity(int type) {
        return this.getMultiplicity(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type));
    }

    public int getMultiplicity(int group, int element) {
        if (!this.isAvailable(group, element)) {
            return 0;
        }
        DcmValue dcmval = this.getDcmValue(group, element);
        int length = dcmval.getData().length;
        if (dcmval != null) {
            switch (dcmval.getVR()) {
                case 19: 
                case 25: {
                    if (length % 2 != 0) {
                        return 0;
                    }
                    return length / 2;
                }
                case 9: 
                case 17: 
                case 23: {
                    if (length % 4 != 0) {
                        return 0;
                    }
                    return length / 4;
                }
                case 8: {
                    if (length % 8 != 0) {
                        return 0;
                    }
                    return length / 8;
                }
            }
            int n = 1;
            int i = 0;
            while (i < length) {
                if (dcmval.getData()[i] == 92) {
                    ++n;
                }
                ++i;
            }
        }
        return 0;
    }

    public DcmValue getDcmValue(int type) {
        return this.getDcmValue(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type));
    }

    public DcmValue getDcmValue(int group, int element) {
        DcmElements dcmElems = (DcmElements)this.grouptable.get(new Integer(group));
        if (dcmElems != null) {
            if (element == 0) {
                byte[] buf = new byte[4];
                DcmValue.ulToBuf(dcmElems.getLength(), buf, 0);
                return new DcmValue(group, element, buf);
            }
            return (DcmValue)dcmElems.get(new Integer(element));
        }
        return null;
    }

    public byte[] getData(int type) {
        return this.getData(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type));
    }

    public byte[] getData(int group, int element) {
        DcmValue dcmval = this.getDcmValue(group, element);
        if (dcmval != null) {
            return dcmval.getData();
        }
        return new byte[0];
    }

    public void removeObject(int type) {
        this.removeObject(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type));
    }

    public void removeObject(int group, int element) {
        DcmElements dcmElems = (DcmElements)this.grouptable.get(new Integer(group));
        dcmElems.remove(new Integer(element));
    }

    public String getString(int type) {
        return this.getString(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type));
    }

    public String getString(int group, int element) {
        byte[] data;
        String result = "";
        DcmValue dcmval = this.getDcmValue(group, element);
        if (dcmval != null && (data = dcmval.getData()).length > 0) {
            int last;
            result = data.length % 2 == 0 ? (data[last = data.length - 1] == 0 || data[last] == 32 ? new String(data, 0, last) : new String(data)) : new String(data);
        }
        return result;
    }

    public String[] getStringArray(int type) {
        return this.getStringArray(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type));
    }

    public String[] getStringArray(int group, int element) {
        String s = this.getString(group, element);
        if (s == null) {
            return null;
        }
        return DcmValue.str2StringArray(s, "\\");
    }

    public short getSS(int type) {
        return this.getSS(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type));
    }

    public short getSS(int group, int element) {
        byte[] data;
        short result = 0;
        DcmValue dcmval = this.getDcmValue(group, element);
        if (dcmval != null && (data = dcmval.getData()).length >= 2) {
            return DcmValue.bufToSS(data, 0);
        }
        return result;
    }

    public short[] getSSArray(int type) {
        return this.getSSArray(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type));
    }

    public short[] getSSArray(int group, int element) {
        DcmValue dcmval = this.getDcmValue(group, element);
        if (dcmval != null) {
            byte[] data = dcmval.getData();
            if (data.length < 2 | data.length % 2 != 0) {
                return null;
            }
            short[] values = new short[data.length / 2];
            int i = 0;
            int offset = 0;
            while (offset < data.length) {
                values[i++] = DcmValue.bufToSS(data, offset);
                offset += 2;
            }
            return values;
        }
        return null;
    }

    public int getSL(int type) {
        return this.getSL(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type));
    }

    public int getSL(int group, int element) {
        byte[] data;
        int result = 0;
        DcmValue dcmval = this.getDcmValue(group, element);
        if (dcmval != null && (data = dcmval.getData()).length >= 4) {
            return DcmValue.bufToSL(data, 0);
        }
        return result;
    }

    public int[] getSLArray(int type) {
        return this.getSLArray(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type));
    }

    public int[] getSLArray(int group, int element) {
        DcmValue dcmval = this.getDcmValue(group, element);
        if (dcmval != null) {
            byte[] data = dcmval.getData();
            if (data.length < 4 | data.length % 4 != 0) {
                return null;
            }
            int[] values = new int[data.length / 4];
            int i = 0;
            int offset = 0;
            while (offset < data.length) {
                values[i++] = DcmValue.bufToSL(data, offset);
                offset += 4;
            }
            return values;
        }
        return null;
    }

    public int getUS(int type) {
        return this.getUS(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type));
    }

    public int getUS(int group, int element) {
        byte[] data;
        int result = 0;
        DcmValue dcmval = this.getDcmValue(group, element);
        if (dcmval != null && (data = dcmval.getData()).length >= 2) {
            return DcmValue.bufToUS(data, 0);
        }
        return result;
    }

    public int[] getUSArray(int type) {
        return this.getUSArray(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type));
    }

    public int[] getUSArray(int group, int element) {
        DcmValue dcmval = this.getDcmValue(group, element);
        if (dcmval != null) {
            byte[] data = dcmval.getData();
            if (data.length < 2 | data.length % 2 != 0) {
                return null;
            }
            int[] values = new int[data.length / 2];
            int i = 0;
            int offset = 0;
            while (offset < data.length) {
                values[i++] = DcmValue.bufToUS(data, offset);
                offset += 2;
            }
            return values;
        }
        return null;
    }

    public long getUL(int type) {
        return this.getUL(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type));
    }

    public long getUL(int group, int element) {
        byte[] data;
        long result = 0L;
        DcmValue dcmval = this.getDcmValue(group, element);
        if (dcmval != null && (data = dcmval.getData()).length >= 4) {
            return DcmValue.bufToUL(data, 0);
        }
        return result;
    }

    public long[] getULArray(int type) {
        return this.getULArray(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type));
    }

    public long[] getULArray(int group, int element) {
        DcmValue dcmval = this.getDcmValue(group, element);
        if (dcmval != null) {
            byte[] data = dcmval.getData();
            if (data.length < 4 | data.length % 4 != 0) {
                return null;
            }
            long[] values = new long[data.length / 4];
            int i = 0;
            int offset = 0;
            while (offset < data.length) {
                values[i++] = DcmValue.bufToUL(data, offset);
                offset += 4;
            }
            return values;
        }
        return null;
    }

    public float getFL(int type) {
        return this.getFL(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type));
    }

    public float getFL(int group, int element) {
        byte[] data;
        float result = 0.0f;
        DcmValue dcmval = this.getDcmValue(group, element);
        if (dcmval != null && (data = dcmval.getData()).length >= 4) {
            return DcmValue.bufToFL(data, 0);
        }
        return result;
    }

    public float[] getFLArray(int type) {
        return this.getFLArray(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type));
    }

    public float[] getFLArray(int group, int element) {
        DcmValue dcmval = this.getDcmValue(group, element);
        if (dcmval != null) {
            byte[] data = dcmval.getData();
            if (data.length < 4 | data.length % 4 != 0) {
                return null;
            }
            float[] values = new float[data.length / 4];
            int i = 0;
            int offset = 0;
            while (offset < data.length) {
                values[i++] = DcmValue.bufToFL(data, offset);
                offset += 4;
            }
            return values;
        }
        return null;
    }

    public double getFD(int type) {
        return this.getFD(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type));
    }

    public double getFD(int group, int element) {
        byte[] data;
        double result = 0.0;
        DcmValue dcmval = this.getDcmValue(group, element);
        if (dcmval != null && (data = dcmval.getData()).length >= 8) {
            return DcmValue.bufToFD(data, 0);
        }
        return result;
    }

    public double[] getFDArray(int type) {
        return this.getFDArray(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type));
    }

    public double[] getFDArray(int group, int element) {
        DcmValue dcmval = this.getDcmValue(group, element);
        if (dcmval != null) {
            byte[] data = dcmval.getData();
            if (data.length < 8 | data.length % 8 != 0) {
                return null;
            }
            double[] values = new double[data.length / 8];
            int i = 0;
            int offset = 0;
            while (offset < data.length) {
                values[i++] = DcmValue.bufToFD(data, offset);
                offset += 8;
            }
            return values;
        }
        return null;
    }

    public void setString(int type, String str) {
        this.setString(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type), str);
    }

    public void setString(int group, int element, String str) {
        this.push(new DcmValue(group, element, str.getBytes()));
    }

    public void setSS(int type, short n) {
        this.setSS(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type), n);
    }

    public void setSS(int group, int element, short n) {
        byte[] buf = new byte[2];
        DcmValue.ssToBuf(n, buf, 0);
        this.push(new DcmValue(group, element, buf));
    }

    public void setUS(int type, int n) {
        this.setUS(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type), n);
    }

    public void setUS(int group, int element, int n) {
        byte[] buf = new byte[2];
        DcmValue.usToBuf(n, buf, 0);
        this.push(new DcmValue(group, element, buf));
    }

    public void setSL(int type, int n) {
        this.setSL(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type), n);
    }

    public void setSL(int group, int element, int n) {
        byte[] buf = new byte[4];
        DcmValue.slToBuf(n, buf, 0);
        this.push(new DcmValue(group, element, buf));
    }

    public void setUL(int type, long n) {
        this.setUL(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type), n);
    }

    public void setUL(int group, int element, long n) {
        byte[] buf = new byte[4];
        DcmValue.ulToBuf(n, buf, 0);
        this.push(new DcmValue(group, element, buf));
    }

    public void setFL(int type, float n) {
        this.setFL(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type), n);
    }

    public void setFL(int group, int element, float n) {
        byte[] buf = new byte[4];
        DcmValue.flToBuf(n, buf, 0);
        this.push(new DcmValue(group, element, buf));
    }

    public void setFD(int type, double n) {
        this.setFD(DcmDDE.getDictGroup(type), DcmDDE.getDictElement(type), n);
    }

    public void setFD(int group, int element, double n) {
        byte[] buf = new byte[8];
        DcmValue.fdToBuf(n, buf, 0);
        this.push(new DcmValue(group, element, buf));
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        DcmValue dv;
        String theStr = "";
        DcmDataObject ddo = this.getCopyOfMe();
        while ((dv = ddo.pop()) != null) {
            void var2_3;
            theStr = theStr + var2_3.toString(true, 32, true, 256, false) + "\n";
        }
        return theStr;
    }

    public void dump(PrintStream ps) {
        Enumeration e = this.grouptable.elements();
        while (e.hasMoreElements()) {
            DcmElements v = (DcmElements)e.nextElement();
            Enumeration e2 = v.elements();
            while (e2.hasMoreElements()) {
                DcmValue vv = (DcmValue)e2.nextElement();
                ps.println(vv.toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public DcmDataObject extract(int[] types) {
        DcmValue dcmval;
        DcmDataObject localCopy = (DcmDataObject)this.clone();
        DcmDataObject res = new DcmDataObject(this.getEncoding(), this.getStructure(), this.getStorage());
        while ((dcmval = localCopy.pop()) != null) {
            void var4_4;
            boolean bOk = false;
            int t = var4_4.getType();
            int i = 0;
            while (i < types.length) {
                if (types[i] == t) {
                    bOk = true;
                }
                ++i;
            }
            if (!bOk) continue;
            res.push((DcmValue)var4_4);
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    public DcmDataObject clear(int[] types) {
        DcmValue dcmval;
        DcmDataObject localCopy = (DcmDataObject)this.clone();
        DcmDataObject res = new DcmDataObject(this.getEncoding(), this.getStructure(), this.getStorage());
        while ((dcmval = localCopy.pop()) != null) {
            void var4_4;
            boolean bOk = true;
            int t = var4_4.getType();
            int i = 0;
            while (i < types.length) {
                if (types[i] == t) {
                    bOk = false;
                }
                ++i;
            }
            if (!bOk) continue;
            res.push((DcmValue)var4_4);
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    public DcmDataObject merge(int[] types, DcmDataObject ddo2) {
        DcmValue dcmval;
        DcmDataObject localCopy = (DcmDataObject)this.clone();
        DcmDataObject res = new DcmDataObject(this.getEncoding(), this.getStructure(), this.getStorage());
        while ((dcmval = localCopy.pop()) != null) {
            void var5_5;
            boolean bOk = false;
            int t = var5_5.getType();
            int i = 0;
            while (i < types.length) {
                if (types[i] == t) {
                    bOk = true;
                }
                ++i;
            }
            if (bOk) {
                DcmValue vv2 = ddo2.getDcmValue(t);
                if (vv2 != null) {
                    res.push(vv2);
                    continue;
                }
                res.push((DcmValue)var5_5);
                continue;
            }
            res.push((DcmValue)var5_5);
        }
        return res;
    }

    static {
        LITTLE_ENDIAN = 1;
        BIG_ENDIAN = 2;
        AUTO_ENDIAN = 4;
        IMPLICITE_VR = 8;
        EXPLICITE_VR = 16;
        AUTO_VR = 32;
        PLAIN_STORAGE = 64;
        META_STORAGE = 128;
        AUTO_STORAGE = 256;
    }
}

