
package edu.uthscsa.ric.utilities;

import java.util.HashMap;
import java.util.Map;

import org.xml.sax.Attributes;


public final class XMLUtilities {

	private XMLUtilities() {}



	public static Map<String, String> attributesToMap(final Attributes atts) {
		Map<String, String> map = null;

		if (atts != null) {
			map = new HashMap<String, String>();
			final int numAtts = atts.getLength();
			for (int ctr = 0; ctr < numAtts; ctr++) {
				final String name = atts.getQName(ctr);
				final String value = atts.getValue(name);
				map.put(name, value);
			}
		}

		return map;
	}
}
