
package edu.uthscsa.ric.utilities;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.Map;


public final class URLUtilities {

	private URLUtilities() {}



	// http://www.java2s.com/Code/Java/Network-Protocol/EncodeaURIpath.htm
	public static StringBuffer encodePath(final StringBuffer bufVal, final String path) {
		StringBuffer buf = bufVal;

		if (buf == null) {
			loop: for (int i = 0; i < path.length(); i++) {
				final char c = path.charAt(i);
				switch (c) {
					case '%':
					case '?':
					case ';':
					case '#':
					case ' ':
						buf = new StringBuffer(path.length() << 1);
						break loop;
					default:
				}
			}
			if (buf == null) {
				return null;
			}
		}

		synchronized (buf) {
			for (int i = 0; i < path.length(); i++) {
				final char c = path.charAt(i);
				switch (c) {
					case '%':
						buf.append("%25");
						continue;
					case '?':
						buf.append("%3F");
						continue;
					case ';':
						buf.append("%3B");
						continue;
					case '#':
						buf.append("%23");
						continue;
					case ' ':
						buf.append("%20");
						continue;
					default:
						buf.append(c);
						continue;
				}
			}
		}

		return buf;
	}



	// http://stackoverflow.com/questions/13592236/parse-the-uri-string-into-name-value-collection-in-java
	public static Map<String, String> splitQuery(final String query) throws UnsupportedEncodingException {
		final Map<String, String> queryPairs = new LinkedHashMap<String, String>();
		final String[] pairs = query.split("&");
		for (final String pair : pairs) {
			final int idx = pair.indexOf('=');
			queryPairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
		}

		return queryPairs;
	}



	public static boolean urlExists(final String urlName) throws MalformedURLException, IOException {
		return urlExists(urlName, 4000);
	}



	public static boolean urlExists(final String urlName, final int timeout) throws MalformedURLException, IOException {
		final HttpURLConnection con = (HttpURLConnection) (new URL(urlName).openConnection());

		con.setConnectTimeout(timeout);
		con.setReadTimeout(timeout);
		con.setRequestMethod("HEAD");

		return (con.getResponseCode() == HttpURLConnection.HTTP_OK);
	}
}
