
package edu.uthscsa.ric.utilities;

import java.util.StringTokenizer;

import javax.swing.JTree;
import javax.swing.tree.TreePath;


// http://www.javalobby.org/java/forums/t19857.html
public final class TreeUtilities {

	private TreeUtilities() {}



	public static String getExpansionState(final JTree tree, final int row) {
		final TreePath rowPath = tree.getPathForRow(row);
		final StringBuffer buf = new StringBuffer();
		final int rowCount = tree.getRowCount();
		for (int i = row; i < rowCount; i++) {
			final TreePath path = tree.getPathForRow(i);
			if ((i == row) || isDescendant(path, rowPath)) {
				if (tree.isExpanded(path)) {
					buf.append(',');
					buf.append(String.valueOf(i - row));
				}
			} else {
				break;
			}
		}
		return buf.toString();
	}



	// is path1 descendant of path2
	public static boolean isDescendant(final TreePath path1Val, final TreePath path2Val) {
		TreePath path1 = path1Val;
		final TreePath path2 = path2Val;

		int count1 = path1.getPathCount();
		final int count2 = path2.getPathCount();
		if (count1 <= count2) {
			return false;
		}
		while (count1 != count2) {
			path1 = path1.getParentPath();
			count1--;
		}
		return path1.equals(path2);
	}



	public static void restoreExpanstionState(final JTree tree, final int row, final String expansionState) {
		if (expansionState != null) {
			final StringTokenizer stok = new StringTokenizer(expansionState, ",");
			while (stok.hasMoreTokens()) {
				final int token = row + Integer.parseInt(stok.nextToken());
				tree.expandRow(token);
			}
		}
	}
}
