
package edu.uthscsa.ric.utilities;

import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;


public final class StringUtilities {

	public static final DecimalFormat FORMATTER = new DecimalFormat("0.#");;



	private StringUtilities() {}



	public static byte[] convertToBytes(final String string, final byte[] byteBufferVal) throws UnsupportedEncodingException {
		byte[] byteBuffer = byteBufferVal;

		if (byteBuffer == null) {
			byteBuffer = new byte[string.length()];
		}

		if (string != null) {
			final byte[] nameBytes = string.getBytes("UTF8");

			for (int ctrB = 0; (ctrB < nameBytes.length) && (ctrB < byteBuffer.length); ctrB++) {
				byteBuffer[ctrB] = nameBytes[ctrB];
			}
		}

		return byteBuffer;
	}



	public static String makeHumanReadableDescriptionFromCamelCase(final String str) {
		// http://stackoverflow.com/questions/2559759/how-do-i-convert-camelcase-into-human-readable-names-in-java
		final String des = str.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
		final String[] words = StringUtils.split(des);
		words[0] = WordUtils.capitalize(words[0]);
		return StringUtils.join(words, ' ').replace("Roi", "ROI");
	}



	public static byte convertToLetterDigitOnly(final byte aChar) {
		if ((Character.isLetter((char) aChar)) || (Character.isDigit((char) aChar))) {
			return aChar;
		} else {
			return 32;
		}
	}



	public static String convertToLetterDigitOnly(final String string) {
		final byte[] someChars = string.getBytes();
		final byte[] returnChars = new byte[someChars.length];

		for (int ctr = 0; ctr < someChars.length; ctr++) {
			returnChars[ctr] = convertToLetterDigitOnly(someChars[ctr]);
		}

		String returnString = new String(returnChars);
		returnString = returnString.trim();

		return returnString;
	}



	public static byte convertToPrintableASCII(final byte aChar) {
		if ((aChar < 32) || (aChar > 126)) {
			return 32;
		} else {
			return aChar;
		}
	}



	public static byte[] convertToPrintableASCII(final byte[] someChars) {
		byte[] returnChars = null;

		if (someChars != null) {
			returnChars = new byte[someChars.length];

			for (int ctr = 0; ctr < someChars.length; ctr++) {
				returnChars[ctr] = convertToPrintableASCII(someChars[ctr]);
			}
		}

		return returnChars;
	}



	public static boolean isProbablyPrintableASCII(final byte[] someChars) {
		int numPrintable = 0;

		for (final byte someChar : someChars) {
			if ((someChar == 0) || ((someChar >= 32) && (someChar <= 126))) {
				numPrintable++;
			}
		}

		final double ratio = (numPrintable / (double) someChars.length);
		return (ratio > .9);
	}



	public static String convertBytesToNiceString(final byte[] someBytes) {
		return convertToPrintableASCIIString(someBytes);
	}



	public static String convertToPrintableASCIIString(final byte[] someChars) {
		final byte[] chars = convertToPrintableASCII(someChars);
		if (chars != null) {
			return (new String(chars)).trim();
		} else {
			return "";
		}
	}



	public static String convertToString(final byte[] bytes) throws UnsupportedEncodingException {
		String string = "";
		string += (new String(bytes, "UTF8"));
		string = string.trim();

		return string;
	}



	// Removes extension
	public static String makeNiceImageName(final String nameStrVal) {
		String nameStr = nameStrVal;
		final int dotIndex = nameStr.indexOf('.');
		if (dotIndex != -1) {
			nameStr = nameStr.substring(0, dotIndex);
		}
		return nameStr;
	}



	/**
	 * Converts number of bytes to file size string.
	 * 
	 * @param imageFileSize
	 * @return
	 */
	public static String makeNiceFileSizeString(final long imageFileSize) {
		String imageFileSizeString = null;

		if (imageFileSize > 1048576) {
			imageFileSizeString = FORMATTER.format(imageFileSize / (double) 1048576) + " Mb";
		} else if (imageFileSize > 1024) {
			imageFileSizeString = FORMATTER.format(imageFileSize / (double) 1024) + " Kb";
		} else {
			imageFileSizeString = imageFileSize + " Bytes";
		}

		return imageFileSizeString;
	}



	public static String makeNiceBinaryString(final long value) {
		final StringBuffer sb = new StringBuffer(StringUtils.leftPad(Long.toBinaryString(value), Long.SIZE, '0'));
		sb.insert(sb.length() - 56, " ");
		sb.insert(sb.length() - 48, " ");
		sb.insert(sb.length() - 40, " ");
		sb.insert(sb.length() - 32, " ");
		sb.insert(sb.length() - 24, " ");
		sb.insert(sb.length() - 16, " ");
		sb.insert(sb.length() - 8, " ");
		return sb.toString();
	}



	public static String makeNiceBinaryString(final int value) {
		final StringBuffer sb = new StringBuffer(StringUtils.leftPad(Integer.toBinaryString(value), Integer.SIZE, '0'));
		sb.insert(sb.length() - 32, " ");
		sb.insert(sb.length() - 24, " ");
		sb.insert(sb.length() - 16, " ");
		sb.insert(sb.length() - 8, " ");
		return sb.toString();
	}



	public static String makeNiceHexString(final int value) {
		String str = Integer.toHexString(value);
		str = StringUtils.leftPad(str, (Integer.SIZE / 8) * 2, '0');
		return str.toUpperCase();
	}



	public static String makeNiceHexString(final short value) {
		String str = Integer.toHexString(value & 0xFFFF);
		str = StringUtils.leftPad(str, (Short.SIZE / 8) * 2, '0');
		return str.toUpperCase();
	}



	public static Vector<String> makeStringTokens(final String string) {
		final Vector<String> tokens = new Vector<String>();
		final StringTokenizer tokenizer = new StringTokenizer(string);
		while (tokenizer.hasMoreTokens()) {
			tokens.add(tokenizer.nextToken());
		}

		return tokens;
	}



	public static String removeLineBreaks(final String str) {
		return str.replace("\n", " ").replace("\r", " ").trim();

	}



	public static int findIndexOfFirstNonWhitespaceCharacter(final String str) {
		int retcod = -1;

		final Pattern p = Pattern.compile("[^\\s]+");
		final Matcher m = p.matcher(str);
		if (m.find()) {
			retcod = m.start();
		}

		return retcod;
	}



	public static int findLastIndexOfCharacter(final String str, final char ch, final int start, final int max, final boolean escape) {
		final Pattern pattern = Pattern.compile((escape ? "\\" + ch : ch) + "\\s*(?=([^\"']*[\"'][^\"']*[\"'])*[^\"']*$)"); // find character only outside quotes
		final Matcher matcher = pattern.matcher(str);

		int previous = -1;

		while (matcher.find()) {
			final int index = matcher.start();

			if (index >= start) {
				if ((max != -1) && (index >= max)) {
					if (previous == -1) {
						return index;
					} else {
						return previous;
					}
				}
			}

			previous = index;
		}

		return previous;
	}



	public static int findIndexOfCharacter(final String str, final char ch, final int start, final boolean escape) {
		final Pattern pattern = Pattern.compile((escape ? "\\" + ch : ch) + "\\s*(?=([^\"']*[\"'][^\"']*[\"'])*[^\"']*$)"); // find character only outside quotes
		final Matcher matcher = pattern.matcher(str);

		while (matcher.find()) {
			final int index = matcher.start();

			if (index >= start) {
				return index;
			}
		}

		return -1;
	}



	public static int findNumberOfCharacters(final String str, final char ch, final boolean escape) {
		final Pattern pattern = Pattern.compile((escape ? "\\" + ch : ch) + "\\s*(?=([^\"']*[\"'][^\"']*[\"'])*[^\"']*$)"); // find character only outside quotes
		final Matcher matcher = pattern.matcher(str);

		int count = 0;

		while (matcher.find()) {
			count++;
		}

		return count;
	}



	public static List<String> splitToEqualLengths(final String text, final int size) {
		final List<String> ret = new ArrayList<String>(((text.length() + size) - 1) / size);
		for (int start = 0; start < text.length(); start += size) {
			ret.add(text.substring(start, Math.min(text.length(), start + size)));
		}

		return ret;
	}
}
