
package edu.uthscsa.ric.utilities;

import java.util.Arrays;


/**
 * median search algorithm I made based on this googled description (below describes a 3x3)...
 * 
 * "A better approach is published in the first Volume of the Graphics Gems series by Paeth [Paeth 1990]. This approach is based on a successive
 * minmax-elimination: the minimum and the maximum of the first six elements are determined and eliminated. Then the 7th element is added to the remaining four
 * of the first pass and the minimum and the maximum of the five elements are determined and eliminated. This scheme is repeated until the 9th element is added
 * to the remaining two and the minmax-elimination results in the median of all nine elements. This algorithm needs 20 comparisons per median."
 * 
 * ... faster than quicksort for finding the median!
 */
public final class RankSearch {

	private RankSearch() {}



	public static float searchMax(final float[] data) {
		float max = data[0];

		for (int ctr = 1; ctr < data.length; ctr++) {
			if (data[ctr] > max) {
				max = data[ctr];
			}
		}

		return max;
	}



	public static float searchMedian(final float[] data, final int startVal, final boolean checkZeros) {
		int start = startVal;
		int limit = start;

		if (checkZeros && (data[0] == 0.0F) && checkForZeros(data, limit)) {
			return 0; // large blocks of zeros; if first value is zero, then check.
		}

		float min, max;
		int minIndex, maxIndex;
		min = max = data[0];
		minIndex = maxIndex = 0;

		while (limit >= 3) {
			for (int ctr = 1; ctr < limit; ctr++) {
				if (data[ctr] < min) {
					min = data[ctr];
					minIndex = ctr;
				} else if (data[ctr] > max) {
					max = data[ctr];
					maxIndex = ctr;
				}
			}

			if (limit == 3) {
				break;
			}

			data[minIndex] = data[start++];
			data[maxIndex] = data[--limit];

			min = max = data[0];
			minIndex = maxIndex = 0;
		}

		final int sum = minIndex + maxIndex;

		if (sum == 1) {
			return data[2];
		} else if (sum == 2) {
			return data[1];
		} else {
			// if(sum == 3) or... if(sum == 0) then (minIndex == maxIndex)
			return data[0];
		}
	}



	public static float searchMin(final float[] data) {
		float min = data[0];

		for (int ctr = 1; ctr < data.length; ctr++) {
			if (data[ctr] < min) {
				min = data[ctr];
			}
		}

		return min;
	}



	public static float searchMinNonZero(final float[] data) {
		float min = Float.MAX_VALUE;

		for (final float element : data) {
			if ((element != 0) && (element < min)) {
				min = element;
			}
		}

		if (min == Float.MAX_VALUE) {
			min = 0;
		}

		return min;
	}



	public static float sortAndSearchMedian(final float[] data) {
		Arrays.sort(data);

		if ((data.length % 2) == 0) {
			final float first = data[(data.length / 2) - 1];
			final float second = data[data.length / 2];
			return (first + second) / 2.0f;
		} else {
			return data[data.length / 2];
		}
	}



	private static boolean checkForZeros(final float[] data, final int limit) { // if there are more than (n / 2) zeros, then zero is median

		for (int ctr = 0; ctr < limit; ctr++) {
			if (data[ctr] != 0.0F) {
				return false;
			}
		}

		return true;
	}
}
