
package edu.uthscsa.ric.utilities;

public final class MathUtilities {

	private static final double EPSILON = 0.00000001;
	private static final double EPSILON_F = 0.00000001f;



	private MathUtilities() {}



	public static boolean essentiallyEqual(final double a, final double b) {
		return (a == b) || (Math.abs(a - b) <= ((Math.abs(a) > Math.abs(b) ? Math.abs(b) : Math.abs(a)) * EPSILON));
	}



	public static boolean essentiallyEqual(final float a, final float b) {
		return (a == b) || (Math.abs(a - b) <= ((Math.abs(a) > Math.abs(b) ? Math.abs(b) : Math.abs(a)) * EPSILON_F));
	}



	public static boolean essentiallyEqual2(final double a, final double b) {
		if (Double.isNaN(a) && Double.isNaN(b)) {
			return true;
		}

		return (a == b) || (Math.abs(a - b) <= ((Math.abs(a) > Math.abs(b) ? Math.abs(b) : Math.abs(a)) * EPSILON));
	}



	// http://bugs.java.com/bugdatabase/view_bug.do?bug_id=8029302
	public static double pow(final double a, final double b) {
		if (b == 2.0) {
			return (a * a);
		} else {
			return Math.pow(a, b);
		}
	}



	public static float clamp(final float val, final float min, final float max) {
		return Math.max(min, Math.min(max, val));
	}



	public static double clamp(final double val, final double min, final double max) {
		return Math.max(min, Math.min(max, val));
	}
}
