
package edu.uthscsa.ric.utilities;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import javax.swing.ImageIcon;

import org.apache.commons.lang3.ArrayUtils;


public final class CollectionUtilities {

	public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
	public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
	public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
	public static final int[] EMPTY_INT_ARRAY = new int[0];
	public static final long[] EMPTY_LONG_ARRAY = new long[0];
	public static final short[] EMPTY_SHORT_ARRAY = new short[0];
	public static final String[] EMPTY_STRING_ARRAY = new String[0];
	public static final Class<?>[] EMPTY_TYPE_ARRAY = new Class<?>[0];



	private CollectionUtilities() {}



	public static String[] array(final List<String> list) {
		return list.toArray(new String[list.size()]);
	}



	public static byte[] arrayBytes(final List<Byte> list) {
		return ArrayUtils.toPrimitive(list.toArray(new Byte[list.size()]));
	}



	public static int[] arrayInts(final List<Integer> list) {
		return ArrayUtils.toPrimitive(list.toArray(new Integer[list.size()]));
	}



	public static float[] arrayFloats(final List<Float> list) {
		return ArrayUtils.toPrimitive(list.toArray(new Float[list.size()]));
	}



	public static double[] arrayDoubles(final List<Double> list) {
		return ArrayUtils.toPrimitive(list.toArray(new Double[list.size()]));
	}



	public static List<Byte> immutable(final Byte... args) {
		return Collections.unmodifiableList(Arrays.asList(args));
	}



	public static List<Boolean> immutable(final Boolean... args) {
		return Collections.unmodifiableList(Arrays.asList(args));
	}



	public static List<Float> immutable(final Float... args) {
		return Collections.unmodifiableList(Arrays.asList(args));
	}



	public static List<Double> immutable(final Double... args) {
		return Collections.unmodifiableList(Arrays.asList(args));
	}



	public static List<Integer> immutable(final Integer... args) {
		return Collections.unmodifiableList(Arrays.asList(args));
	}



	public static List<int[]> immutable(final int[]... args) {
		return Collections.unmodifiableList(Arrays.asList(args));
	}



	public static List<String> immutable(final String... args) {
		return Collections.unmodifiableList(Arrays.asList(args));
	}



	public static List<ImageIcon> immutable(final ImageIcon... args) {
		return Collections.unmodifiableList(Arrays.asList(args));
	}



	public static boolean isEmpty(final Object array) {
		if (array == null) {
			return true;
		}

		if (array.getClass().isArray()) {
			return (Array.getLength(array) == 0);
		} else {
			throw new IllegalArgumentException("Not an array!");
		}
	}



	public static boolean isNotEmpty(final Object array) {
		return !isEmpty(array);
	}



	public static <T, E> T getKeyByValue(final Map<T, E> map, final E value) {
		for (final Entry<T, E> entry : map.entrySet()) {
			if (value.equals(entry.getValue())) {
				return entry.getKey();
			}
		}
		return null;
	}



	public static int findIndexOfMax(final int[] data) {
		int index = 0;
		int max = data[index];

		for (int ctr = 1; ctr < data.length; ctr++) {
			if (data[ctr] > max) {
				index = ctr;
				max = data[ctr];
			}
		}

		return index;
	}
}
