
package edu.uthscsa.ric.utilities;

public final class BitUtilities {

	private BitUtilities() {}



	/**
	 * Returns the highest one bit index of the specified mask.
	 * 
	 * @param bitMask the bit mask
	 * @return the highest one bit
	 */
	public static int findHighestOneBitIndex(final long bitMask) {
		int highest = 0;

		for (int ctr = 0; ctr < Long.SIZE; ctr++) {
			if (((bitMask >> ctr) & 1) == 1) {
				highest = ctr;
			}
		}

		return highest;
	}



	/**
	 * Returns the needed precision (8, 16, 32, or 64) to hold the specified mask.
	 * 
	 * @param bitMask the bit mask
	 * @return the needed precision (8, 16, 32, or 64)
	 */
	public static int findNeededPrecision(final long bitMask) {
		final int highest = findHighestOneBitIndex(bitMask);

		if (highest < Byte.SIZE) {
			return Byte.SIZE;
		} else if (highest < Short.SIZE) {
			return Short.SIZE;
		} else if (highest < Integer.SIZE) {
			return Integer.SIZE;
		} else {
			return Long.SIZE;
		}
	}



	public static int findNextSetBitIndex(final long mask, final int startIndex) {
		for (int ctr = startIndex; ctr < Long.SIZE; ctr++) {
			if (((mask >>> ctr) & 1L) == 1L) {
				return ctr;
			}
		}

		return -1;
	}
}
