
package edu.uthscsa.ric.volume.formats.dicom.privateheader;

import edu.uthscsa.ric.utilities.ByteUtilities;


// http://nipy.bic.berkeley.edu/nightly/nibabel/doc/dicom/siemens_csa.html
public class Siemens implements PrivateHeader {

	public static final String CSA2_MAGIC_NUMBER = "SV10";
	public static final int NAME_LENGTH = 64;
	public static final int ELEMENT_CSA1 = 0x1010;
	public static final int ELEMENT_CSA2 = 0x1020;
	public static final int GROUP_CSA = 0x029;
	public static final String DESCRIPTION = "Siemens CSA Header";



	@Override
	public String readHeader(final byte[] data) {
		String returnVal = null;

		final String str = new String(data, 0, CSA2_MAGIC_NUMBER.length());
		if (str.equals(CSA2_MAGIC_NUMBER)) {
			returnVal = readHeader(data, CSA2_MAGIC_NUMBER.length() + 4);
		} else {
			returnVal = readHeader(data, 0);
		}

		return returnVal;
	}



	private String readHeader(final byte[] data, final int offsetVal) {
		int offset = offsetVal;
		final StringBuffer sb = new StringBuffer();
		sb.append('\n');

		final int numTags = ByteUtilities.swapInt(data, offset);
		offset += 4;

		offset += 4; // unused

		for (int ctr = 0; ctr < numTags; ctr++) {
			offset = readTag(data, offset, sb);

			if (offset == -1) {
				break;
			}
		}

		return sb.toString();
	}



	private int readItem(final byte[] data, final int offsetVal, final StringBuffer sb) {
		int offset = offsetVal;
		final int itemLength = ByteUtilities.swapInt(data, offset);

		if ((offset + itemLength) > data.length) {
			return -1;
		}

		offset += 16;

		if (itemLength > 0) {
			sb.append((new String(data, offset, itemLength)).trim() + " ");
		}

		return offset + itemLength;
	}



	private int readTag(final byte[] data, final int offsetVal, final StringBuffer sb) {
		int offset = offsetVal;
		final String name = new String(data, offset, NAME_LENGTH).split("\0")[0]; // null-terminated
		offset += NAME_LENGTH;

		offset += 4; // vm

		//		final String vr = (new String(data, offset, 4)).substring(0, 3).trim();
		offset += 4;

		offset += 4; // syngodt

		final int numItems = ByteUtilities.swapInt(data, offset);
		offset += 4;

		offset += 4; // unused

		sb.append("    " + name + "=");

		for (int ctr = 0; ctr < numItems; ctr++) {
			offset = readItem(data, offset, sb);

			if (offset == -1) {
				break;
			} else if ((offset % 4) != 0) {
				offset += (4 - (offset % 4));
			}
		}

		sb.append('\n');

		return offset;
	}



	@Override
	public boolean canRead(final int group, final int element) {
		return (group == GROUP_CSA) && ((element == ELEMENT_CSA1) || (element == ELEMENT_CSA2));
	}



	@Override
	public String getDescription() {
		return DESCRIPTION;
	}
}
