
package edu.uthscsa.ric.volume.formats.dicom.compression;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;


public class CompressedPart {

	private final URI uri;
	private final List<Integer> offsets;
	private final List<Integer> lengths;



	public CompressedPart(final URI uri) {
		this.uri = uri;
		offsets = new ArrayList<Integer>();
		lengths = new ArrayList<Integer>();
	}



	public void addPart(final int offset, final int length) {
		offsets.add(offset);
		lengths.add(length);
	}



	public List<Integer> getOffsets() {
		return offsets;
	}



	public List<Integer> getLengths() {
		return lengths;
	}



	public URI getUri() {
		return uri;
	}



	public static byte[] concatenateCompressedInternalParts(final CompressedPart jpeg, final URI uri) throws IOException {
		InputStream input = null;

		final int[] dataOffsets = CollectionUtilities.arrayInts(jpeg.getOffsets());
		final int[] dataLengths = CollectionUtilities.arrayInts(jpeg.getLengths());

		int totalDataLength = 0;
		for (final int dataLength : dataLengths) {
			totalDataLength += dataLength;
		}

		final byte[] bufferData = new byte[totalDataLength];

		try {
			input = FileUtilities.getInputStream(uri, false);

			int totalDataRead = 0;
			int offset = 0;

			for (int ctr = 0; ctr < dataOffsets.length; ctr++) {
				FileUtilities.skipFully(input, dataOffsets[ctr] - offset);
				FileUtilities.readFully(input, bufferData, totalDataRead, dataLengths[ctr]);

				totalDataRead += dataLengths[ctr];
				offset += ((dataOffsets[ctr] - offset) + dataLengths[ctr]);
			}
		} finally {
			if (input != null) {
				input.close();
			}
		}

		return bufferData;
	}
}
