
package edu.uthscsa.ric.volume.formats.dicom;

public class Tag {

	private final int group;
	private final int elem;
	private final String vr;
	private final String name;



	public Tag(final String group, final String elem, final String name, final String vr) {
		this.group = Integer.parseInt(group, 16);
		this.elem = Integer.parseInt(elem, 16);
		this.vr = vr;
		this.name = name;
	}



	public int getGroup() {
		return group;
	}



	public int getElement() {
		return elem;
	}



	public short getGroupId() {
		return (short) (group & 0xFFFF);
	}



	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = (prime * result) + elem;
		result = (prime * result) + group;
		return result;
	}



	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final Tag other = (Tag) obj;
		if (elem != other.elem) {
			return false;
		}
		if (group != other.group) {
			return false;
		}
		return true;
	}



	public short getElementId() {
		return (short) (elem & 0xFFFF);
	}



	public Long getId() {
		return makeMappableDicomId(this);
	}



	public static long makeMappableDicomId(final Tag tag) {
		final int group = tag.getGroup();
		final int elem = tag.getElement();
		return makeMappableDicomId(group, elem);
	}



	public static long makeMappableDicomId(final int group, final int elem) {
		return ((long) group << 32) | (elem & 0xFFFFFFFL);
	}



	public String getVr() {
		return vr;
	}



	public String getName() {
		return name;
	}



	@Override
	public String toString() {
		return "Tag [group=" + Integer.toHexString(group) + ", elem=" + Integer.toHexString(elem) + ", vr=" + vr + ", name=" + name + "]";
	}
}
