
package edu.uthscsa.ric.volume.formats.dicom;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

import edu.uthscsa.ric.utilities.AppLogger;


public class Dictionary {

	public static final String TAG_FILE = "tags.csv";
	public static final String VR_RAW_DATA = "OB OW UN";
	public static final String VR_TAG = "AT";
	public static final String VR_TEXT = "AE AS CS DA DS DT IS LO LT PN SH ST TM UI UT";
	public static final String VRS_ALL = "AE AS AT CS DA DS DT FL FD IS LO LT OB OD OF OW PN SH SL SS ST TM UI UL UN US UT";
	public static final String VRS_DATA = "OB OW OF SQ UT UN";
	public static final String VR_TYPE_32_FLOAT = "FL";
	public static final String VR_TYPE_16_SIGNED = "SS";
	public static final String VR_TYPE_16_UNSIGNED = "US";
	public static final String VR_TYPE_64_FLOAT = "FD";
	public static final String VR_TYPE_32_SIGNED = "SL";
	public static final String VR_TYPE_32_UNSIGNED = "UL";

	public static final Map<Long, Tag> DICOM_TAG_MAP;
	public static final Map<Long, Object> DICOM_DEFAULT_STRING_MAP = new HashMap<Long, Object>();

	public static final String NONE = "NONE";

	static {
		DICOM_TAG_MAP = new HashMap<Long, Tag>();
		readTags();
	}

	public static final Tag TAG_0002_FILE_META_INFO_VERSION = getTag(0x0002, 0x0001);
	public static final Tag TAG_0002_GROUP_LENGTH = getTag(0x0002, 0x0000);
	public static final Tag TAG_0002_IMPLEMENTATION_CLASS_UID = getTag(0x0002, 0x0012);
	public static final Tag TAG_0002_IMPLEMENTATION_VERSION_NAME = getTag(0x0002, 0x0013);
	public static final Tag TAG_0002_MEDIA_STORED_SOP_CLASS_UID = getTag(0x0002, 0x0002);
	public static final Tag TAG_0002_MEDIA_STORED_SOP_INSTANCE_UID = getTag(0x0002, 0x0003);
	public static final Tag TAG_0002_TRANSFER_SYNTAX_UID = getTag(0x0002, 0x0010);
	public static final Tag TAG_0008_ACCESSION_NUMBER = getTag(0x0008, 0x0050);
	public static final Tag TAG_0008_ACQUISITION_CONTRAST = getTag(0x0008, 0x9209);
	public static final Tag TAG_0008_ACQUISITION_DATETIME = getTag(0x0008, 0x002A);
	public static final Tag TAG_0008_ANATOMIC_REGION_SQ = getTag(0x0008, 0x2218);
	public static final Tag TAG_0008_CODE_MEANING = getTag(0x0008, 0x0104);
	public static final Tag TAG_0008_CODE_VALUE = getTag(0x0008, 0x0100);
	public static final Tag TAG_0008_CODING_SCHEME_DESIGNATOR = getTag(0x0008, 0x0102);
	public static final Tag TAG_0008_COMPLEX_IMAGE_COMP = getTag(0x0008, 0x9208);
	public static final Tag TAG_0008_CONTENT_DATE = getTag(0x0008, 0x0023);
	public static final Tag TAG_0008_CONTENT_TIME = getTag(0x0008, 0x0033);
	public static final Tag TAG_0008_CONVERSION_TYPE = getTag(0x0008, 0x0064);
	public static final Tag TAG_0008_FRAME_TYPE = getTag(0x0008, 0x9007);
	public static final Tag TAG_0008_IMAGE_TYPE = getTag(0x0008, 0x0008);
	public static final Tag TAG_0008_INSTITUTION_NAME = getTag(0x0008, 0x0080);
	public static final Tag TAG_0008_INSTITUTION_ADDRESS = getTag(0x0008, 0x0081);
	public static final Tag TAG_0008_MANUFACTURER = getTag(0x0008, 0x0070);
	public static final Tag TAG_0008_MANUFACTURER_MODEL_NAME = getTag(0x0008, 0x1090);
	public static final Tag TAG_0008_MODALITY = getTag(0x0008, 0x0060);
	public static final Tag TAG_0008_PIXEL_PRESENTATION = getTag(0x0008, 0x9205);
	public static final Tag TAG_0008_REFERRING_PHYSICIAN_NAME = getTag(0x0008, 0x0090);
	public static final Tag TAG_0008_SERIES_DESCRIPTION = getTag(0x0008, 0x103E);
	public static final Tag TAG_0008_SOP_CLASS_UID = getTag(0x0008, 0x0016);
	public static final Tag TAG_0008_SOP_INSTANCE_UID = getTag(0x0008, 0x0018);
	public static final Tag TAG_0008_STUDY_DATE = getTag(0x0008, 0x0020);
	public static final Tag TAG_0008_STUDY_DESCRIPTION = getTag(0x0008, 0x1030);
	public static final Tag TAG_0008_STUDY_TIME = getTag(0x0008, 0x0030);
	public static final Tag TAG_0008_VOLUMETRIC_PROPERTIES = getTag(0x0008, 0x9206);
	public static final Tag TAG_0008_VOLUME_BASED_CALCULATION_TECH = getTag(0x0008, 0x9207);
	public static final Tag TAG_0010_PATIENT_BIRTH_DATE = getTag(0x0010, 0x0030);
	public static final Tag TAG_0010_PATIENT_ID = getTag(0x0010, 0x0020);
	public static final Tag TAG_0010_PATIENT_NAME = getTag(0x0010, 0x0010);
	public static final Tag TAG_0010_PATIENT_SEX = getTag(0x0010, 0x0040);
	public static final Tag TAG_0010_PATIENT_OTHER_ID = getTag(0x0010, 0x1000);
	public static final Tag TAG_0010_PATIENT_OTHER_NAMES = getTag(0x0010, 0x1001);
	public static final Tag TAG_0010_PATIENT_BIRTH_NAME = getTag(0x0010, 0x1005);
	public static final Tag TAG_0010_PATIENT_ADDRESS = getTag(0x0010, 0x1040);
	public static final Tag TAG_0010_PATIENT_WEIGHT = getTag(0x0010, 0x1030);
	public static final Tag TAG_0018_ACQUISITION_DURATION = getTag(0x0018, 0x9073);
	public static final Tag TAG_0018_ACQUISITION_START_CONDITON = getTag(0x0018, 0x0073);
	public static final Tag TAG_0018_ACQUISITION_TERM_CONDITON = getTag(0x0018, 0x0071);
	public static final Tag TAG_0018_APPLICABLE_SAFETY_STANDARD_AGENCY = getTag(0x0018, 0x9174);
	public static final Tag TAG_0018_ATTENUATION_CORRECTED = getTag(0x0018, 0x9759);
	public static final Tag TAG_0018_AXIAL_DETECTOR_DIMENSION = getTag(0x0018, 0x9727);
	public static final Tag TAG_0018_BLOOD_SIGNAL_NULLING = getTag(0x0018, 0x9022);
	public static final Tag TAG_0018_COLLIMATOR_TYPE = getTag(0x0018, 0x1181);
	public static final Tag TAG_0018_CONTENT_QUALIFICATION = getTag(0x0018, 0x9004);
	public static final Tag TAG_0018_COUNT_LOSS_NORMALIZATION_CORRECTED = getTag(0x0018, 0x9764);
	public static final Tag TAG_0018_COVERAGE_OF_K_SPACE = getTag(0x0018, 0x9094);
	public static final Tag TAG_0018_DATA_COLLECTION_CENTER_PATIENT = getTag(0x0018, 0x9313);
	public static final Tag TAG_0018_DATA_COLLECTION_DIAMETER = getTag(0x0018, 0x0090);
	public static final Tag TAG_0018_DEAD_TIME_CORRECTED = getTag(0x0018, 0x9761);
	public static final Tag TAG_0018_DECAY_CORRECTED = getTag(0x0018, 0x9758);
	public static final Tag TAG_0018_DETECTOR_GEOMETRY = getTag(0x0018, 0x9725);
	public static final Tag TAG_0018_DETECTOR_NORMALIZATION_CORRECTION = getTag(0x0018, 0x9768);
	public static final Tag TAG_0018_DEVICE_SERIAL_NUMBER = getTag(0x0018, 0x1000);
	public static final Tag TAG_0018_DIFFUSION_ANISOTROPY_TYPE = getTag(0x0018, 0x9147);
	public static final Tag TAG_0018_DIFFUSION_B_VALUE = getTag(0x0018, 0x9087);
	public static final Tag TAG_0018_DIFFUSION_DIRECTIONALITY = getTag(0x0018, 0x9075);
	public static final Tag TAG_0018_ECHO_PLANAR_PULSE_SEQUENCE = getTag(0x0018, 0x9018);
	public static final Tag TAG_0018_ECHO_PULSE_SEQUENCE = getTag(0x0018, 0x9008);
	public static final Tag TAG_0018_ECHO_TIME = getTag(0x0018, 0x0081);
	public static final Tag TAG_0018_ECHO_TRAIN_LENGTH = getTag(0x0018, 0x0091);
	public static final Tag TAG_0018_EFFECTIVE_ECHO_TIME = getTag(0x0018, 0x9082);
	public static final Tag TAG_0018_FLIP_ANGLE = getTag(0x0018, 0x1314);
	public static final Tag TAG_0018_FLOW_COMPENSATION = getTag(0x0018, 0x9010);
	public static final Tag TAG_0018_GANTRY_DETECTOR_SLEW = getTag(0x0018, 0x1121);
	public static final Tag TAG_0018_GANTRY_DETECTOR_TILT = getTag(0x0018, 0x1120);
	public static final Tag TAG_0018_GANTRY_MOTION_CORRECTED = getTag(0x0018, 0x9762);
	public static final Tag TAG_0018_GEOMETRY_K_SPACE_TRAVERSAL = getTag(0x0018, 0x9032);
	public static final Tag TAG_0018_GRADIENT_ECHO_TRAIN_LENGTH = getTag(0x0018, 0x9241);
	public static final Tag TAG_0018_IMAGED_NUCLEUS = getTag(0x0018, 0x0085);
	public static final Tag TAG_0018_IMAGING_FREQUENCY = getTag(0x0018, 0x0084);
	public static final Tag TAG_0018_INVERSION_RECOVERY = getTag(0x0018, 0x9009);
	public static final Tag TAG_0018_INVERSION_TIME = getTag(0x0018, 0x0082);
	public static final Tag TAG_0018_ITERATIVE_RECONSTRUCTION_METHOD = getTag(0x0018, 0x9769);
	public static final Tag TAG_0018_K_SPACE_FILTERING = getTag(0x0018, 0x9064);
	public static final Tag TAG_0018_MAGNETIC_FIELD_STRENGTH = getTag(0x0018, 0x0087);
	public static final Tag TAG_0018_MAGNETIZATION_TRANSFER = getTag(0x0018, 0x9020);
	public static final Tag TAG_0018_MR_ACQUISITION_TYPE = getTag(0x0018, 0x0023);
	public static final Tag TAG_0018_MR_AVERAGES_SEQ = getTag(0x0018, 0x9119);
	public static final Tag TAG_0018_MR_DIFFUSION_SEQ = getTag(0x0018, 0x9117);
	public static final Tag TAG_0018_MR_ECHO_SEQ = getTag(0x0018, 0x9114);
	public static final Tag TAG_0018_MR_IMAGE_FRAME_TYPE_SEQ = getTag(0x0018, 0x9226);
	public static final Tag TAG_0018_MR_IMAGING_MODIFIER_SEQ = getTag(0x0018, 0x9006);
	public static final Tag TAG_0018_MR_MODIFIER_SEQ = getTag(0x0018, 0x9115);
	public static final Tag TAG_0018_MR_RECEIVE_COIL_SEQ = getTag(0x0018, 0x9042);
	public static final Tag TAG_0018_MR_TIMING_SEQ = getTag(0x0018, 0x9112);
	public static final Tag TAG_0018_MR_TRANSMIT_COIL_SEQUENCE = getTag(0x0018, 0x9049);
	public static final Tag TAG_0018_MULTIPLE_SPIN_ECHO = getTag(0x0018, 0x9011);
	public static final Tag TAG_0018_MULTI_PLANAR_EXCITATION = getTag(0x0018, 0x9012);
	public static final Tag TAG_0018_NONUNIFORM_RADIO_SAMPLING_CORRECTED = getTag(0x0018, 0x9766);
	public static final Tag TAG_0018_NUMBER_K_SPACE_TRAJECTORIES = getTag(0x0018, 0x9093);
	public static final Tag TAG_0018_NUM_AVERAGES = getTag(0x0018, 0x0083);
	public static final Tag TAG_0018_OPERATING_MODE = getTag(0x0018, 0x9178);
	public static final Tag TAG_0018_OPERATING_MODE_SEQ = getTag(0x0018, 0x9176);
	public static final Tag TAG_0018_OPERATING_MODE_TYPE = getTag(0x0018, 0x9177);
	public static final Tag TAG_0018_OVERSAMPLING_PHASE = getTag(0x0018, 0x9029);
	public static final Tag TAG_0018_PARALLEL_ACQUSITION = getTag(0x0018, 0x9077);
	public static final Tag TAG_0018_PARTIAL_FOURIER = getTag(0x0018, 0x9081);
	public static final Tag TAG_0018_PATIENT_MOTION_CORRECTED = getTag(0x0018, 0x9763);
	public static final Tag TAG_0018_PATIENT_POSITION = getTag(0x0018, 0x5100);
	public static final Tag TAG_0018_PET_FRAME_ACQUISITION_SQ = getTag(0x0018, 0x9732);
	public static final Tag TAG_0018_PET_FRAME_CORRECTION_FACTORS_SQ = getTag(0x0018, 0x9736);
	public static final Tag TAG_0018_PET_FRAME_TYPE_SQ = getTag(0x0018, 0x9751);
	public static final Tag TAG_0018_PET_POSITION_SQ = getTag(0x0018, 0x9735);
	public static final Tag TAG_0018_PET_RECONSTRUCTION_SQ = getTag(0x0018, 0x9749);
	public static final Tag TAG_0018_PHASE_CONTRAST = getTag(0x0018, 0x9014);
	public static final Tag TAG_0018_PIXEL_BANDWIDTH = getTag(0x0018, 0x0095);
	public static final Tag TAG_0018_PULSE_SEQUENCE_NAME = getTag(0x0018, 0x9005);
	public static final Tag TAG_0018_QUADRATURE_RECEIVE_COIL = getTag(0x0018, 0x9044);
	public static final Tag TAG_0018_RADIONUCLIDE_HALF_LIFE = getTag(0x0018, 0x1075);
	public static final Tag TAG_0018_RADIONUCLIDE_POSITRON_FRACTION = getTag(0x0018, 0x1076);
	public static final Tag TAG_0018_RADIONUCLIDE_TOTAL_DOSE = getTag(0x0018, 0x1074);
	public static final Tag TAG_0018_RADIOPHARMA_AGENT_NUMBER = getTag(0x0018, 0x9729);
	public static final Tag TAG_0018_RADIOPHARMA_START_TIME = getTag(0x0018, 0x1078);
	public static final Tag TAG_0018_RADIOPHARMA_USAGE_SQ = getTag(0x0018, 0x9737);
	public static final Tag TAG_0018_RANDOMS_CORRECTED = getTag(0x0018, 0x9765);
	public static final Tag TAG_0018_RECEIVE_COIL_NAME = getTag(0x0018, 0x1250);
	public static final Tag TAG_0018_RECIEVE_COIL_MANUFACTURER_NAME = getTag(0x0018, 0x9041);
	public static final Tag TAG_0018_RECIEVE_COIL_TYPE = getTag(0x0018, 0x9043);
	public static final Tag TAG_0018_RECONSTRUCTION_ALGORITHM = getTag(0x0018, 0x9315);
	public static final Tag TAG_0018_RECONSTRUCTION_DIAMETER = getTag(0x0018, 0x1100);
	public static final Tag TAG_0018_RECONSTRUCTION_TYPE = getTag(0x0018, 0x9756);
	public static final Tag TAG_0018_RECONSTUCTION_TARGET_CENTER_PATIENT = getTag(0x0018, 0x9318);
	public static final Tag TAG_0018_REPETITION_TIME = getTag(0x0018, 0x0080);
	public static final Tag TAG_0018_RESONANT_NUCLEUS = getTag(0x0018, 0x9100);
	public static final Tag TAG_0018_RF_ECHO_TRAIN_LENGTH = getTag(0x0018, 0x9240);
	public static final Tag TAG_0018_SATURATION_RECOVERY = getTag(0x0018, 0x9024);
	public static final Tag TAG_0018_SCATTER_CORRECTED = getTag(0x0018, 0x9760);
	public static final Tag TAG_0018_SEGMENTED_K_SPACE_TRAVERSAL = getTag(0x0018, 0x9033);
	public static final Tag TAG_0018_SENSITIVITY_CALIBRATED = getTag(0x0018, 0x9767);
	public static final Tag TAG_0018_SLICE_LOCATION_VECTOR = getTag(0x0018, 0x2005);
	public static final Tag TAG_0018_SLICE_THICKNESS = getTag(0x0018, 0x0050);
	public static final Tag TAG_0018_SOFTWARE_VERIONS = getTag(0x0018, 0x1020);
	public static final Tag TAG_0018_SPATIAL_PRESATURATION = getTag(0x0018, 0x9027);
	public static final Tag TAG_0018_SPECIFIC_ABSORPTION_RATE_DEF = getTag(0x0018, 0x9179);
	public static final Tag TAG_0018_SPECIFIC_ABSORPTION_RATE_SEQ = getTag(0x0018, 0x9239);
	public static final Tag TAG_0018_SPECIFIC_ABSORPTION_RATE_VALUE = getTag(0x0018, 0x9181);
	public static final Tag TAG_0018_SPECTRALLY_SELECTED_EXCITATION = getTag(0x0018, 0x9026);
	public static final Tag TAG_0018_SPECTRALLY_SELECTED_SUPPRESSION = getTag(0x0018, 0x9025);
	public static final Tag TAG_0018_STEADY_STATE_PULSE_SEQUENCE = getTag(0x0018, 0x9017);
	public static final Tag TAG_0018_T2_PREPARATION = getTag(0x0018, 0x9021);
	public static final Tag TAG_0018_TABLE_HIEGHT = getTag(0x0018, 0x1130);
	public static final Tag TAG_0018_TABLE_MOTION = getTag(0x0018, 0x1134);
	public static final Tag TAG_0018_TABLE_POSITION = getTag(0x0018, 0x9327);
	public static final Tag TAG_0018_TAGGING = getTag(0x0018, 0x9028);
	public static final Tag TAG_0018_TIME_OF_FLIGHT = getTag(0x0018, 0x9015);
	public static final Tag TAG_0018_TIME_OF_FLIGHT_INFO_USED = getTag(0x0018, 0x9755);
	public static final Tag TAG_0018_TRANSMITTER_FREQ = getTag(0x0018, 0x9098);
	public static final Tag TAG_0018_TRANSMIT_COIL_MANUFACTURER_NAME = getTag(0x0018, 0x9050);
	public static final Tag TAG_0018_TRANSMIT_COIL_TYPE = getTag(0x0018, 0x9051);
	public static final Tag TAG_0018_TRANSVERSE_DETECTION_SEPARATION = getTag(0x0018, 0x9726);
	public static final Tag TAG_0018_TRASMIT_COIL_NAME = getTag(0x0018, 0x1251);
	public static final Tag TAG_0020_DIMENSION_INDEX_POINTER = getTag(0x0020, 0x9165);
	public static final Tag TAG_0020_DIMENSION_INDEX_SQ = getTag(0x0020, 0x9222);
	public static final Tag TAG_0020_DIMENSION_INDEX_VALUES = getTag(0x0020, 0x9157);
	public static final Tag TAG_0020_DIMENSION_ORGANIZATION_ID = getTag(0x0020, 0x9164);
	public static final Tag TAG_0020_DIMENSION_ORGANIZATION_SQ = getTag(0x0020, 0x9221);
	public static final Tag TAG_0020_FRAME_ANATOMY_SQ = getTag(0x0020, 0x9071);
	public static final Tag TAG_0020_FRAME_CONTENT_SQ = getTag(0x0020, 0x9111);
	public static final Tag TAG_0020_FRAME_LATERALITY = getTag(0x0020, 0x9072);
	public static final Tag TAG_0020_FRAME_OF_REF_ID = getTag(0x0020, 0x0052);
	public static final Tag TAG_0020_FUNCTIONAL_GROUP_POINTER = getTag(0x0020, 0x9167);
	public static final Tag TAG_0020_IMAGE_LATERALITY = getTag(0x0020, 0x0062);
	public static final Tag TAG_0020_IMAGE_NUMBER = getTag(0x0020, 0x0013);
	public static final Tag TAG_0020_IMAGE_ORIENTATION = getTag(0x0020, 0x0037);
	public static final Tag TAG_0020_IMAGE_POSITION = getTag(0x0020, 0x0032);
	public static final Tag TAG_0020_IN_STACK_POSITION = getTag(0x0020, 0x9057);
	public static final Tag TAG_0020_PATIENT_ORIENTATION = getTag(0x0020, 0x0020);
	public static final Tag TAG_0020_PLANE_ORIENTATION_SQ = getTag(0x0020, 0x9116);
	public static final Tag TAG_0020_PLANE_POSITION_SQ = getTag(0x0020, 0x9113);
	public static final Tag TAG_0020_POS_REF_INDICATOR = getTag(0x0020, 0x1040);
	public static final Tag TAG_0020_SERIES_ID = getTag(0x0020, 0x0011);
	public static final Tag TAG_0020_SERIES_INSTANCE_ID = getTag(0x0020, 0x000E);
	public static final Tag TAG_0020_STACK_ID = getTag(0x0020, 0x9056);
	public static final Tag TAG_0020_STUDY_ID = getTag(0x0020, 0x0010);
	public static final Tag TAG_0020_STUDY_INSTANCE_ID = getTag(0x0020, 0x000D);
	public static final Tag TAG_0020_TEMPORAL_POSITION_INDEX = getTag(0x0020, 0x9128);
	public static final Tag TAG_0028_BITS_ALLOCATED = getTag(0x0028, 0x0100);
	public static final Tag TAG_0028_BITS_STORED = getTag(0x0028, 0x0101);
	public static final Tag TAG_0028_BURNED_IN_ANNOTATION = getTag(0x0028, 0x0301);
	public static final Tag TAG_0028_COLUMNS = getTag(0x0028, 0x0011);
	public static final Tag TAG_0028_FRAME_INCREMENT_POINTER = getTag(0x0028, 0x0009);
	public static final Tag TAG_0028_FRAME_VOI_LUT_SQ = getTag(0x0028, 0x9132);
	public static final Tag TAG_0028_HIGH_BIT = getTag(0x0028, 0x0102);
	public static final Tag TAG_0028_LARGEST_IMAGE_PIXEL_VALUE = getTag(0x0028, 0x0107);
	public static final Tag TAG_0028_LARGEST_SERIES_PIXEL_VALUE = getTag(0x0028, 0x0109);
	public static final Tag TAG_0028_LOSSY_IMAGE_COMPRESSION = getTag(0x0028, 0x2110);
	public static final Tag TAG_0028_LUT_EXPLANATION = getTag(0x0028, 0x3003);
	public static final Tag TAG_0028_NUMBER_OF_FRAMES = getTag(0x0028, 0x0008);
	public static final Tag TAG_0028_PHOTOMETRIC_INTERP = getTag(0x0028, 0x0004);
	public static final Tag TAG_0028_PIXEL_MEASURES_SQ = getTag(0x0028, 0x9110);
	public static final Tag TAG_0028_PIXEL_REP = getTag(0x0028, 0x0103);
	public static final Tag TAG_0028_PIXEL_SPACING = getTag(0x0028, 0x0030);
	public static final Tag TAG_0028_PIXEL_TRANSFORMATION_SQ = getTag(0x0028, 0x9145);
	public static final Tag TAG_0028_RESCALE_INTERCEPT = getTag(0x0028, 0x1052);
	public static final Tag TAG_0028_RESCALE_SLOPE = getTag(0x0028, 0x1053);
	public static final Tag TAG_0028_RESCALE_TYPE = getTag(0x0028, 0x1054);
	public static final Tag TAG_0028_ROWS = getTag(0x0028, 0x0010);
	public static final Tag TAG_0028_SAMPLES_PER_PIXEL = getTag(0x0028, 0x0002);
	public static final Tag TAG_0028_SMALLEST_IMAGE_PIXEL_VALUE = getTag(0x0028, 0x0106);
	public static final Tag TAG_0028_SMALLEST_SERIES_PIXEL_VALUE = getTag(0x0028, 0x0108);
	public static final Tag TAG_0028_WINDOW_CENTER = getTag(0x0028, 0x1050);
	public static final Tag TAG_0028_WINDOW_WIDTH = getTag(0x0028, 0x1051);
	public static final Tag TAG_0040_ACQUISITION_CONTEXT_SQ = getTag(0x0040, 0x0555);
	public static final Tag TAG_0040_LUT_LABEL = getTag(0x0040, 0x9210);
	public static final Tag TAG_0040_MEASUREMENT_UNITS_CODE_SQ = getTag(0x0040, 0x08EA);
	public static final Tag TAG_0040_REAL_WORLD_FIRST_VALUE_MAPPED = getTag(0x0040, 0x9216);
	public static final Tag TAG_0040_REAL_WORLD_LAST_VALUE_MAPPED = getTag(0x0040, 0x9211);
	public static final Tag TAG_0040_REAL_WORLD_MAPPING_SQ = getTag(0x0040, 0x9096);
	public static final Tag TAG_0040_REAL_WORLD_VALUE_INTERCEPT = getTag(0x0040, 0x9224);
	public static final Tag TAG_0040_REAL_WORLD_VALUE_SLOPE = getTag(0x0040, 0x9225);
	public static final Tag TAG_0054_ADMINISTRATION_ROUTE_CODE_SQ = getTag(0x0054, 0x0302);
	public static final Tag TAG_0054_COINCIDENCE_WINDOW_WIDTH = getTag(0x0054, 0x1210);
	public static final Tag TAG_0054_COUNTS_SOURCE = getTag(0x0054, 0x1002);
	public static final Tag TAG_0054_DEAD_TIME_FACTOR = getTag(0x0054, 0x1324);
	public static final Tag TAG_0054_ENERGY_WINDOW_LOWER_LIMIT = getTag(0x0054, 0x0014);
	public static final Tag TAG_0054_ENERGY_WINDOW_RANGE_SQ = getTag(0x0054, 0x0013);
	public static final Tag TAG_0054_ENERGY_WINDOW_UPPER_LIMIT = getTag(0x0054, 0x0015);
	public static final Tag TAG_0054_PRIMARY_COUNTS_ACCUMULATED = getTag(0x0054, 0x1310);
	public static final Tag TAG_0054_RADIONUCLIDE_CODE_SQ = getTag(0x0054, 0x0300);
	public static final Tag TAG_0054_RADIOPHARMA_CODE_SQ = getTag(0x0054, 0x0304);
	public static final Tag TAG_0054_RADIOPHARMA_INFORMATION_SQ = getTag(0x0054, 0x0016);
	public static final Tag TAG_0054_SCATTER_FRACTION_FACTOR = getTag(0x0054, 0x1323);
	public static final Tag TAG_0054_SLICE_SENSITIVITY_FACTOR = getTag(0x0054, 0x1320);
	public static final Tag TAG_0054_TYPE_OF_DETECTOR_MOTION = getTag(0x0054, 0x0202);
	public static final Tag TAG_0054_VIEW_CODE_SQ = getTag(0x0054, 0x0220);
	public static final Tag TAG_2050_PRESENTATION_LUT_SHAPE = getTag(0x2050, 0x0020);
	public static final Tag TAG_5200_PER_FRAME_FUNCTIONAL_GROUPS_SQ = getTag(0x5200, 0x9230);
	public static final Tag TAG_5200_SHARED_FUNCTIONAL_GROUPS_SQ = getTag(0x5200, 0x9229);
	public static final Tag TAG_PIXEL_DATA = getTag(0x7FE0, 0x0010);

	static {
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_FLOW_COMPENSATION), NONE);
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0020_FRAME_LATERALITY), "U");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0008_COMPLEX_IMAGE_COMP), "MAGNITUDE");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_INVERSION_RECOVERY), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_PARTIAL_FOURIER), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0028_PHOTOMETRIC_INTERP), "MONOCHROME2");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0008_PIXEL_PRESENTATION), "MONOCHROME");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_SPATIAL_PRESATURATION), NONE);
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_SPECTRALLY_SELECTED_EXCITATION), NONE);
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_T2_PREPARATION), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0008_VOLUMETRIC_PROPERTIES), "VOLUME");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0008_VOLUME_BASED_CALCULATION_TECH), "VOLUME_RENDER");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_PARALLEL_ACQUSITION), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_MAGNETIZATION_TRANSFER), NONE);
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_BLOOD_SIGNAL_NULLING), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_TAGGING), NONE);
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_RECIEVE_COIL_TYPE), "VOLUME");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_QUADRATURE_RECEIVE_COIL), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_DIFFUSION_DIRECTIONALITY), "ISOTROPIC");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_CONTENT_QUALIFICATION), "RESEARCH");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_K_SPACE_FILTERING), NONE);
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0028_BURNED_IN_ANNOTATION), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_2050_PRESENTATION_LUT_SHAPE), "IDENTITY");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_TRANSMIT_COIL_TYPE), "VOLUME");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_MR_ACQUISITION_TYPE), "3D");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_MULTI_PLANAR_EXCITATION), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_PHASE_CONTRAST), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_TIME_OF_FLIGHT), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_STEADY_STATE_PULSE_SEQUENCE), NONE);
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_ECHO_PLANAR_PULSE_SEQUENCE), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_SATURATION_RECOVERY), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_SPECTRALLY_SELECTED_SUPPRESSION), NONE);
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_OVERSAMPLING_PHASE), NONE);
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_ECHO_PULSE_SEQUENCE), "BOTH");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_MULTIPLE_SPIN_ECHO), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_SEGMENTED_K_SPACE_TRAVERSAL), "FULL");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_ATTENUATION_CORRECTED), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_SCATTER_CORRECTED), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0054_COUNTS_SOURCE), "EMISSION");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_DECAY_CORRECTED), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_DEAD_TIME_CORRECTED), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_GANTRY_MOTION_CORRECTED), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_PATIENT_MOTION_CORRECTED), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_COUNT_LOSS_NORMALIZATION_CORRECTED), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_RANDOMS_CORRECTED), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_NONUNIFORM_RADIO_SAMPLING_CORRECTED), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_SENSITIVITY_CALIBRATED), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_DETECTOR_NORMALIZATION_CORRECTION), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_TABLE_MOTION), "STATIC");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_TIME_OF_FLIGHT_INFO_USED), "FALSE");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_COLLIMATOR_TYPE), NONE);
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_DETECTOR_GEOMETRY), "CYLINDRICAL_RING");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0054_TYPE_OF_DETECTOR_MOTION), "STATIONARY");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_ACQUISITION_TERM_CONDITON), "MANU");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_ACQUISITION_START_CONDITON), "MANU");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_RADIOPHARMA_AGENT_NUMBER), 1);
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_ITERATIVE_RECONSTRUCTION_METHOD), "NO");
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_RECONSTUCTION_TARGET_CENTER_PATIENT), new double[] { 0, 0, 0 });
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0018_DATA_COLLECTION_CENTER_PATIENT), new double[] { 0, 0, 0 });
		DICOM_DEFAULT_STRING_MAP.put(Tag.makeMappableDicomId(TAG_0020_IMAGE_LATERALITY), "B");
	}



	protected static String getDescription(final int group, final int element) {
		String des = null;
		final Tag tag = getTag(group & 0xFFFF, element & 0xFFFF);
		if (tag != null) {
			des = tag.getName();
		}

		return des;
	}



	protected static String getVR(final int group, final int element) {
		String vr = null;
		final Tag tag = getTag(group & 0xFFFF, element & 0xFFFF);
		if (tag != null) {
			vr = tag.getVr();
		}

		return vr;
	}



	protected static Tag getTag(final int group, final int elem) {
		final long id = Tag.makeMappableDicomId(group & 0xFFFF, elem & 0xFFFF);
		return DICOM_TAG_MAP.get(id);
	}



	private static void readTags() {
		BufferedReader br = null;
		try {
			br = new BufferedReader(new InputStreamReader(DICOM.class.getResourceAsStream(TAG_FILE)));
			String line;
			while ((line = br.readLine()) != null) {
				final String[] parts = line.split(",");
				final Tag tag = new Tag(parts[0], parts[1], parts[2], parts[3]);
				DICOM_TAG_MAP.put(tag.getId(), tag);
			}
		} catch (final FileNotFoundException ex) {
			AppLogger.error(ex);
		} catch (final IOException ex) {
			AppLogger.error(ex);
		} finally {
			try {
				if (br != null) {
					br.close();
				}
			} catch (final IOException ex) {
				AppLogger.error(ex);
			}
		}
	}
}
