
package edu.uthscsa.ric.volume.formats.dicom;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;


public final class DICOMInputStream extends BufferedInputStream {

	private long pos = 0;
	private long mark = 0;



	public DICOMInputStream(final InputStream in) {
		super(in);
	}



	public synchronized long getPosition() {
		return pos;
	}



	@Override
	public synchronized int read() throws IOException {
		final int val = super.read();
		if (val >= 0) {
			pos += 1;
		}

		return val;
	}



	@Override
	public synchronized int read(final byte[] b, final int off, final int len) throws IOException {
		final int bytesRead = super.read(b, off, len);
		if (bytesRead > 0) {
			pos += bytesRead;
		}

		return bytesRead;
	}



	@Override
	public synchronized long skip(final long skip) throws IOException {
		final long bytesSkipped = super.skip(skip);
		if (bytesSkipped > 0) {
			pos += bytesSkipped;
		}

		return bytesSkipped;
	}



	@Override
	public synchronized void mark(final int readlimit) {
		super.mark(readlimit);
		mark = pos;
	}



	@Override
	public synchronized void reset() throws IOException {
		super.reset();
		pos = mark;
	}
}
