
package edu.uthscsa.ric.volume.formats.dicom;

import java.io.Serializable;
import java.util.Comparator;

import edu.uthscsa.ric.utilities.StringUtilities;


public class DICOMComparator implements Comparator<Item>, Serializable {

	private static final long serialVersionUID = 1L;



	@Override
	public int compare(final Item itemA, final Item itemB) {
		final String groupA = StringUtilities.makeNiceHexString((short) itemA.getGroup());
		final String groupB = StringUtilities.makeNiceHexString((short) itemB.getGroup());

		final String elemA = StringUtilities.makeNiceHexString((short) itemA.getElement());
		final String elemB = StringUtilities.makeNiceHexString((short) itemB.getElement());

		if (groupA.compareTo(groupB) != 0) {
			return groupA.compareTo(groupB);
		} else {
			if (elemA.compareTo(elemB) != 0) {
				return elemA.compareTo(elemB);
			}
		}

		return 0;
	}



	@Override
	public boolean equals(final Object ob) {
		return (ob instanceof DICOMComparator);
	}
}
