
package edu.uthscsa.ric.volume.formats.dicom;

import java.util.HashMap;
import java.util.Map;


public class Constants {

	public static final Map<String, String> SOP_CLASS_DEFINITIONS = new HashMap<String, String>();

	public static final Map<String, String> TRANSFER_SYNTAX_DEFINITIONS = new HashMap<String, String>();

	public static final String TRANSFER_SYNTAX_ID_COMPRESSION_JPEG_12BIT = "1.2.840.10008.1.2.4.51";
	public static final String TRANSFER_SYNTAX_ID_COMPRESSION_JPEG_2000 = "1.2.840.10008.1.2.4.91";
	public static final String TRANSFER_SYNTAX_ID_COMPRESSION_JPEG_2000_LOSSLESS = "1.2.840.10008.1.2.4.90";
	public static final String TRANSFER_SYNTAX_ID_COMPRESSION_JPEG_8BIT = "1.2.840.10008.1.2.4.50";
	public static final String TRANSFER_SYNTAX_ID_COMPRESSION_JPEG_LOSSLESS = "1.2.840.10008.1.2.4.57";
	public static final String TRANSFER_SYNTAX_ID_COMPRESSION_JPEG_LOSSLESS_SEL1 = "1.2.840.10008.1.2.4.70";
	public static final String TRANSFER_SYNTAX_ID_COMPRESSION_JPEG_LS = "1.2.840.10008.1.2.4.81";
	public static final String TRANSFER_SYNTAX_ID_COMPRESSION_JPEG_LS_LOSSLESS = "1.2.840.10008.1.2.4.80";
	public static final String TRANSFER_SYNTAX_ID_COMPRESSION_JPEG_PREFIX = "1.2.840.10008.1.2.4";
	public static final String TRANSFER_SYNTAX_ID_COMPRESSION_RLE = "1.2.840.10008.1.2.5";
	public static final String TRANSFER_SYNTAX_ID_EXPLICIT_BIG = "1.2.840.10008.1.2.2";
	public static final String TRANSFER_SYNTAX_ID_EXPLICIT_LITTLE = "1.2.840.10008.1.2.1";
	public static final String TRANSFER_SYNTAX_ID_IMPLICIT = "1.2.840.10008.1.2";

	static {
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2", "Implicit VR Endian");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.1", "Explicit VR Little Endian");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.1.99", "Deflated Explicit VR Little Endian");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.2", "Explicit VR Big Endian");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.50", "JPEG Baseline (Process 1)");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.51", "JPEG Baseline (Processes 2 & 4)");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.52", "JPEG Extended (Processes 3 & 5)");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.53", "JPEG Spectral Selection, Nonhierarchical (Processes 6 & 8)");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.54", "JPEG Spectral Selection, Nonhierarchical (Processes 7 & 9)");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.55", "JPEG Full Progression, Nonhierarchical (Processes 10 & 12)");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.56", "JPEG Full Progression, Nonhierarchical (Processes 11 & 13)");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.57", "JPEG Lossless, Nonhierarchical (Processes 14)");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.58", "JPEG Lossless, Nonhierarchical (Processes 15)");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.59", "JPEG Extended, Hierarchical (Processes 16 & 18)");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.60", "JPEG Extended, Hierarchical (Processes 17 & 19)");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.61", "JPEG Spectral Selection, Hierarchical (Processes 20 & 22)");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.62", "JPEG Spectral Selection, Hierarchical (Processes 21 & 23)");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.63", "	JPEG Full Progression, Hierarchical (Processes 24 & 26)");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.64", "JPEG Full Progression, Hierarchical (Processes 25 & 27)");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.65", "JPEG Lossless, Nonhierarchical (Process 28)");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.66", "JPEG Lossless, Nonhierarchical (Process 29)");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.70", "JPEG Lossless, Nonhierarchical (Processes 14 [Selection Value 1])");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.80", "JPEG-LS Lossless Image Compression");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.81", "JPEG-LS Lossy (Near-Lossless) Image Compression");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.90", "JPEG 2000 Image Compression (Lossless Only)");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.91", "JPEG 2000 Image Compression");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.92", "JPEG 2000 Part 2 Multicomponent Image Compression (Lossless Only)");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.93", "JPEG 2000 Part 2 Multicomponent Image Compression");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.94	", "JPIP Referenced");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.95", "JPIP Referenced Deflate");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.5", "RLE Lossless");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.6.1", "RFC 2557 MIME Encapsulation");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.100", "MPEG2 Main Profile Main Level");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.102", "MPEG-4 AVC/H.264 High Profile / Level 4.1");
		TRANSFER_SYNTAX_DEFINITIONS.put("1.2.840.10008.1.2.4.103", "MPEG-4 AVC/H.264 BD-compatible High Profile / Level 4.1");

		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.1.1", "Verification");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.1.20.1", "Storage Commitment Push Model");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.1.20.2", "Storage Commitment Pull Model");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.1.3.10", "Media Storage Directory Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.1.40", "Procedural Event Logging");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.1.9", "Basic Study Content Notification");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.3.1.2.1.1", "Detached Patient Management");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.3.1.2.1.4", "Detached Patient Management Meta");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.3.1.2.2.1", "Detached Visit Management");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.3.1.2.3.1", "Detached Study Management");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.3.1.2.3.2", "Study Component Management");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.3.1.2.3.3", "Modality Performed Procedure Step");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.3.1.2.3.4", "Modality Performed Procedure Step Retrieve");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.3.1.2.3.5", "Modality Performed Procedure Step Notification");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.3.1.2.5.1", "Detached Results Management");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.3.1.2.5.4", "Detached Results Management Meta");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.3.1.2.5.5", "Detached Study Management Meta");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.3.1.2.6.1", "Detached Interpretation Management");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.4.2", "Storage Service Class");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.1", "Basic Film Session");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.14", "Print Job");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.15", "Basic Annotation Box");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.16", "Printer");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.16.376", "Printer Configuration Retrieval");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.18", "Basic Color Print Management Meta");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.18.1", "Referenced Color Print Management Meta");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.2", "Basic Film Box");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.22", "VOI LUT Box");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.23", "Presentation LUT");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.24", "Image Overlay Box");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.24.1", "Basic Print Image Overlay Box");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.26", "Print Queue Management");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.27", "Stored Print Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.29", "Hardcopy Grayscale Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.30", "Hardcopy Color Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.31", "Pull Print Request");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.32", "Pull Stored Print Management Meta");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.33", "Media Creation Management UID");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.4", "Basic Grayscale Image Box");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.4.1", "Basic Color Image Box");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.4.2", "Referenced Image Box");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.9", "Basic Grayscale Print Management Meta");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.1.9.1", "Referenced Grayscale Print Management Meta");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.1", "CR Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.1.1", "Digital X-Ray Image Storage – for Presentation");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.1.1.1", "Digital X-Ray Image Storage – for Processing");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.1.2", "Digital Mammography X-Ray Image Storage – for Presentation");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.1.2.1", "Digital Mammography X-Ray Image Storage – for Processing");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.1.3", "Digital Intra – oral X-Ray Image Storage – for Presentation");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.1.3.1", "Digital Intra – oral X-Ray Image Storage – for Processing");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.10", "Standalone Modality LUT Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.104.1", "Encapsulated PDF Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.11", "Standalone VOI LUT Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.11.1", "Grayscale Softcopy Presentation State Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.11.2", "Color Softcopy Presentation State Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.11.3", "Pseudocolor Softcopy Presentation Stage Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.11.4", "Blending Softcopy Presentation State Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.12.1", "X-Ray Angiographic Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.12.1.1", "Enhanced XA Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.12.2", "X-Ray Radiofluoroscopic Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.12.2.1", "Enhanced XRF Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.12.3", "X-Ray Angiographic Bi-plane Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.128", "Positron Emission Tomography Curve Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.129", "Standalone Positron Emission Tomography Curve Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.2", "CT Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.2.1", "Enhanced CT Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.20", "NM Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.3", "Ultrasound Multiframe Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.3.1", "Ultrasound Multiframe Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.4", "MR Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.4.1", "Enhanced MR Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.4.2", "MR Spectroscopy Storage  ");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.481.1", "Radiation Therapy Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.481.2", "Radiation Therapy Dose Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.481.3", "Radiation Therapy Structure Set Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.481.4", "Radiation Therapy Beams Treatment Record Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.481.5", "Radiation Therapy Plan Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.481.6", "Radiation Therapy Brachy Treatment Record Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.481.7", "Radiation Therapy Treatment Summary Record Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.481.8", "Radiation Therapy Ion Plan Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.481.9", "Radiation Therapy Ion Beams Treatment Record Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.5", "NM Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.6", "Ultrasound Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.6.1", "Ultrasound Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.66", "Raw Data Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.66.1", "Spatial Registration Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.66.2", "Spatial Fiducials Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.66.3", "Deformable Spatial Registration Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.66.4", "Segmentation Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.67", "Real World Value Mapping Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.7", "Secondary Capture Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.7.1", "Multiframe Single Bit Secondary Capture Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.7.2", "Multiframe Grayscale Byte Secondary Capture Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.7.3", "Multiframe Grayscale Word Secondary Capture Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.7.4", "Multiframe True Color Secondary Capture Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.77.1", "VL (Visible Light) Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.77.1.1", "VL endoscopic Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.77.1.1.1", "Video Endoscopic Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.77.1.2", "VL Microscopic Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.77.1.2.1", "Video Microscopic Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.77.1.3", "VL Slide-Coordinates Microscopic Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.77.1.4", "VL Photographic Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.77.1.4.1", "Video Photographic Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.77.1.5.1", "Ophthalmic Photography 8-Bit Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.77.1.5.2", "Ophthalmic Photography 16-Bit Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.77.1.5.3", "Stereometric Relationship Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.77.2", "VL Multiframe Image Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.8", "Standalone Overlay Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.88.11", "Basic Text SR");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.88.22", "Enhanced SR");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.88.33", "Comprehensive SR");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.88.40", "Procedure Log Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.88.50", "Mammography CAD SR");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.88.59", "Key Object Selection Document");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.88.65", "Chest CAD SR");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.88.67", "X-Ray Radiation Dose SR  ");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.9", "Standalone Curve Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.9.1.1", "12-lead ECG Waveform Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.9.1.2", "General ECG Waveform Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.9.1.3", "Ambulatory ECG Waveform Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.9.2.1", "Hemodynamic Waveform Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.9.3.1", "Cardiac Electrophysiology Waveform Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.1.9.4.1", "Basic Voice Audio Waveform Storage  ");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.2.1.1", "Patient Root Query/Retrieve Information Model – FIND");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.2.1.2", "Patient Root Query/Retrieve Information Model – MOVE");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.2.1.3", "Patient Root Query/Retrieve Information Model – GET");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.2.2.1", "Study Root Query/Retrieve Information Model – FIND");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.2.2.2", "Study Root Query/Retrieve Information Model – MOVE");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.2.2.3", "Study Root Query/Retrieve Information Model – GET");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.2.3.1", "Patient/Study Only Query/Retrieve Information Model – FIND");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.2.3.2", "Patient/Study Only Query/Retrieve Information Model – MOVE");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.1.2.3.3", "Patient/Study Only Query/Retrieve Information Model – GET");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.31", "Modality Worklist Information Model – FIND");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.32", "General Purpose Worklist Management Meta");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.32.1", "General Purpose Worklist Information Model – FIND");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.32.2", "General Purpose Scheduled Procedure Step");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.32.3", "General Purpose Performed Procedure Step");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.33", "Instance Availability Notification");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.37.1", "General Relevant Patient Information Query");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.37.2", "Breast Imaging Relevant Patient Information Query");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.37.3", "Cardiac Relevant Patient Information Query");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.38.1", "Hanging Protocol Storage");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.38.2", "Hanging Protocol Information Model – FIND");
		SOP_CLASS_DEFINITIONS.put("1.2.840.10008.5.1.4.38.3", "Hanging Protocol Information Model – MOVE");
	}
}
