
package edu.uthscsa.ric.volume;

/**
 * An exception class used to pass along specific error messages about why a file header cannot be read or is read successfully but found not to be valid.
 */
public class InvalidHeaderException extends Exception {

	private static final long serialVersionUID = 1L;



	/**
	 * Default constructor.
	 */
	public InvalidHeaderException() {
		super();
	}



	/**
	 * Constructor that takes a string. This message will appear in a dialog if the image read was unsuccessful.
	 * 
	 * @param message the message
	 */
	public InvalidHeaderException(final String message) {
		super(message);
	}



	/**
	 * Constructor. This message will appear in a dialog if the image read was unsuccessful.
	 * 
	 * @param message the message
	 * @param ex the exception
	 */
	public InvalidHeaderException(final String message, final Exception ex) {
		super(message, ex);
	}
}
