
package edu.uthscsa.ric.volume;

import java.util.List;


/**
 * The result of a histogram operation.
 * 
 * @author michaelmartinez
 *
 */
public interface Histogram {

	/**
	 * Returns an array of histogram bin counts.
	 * 
	 * @return an array of histogram bin counts
	 */
	int[] getBinCounts();



	/**
	 * Returns an array of histogram bin range maxs.
	 * 
	 * @return an array of histogram bin range maxs
	 */
	double[] getBinRangeMaximums();



	/**
	 * Returns an array of histogram bin range mins.
	 * 
	 * @return an array of histogram bin range mins
	 */
	double[] getBinRangeMinimums();



	/**
	 * Returns the histogram range max.
	 * 
	 * @return the histogram range max
	 */
	double getMax();



	/**
	 * Returns the histogram range min.
	 * 
	 * @return the histogram range min
	 */
	double getMin();



	/**
	 * Returns the number of histogram bins.
	 * 
	 * @return the number of histogram bins
	 */
	int getNumBins();



	/**
	 * Returns the selection end bin index for the specified ROI color.
	 * 
	 * @param color the ROI color index
	 * @return the selection end bin index
	 */
	int getSelectedBinEndIndex(int color);



	/**
	 * Returns the selection start bin index for the specified ROI color.
	 * 
	 * @param color the ROI color index
	 * @return the selection start bin index
	 */
	int getSelectedBinStartIndex(int color);



	/**
	 * Returns a list of ROI color indices currently used in selection.
	 * 
	 * @return a list of ROI color indices
	 */
	List<Integer> getSelectedColors();
}
