
package edu.uthscsa.ric.volume;

import java.io.Serializable;


/**
 * Coordinate4D extends Coordinate and includes a series dimension.
 */
public class Coordinate4D extends Coordinate implements Serializable {

	private static final long serialVersionUID = 1L;

	public int seriesPoint;



	/**
	 * Constructor.
	 * 
	 * @param coor the Coordinate to copy
	 * @param seriesPoint the series point
	 */
	public Coordinate4D(final Coordinate coor, final int seriesPoint) {
		super(coor);
		this.seriesPoint = seriesPoint;
	}



	/**
	 * Constructor.
	 * 
	 * @param x the X location
	 * @param y the Y location
	 * @param z the Z location
	 * @param seriesPoint the series point
	 */
	public Coordinate4D(final double x, final double y, final double z, final int seriesPoint) {
		super(x, y, z);
		this.seriesPoint = seriesPoint;
	}



	/**
	 * Tests equality.
	 * 
	 * @return true if the objects are equals, false otherwise.
	 */
	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (!super.equals(obj)) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final Coordinate4D other = (Coordinate4D) obj;

		return (this.seriesPoint == other.seriesPoint);
	}



	/**
	 * Returns the series point.
	 * 
	 * @return the series point
	 */
	public int getSeriesPoint() {
		return this.seriesPoint;
	}



	/**
	 * Compute hash code.
	 * 
	 * @return the hash code
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = (prime * result) + this.seriesPoint;
		return result;
	}



	/**
	 * Sets the values of this Coordinate4D.
	 * 
	 * @param x the X location
	 * @param y the Y location
	 * @param z the Z location
	 * @param seriesPoint the series point
	 */
	public void setValues(final double x, final double y, final double z, final int seriesPoint) {
		super.setValues(x, y, z);
		this.seriesPoint = seriesPoint;
	}



	/**
	 * Returns a string representation of this object.
	 * 
	 * @return a string representation of this object
	 */
	@Override
	public String toString() {
		return "Coordinate (X:" + this.xDbl + " Y:" + this.yDbl + " Z:" + this.zDbl + " T:" + this.seriesPoint + ")";
	}
}
